;----------------------------------------------------------------------------------- ---- --- -- - -  -  player constants
ini_indexed_mask = 1
ini_indexmask_size = 32
ini_relative = 1
ini_mus_loop = 0

ini_mus_stack = #6000
mus_data_adr  = #c000

max_inner_call = 7

mus_buffer = #7000
;----------------------------------------------------------------------------------- ---- --- -- - -  -  description
; psg_player_align_v1.0  by  tmk & bfox
;--------------------------------------
; speed-optimized player for psg-packer v1.0 (zx-spectrum) with self-modifyed code (use in RAM only),
; designed to be used in border, multicolor and other precisely timed effects.
;
; there're 3 entry points:  <mus_init>   - initialise the player
;                           <mus_depack> - unpack one frame into the <mus_buffer> (sized 14 bytes)
;                           <mus_play>   - send the frame buffer to PSG (constant time: 563t without call)
;
; the number of t-states in <mus_depack> is 820+[inner_call nesting]*52+[quantity of links]*180 or less, but always divisible by 4.
; (the values in square brackets differs from frame to frame and depend on the contents of the music data structure)
;
; trashed regs:	HL,DE,BC,AF,AF'
;
; WARNING: in <ini_indexed_mask=1> mode <mus_data_adr> must be aligned to 256 bytes!
;
;----------------------------------------------------------------------------------- ---- --- -- - -  -  test code
		device	zxspectrum128

		org	#8000
code_run
		call	mus_init

		di
		ld hl,#c9fb	; ei:ret
		ld (#5c77),hl
		ld a,37,i,a
		im 2
		ei

loop		halt

		ld	bc,893
1		dec	bc
		inc	b
		djnz	1b

		ld	a,2 : out (#fe),a
		call	mus_play
		ld	a,7 : out (#FE),a
		call	mus_depack
		xor	a   : out (#FE),a

		jr	loop

;----------------------------------------------------------------------------------- ---- --- -- - -  -  initialization
mus_init
		  ld	hl,ini_mus_stack
		  ld	(mus_stack_adr),hl
		if ini_indexed_mask = 1
		  ld	hl,ini_indexmask_size * 2 + mus_data_adr
		else
		  ld	hl,mus_data_adr
		endif
		  ld	(mus_adr),hl
		if ini_mus_loop = 1
		  ld	(mus_loop_adr),hl
		endif
;------------------------------------------------------- ---- --- -- - -  -   -    -
mus_clear_buff
		if ini_indexed_mask = 1
		cp	(hl)			;7	***
		endif

		ld	hl,mus_buffer+13	;10
		ld	a,14			;4
1		ld	(hl),0			;10
		dec	a			;4
		jr	nz,1b			;12
		ret				;10
;------------------------------------------------------- ---- --- -- - -  -   -    -
muz_wait	dec	a		;4
		ld	(mus_pause),a	;13
		dec	de
		ret			;10
;----------------------------------------------------------------------------------- ---- --- -- - -  -  music depacking
mus_depack	
;------------------------------------------------------- ---- --- -- - -  -   -    -
		ld	a,0		;7
mus_pause	  equ $-1
		or	a		;4
		jr	nz,muz_wait	;7/12

;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -
;11hhhhhh , llllllll , nnnnnnnn - mus_call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll            - call_1 - play one frame from mus_adr-00hhhhhh llllllll
;01mmmmmm , mmmmmmmm ,  ......  - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;001nnnnn                       - number of indexed mask in table (first 32 bytes of data block)
;0001pppp               - pause16 pppp+1 (1..16)
;0000hhhh , vvvvvvvv    - playback of psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;00001111               - end of playback (shutdown AY-chip or loop track)
;00000000 , nnnnnnnn    - wait for nnnnnnnn+1 frames (put nothing to registers)
;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -

	if ini_indexed_mask = 1
		ld	hl,mus_data_adr + ini_indexmask_size * 2	;10
	else
		ld	hl,mus_data_adr					;..
	endif
mus_adr		  equ $-2
		or	(hl)		  ;7
		inc	hl		  ;6	
		jp	m,mus_links	  ;10
		jr	z,mus_pause_n	  ;7/12
	if ini_indexed_mask = 1
		sub	64		  ;7
		jp	nc,mus_psg2	  ;10
		sub	224		  ;7
		jp	nc,mus_psg2_index ;10
		add	a,17		  ;7
		  if ini_mus_loop = 1
		     jr	z,mus_loop	  ;7/12
		  else
		     jr	z,mus_clear_buff  ;7/12
		  endif
		jr	nc,mus_psg1	  ;7/12
		dec	a		  ;4
	else
		cp	64		  ;7
		jp	nc,mus_psg2	  ;10
		cp	15		  ;7
		  if ini_mus_loop = 1
		     jr	z,mus_loop	  ;7/12
		  else
		     jr	z,mus_clear_buff  ;7/12
		  endif
		jr	c,mus_psg1	  ;7/12
		and	15		  ;7
		dec	de		  ;6	***
	endif
;-----------------------------------------------------------------------------------------------------------
;0001pppp - pause16 pppp+1 (1..16)
;-----------------------------------------------------------------------------------------------------------
mus_pause16
		ld	(mus_pause),a		;13

;------------------------------------------------------------------------- ----- ---- --- -- - -  -   -    -
mus_com_exit
		ld	(mus_adr),hl		;16

		ld	a,(mus_stack_adr)	;13
		ld	hl,ini_mus_stack+2	;10

inner_calloop	  cp	L			;4
		  ret	c			;5/11
		  dec	(hl)			;11
		  jp	z,mus_call_ret		;10
		  inc	L,L,L			;12
		  jp	inner_calloop		;10
mus_call_ret
		dec	L			;4
		ld	d,(hl)			;7
		dec	L			;4
		ld	e,(hl)			;7

		ld	(mus_stack_adr),hl	;16
		ld	(mus_adr),de		;20
		ret	nc			;11

;-----------------------------------------------------------------------------------------------------------
;0000hhhh , vvvvvvvv	- playback psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;-----------------------------------------------------------------------------------------------------------
mus_psg1
	if ini_indexed_mask = 1
		sub	#f2		  ;7
	else
		dec	a		  ;4
	endif
		ld	e,a		  ;4
		ld	d,high mus_buffer ;7
		ldi			  ;16
		jp	mus_com_exit	  ;10
;-----------------------------------------------------------------------------------------------------------
;00001111 - end of playback (shutdown AY-chip or loop track)
;-----------------------------------------------------------------------------------------------------------
	  if ini_mus_loop = 1
mus_loop	
	   if ini_indexed_mask = 1
		ld	hl,ini_indexmask_size * 2 + mus_data_adr
mus_loop_adr	equ $-2
		ret	nz			;5	***
		jp	mus_adr+2		;10
	   else
		ld	hl,mus_data_adr
mus_loop_adr	equ $-2
		jr	mus_adr+2		;12
		endif
	endif
;-----------------------------------------------------------------------------------------------------------
;00000000 , nnnnnnnn - wait for nnnnnnnn+1 frames (put nothing to registers)
;-----------------------------------------------------------------------------------------------------------
mus_pause_n
		ld	a,(hl)		;7		***
		ld	a,(hl)		;7
		inc	hl		;6
		ld	(mus_pause),a	;13
		jp	mus_com_exit	;10
;-----------------------------------------------------------------------------------------------------------
;01mmmmmm , mmmmmmmm - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;-----------------------------------------------------------------------------------------------------------
mus_psg2
		ex	af,af		;4
		ld	a,(hl)		;7
		inc	hl		;6
		jp	mus_psg2_	;10

	if ini_indexed_mask = 1
;-----------------------------------------------------------------------------------------------------------
;001nnnnn - number of indexed mask in table (first 32 bytes of data block)
;-----------------------------------------------------------------------------------------------------------
mus_psg2_index
		ret	c			;5	***

		add	a,a			;4
		ld	e,a			;4
		ld	d,high mus_data_adr	;7
		ld	a,(de)			;7
		inc	e			;4
		ex	af,af			;4
		ld	a,(de)			;7
	endif
;__________________________________ _____ ____ ___ __ _ _  _   _    _

mus_psg2_	ld	de,mus_buffer	;10

		   dup	8
		rra		;4
		jp	nc,1F	;10
		ldi		;16
		dec	e	;4
1		inc	e	;4 =38/18 * 8 (max 304)
		   edup

		ex	af,af	;4

		   dup	5
		rra		;4
		jp	nc,1F	;10
		ldi		;16
		dec	e	;4
1		inc	e	;4 =38/18 * 5 (max 190)
		   edup

		rra			;4
		jp	nc,1f		;10
		ldi			;16
1		jp	mus_com_exit	;10

;-----------------------------------------------------------------------------------------------------------
;11hhhhhh , llllllll , nnnnnnnn	- call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll		- call_1 - play one frame from mus_adr-00hhhhhh llllllll
;-----------------------------------------------------------------------------------------------------------
mus_links
		ld	c,(hl)		;7
		inc	hl		;6
		sub	%11000000	;7
		ld	b,a		;4
		jr	c,1f		;7 /12
		  ld	a,(hl)		;7
		  inc	hl		;6
		  jp	2f		;10
1		sub	%11000000	;   /7
		ld	b,a		;   /4
		ld	a,01		;   /7
2					;54/54
		ex	de,hl			;4

		ld	hl,ini_mus_stack	;10
mus_stack_adr	  equ $-2
		ld	(hl),e			;7
		inc	L			;4
		ld	(hl),d			;7
		inc	L			;4
		ld	(hl),a			;7
		inc	L			;4
		ld	(mus_stack_adr),hl	;16
		xor	a			;4

	if ini_relative = 1

		ex	de,hl		;4
		sbc	hl,bc		;15		CY is always = 0
		cp	(hl)		;7		***
		jp	mus_adr + 2	;10
	else
		ld	hl,mus_data_adr	;10
mus_init_adr	  equ $-2
		ret	c		;5		***
		add	hl,bc		;11
		jp	mus_adr + 2	;10
	endif
;----------------------------------------------------------------------------------- ---- --- -- - -  -  music playback
mus_play	
;------------------------------------------ ---- --- -- - -  -   -    -
		ld	hl,mus_buffer	;10
		ld	d,#bf		;7
		ld	bc,#fdfd	;10

		out	(c),L		;12
		ld	b,d		;4
		outi			;16

		dup	12

		ld	b,c		;4
		out	(c),L		;12
		ld	b,d		;4
		outi			;16

		edup

		ld	b,c		;4
		out	(c),L		;12
		in	a,(c)		;12
		xor	(hl)		;7
		ld	b,d		;4
		jr	z,1f		;7  / 12
		outi			;16
		ret			;10		// total: 563t + call (17t) = 580t
1
		add	hl,bc		;     11
		ret			;     10	// total: 563t + call (17t) = 580t

;----------------------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -   -    -
;                  :

; PORT      MASK FOR 48k        MASK FOR 128k/+2       MASK FOR +2a/+2b/+3 
;#fe     xxxxxxxx xxxxxxx0      xxxxxxxx xxxxxxx0       xxxxxxxx xxxxxxx0
;#7ffd          n/a             0xxxxxxx xxxxxx0x       01xxxxxx xxxxxx0x
;#1ffd          n/a                    n/a              0001xxxx xxxxxx0x
;#bffd          n/a             10xxxxxx xxxxxx0x       10xxxxxx xxxxxx0x
;#fffd          n/a             11xxxxxx xxxxxx0       11xxxxxx xxxxxx0

;----------------------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -   -    -
code_end

	display "------------------------------------------"
	display	"mus_stack: ", /a, ini_mus_stack, " ... ", /a, max_inner_call*3+ini_mus_stack
	display "------------------------------------------"
	display "start:  ", /a, code_run, " bytes"
	display "total:  ", /a, code_end - code_run, " bytes"
	display "player: ", /a, code_end - mus_init, " bytes"
	display "------------------------------------------"

	org	mus_data_adr

	INCBIN	"music.psg.packed"

;	savesna "c:\Program Files\UnrealSpeccy\Qsave1.sna", code_run
;	savesna "c:\Program Files (x86)\UnrealSpeccy\Qsave1.sna", code_run
