var streamDump = <?= json_encode($analyze->dump) ?>;
var streamCommandsList = <?= json_encode($streamCommandsList) ?>;
var streamFrames = [<?= implode(',', $analyze->streamFrames) ?>];
var repeatedFrames = <?= json_encode($analyze->repeatedFrames) ?>;
var callFrames = <?= json_encode($analyze->callFrames) ?>;
var callCmdFrames = <?= json_encode($analyze->callCmdFrames) ?>;
var canvas = document.getElementById('canvas');
var canvasInfo = document.getElementById('canvas-info');
var canvasCursorV = document.getElementById('canvas-cursor-v');
var canvasPlayCursor = document.getElementById('canvas-play-cursor');
canvas.width = <?= sizeof($analyze->streamFrames) ?>;
canvas.height = 80;
var ctx = canvas.getContext('2d');
var lingrad = ctx.createLinearGradient(0,0,0,88);
lingrad.addColorStop(0, '#ff0000');
lingrad.addColorStop(0.65, '#ffff00');
lingrad.addColorStop(1, '#00ff00');

console.log(streamFrames.length);
for (var frame in streamFrames) {
    var val = streamFrames[frame];

    ctx.fillStyle = streamCommandsList[val].color;
    ctx.fillRect(frame, 0, 1, 19);

    ctx.fillStyle = repeatedFrames[frame] == 1 ? '#ffffff' : '#000000';
    ctx.fillRect(frame, 20, 1, 19);

    var style = '#000000';
    if (callFrames[frame] == 1){ style= '#006000'; }
    if (callCmdFrames[frame] == 1){ style = '#ffffff'; }
    if (callCmdFrames[frame] == 2){ style = '#00ff00';}
    if (callCmdFrames[frame] == 3){ style = '#00ffff';}
    if (callCmdFrames[frame] == 4){ style = '#0080ff';}
    ctx.fillStyle = style;
    ctx.fillRect(frame, 40, 1, 19);

    var style = '#ff8080';
    if (callFrames[frame] == 1){ style= '#000000'; }
    if (repeatedFrames[frame] == 1){ style= '#000000'; }
    ctx.fillStyle = style;
    ctx.fillRect(frame, 60, 1, 19);
}

function showInfo(frame) {
    canvasInfo.innerHTML = '<div>frame: ' + frame + '</div><div>' + streamCommandsList[streamFrames[frame]].name + '</div>';
    canvasInfo.style.left = (16 + frame) + 'px';
    canvasInfo.style.display = 'block';
    canvasCursorV.style.left = (frame - 1) + 'px';
    canvasCursorV.style.display = 'block';
}
canvas.onmouseenter = function(e){ showInfo(e.offsetX); }
canvas.onmousemove = function(e){ showInfo(e.offsetX); }
canvas.onmouseleave = function(){
    canvasInfo.style.display = 'none';
    canvasCursorV.style.display = 'none';
}


var plState = {};
plState.audioCtxIsInited = 0;
plState.isPlayed = 0;
plState.frame = 0;


setInterval(function(){
    canvasPlayCursor.style.left = plState.frame + 'px';
}, 100);


function fnPlayGetRegs() {
    regs = [0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    if (plState.frame < streamDump.length) {
        for (var regId = 0; regId < 14; regId++) {
            regs[regId] = streamDump[plState.frame][regId];
        }
        plState.frame++;
    }
    return regs;
}

canvas.addEventListener('click', function(e){
    plState.frame = parseInt(e.offsetX);
});


function plInit() {
    window.AudioContext = window.AudioContext || window.webkitAudioContext;
    window.audioContext = new AudioContext();
    
    window.sampleRate = window.audioContext.sampleRate;

    window.gainNode = audioContext.createGain();
    window.gainNode.gain.value = 1;
    gainNode.connect(audioContext.destination);

    window.audioNode = audioContext.createScriptProcessor(4096, 0, 2);
    audioNode.onaudioprocess = fillBuffer;
    audioNode.connect(gainNode);
    

    window.ayumi = new Ayumi();
        ayumi.configure(true, clockRate, sampleRate);
        ayumi.setPan(0, 0.1, 0);
        ayumi.setPan(1, 0.5, 0);
        ayumi.setPan(2, 0.9, 0);

    window.aymPlayer = new aymPlayer();
    plState.audioCtxIsInited = 1;
}

function play(initFrame) {
    if (plState.audioCtxIsInited == 0) {
        plInit();
    }
    if (plState.isPlayed == 0 || initFrame == 1) {
        if (initFrame == 1) {
            plState.frame = 0;
        }
        plState.isPlayed = 1;
        window.aymPlayer.play();
    }
}


document.getElementById('play-start').addEventListener('click', function(e){
    play(1);
    e.preventDefault();
});
document.getElementById('play').addEventListener('click', function(e){
    play(0);
    e.preventDefault();
});
document.getElementById('stop').addEventListener('click', function(e){
    window.aymPlayer.stop();
    plState.isPlayed = 0;
    e.preventDefault();
});
