
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: COMMAND.COM

; Подозреваю, что эта прога была написана на Си, слишком много неоптимального кода
; и буфер глобальных переменных, которые используются как попало.
; ═══════════════════════════════════════════════════════════════════════════
.include "inc/dx_sys.asm"
.include "inc/dx_fcb.asm"
.include "inc/dx_fat.asm"
.include "inc/dx_cmd.asm"
.include "inc/FDDParam.asm"
;----------------------------
BATBSZ = StdRecSize  ; размер буфера для чтения строк из бат файла либо это простое совпадение, и надо число 200 задать
NMBFSZ = 14   ; размер буфера для формирования числа в ITOA, чтобы потом его вывести на экран
DTBFSZ = 16   ; размер буфера ввода даты
WRKBUF = 1000 ; рабочий буфер. размер как минимум 1000+1000
IOBFSZ = 1000 ; размер буфера ввода-вывода (да и блока чтения тоже.)


; START - C$CCSZ - 2 - 1000 - 200 - 14 - 16 - и опять буфер - под ввод даты
; START - C$CCSZ - 2 - 1000 - 200 - 14 - и ещё буфер - для формирования числа в ITOA, чтобы потом его вывести на экран
; START - C$CCSZ - 2 - 1000 - 200 - ещё буфер - для чтения строки бат файла
; START - C$CCSZ - 2 - 1000 - адрес области обмена с диском коммандкома
; START - C$CCSZ - 2 - адрес начала системного буфера коммандкома

.la 0           ; если адрес загрузки равен 0, то коммандком грузится в верхние адреса.
                ; иначе - по адресу загрузки, что неудобно

START:          nop
                br      1STRT$
; адрес вектора 4, обработка кнопки стоп
CMDV4:          .addr   R3, START-2 - C$CCSZ ; указатель на системный буфер коммандкома
                mov     C$AIOB(R3), R0  ; буфер хранения старого адреса области обмена с диском
                iot                     ; восстановим оригинальный адрес области обмена с диском
                .word   32              ; Установление адреса области обмена с диском
                                        ; (адрес чтения/записи физического сектора)
                                        ; вход: R0-адрес обмена.
                mov     C$V4BF(R3), @#4 ; восстановим оригинальный адрес вектора 4

1STRT$:         mov     #WRKBUF, SP     ; выставляем стек
                .addr   R3, START-2
                mov     SP, R1          ; очищаем всю память
1$:             clr     (R1)+           ; от начала буферов
                cmp     R1, R3          ; до начала коммандкома.
                blo     1$
                sub     #C$CCSZ, R3     ; указатель на системный буфер коммандкома
                mov     R3, R5          ; сохраним для дальнейшего использования
                iot
                .word   57              ; Получить адрес обмена с диском (адрес чтения/записи сектора).
                                        ; выход: R0-адрес.
                mov     R0, C$AIOB(R3)  ; сохраним оригинальный адрес области обмена с диском
                mov     #4, R1
                mov     (R1), C$V4BF(R3) ; сохраним оригинальный адрес вектора 4
                mov     PC, (R1)
                add     #CMDV4-., (R1)  ; перенаправим вектор 4 в нужную точку
                ; начинаем инициализацию переменных системного буфера коммандкома
                movb    #4, C$CLNM(R3)  ; количество столбцов помещающихся на экране для дир
                movb    #26, C$STNM(R3) ; количество строк, помещающихся на экране для постраничного вывода дир
                sub     #IOBFSZ, R5
                mov     R5, R0
                iot
                .word   32              ; Установление адреса области обмена с диском
                                        ; (адрес чтения/записи физического сектора)
                                        ; вход: R0-адрес обмена.
                iot
                .word   30              ; Доступ к буферам DOS.
                                        ; выход: R0 - адрес области BAT-файлов.
                                        ;        первое слово - уровень вложенности (0 - область пуста).
                                        ;        R1 - адрес FCB стандартного устройства ввода.
                                        ;        R2 - адрес FCB стандартного устройства вывода.
                mov     R1, C$STDI(R3)  ; адрес FCB стандартного устройства ввода.
                mov     R2, C$STDO(R3)  ; адрес FCB стандартного устройства вывода.
                mov     R0, C$ABAR(R3)  ; адрес области BAT-файлов.
                sub     #BATBSZ, R5
                mov     R5, C$BFBF(R3)  ; буфер чтения строк из бат файла
                sub     #NMBFSZ, R5
                mov     R5, C$NMBF(R3)  ; буфер для формирования числа в ITOA, чтобы потом его вывести на экран
                sub     #DTBFSZ, R5
                mov     R5, C$DTBF(R3)  ; буфер ввода даты
                tst     -(R5)
                mov     R5, C$USED(R3)  ; адрес начала занятой коммандкомом памяти
                .addr   R0, ENVNML
                mov     R0, C$ENNM(R3)  ; адрес списка имён переменных окружения
                add     #ENVVLL-ENVNML, R0
                mov     R0, C$ENVL(R3)  ; адрес списка значений констант
                add     #ENVEXT-ENVVLL, R0
                mov     R0, C$ENEX(R3)  ; адрес списка обрабатываемых расширений
                com     C$PSTI(R3)      ; изначально буфер обнулён, поэтому команда выставляет флаги пересоздания
                                        ; стандартных устройств ввода-вывода. C$PSTI должно быть чётным, чтобы оба флага одной командой
                clrb    C$ECHO(R3)      ; выставляем значение ECHO ON
                iot
                .word   61              ; Доступ к внутрисистемной информации.
                                        ; выход: R1-адрес области DOS.
                movb    S$MONT(R1), R5
                movb    R5, C$MONT(R3)  ; тип монитора БК
                call    ECHOST          ; Получение состояния переменной окружения ECHO
                                        ; выход: R0 - числовое значение состояния
                                        ;        R1 - строковое значение переменной окружения
                tstb    C$SENV(R3)      ; в процессе получения задавали значение по умолчанию?
                beq     L11$            ; нет - сразу в рабочий цикл
                .addr   R1, CMDVER      ; а иначе - выведем версию коммандкома
2$:             movb    (R1)+, R0
                beq     L11$
                cmpb    #1, R5
                bne     3$
                emt     63
                br      2$

3$:             emt     16
                br      2$

L11$:           mov     #WRKBUF, R4     ; чистим рабочие буферы
                mov     R4, R5          ; тут предполагается, что буферы начинаются с адреса 1000
1$:             clr     (R5)+           ; и их размер 1000 слов, что может поменяться когда-нибудь
                sob     R4, 1$
                .addr   R5, CONNME      ; консоль
                tstb    C$PSTI(R3)      ; стандартное устройство ввода пересоздавать надо?
                beq     2$              ; нет
                mov     C$STDI(R3), R4  ; адрес FCB стандартного устройства ввода.
                iot                     ; закроем стандартное устройство ввода
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                mov     R5, R1          ; консоль
                call    SyntaxName2$
                iot                     ; создаём стандартное устройство ввода - консоль
                .word   26              ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
2$:             tstb    C$PSTO(R3)      ; стандартное устройство вывода пересоздавать надо?
                beq     3$              ; нет
                mov     C$STDO(R3), R4  ; адрес FCB стандартного устройства вывода.
                iot                     ; закроем стандартное устройство вывода
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                mov     R5, R1          ; консоль
                call    SyntaxName2$
                iot                     ; создаём стандартное устройство вывода - консоль
                .word   26              ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
                call    CRLFOU          ; сделать перевод строки
3$:             clr     C$PSTI(R3)      ; сбрасываем флаги
                mov     C$ABAR(R3), R4  ; адрес области BAT-файлов.
                mov     (R4)+, R0       ; первое слово - уровень вложенности
                ble     9$              ; вообще нет бат файла - обработаем командную строку
4$:             dec     R0              ; вычисляем вложенность
                                        ; максимальная вложенность - 3, т.к. размер области бат файлов == 204 байта
                beq     5$              ; но тут никаких проверок не проводится, и мы спокойно можем портить память.
                add     #BATLBF, R4     ; и по вложенности - нужное место в области бат файлов
                br      4$

; буфер уровня вложенности бат файлов - обычный блок FCB
5$:             mov     #1, F$RCSZ(R4)  ; размер записи в байтах.
                mov     C$BFBF(R3), F$DTAD(R4) ; адрес обмена - адрес буфера длиной BATBSZ
6$:             iot
                .word   24              ; Последовательное чтение из файла.
                                        ; вход: R4-адрес FCB.
                                        ; После чтения соответствующие поля FCB модифицируются.
                bcs     1Err$
                mov     F$DTAD(R4), R5  ; адрес обмена
                inc     F$DTAD(R4)
                call    IsCRLF$
                bne     6$              ; нет - читаем дальше, пока не встретим перевод строки
                clrb    (R5)+           ; формируем конец строки - 0
                iot                     ; вхолостую прочтём символ. по умолчанию предполагается, что за CR всегда идёт LF. иные варианты даже не рассматриваются.
                .word   24              ; Последовательное чтение из файла.
                                        ; вход: R4-адрес FCB.
                                        ; После чтения соответствующие поля FCB модифицируются.
                bcs     1Err$
                call    IsCRLF$
                bne     7$
                clrb    (R5)+           ; и совсем конец, чтобы \r\n не было
7$:             ; а вот если строка оканчивается одним только \n, тут будет не очень хорошо

; я так понимаю, тут мы читаем в буфер очередную строку из бат файла. размер буфера - 200 байтов
; т.е. размер строки - не более 176 символов + перевод строки \r\n
; никаких проверок на переполнение не делается.
                inc     C$BSNM(R3)      ; счётчик прочитанных строк
                mov     C$BFBF(R3), R1  ; адрес буфера чтения бат файлов
                cmpb    #'@, (R1)+      ; строка начинается с собаки?
                beq     10$             ; да - пропускаем и идём обрабатывать строку
                dec     R1              ; нет - возвращаем указатель назад

8$:             tstb    C$ECHO(R3)      ; эхо на экран нужно?
                bne     10$             ; нет
                call    PREFIX          ; выведем префикс командной строки
                iot                     ; выведем строку, адрес строки в R1
                .word   11              ; Вывод строки символов на устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ; (Строка должна оканчиваться нулевым байтом)
                call    CRLFOU          ; сделать перевод строки
                br      10$             ; и идём на обработку строки

9$:             call    PREFIX          ; выведем префикс командной строки
                iot
                .word   64              ; Получить доступ к командной строке.
                                        ; Вых: R1- адрес командной строки.
                                        ;      R2- размер командной строки в байтах.
                iot
                .word   6               ; Буферизованный ввод с клавиатуры с возможностью редактирования.
                                        ; вход: R1-адрес буфера,
                                        ;       R2-размер буфера в байтах.
                clr     C$BSNM(R3)      ; обнулим счётчик прочитанных строк - значит не из бат файла чтение
10$:            tstb    (R1)            ; а вообще обрабатываемая строка есть?
                beq     L11$            ; нету - нечего обрабатывать
                ; парсим и обрабатываем команды
                call    PARSER          ; разбор очередной строки бат файла /или командной строки
                                        ; вход:  R1 - адрес начала строки
                br      L11$
; если произошла ошибка при чтении бат файла, то прекращаем его обработку
1Err$:          dec     @C$ABAR(R3)     ; уменьшаем уровень вложенности бат файлов
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                br      L11$

; проверка на CR или LF
; вход: R5 - адрес, куда прочитался символ
; выход: Z - оно, !Z - не оно
IsCRLF$:        cmpb    #15, (R5)       ; что прочитали? CR?
                beq     1$
                cmpb    #12, (R5)       ; LF?
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; разбор очередной строки бат файла /или командной строки
; вход:  R1 - адрес начала строки
PARSER:         mov     R1, R2          ; адрес начала строки
1$:             movb    (R2)+, R0       ; если строка закончилась
                beq     3$              ; то пойдём дальше
                bitb    #200, R0        ; а пока проверим, что за символы
                bne     1$              ; если 200..377, их игнорируем
                cmpb    #100, R0        ; а для остальных делаем из маленьких букв
                bhi     1$
                bicb    #40, -1(R2)     ; большие
                br      1$              ; и так, пока строка не кончится

3$:             mov     R1, R2
                movb    (R1)+, R0       ; потенциально - имя диска
                cmpb    (R1)+, #':      ; второй символ :?
                bne     4$              ; нет, значит первый - не имя диска
                tstb    (R1)            ; если третий символ не конец строки,
                bne     4$              ; то имя диска - это не задание текущего диска, а часть пути
                sub     #'A, R0         ; сделаем из имени диска его номер.
                iot
                .word   16              ; Задать текущий дисковод.
                                        ; вход:  R0-номер дисковода.
                                        ;        0-дисковод "А" и т. д.
                br      5$              ; и всё

4$:             .addr   R1, CMDSET      ; поищем среди команд встреченное слово
                call    STRNUM          ; поиск строки в массиве
                                        ; вход:  R1 - адрес начала массива строк
                                        ;        R2 - адрес эталонной строки
                                        ; выход: R0 - номер строки * 2
                                        ; если ошибок нет,
                                        ;        R1 - указатель на конец участка совпадения в эталонной строке
                                        ; если ошибки есть
                                        ;        R1 - указатель на начало эталонной строки
                bcs     1NOCMD          ; не нашли - значит это не команда
                add     PC, R0          ; а иначе
                add     #CMDADR-., R0   ; пойдём обработаем команду
                add     (R0), R0
                call    (R0)
5$:             jmp     ERCTCH          ; выходим, и если нужно - выведем сообщение об ошибке

1NOCMD:         mov     R1, -(SP)       ; если не команда, то наверное имя файла
                mov     R1, R2          ; проверим
                mov     #13, R0         ; имена файлов только короткие.
7$:             cmpb    (R2)+, #'.      ; если точка - то нашли расширение
                beq     6$
                cmpb    (R2), #40       ; если код <= пробела
                blos    8$              ; то конец строки
                sob     R0, 7$
                br      8$

6$:             mov     C$ENEX(R3), R1  ; адрес списка обрабатываемых расширений
                call    STRNUM          ; поиск строки в массиве
                                        ; вход:  R1 - адрес начала массива строк
                                        ;        R2 - адрес эталонной строки
                                        ; выход: R0 - номер строки * 2
                                        ; если ошибок нет,
                                        ;        R1 - указатель на конец участка совпадения в эталонной строке
                                        ; если ошибки есть
                                        ;        R1 - указатель на начало эталонной строки
                bcc     9$              ; если расширение из тех, что обрабатываем, то туда
                ; иначе загрузим и запустим файл
8$:             mov     C$AIOB(R3), R0  ; буфер хранения старого адреса области обмена с диском
                iot
                .word   32              ; Установление адреса области обмена с диском
                                        ; (адрес чтения/записи физического сектора)
                                        ; вход: R0-адрес обмена.
                mov     (SP)+, R1       ; адрес строки имени файла
                call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     1Ex$
                mov     C$V4BF(R3), @#4 ; восстановим вектор 4
                clr     R2              ; флаг - запускать файл
                iot
                .word   46              ; Исполнить программу.(Автозапуск работает корректно).
                                        ; вход: R1 - адрес строки содержащую имя файла.
                                        ;       R2 мл. байт - флаг: !0-запуска не происходит, 0 - файл запускается
                                        ;          на исполнение.
                br      1Ex$
                ; сюда попадаем, если запускаем бат файл
9$:             mov     C$ABAR(R3), R4  ; адрес области BAT-файлов.
                mov     (R4)+, R5       ; уровень вложенности
                beq     11$             ; если 0 то пора
10$:            add     #BATLBF, R4     ; а иначе, поищем нужный буфер уровня вложенности
                sob     R5, 10$         ; !!! вот тут мне кажется, что неправильно
                                        ; потому что выше было, если уровень вложенности == 1
                                        ; то это первый буфер за словом а не второй, как сейчас.

11$:            mov     (SP)+, R1       ; адрес обрабатываемой строки - там имя бат файла
                call    SyntaxName2$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     1Ex$            ; если фигня какая-то, а не файл, то выход
                iot
                .word   17              ; Открыть файл методом FCB.
                                        ; вход: R4-адрес FCB.
                bcs     1Ex$
                inc     @C$ABAR(R3)     ; увеличиваем уровень вложенности.
1Ex$:           jmp     ERCTCH          ; и выходим

; ═══════════════════════════════════════════════════════════════════════════
; проверка перенаправления входного/выходного контекста
; Вход: R1 - адрес в строке
REDIRC:         mov     R1, -(SP)
4$:             movb    (R1)+, R0       ; строка кончилась?
                beq     3$              ; выход
                cmpb    #'>, R0         ; если встретился такой знак
                bne     2$
                call    REDOUT          ; то это перенаправление выходного контекста
                                        ; Вход: R1 - адрес в строке, указывающий сразу за >
                bcs     1$
                br      4$

2$:             cmpb    #'<, R0         ; если встретился такой знак
                bne     4$
                call    REDINP          ; то это перенаправление входного контекста
                                        ; Вход: R1 - адрес в строке, указывающий сразу за <
                bcs     1$
                br      4$

3$:             clc     ; в процессе сравнения иногда бит С устанавливается, поэтому его надо принудительно очищать
1$:             mov     (SP)+, R1
                return


; делаем простой синтаксический разбор строки
; вход: R1 - адрес обрабатываемой строки.
;       R4 - адрес формируемого FCB-блока.
SyntaxName1$:   call    SKIPWS          ; пропустим пробелы
SyntaxName2$:   clr     R2              ; обычный разбор
                iot
                .word   51              ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0,то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                return


; ═══════════════════════════════════════════════════════════════════════════
; перенаправление входного потока
; Вход: R1 - адрес в строке, указывающий сразу за <
; Выход: R1 - продолжение строки
REDINP:         tstb    C$PSTI(R3)      ; входное устройство уже перенаправлено?
                bne     RED$ER          ; да - значит ошибка.
                incb    C$PSTI(R3)      ; установим флаг
                mov     C$STDI(R3), R4  ; адрес FCB стандартного устройства ввода.
                mov     R1, -(SP)
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                mov     (SP)+, R1       ; указатель сразу за <

                call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     2$              ; если какая-то неведома фигня, то ошибка
                mov     R1, -(SP)       ; а иначе - это файл, который надо открыть.
                iot
                .word   17              ; Открыть файл методом FCB.
                                        ; вход: R4-адрес FCB.
                mov     (SP)+, R1
2$:             return

RED$ER:         movb    #43, @#ERRFDD   ; да - скажем, что ошибка
                sec
                return

; ═══════════════════════════════════════════════════════════════════════════
; перенаправление выходного потока
; Вход: R1 - адрес в строке, указывающий сразу за >
; Выход: R1 - продолжение строки
REDOUT:         tstb    C$PSTO(R3)      ; выходной поток уже перенаправлен?
                bne     RED$ER          ; да - значит ошибка.
                incb    C$PSTO(R3)      ; установим флаг
                mov     C$STDO(R3), R4  ; адрес FCB стандартного устройства вывода.
                mov     R1, -(SP)
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                mov     (SP)+, R1       ; указатель сразу за >
                cmpb    #'>, (R1)       ; а там за ним второй >?
                bne     1$              ; нет - значит всё просто
                ; иначе - открываем файл для дозаписи.
                inc     R1              ; пропустим второй >
                call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     2$
                mov     R1, -(SP)
                iot
                .word   17              ; Открыть файл методом FCB.
                                        ; вход: R4-адрес FCB.
                mov     (SP)+, R1
                bcs     3$              ; если не открывается, то пойдём создавать
                mov     R1, -(SP)
                mov     F$FLSZ(R4), R0  ; размер файла в байтах
                mov     F$FLSZ+2(R4), R1
                mov     #StdRecSize, R2 ; размер записи
                mov     R4, -(SP)
                call    DIVIDE
                mov     R4, R2
                mov     (SP)+, R4
                mov     R0, F$CURR(R4)  ; текущая запись (последов.доступ к файлам)
                mov     R2, F$CBLK(R4)  ; номер текущего блока(для функций последовательного доступа).
                mov     (SP)+, R1       ; это мы так в конец файла переместились.
                clc
2$:             return

1$:             call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     2$
3$:             mov     R1, -(SP)
                iot
                .word   26              ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
                mov     (SP)+, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
; отрисовка префикса командной строки
PREFIX:         iot
                .word   31              ; Получение номера текущего устройства прямого доступа
                add     #'A, R0
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                mov     #'>, R0
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                iot
                .word   15              ; Инициализировать драйвер (контроллер) дисковода.
                return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды ECHO
CM$ECH:         mov     R1, R4          ; адрес в строке за командой
                call    SKIPWS          ; пропустим пробелы
                tstb    (R1)            ; если за командой ничего нет
                beq     1$              ; то туда пойдём
                mov     R1, R2          ; а иначе проверим
                mov     C$ENVL(R3), R1  ; что там такое написано
                ; получим номер константы
                call    STRNUM          ; поиск строки в массиве
                                        ; вход:  R1 - адрес начала массива строк
                                        ;        R2 - адрес эталонной строки
                                        ; выход: R0 - номер строки * 2
                                        ; если ошибок нет,
                                        ;        R1 - указатель на конец участка совпадения в эталонной строке
                                        ; если ошибки есть
                                        ;        R1 - указатель на начало эталонной строки
                bcs     2$              ; если не номер, то пойдём и просто выведем на консоль
                mov     R2, R1          ; а иначе номер * 2
                asr     R0              ; сделаем просто номер
                inc     R0              ; превратим в номер по порядку, счёт начинается с 1
                mov     R0, -(SP)
                mov     #1, R1          ; получим в буфере имя переменной окружения ECHO
                call    VARNAM          ; формирование в буфере имени переменной окружения
                                        ; вход:  R1 - номер переменной в массиве переменных, счёт начинается с 1: 1..n
                                        ; выход: R1, C$PENV(R3) - адрес конца строки в буфере #WRKBUF
                mov     (SP)+, R1
                call    SETVAR          ; и пойдём установим её новое значение
                                        ; вход:  R1 - номер значения в массиве значений, счёт начинается с 1: 1..n
                bcs     3$              ; если что-то не так
                                        ; то там кроме получения статуса, ещё и значение по умолчанию устанавливается
                call    ECHOST          ; Получение состояния переменной окружения ECHO
                                        ; выход: R0 - числовое значение состояния
                                        ;        R1 - строковое значение переменной окружения
3$:             return

1$:             tst     C$BSNM(R3)      ; это мы в батнике?
                bne     4$              ; да - просто игнорируем команду, выводить то нечего
                                        ; нет - в командной строке
                jsr     R5, OutersI$    ; вывод сообщения
                .word   24              ; "Echo is"
                call    ECHOST          ; Получение состояния переменной окружения ECHO
                                        ; выход: R0 - числовое значение состояния
                                        ;        R1 - строковое значение переменной окружения
                br      5$              ; и выведем его

2$:             mov     R4, R1          ; выведем то, что было за командой
                inc     R1
5$:             iot
                .word   11              ; Вывод строки символов на устройство вывода
4$:             jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
; Получение состояния переменной окружения ECHO
; выход: R0 - числовое значение состояния
;        R1 - строковое значение переменной окружения
ECHOST:         clrb    C$SENV(R3)      ; сбросим флаг
                mov     #1, R1          ; номер переменной окружения ECHO
                call    VARNAM          ; формирование в буфере имени переменной окружения
                                        ; вход:  R1 - номер переменной в массиве переменных, счёт начинается с 1: 1..n
                                        ; выход: R1, C$PENV(R3) - адрес конца строки в буфере #WRKBUF
                mov     #WRKBUF, R1     ; адрес буфера нужной нам переменной
                iot
                .word   67              ; Получить переменную из области окружения DOS.
                                        ; выход: R2 указывает на значение переменной в окружении DOS.
                                        ; R0 указывает на имя переменной в области окружения DOS.
                                        ; если переменной нет ,то С=1 и R2 указывает на свободную строку в области окружения DOS.
                bcs     1$              ; если такой переменной нету, пойдём устанавливать

                mov     C$ENVL(R3), R1  ; адрес списка значений констант
                ; получим номер константы
                call    STRNUM          ; поиск строки в массиве
                                        ; вход:  R1 - адрес начала массива строк
                                        ;        R2 - адрес эталонной строки
                                        ; выход: R0 - номер строки * 2
                                        ; если ошибок нет,
                                        ;        R1 - указатель на конец участка совпадения в эталонной строке
                                        ; если ошибки есть
                                        ;        R1 - указатель на начало эталонной строки
                bcs     1$
                movb    R0, C$ECHO(R3)  ; номер значения переменной окружения
                mov     R2, R1          ; строковое значение переменной окружения
                return

1$:             mov     #1, R1          ; номер значения ON для переменной окружения ECHO
                call    SETVAR          ; устанавливаем значение
                                        ; вход:  R1 - номер значения в массиве значений, счёт начинается с 1: 1..n
                incb    C$SENV(R3)      ; отмечаем, что установили
                br      ECHOST          ; повторим попытку получения переменной ECHO

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды TYPE
FCBType$ = WRKBUF
CM$TYP:         mov     #FCBType$, R4     ; буфер для временного FCB
                call    NEXTTK          ; пропустим пробелы, вроде ничего другого тут сделать не получится.
                call    SyntaxName2$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     1$              ; если не получилось - выход
                iot
                .word   17              ; Открыть файл методом FCB.
                bcs     1$
                mov     #FCBType$ + FCB$SZ, F$DTAD(R4) ; адрес обмена - сразу за временным FCB
                mov     #1, F$RCSZ(R4)  ; размер записи в байтах.
14$:            clr     (R3)            ; очищаем флаг.
4$:             iot
                .word   24              ; Последовательное чтение из файла.
                                        ; вход: R4-адрес FCB.
                                        ; После чтения соответствующие поля FCB модифицируются.
                bcs     2$              ; если неудача - выход
                iot
                .word   15              ; Инициализировать драйвер (контроллер) дисковода.
                movb    @F$DTAD(R4), R0 ; что прочитали
                beq     8$              ; 0 ? - это бкшный перевод строки
                cmpb    #32, R0         ; это ^Z ?
                beq     2$              ; да - конец файла
3$:             cmpb    R0, #12         ; это что ?
                beq     8$              ; да - делаем перевод строки.
                bhi     5$              ; код больше 12
                tst     (R3)            ; а коды 1..11 обрабатываются по особому.
                beq     6$              ; первый
                asl     R0
                asl     R0
                asl     R0
6$:             movb    R0, R5
                inc     (R3)
                mov     #40, R0
7$:             iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                sob     R5, 7$
                br      4$
; в общем. коды 1..11. Если это первый код, то он означает количество пробелов.
; а второй и все следующие идущие подряд коды 1..11 означают количество пробелов * 8.

5$:             iot                     ; а все остальные символы - выводим средствами ДОС
                .word   2               ; Вывод символа на стандартное устройство вывода
                br      14$             ; и продолжим

8$:             call    CRLFOU          ; сделать перевод строки, т.к. 0 - бкшный перевод строки
                br      14$             ; и продолжим

2$:             iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды REName
FCBRen$ = WRKBUF
CM$REN:         mov     #FCBRen$, R4     ; буфер для временного FCB
                ; имя - что переименовываем
                call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     1$
                add     #F$MDRV, R4     ; буфер для получения модифицированного временного FCB
                ; имя - на что переименовываем
                call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     1$
                mov     #FCBRen$, R4     ; буфер для модифицированного временного FCB для переименования
                iot
                .word   27              ; Переименовать файл.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды DEL и ERASE
FCBDel$ = WRKBUF
CM$DEL:         call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     1$              ; если было, но не удалось, выйдем
                mov     #FCBDel$, R4
                call    SyntaxName1$    ; делаем простой синтаксический разбор строки
                                        ; вход: R1 - адрес обрабатываемой строки.
                                        ;       R4 - адрес формируемого FCB-блока.
                bcs     1$
                cmp     #13, R2         ; имя файла - любое имя?
                bne     2$              ; нет
                ; да - вывод дополнительного запроса
                jsr     R5, OutersI$    ; вывод сообщения
                .word   5               ; "Аре ыоу суре?"
                iot
                .word   1               ; Ввод символа со стандартного устройства ввода
                bcs     1$
                bic     #177240, R0
                cmp     #'Y, R0         ; и если ответили утвердительно
                bne     1$              ; то только тогда удалять.
2$:             iot
                .word   23              ; Удалить файл.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды SET
CM$SET:         call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     1$              ; если было, но не удалось, выйдем
                call    SKIPWS          ; пропустим пробелы
                tstb    (R1)            ; строка закончилась
                beq     4$              ; да
                iot                     ; нет
                .word   70              ; Записать переменную в область окружения DOS.
                                        ; вход: R1-адрес строки.
                return
; SET без параметров тупо выводит на экран список переменных окружения
4$:             iot
                .word   40              ; Получить адрес области окружения DOS.
                                        ; выход: R1-адрес начала области.
                                        ;        R2-размер области в байтах.
                add     R1, R2          ; адрес конца области окружения
2$:             movb    (R1)+, R0       ; получим очередной символ
                beq     1$              ; если всё закончилось, то просто выйдем
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                tstb    (R1)            ; дошли до конца строки?
                bne     3$              ; нет
                call    CRLFOU          ; сделать перевод строки
                inc     R1              ; пропустим конец строки
3$:             cmp     R1, R2          ; дошли до конца области окружения?
                blos    2$              ; нет.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды COPY
CM$COP:         clr     C$QNSS(R3)      ; чистим счётчики '?' в шаблонах источника и приёмника
                clr     C$FLCN(R3)      ; счётчик скопированных файлов
                clrb    C$OFCF(R3)      ; сбрасываем флаг, что выходной файл уже создан
                call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     1$              ; если было, но не удалось, выйдем
                call    SKIPWS
                mov     R1, -(SP)
2$:             mov     #17, R5
3$:             movb    (R1), R0
                beq     4$
                cmpb    #40, R0
                bne     5$
                call    NEXTTK
                bcs     6$
                cmpb    #'+, (R1)
                bne     2$
7$:             jmp     CPY$AD          ; склейка

5$:             inc     R1
                sob     R5, 3$
                jsr     R5, OutersI$    ; вывод сообщения
                .word   2               ; "Bad command or file name"
6$:             mov     (SP)+, R1
1$:             return

; копирование типа шаблон1 -> шаблон2
FCBSrc$ = WRKBUF
FCBDst$ = FCBSrc$ + FCB$SZ
4$:             mov     (SP)+, R1
                mov     #FCBSrc$, R4    ; тут FCB источника
                inc     R2              ; формирование шаблона источника
                iot
                .word   51              ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0,то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                bcs     ERR1$
                movb    R2, C$QNSS(R3)  ; количество символов '?' в шаблоне источнике
                add     #FCB$SZ, R4     ; тут FCB приёмника
                call    NEXTTK          ; ищем следующий токен
                bcs     ERR1$           ; если нету - то ошибка, конец строки - не ошибка
                inc     R2              ; формирование шаблона приёмника
                iot
                .word   51              ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0,то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                bcs     ERR1$
                movb    R2, C$QNSD(R3)  ; количество символов '?' в шаблоне приёмнике
                mov     R4, -(SP)
                mov     R4, R5          ; проверим
                sub     #FCB$SZ, R5     ; не копируем ли
                mov     #13, R0         ; сами в себя
8$:             cmpb    (R5)+, (R4)+
                bne     9$              ; если нет - то продолжим
                sob     R0, 8$
                mov     (SP)+, R4
                jsr     R5, OutersI$    ; вывод сообщения
                .word   7               ; "File cannot be copied onto itself"
                jmp     CPY$EX          ; и выходим.

9$:             mov     (SP)+, R4       ; тут FCB приёмника
                mov     #FCB$SZ, R0
                add     R0, R4
                mov     R4, C$FCST(R3)  ; буфер временного FCB источника
                add     R0, R4
                mov     R4, C$FCDT(R3)  ; буфер временного FCB приёмника
                add     R0, R4
                mov     R4, C$CPBF(R3)  ; адрес начала буфера для копирования
                mov     C$USED(R3), R0  ; адрес конца буфера для копирования
                sub     R4, R0          ; рассчитаем
                mov     R0, C$CPBS(R3)  ; размер доступного буфера для копирования
                mov     #FCBSrc$, R4    ; FCB источника
                iot
                .word   21              ; Найти первый файл по образцу.
                bcs     ERR1$           ; ничего не нашлось - выйдем с ошибкой
                cmp     #-1, R1         ; указатель получился ?
                bne     10$             ; да
                tstb    C$QNSD(R3)      ; нет. а для приёмника задавали шаблон?
                beq     10$             ; нет, полное имя - значит норма
                ; да, шаблон - значит ошибка
                jsr     R5, OutersI$    ; вывод сообщения
                .word   2               ; "Bad command or file name"
                return

ERR1$:          sec
 ; обработка команды REM, комментарий
CM$REM:         return

15$:            cmp     #-1, R1
                beq     16$

10$:            tstb    C$QNSS(R3)      ; в шаблоне источника были "?"
                beq     11$             ; нет
                mov     R1, -(SP)
                mov     #13, R5         ; да
12$:            movb    (R1)+, R0       ; выведем имя найденного файла
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                sob     R5, 12$
                call    CRLFOU          ; сделать перевод строки
                mov     (SP)+, R1
11$:            mov     C$FCST(R3), R5  ; временный FCB шаблона источника
                mov     R5, -(SP)
                movb    (R4), (R5)+     ; скопируем привод из FCB источника во временный FCB источника
                cmp     #-1, R1         ; указатель есть?
                bne     14$             ; да - имя берём из найденной записи
                mov     #FCBSrc$+1, R1  ; нет - имя берём из FCB источника
14$:            mov     #13, R0
13$:            movb    (R1)+, (R5)+
                sob     R0, 13$

                mov     (SP)+, R4       ; временный FCB шаблона источника
                mov     #FCBDst$, R2    ; FCB приёмника
                mov     C$FCDT(R3), R5  ; буфер временного FCB приёмника
                movb    (R2)+, (R5)+    ; копируем туда из FCB приёмника привод
                inc     R4              ;
                mov     #13, R0         ; формируем выходное имя
19$:            cmpb    #'?, (R2)       ; если не вопрос
                beq     17$
                movb    (R2), (R5)+     ; берём символ из FCB приёмника
                br      18$

17$:            movb    (R4), (R5)+    ; берём символ из временного FCB шаблона источника
18$:            inc     R2
                inc     R4
                sob     R0, 19$

                call    COPYFL          ; выполняем собственно процедуру копирования данных
                bcs     20$
                mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника
                tstb    C$QNSD(R3)      ; приёмник задавали шаблоном
                beq     21$             ; нет
                clrb    C$OFCF(R3)      ; да - сбрасываем флаг, что выходной файл уже создан
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                bcs     ERR1$

21$:            mov     #FCBSrc$, R4
                iot
                .word   22              ; Продолжить поиск файлов.
                bcc     15$             ; если ещё что-то нашлось - продолжаем
                cmpb    @#ERRFDD, #25   ; если не ошибка 25
                bne     22$             ; молча выходим
16$:            tstb    C$OFCF(R3)      ; иначе, выходной файл создан?
                beq     CPY$EX          ; нет, наверное уже закрыт
20$:            mov     C$FCDT(R3), R4  ; закроем результирующий файл
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
CPY$EX:         mov     C$FLCN(R3), R0  ; счётчик скопированных файлов
                call    ITOA16          ; вывод числа из R0
                jsr     R5, OutersI$    ; вывод сообщения
                .word   12              ; "file "
                jsr     R5, OutersI$    ; вывод сообщения
                .word   23              ; " copied"
                call    CRLFOU          ; сделать перевод строки
22$:            tst     (PC)+
CPY$ER:         sec
                return
; ───────────────────────────────────────────────────────────────────────────
; собственно процедура копирования содержимого файла
COPYFL:         mov     C$FCST(R3), R4  ; буфер временного FCB источника - тут сформирован конкретный файл из найденного по шаблону
                tstb    C$OFCF(R3)      ; выходной файл уже создан ?
                bne     1$              ; да - пропускаем проверку, делали уже
                mov     R4, R1
                mov     C$FCDT(R3), R2  ; проверим
                mov     #14, R0         ; не копируем ли
2$:             cmpb    (R1)+, (R2)+    ; файл сам в себя
                bne     1$
                sob     R0, 2$
                jsr     R5, OutersI$    ; вывод сообщения
                .word   7               ; нельзя копировать себя в себя
                br      CPY$ER

1$:             iot
                .word   17              ; Открыть файл методом FCB.
                bcs     ERR2$
                clrb    C$EORF(R3)      ; очищаем флаг что прочли неполный буфер
                mov     F$FLSZ(R4), C$TMP1(R3)  ; размер файла в байтах (мл.слово)
                mov     F$FLSZ+2(R4), C$TMP2(R3)    ;(ст.слово)
10$:            mov     #1, F$RCSZ(R4)  ; размер записи в байтах
                mov     C$CPBF(R3), F$DTAD(R4)  ; адрес обмена
                mov     C$CPBS(R3), R0  ; размер буфера для копирования
                tstb    F$IDEV(R4)      ; идентификатор устройства.
                bmi     3$
                tst     C$TMP2(R3)      ; если файл меньше
                bne     3$
                cmp     R0, C$TMP1(R3)  ; чем размер буфера
                blos    3$
                mov     C$TMP1(R3), R0  ; то читаем столько, сколько байтов в файле
                beq     4$
3$:             iot
                .word   47              ; Считать несколько записей.
                bcs     ERR2$
                tst     R0              ; что прочиталось?
                beq     5$              ; ничего - выйдем
                mov     R0, -(SP)
                tstb    F$IDEV(R4)      ; идентификатор устройства.
                bpl     6$
                cmp     C$CPBS(R3), R0  ; прочитался полный буфер?
                beq     6$              ; да
                incb    C$EORF(R3)      ; нет - отметим этот факт.
6$:             mov     R4, R5          ; временный FCB источника
                mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника для копирования
                tstb    C$OFCF(R3)      ; выходной файл уже создан ?
                bne     7$              ; да - пропускаем создание
                incb    C$OFCF(R3)      ; нет - помечаем, что создан
                iot
                .word   26              ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
7$:             mov     (SP)+, R0
                bcs     ERR2$
                mov     F$FLDT(R5), F$FLDT(R4)  ; дата создания файла.
                mov     F$FLLD(R5), F$FLLD(R4)  ; адрес загрузки файла в память (для исполняемых файлов)
                mov     #1, F$RCSZ(R4)  ; размер записи в байтах.
                mov     C$CPBF(R3), F$DTAD(R4)  ; адрес обмена
                tstb    F$IDEV(R4)      ; идентификатор устройства.
                bpl     8$
                iot
                .word   15              ; Инициализировать драйвер (контроллер) дисковода.
8$:             iot
                .word   50              ; Записать несколько записей.
                bcs     ERR2$
                mov     R5, R4          ; временный FCB источника
                tstb    F$IDEV(R4)      ; идентификатор устройства.
                bpl     9$              ; если не системные стандартные устройства
                tstb    C$EORF(R3)      ; прочитали неполный буфер
                bne     4$              ; да - значит всё
                br      10$             ; а иначе повторим

9$:             sub     R0, C$TMP1(R3)  ; отнимаем буфер от размера файла
                sbc     C$TMP2(R3)
                ;tst     C$TMP2(R3)     ; ещё там осталось копировать?
                bne     10$
                tst     C$TMP1(R3)      ; да, осталось.
                bne     10$             ; и продолжим.
4$:             inc     C$FLCN(R3)      ; сосчитаем скопированный файл.
5$:             iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
ERR2$:          jmp     ERCTCH
; ───────────────────────────────────────────────────────────────────────────

CPY1EX:         jmp     CPY$EX
; копирование со склейкой нескольких файлов в один
CPY$AD:         clrb    C$IADS(R3)      ; чистим флаги.
                clr     R5              ; счётчик склеиваемых файлов, заданных в командной строке
                clr     C$NADF(R3)      ; счётчик открываемых файлов
                mov     (SP)+, R1
                mov     #FCBSrc$, R4    ; начало буферов FCB источников
3$:             cmpb    #'+, (R1)       ; нашли "+" ?
                bne     1$              ; нет - значит должно быть имя файла
                inc     R5              ; да - подсчитаем найденное имя файла
                inc     R1              ; двинемся за "+"
                br      2$              ; идём искать начало имени файла

1$:             inc     C$NADF(R3)      ; подсчитаем открываемый файл
                call    SyntaxName2$
                bcs     CPY1EX          ; если ошибка - выйдем
                add     #FCB$SZ, R4     ; указатель на следующий буфер FCB
2$:             call    NEXTTK          ; ищем следующий токен - имя файла или "+"
                bcs     CPY1EX
                cmpb    (R1), #40       ; если что-то нашли, то
                bhis    3$              ; пойдём обработаем
                inc     R5              ; первый файл перед "+" тоже надо сосчитать
                sub     C$NADF(R3), R5  ; узнаем, скока файлов склеивать и скока из них надо открыть
                mov     R4, C$FCST(R3)  ; буфер временного FCB источника для копирования
                add     #FCB$SZ, R4
                mov     R4, C$FCDT(R3)  ; буфер временного FCB приёмника для копирования
                add     #FCB$SZ, R4
                mov     R4, C$CPBF(R3)  ; адрес начала буфера для копирования
                mov     C$USED(R3), R0  ; адрес начала занятой коммандкомом памяти
                sub     R4, R0          ; узнаем, сколько памяти осталось под буфер копирования
                mov     R0, C$CPBS(R3)  ; размер буфера для копирования
                tst     R5              ; какие наши дальнейшие действия?
                bne     4$              ; такие
                jmp     L5374           ; или другие

4$:             mov     #FCBSrc$, R4     ; начало буферов FCB источников
                mov     #FCB$SZ, R0     ; размер буферов
                clr     R1
                mov     C$NADF(R3), R2  ; сколько буферов зарезервировали
                dec     R2
                mov     R2, R5          ; сохраним на будущее
                call    MULTIP          ; умножение
                                        ; вход:  R1:R0 - множимое
                                        ;        R2 - множитель
                                        ; выход: R1:R0 - результат
                add     R0, R4          ; получим конец области буферов
                mov     R4, C$FCBD(R3)  ; конец области буферов FCB источников для копирования при склейке файлов, и по идее буфер FCB приёмника
                mov     R4, R2
                mov     #FCBSrc$, R4
                cmp     R4, R2          ; начало совпадает с концом?
                bne     5$              ; нет
8$:             add     #FCB$SZ, R4     ; а если да, то в C$NADF(R3) было 1 и мы охренеть как зациклимся!!!
5$:             mov     R4, -(SP)
                mov     R2, -(SP)
                mov     #14, R0         ; проверка на копирование источников
6$:             cmpb    (R2)+, (R4)+    ; в один из источников
                bne     7$
                sob     R0, 6$
                cmp     (SP)+, (SP)+
                ; если да - то не дадим делать такое действие
                jsr     R5, OutersI$    ; вывод сообщения
                .word   20              ; об ошибке
                jmp     CPY$EX

7$:             mov     (SP)+, R2
                mov     (SP)+, R4
                sob     R5, 8$          ; и далее по списку. если в C$NADF(R3) было 1 тут будет зацикливание с крашем!!!
                ; так что тут вместо sob надо использовать dec R5 bpl 8$

19$:            mov     #FCBSrc$, C$SFBF(R3) ; начало буферов FCB источников
                movb    #1, C$IADS(R3)  ; счётчик позиций в массиве буферов FCB источников
18$:            mov     C$SFBF(R3), R4  ; берём буфер очередного FCB
                tstb    C$FSFL(R3)      ; первый раз?
                bne     9$              ; нет
                iot                     ; да - ищем первый файл
                .word   21              ; Найти первый файл по образцу.
                bcs     11$             ; неудача - конец копирования
                br      10$

9$:             iot                     ; ищем следующие файлы
                .word   22              ; Продолжить поиск файлов.
                bcs     11$             ; неудача - конец копирования
                cmp     #-1, R1         ; конкретную запись получить не удалось?
                beq     11$             ; конец копирования (почему при первом поиске можно, а при последующем нельзя, непонятно)
10$:            mov     C$FCST(R3), R2  ; буфер временного FCB источника для копирования
                cmp     #-1, R1         ; если при начале копирования конкретную запись получить не удалось
                bne     12$             ;
                mov     C$SFBF(R3), R1  ; то используем текущий буфер FCB источника.
                inc     R1
12$:            movb    (R4)+, (R2)+
                mov     R2, -(SP)
                mov     #13, R5
13$:            movb    (R1)+, R0
                movb    R0, (R2)+
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                sob     R5, 13$         ; формируем временный FCB источника для копирования
                call    CRLFOU          ; сделать перевод строки
                mov     (SP)+, R2
                cmp     #FCBSrc$, C$SFBF(R3) ; сейчас обрабатываем первый файл?
                bne     14$             ; уже нет
                mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника для копирования
                mov     C$FCBD(R3), R1  ; буфер FCB приёмника для копирования
                mov     #13, R5         ; формируем выходное имя
                movb    (R1)+, (R4)+
17$:            cmpb    #'?, (R1)       ; шаблон?
                beq     15$
                movb    (R1), (R4)+
                br      16$

15$:            movb    (R2), (R4)+
                incb    C$QNSD(R3)      ;(1б) количество '?' в шаблоне приёмника для копирования
16$:            inc     R2
                inc     R1
                sob     R5, 17$
14$:            call    COPYFL          ; просто копируем файл источник в файл приёмник
                bcs     11$
                add     #FCB$SZ, C$SFBF(R3) ; переходим к следующему файлу источнику
                incb    C$IADS(R3)      ; увеличиваем счётчик
                cmpb    C$IADS(R3), C$NADF(R3)  ; ещё не конец?
                blo     18$             ; продолжим. Вот это классический сишный цикл for (i=1; i<n; i++)
                incb    C$FSFL(R3)      ; выставляем флаг следующего захода
                tstb    C$QNSD(R3)      ; приёмник был задан шаблоном?
                beq     19$             ; нет - повторим заход.
                mov     C$FCDT(R3), R4  ; да - буфер временного FCB приёмника для копирования
                clrb    C$OFCF(R3)      ;(1б) флаг, что выходной файл уже создан для копирования
                iot                     ; закроем текущий выходной файл
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                bcc     19$             ; и если всё в порядке - повторим заход, чтобы скопировать в следующий файл по шаблону

11$:            mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника для копирования
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
111$:           jmp     CPY$EX          ; выход
; ───────────────────────────────────────────────────────────────────────────
; обработка операции типа COPY <шаблон1> + <шаблон2> + ... + <шаблон N>
;- приклеивание к файлу <шаблон1> остальных.
L5374:          mov     #FCBSrc$, R4
                mov     R4, C$FCBD(R3)  ; конец области буферов FCB источников для копирования при склейке файлов, и по идее буфер FCB приёмника
                mov     C$FCDT(R3), R5  ; буфер временного FCB приёмника для копирования
                mov     #13, R0
                mov     R5, -(SP)
                movb    (R4)+, (R5)+
1$:             cmpb    #'?, (R4)
                bne     2$
                incb    C$QNSD(R3)      ; количество '?' в шаблоне приёмника для копирования
2$:             movb    (R4)+, (R5)+    ; формируем FCB приёмника
                sob     R0, 1$
                mov     (SP)+, R4
3$:             mov     #FCBDst$, C$SFBF(R3)  ; начало буферов FCB источников
                movb    #1, C$IADS(R3)  ; счётчик позиций в массиве буферов FCB источников
4$:             mov     C$SFBF(R3), R4  ; берём буфер очередного FCB
                tstb    C$FSFL(R3)      ; первый раз?
                bne     5$              ; нет
                iot                     ; да - ищем первый файл
                .word   21              ; Найти первый файл по образцу.
                bcs     6$              ; неудача - конец копирования
                br      7$

5$:             iot                     ; ищем следующие файлы
                .word   22              ; Продолжить поиск файлов.
                bcs     6$              ; неудача - конец копирования
                cmp     #-1, R1         ; конкретную запись получить не удалось?
                beq     6$              ; конец копирования (почему при первом поиске можно, а при последующем нельзя, непонятно)
7$:             mov     C$FCST(R3), R5  ; буфер временного FCB источника для копирования
                cmp     #-1, R1         ; если при начале копирования конкретную запись получить не удалось
                bne     8$
                mov     C$SFBF(R3), R1  ; то используем текущий буфер FCB источника.
                inc     R1
8$:             movb    (R4)+, (R5)+
                mov     #13, R2
9$:             movb    (R1)+, R0
                movb    R0, (R5)+
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                sob     R2, 9$          ; формируем временный FCB источника для копирования
                call    CRLFOU          ; сделать перевод строки
                tstb    C$QNSD(R3)      ; выходной файл задавался шаблоном?
                beq     10$             ; нет
                mov     C$FCST(R3), R4  ; буфер временного FCB источника для копирования
                mov     C$FCDT(R3), R5  ; буфер временного FCB приёмника для копирования
                mov     #FCBSrc$, R2    ; буфер FCB начального шаблона
                movb    (R2)+, (R5)+
                mov     #13, R0
                inc     R4
11$:            cmpb    #'?, (R2)
                bne     12$
                movb    (R4), (R5)+     ; формируем окончательное FCB приёмника
                br      13$

12$:            movb    (R2), (R5)+
13$:            inc     R2
                inc     R4
                sob     R0, 11$

10$:            tstb    C$OFCF(R3)      ; флаг, что выходной файл уже создан для копирования
                bne     14$             ; да, создан
                incb    C$OFCF(R3)      ; нет - создадим
                mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника для копирования
                iot
                .word   17              ; Открыть файл методом FCB.
                mov     F$FLSZ(R4), F$RECN(R4)  ; указатель seek в конец файла
                mov     F$FLSZ+2(R4), F$RECN+2(R4)
                bcc     14$             ; если открылся, то норма
                cmpb    @#ERRFDD, #25   ; случилась ошибка 25?
                bne     15$             ; нет - входим
                iot                     ; да - создадим файл
                .word   26              ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
                bcs     15$
14$:            call    COPYFL          ; копируем
                bcs     6$
                add     #FCB$SZ, C$SFBF(R3) ; переходим к следующему файлу источнику
                incb    C$IADS(R3)      ; увеличиваем счётчик
                cmpb    C$IADS(R3), C$NADF(R3)  ; ещё не конец?
                blo     4$              ; продолжим.
                incb    C$FSFL(R3)      ; выставляем флаг следующего захода
                tstb    C$QNSD(R3)      ; приёмник был задан шаблоном?
                beq     3$              ; нет - повторим заход.
                mov     C$FCDT(R3), R4  ; да - буфер временного FCB приёмника для копирования
                clrb    C$OFCF(R3)      ; флаг, что выходной файл уже создан для копирования
                iot                     ; закроем текущий выходной файл
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                bcc     3$              ; и если всё в порядке - повторим заход, чтобы скопировать в следующий файл по шаблону
                br      15$             ; а вот тут не забыли jmp     CPY$EX

6$:             mov     C$FCDT(R3), R4  ; буфер временного FCB приёмника для копирования
                iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
15$:            jmp     CPY$EX          ; выход

; ═══════════════════════════════════════════════════════════════════════════
; обработка параметров командной строки команды DIR
; Вход: R1 - адрес в строке
DIRCMD:         call    DIRKEY          ; поищем ключи
                bcs     ERR3$
                call    SKIPWS
                bit     #100000, (R3)
                beq     1$
                cmpb    #40, (R1)
                bhi     RET1$
1$:             bis     #100000, (R3)
                mov     R1, R5
                cmpb    #'>, (R1)
                bne     2$
                clrb    (R1)
                bis     #40000, (R3)
2$:             mov     #WRKBUF+IOBFSZ, R4  ; тут будет шаблон вывода дир.
                inc     R2              ; непростой разбор
                iot
                .word   51              ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0,то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                bcs     RET1$
                bit     #40000, (R3)
                beq     3$
                movb    #'>, (R5)
3$:             call    SKIPWS
                return  ;!!! похоже, тут сэкономили на returne, т.к. после знака > искать ключи бессмысленно
; ═══════════════════════════════════════════════════════════════════════════
; обработка ключей командной строки команды DIR
; слово состояния ключей
; бит 0 (01) - P
; бит 1 (02) - W
; бит 2 (04) - H
; бит 3 (10) - F
; бит 14 - наличие перенаправления
; бит 15 - наличие шаблона ???
DIRKEY:         call    SKIPWS          ; пропустим пробелы
                cmpb    #'/, (R1)       ; есть слеш?
                bne     1$              ; нет - конец
                inc     R1              ; пропустим
                call    SKIPWS          ; между слешем и ключом оказывается можно ставить пробелы
                movb    (R1)+, R0       ; посмотрим ключ.
                cmpb    #'P, R0
                bne     2$
                bis     #1, (R3)
                br      DIRKEY          ; и поищем следующий ключ

2$:             cmpb    #'W, R0
                bne     4$
                bis     #2, (R3)
                br      DIRKEY          ; и поищем следующий ключ

4$:             cmpb    #'H, R0
                bne     5$
                bis     #4, (R3)
                br      DIRKEY          ; и поищем следующий ключ

5$:             cmpb    #'F, R0
                bne     ERR3$
                bis     #10, (R3)
                br      DIRKEY          ; и поищем следующий ключ

1$:             clc
                return

ERR3$:          movb    #46, @#ERRFDD   ; ошибка параметров команды DIR
                sec
RET1$:          return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды DIR
CM$DIR:         clr     C$FLCN(R3)      ; счётчик файлов в каталоге
                call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     6$
                mov     #4, R4          ; кол-во столбцов, умещающихся на экране
                tstb    C$MONT(R3)      ; что за монитор?
                bne     1$              ; БК11
                emt     34              ; чтение слова состояния дисплея. БК10
                bit     #1, R0          ; 32 символа в строке?
                beq     2$              ; нет
                br      3$              ; да

1$:             cmpb    C$MONT(R3), #2  ; это БК11?
                beq     4$              ; да
                emt     52              ; чтение режима драйвера экрана БК11М
                bic     #177770, R0     ; что там?
                beq     2$              ; обычный 64 символа в строке
                cmp     #4, R0          ; 80 символов в строке?
                beq     2$              ; да
                br      3$              ; иначе - 32 символа в строке

4$:             mov     #WRKBUF, R0     ; для БК11 всё посложнее
                emt     34              ; чтение слова состояния дисплея. БК11
                bit     #2, (R0)        ; режим 64 символа в строке?
                bne     2$              ; да
3$:             asr     R4              ; нет - 32 символа, значит на экране в ширину помещается в 2 раза меньше
2$:             movb    R4, C$CLNM(R3)  ; кол-во столбцов, умещающихся на экране
                movb    R4, C$TMP1(R3)  ; счётчик столбцов, выводимых на экран
                movb    C$STNM(R3), C$TMP2(R3)  ; счётчик строк, выводимых на экране
                clr     (R3)            ; тут будут параметры ключей команды
                mov     R1, -(SP)
                mov     #2, R1          ; имя переменной окружения DIRCMD
                call    VARNAM          ; формирование в буфере имени переменной окружения
                                        ; вход:  R1 - номер переменной в массиве переменных, счёт начинается с 1: 1..n
                                        ; выход: R1, C$PENV(R3) - адрес конца строки в буфере #WRKBUF
                mov     #WRKBUF, R1
                iot
                .word   67              ; Получить переменную из области окружения DOS.
                                        ; вход:  R1-адрес имени переменной.
                                        ; выход: R2-указывает на значение переменной в окружении DOS.
                                        ;        R0-указывает на имя переменной в области окружения DOS.
                                        ;        если переменной нет, то С=1 и R2-указывает на свободную
                                        ;        строку в области окружения DOS.
                bcs     5$              ; если нету - то обработаем параметры командной строки
                mov     R2, R1          ; если есть - сперва обработаем её значение
                call    DIRCMD          ; разбор параметров
                bcs     6$
5$:             mov     (SP)+, R1
                call    DIRCMD          ; разбор параметров
                bcc     7$
6$:             return
; собственно процедура вывода каталога на экран
7$:             mov     #WRKBUF+IOBFSZ, R4  ; FCB шаблона
                movb    (R4), R0        ; номер дисковода
                iot
                .word   66              ; Получить размер свободного пространства на диске.
                bcs     6$
                                        ; R0 количество свободных кластеров.
                mov     R2, -(SP)       ; общее количество кластеров на диске.
                mov     R1, -(SP)       ; секторов в кластере.
                mov     R1, R2
                clr     R1              ; умножаем количество свободных кластеров на количество секторов в кластере.
                                        ; получим количество свободных секторов.
                call    MULTIP          ; вход:  R1:R0 - множимое
                                        ;        R2 - множитель
                                        ; выход: R1:R0 - результат
                mov     #512., R2       ; потом умножаем на 512.
                call    MULTIP          ; и получим количество свободного места в байтах
                mov     R0, C$FRES(R3)  ; и сохраним, это мл. слово
                mov     R1, C$FRES+2(R3) ; это ст. слово
                mov     (SP)+, R2       ; секторов в кластере.
                mov     (SP)+, R0       ; общее количество кластеров на диске.
                clr     R1
                call    MULTIP
                mov     #512., R2
                call    MULTIP          ; теперь получим общий размер диска в байтах
                mov     R0, C$VOLS(R3)  ; и сохраним, это мл. слово
                mov     R1, C$VOLS+2(R3) ; это ст. слово
                bit     #10, (R3)       ; был ключ /F ?
                bne     8$              ; да - пойдём просто выведем размер свободного пространства.
                                        ; безо всяких каталогов.
                ; вона оно как оказывается. а я думал будет просто более полный вид в виде доп. инфы в конце.
                iot
                .word   21              ; Найти первый файл по образцу.
                bcs     6$              ; ничего не найдено - молча выйдем. ничего не выводя.
9$:             mov     #13, R2
                movb    K$ATTR(R1), R5  ; атрибуты найденной записи
                movb    R5, C$FATR(R3)  ; сохраним
                ;bit     #A$DIR, R5      ; это каталог? !!!ненужная проверка на каталог тут
                ;bne     10$             ;!!! каталоги ещё не реализованы
                ; обработка каталогов
                ; ......
                ; ......
10$:            bit     #A$HIDDEN, R5   ; скрытый?
                beq     11$             ; нет
                bit     #4, (R3)        ; скрытые показывать?
                beq     12$             ; нет - пропустим запись.
11$:            movb    (R1)+, R0       ; скрытые, но не системные пропускаем,
                                        ; скрытые, но системные и обычные - выводим.
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                cmp     #4, R2          ; пора выводить расширение?
                bne     13$             ; нет ещё
                mov     (PC)+, R0       ; будем выводить
                .byte   277, 40         ; кирпич для скрытого, пробел для обычного файла
                bit     #A$HIDDEN, R5   ; скрытый?
                bne     14$             ; да
                swab    R0              ; нет - меняем на пробел
14$:            iot
                .word   2               ; Вывод символа на стандартное устройство вывода
13$:            sob     R2, 11$
                inc     C$FLCN(R3)      ; сосчитаем запись
                call    SPSOUT
                mov     R1, R5          ; сейчас указывает на атрибуты
                decb    C$TMP1(R3)      ; счётчик столбцов умещающихся на экране
                bit     #2, (R3)        ; ключ /W был ?
                bne     16$             ; да - пропустим подробности
                bitb    #A$DIR, C$FATR(R3) ; нет, запись - каталог ?
                beq     17$             ; нет
                dec     C$FLCN(R3)      ; да - не считается.
                jsr     R5, OutersI$    ; вывод сообщения
                .word   22              ; " <DIR> "
                br      18$             ; и идём дальше

8$:             br      15$             ; да-да, идём-идём

17$:            add     #K$SIZE-K$ATTR, R1 ; а если не каталог, то
                mov     (R1)+, R0       ; надо вывести размер файла
                mov     (R1), R1
                call    ITOA            ; вывод числа из R1:R0
                call    SPSOUT          ; пробел
18$:            add     #K$TLWR-K$ATTR, R5 ; указатель на Время выполнения последней операции записи в файл
                mov     (R5)+, R1       ; в оригинале, а у нас - адрес загрузки файла
                call    OUT8            ; выводим адрес загрузки
                call    SPSOUT
                mov     (R5)+, R0       ; затем дата создания
                cmpb    C$CLNM(R3), #2  ; вывод в 2 столбца?
                beq     16$             ; да - дата не полезает тогда
                call    DATOUT          ; иначе выводим дату
16$:            bit     #1, (R3)        ; ключ /P был ?
                beq     19$             ; нет - не проверяем, сколько чего вывелось
                tstb    C$TMP2(R3)      ; строки все заполнились?
                bne     20$             ; нет ещё
                movb    C$STNM(R3), C$TMP2(R3)  ; да - восстановим значение
                call    CRLFOU          ; сделать перевод строки
                call    PRANYK          ; попросим нажать любую клавишу
                br      19$             ; и продолжаем вывод

20$:            bit     #2, (R3)        ; ключ /W был ?
                bne     21$             ; да - тогда вывод в несколько столбцов
                br      23$             ; нет

19$:            bit     #2, (R3)        ; ключ /W был ?
                beq     22$             ; нет
21$:            tstb    C$TMP1(R3)      ; столбцы кончились?
                bne     12$             ; нет ещё
                movb    C$CLNM(R3), C$TMP1(R3)  ; восстановим значение
23$:            decb    C$TMP2(R3)      ; и уменьшаем счётчик строк
22$:            call    CRLFOU          ; сделать перевод строки
12$:            iot
                .word   22              ; Продолжить поиск файлов.
                bcc     9$              ; если что-то нашлось - продолжим
                cmpb    @#ERRFDD, #25   ; есть ошибка 25?
                bne     RET2$           ; нет - молча выходим
                call    CRLFOU          ; сделать перевод строки
                mov     C$FLCN(R3), R0  ; количество найденных файлов
                call    ITOA16          ; вывод числа из R0
                jsr     R5, OutersI$    ; вывод сообщения
                .word   12              ; " file "

15$:            mov     C$FRES(R3), R0  ; свободное место
                mov     C$FRES+2(R3), R1
                call    ITOA            ; вывод числа из R1:R0
                jsr     R5, OutersI$    ; вывод сообщения
                .word   13              ; "byte free"
                call    CRLFOU          ; сделать перевод строки
                mov     C$VOLS(R3), R0  ; общий размер
                mov     C$VOLS+2(R3), R1
                call    ITOA            ; вывод числа из R1:R0
                jsr     R5, OutersI$    ; вывод сообщения
                .word   17              ; " bytes total disk space"
                return


; ═══════════════════════════════════════════════════════════════════════════
; вывод сообщения, чтобы нажали любую клавишу
PRANYK:
                jsr     R5, OutersI$    ; вывод сообщения
                .word   3               ; нажмите любую кнопку

                br      7312$

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды PAUSE
CM$PAU:         call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     RET2$
                call    NEXTTK          ; пропустим пробелы
                tstb    (R1)            ; за командой что-нибудь есть?
                beq     PRANYK          ; нет - выведем стандартное сообщение
                iot
                .word   11              ; Вывод строки символов на устройство вывода
7312$:          iot
                .word   15              ; Инициализировать драйвер (контроллер) дисковода.
                iot
                .word   1               ; Ввод символа со стандартного устройства ввода
                ; и перевод строки

; ═══════════════════════════════════════════════════════════════════════════
; вывод перевода строки
CRLFOU:         mov     #5015, R0
                iot
                .word   2
                swab    R0
                iot
                .word   2
                return


; ═══════════════════════════════════════════════════════════════════════════
; обработка команды CLS
CM$CLS:         cmpb    C$MONT(R3), #2  ; монитор - БК11М?
                bne     1$              ; нет
                emt     62              ; очистка экрана на БК11М
                return

1$:             emt     14              ; очистка экрана на БК10, БК11
RET2$:          return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды VER
CM$VER:         call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     RET2$
                jsr     R5, OutersI$    ; вывод сообщения
                .word   31              ; "DXDOS version"
                iot
                .word   60              ; Получить версию DOS.
                                        ; выход: R0-версия:
                                        ;        ст.байт номер версии, мл.байт номер подверсии.
                mov     R0, R5
                clrb    R0              ; оставляем ст. байт
                bic     R0, R5          ; оставляем мл. байт
                swab    R0              ; выводим версию
                call    ITOA16          ; вывод числа из R0
                mov     #'., R0
                incb    C$NMEV(R3)
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                mov     R5, R0          ; выводим подверсию
                call    ITOA16          ; вывод числа из R0
                clrb    C$NMEV(R3)
                jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
; вход:  R1 - номер выводимой строки
OUTERS:         .addr   R2, ERRTXT
                call    GETSTR          ; получение адреса строки из массива по её номеру
                                        ; вход:  R1 - номер строки, счёт начинается с 1: 1..n
                                        ;        R2 - адрес массива строк
                                        ; выход: R0 - номер строки, счёт начинается с 0.
                                        ;        R1,R2 - адрес строки
                iot
                .word   11              ; Вывод строки символов на устройство вывода
                return

OutersI$:       mov     (R5)+, R1
                call    OUTERS
                rts     R5


; ═══════════════════════════════════════════════════════════════════════════
; получение адреса строки из массива по её номеру
; вход:  R1 - номер строки, счёт начинается с 1: 1..n
;        R2 - адрес массива строк
; выход: R0 - номер строки, счёт начинается с 0.
;        R1,R2 - адрес строки
GETSTR:         clr     R0              ; тут формируется номер выдаваемой строки
                br      3$

2$:             tstb    (R2)+           ; перейдём к следующей строке в массиве
                bne     2$
                inc     R0              ; счётчик номера выдаваемой строки увеличим
3$:             sob     R1, 2$          ; уменьшаем входной номер.
                                        ; если цикл кончился, то нашли то, что надо
1$:             mov     R2, R1          ; нужный нам адрес, в выходной регистр
                return

; ═══════════════════════════════════════════════════════════════════════════
; формирование в буфере имени переменной окружения
; вход:  R1 - номер переменной в массиве переменных, счёт начинается с 1: 1..n
; выход: R1, C$PENV(R3) - адрес конца строки в буфере #WRKBUF
VARNAM:         mov     #WRKBUF, C$PENV(R3) ; адрес буфера, где будет формироваться строка
                mov     C$ENNM(R3), R2  ; адрес списка имён переменных окружения
                ; получим в R1 и R2 адрес нужной переменной окружения
                call    GETSTR          ; получение адреса строки из массива по её номеру
                                        ; вход:  R1 - номер строки, счёт начинается с 1: 1..n
                                        ;        R2 - адрес массива строк
                                        ; выход: R0 - номер строки, счёт начинается с 0.
                                        ;        R1,R2 - адрес строки
                ; скопируем строку в буфер
                call    STRBUF          ; копирование строки в буфер с завершающим нулём
                                        ; вход:  R2 - адрес строки
                                        ; выход: R1 - адрес конца строки в буфере, указывает на завершающий 0
                movb    #'=, (R1)+      ; допишем знак =
                mov     R1, C$PENV(R3)  ; и сохраним адрес.
                return

; ═══════════════════════════════════════════════════════════════════════════
; копирование строки в буфер с завершающим нулём
; вход:  R2 - адрес строки
; выход: R1 - адрес конца строки в буфере, указывает на завершающий 0
STRBUF:         mov     C$PENV(R3), R1  ; получим буфер, где надо формировать строку
1$:             movb    (R2)+, (R1)+    ; копируем её в буфер
                bne     1$
                dec     R1
                return

; ═══════════════════════════════════════════════════════════════════════════
; установка значения переменной окружения
; вход:  R1 - номер значения в массиве значений, счёт начинается с 1: 1..n
SETVAR:         mov     C$ENVL(R3), R2  ; адрес списка значений констант
                call    GETSTR          ; получение адреса строки из массива по её номеру
                                        ; вход:  R1 - номер строки, счёт начинается с 1: 1..n
                                        ;        R2 - адрес массива строк
                                        ; выход: R0 - номер строки, счёт начинается с 0.
                                        ;        R1,R2 - адрес строки
                call    STRBUF          ; копирование строки в буфер с завершающим нулём
                                        ; вход:  R2 - адрес строки
                                        ; выход: R1 - адрес конца строки в буфере, указывает на завершающий 0
                mov     #WRKBUF, R1     ; буфер
                iot
                .word   70              ; Записать переменную в область окружения DOS.
                                        ; вход: R1-адрес строки.
                return
; ───────────────────────────────────────────────────────────────────────────
; таблица имён переменных окружения
                                ; входной номер -> выходной номер
ENVNML:         .asciz "ECHO"   ; 1 -> 0
                .asciz "DIRCMD" ; 2 -> 1
                .asciz "$"
; таблица значений констант
ENVVLL:         .asciz "ON"     ; 1 -> 0
                .asciz "OFF"    ; 2 -> 1
                .asciz "$"
; таблица обрабатываемых расширений файлов
ENVEXT:         .asciz "BAT"    ; 1 -> 0
                .asciz "$"
                .even

; ═══════════════════════════════════════════════════════════════════════════
; если пробелы, то пропускаем
; если конец строки, то выход
; иначе - говорим что ошибка и выходим с битом C
NEXTTK:         cmpb    #40, (R1)
                beq     SKIPWS
                tstb    (R1)
                beq     1$
                jsr     R5, OutersI$    ; вывод сообщения
                .word   2               ; bad command or file name
                sec
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; пропуск пробелов. !!! дописать, чтобы пропускались остальные символы типа tab, cr, lf (только зачем?)

SKIPWS:         cmpb    #40, (R1)+
                beq     SKIPWS
                dec     R1
                clc
                return

; ═══════════════════════════════════════════════════════════════════════════
; преобразование строки в десятичное число
; вход:  R0 - адрес строки десятичных символов
; выход  R1 - распознанное число
ATOI:           clr     R1              ; тут накапливается результат
1$:             movb    (R0)+, R2       ; берём очередной символ
                beq     2$              ; если 0 - то конец
                cmpb    #':, R2         ; если : - то тоже конец (для ввода даты)
                beq     2$
                cmpb    R2, #'0         ; если меньше кода 0
                blo     3$              ; то конец с ошибкой
                cmpb    R2, #'9         ; если больше кода 9
                bhi     3$              ; то конец с ошибкой
                sub     #'0, R2         ; получим цифру
                asl     R1              ; умножаем R1 на 10.
                add     R1, R2          ; пока умножаем - цифру тоже заранее прибавим
                asl     R1
                asl     R1
                add     R2, R1          ; прибавим цифру к результату
                br      1$              ; и дальше, обработаем следующий символ

2$:             tst     (PC)+
3$:             sec
                return

; ═══════════════════════════════════════════════════════════════════════════
; вывод 16 разрядного десятичного числа в виде строки
; вход: R0 - число

ITOA16:         clr     R1
; вывод десятичного числа в виде строки
; вход: R1:R0 - число
ITOA:           mov     R5, -(SP)
                mov     R4, -(SP)
                mov     C$NMBF(R3), R5  ; адрес буфера длиной 14
                mov     #10., R4        ; 32 разрядное число может занимать 10 знаков
1$:             movb    #40, (R5)+
                sob     R4, 1$

4$:             mov     #10., R2
                tst     R1
                bne     2$
                cmp     R0, R2
                blo     3$              ; всё, кончилось число, остался последний разряд
2$:             call    DIVIDE          ; вход:  R1:R0 - делимое
                                        ;        R2 - делитель
                                        ; выход: R2:R4 - результат
                                        ;        R1:R0 - остаток от деления
                add     #'0, R0
                movb    R0, -(R5)
                mov     R4, R0
                mov     R2, R1
                br      4$

3$:             add     #'0, R0
                movb    R0, -(R5)
                mov     C$NMBF(R3), R1
                tstb    C$NMEV(R3)      ; какое у нас выравнивание
                beq     5$              ; по правому краю
                ; по левому краю
6$:             cmpb    (R1)+, #40      ; ищем начало числа
                blo     7$              ; вообще строки не получилось - выход
                beq     6$              ; пропускаем пробелы
                dec     R1              ; возвращаемся к не пробелу

5$:             iot
                .word   11              ; Вывод строки символов на устройство вывода
7$:             mov     (SP)+, R4
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════
; деление
; вход:  R1:R0 - делимое
;        R2 - делитель
; выход: R2:R4 - результат
;        R1:R0 - остаток от деления
DIVIDE:         tst     R2
                beq     1$
                mov     R3, -(SP)
                mov     R5, -(SP)
                clr     R3
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             add     #1, R4
                adc     R3
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                sub     #1, R4
                sbc     R3
                asl     R4
                rol     R3
                sob     R5, 3$
                ror     R3
                ror     R4
                mov     (SP)+, R5
                mov     R3, R2
                mov     (SP)+, R3
                return

1$:             movb    #31, @#ERRFDD
                sec
RET3$:          return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды DATE
CM$DAT:         call    REDIRC          ; проверка перенаправления входного/выходного контекста
                bcs     RET3$           ; если было, но не получилось - выйдем
                mov     R4, -(SP)
                mov     R5, -(SP)
                jsr     R5, OutersI$    ; вывод сообщения
                .word   14              ; "Current date is "
                iot
                .word   52              ; Получить текущую дату.
                                        ; выход: R0 - дата
                call    DATOUT          ; вывод даты
                jsr     R5, OutersI$    ; вывод сообщения
                .word   15              ; "Enter new date "
                mov     C$DTBF(R3), R1  ; буфер ввода даты
                mov     #DTBFSZ-1, R2   ; длина буфера
                iot
                .word   6               ; Буферизованный ввод с клавиатуры с возможностью редактирования.
                                        ; вход: R1-адрес буфера,
                                        ;       R2-размер буфера в байтах.
                bcs     1$              ; если какая-то ошибка
                tstb    (R1)            ; или пустая строка
                beq     1$              ; выйдем
                mov     R1, R0
                call    ATOI            ; опознаем первую группу цифр, это будет число.
                                        ; вход:  R0 - адрес строки десятичных символов
                                        ; выход  R1 - распознанное число
                bcs     2$
                cmp     R1, #31.        ; больше 31 ?
                bhi     2$              ; да - ошибка
                tst     R1              ; 0 ?
                beq     2$              ; тоже ошибка
                mov     R1, R4          ; число сохраним
                call    ATOI            ; опознаем следующую группу цифр, это будет месяц.
                                        ; вход:  R0 - адрес строки десятичных символов
                                        ; выход  R1 - распознанное число
                bcs     2$
                cmp     R1, #12.        ; больше 12 ?
                bhi     2$              ; да - ошибка
                tst     R1              ; 0 ?
                beq     2$              ; тоже ошибка
                asl     R1
                asl     R1
                asl     R1
                asl     R1
                asl     R1
                bis     R1, R4          ; месяц сохраним
                call    ATOI            ; опознаем следующую группу цифр, это будет год.
                                        ; вход:  R0 - адрес строки десятичных символов
                                        ; выход  R1 - распознанное число
                bcs     2$
                cmp     R1, #2107.      ; больше предела, в которые влазят биты года ?
                bhi     2$              ; да - ошибка
                sub     #1980., R1      ; меньше нижнего предела?
                bmi     2$              ; да - тоже ошибка
                swab    R1
                asl     R1
                bis     R1, R4          ; год сохраним
                mov     R4, R0
                iot
                .word   53              ; Установить дату.
                                        ; вход: R0 - дата
                br      1$

2$:             jsr     R5, OutersI$    ; вывод сообщения
                .word   16              ; "инжалид дате"
1$:             mov     (SP)+, R5
                mov     (SP)+, R4
                jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
; вывод даты
; вход:  R0 - дата
DATOUT:         mov     R4, -(SP)
                mov     R5, -(SP)
                mov     R0, -(SP)
                beq     1$
                incb    C$NMEV(R3)      ; выставляем выравнивание по левому краю
                bic     #177740, R0     ; день
                call    ITOA16          ; вывод числа из R0
                mov     #':, R0
                iot
                .word   2
                mov     (SP), R0
                bic     #177037, R0     ; месяц
                asr     R0
                asr     R0
                asr     R0
                asr     R0
                asr     R0
                call    ITOA16          ; вывод числа из R0
                mov     #':, R0
                iot
                .word   2
                mov     (SP), R0
                bic     #777, R0
                swab    R0
                asr     R0
                add     #1980., R0      ; год
                call    ITOA16          ; вывод числа из R0
                clrb    C$NMEV(R3)
1$:             mov     (SP)+, R0
                mov     (SP)+, R5
                mov     (SP)+, R4
                return

; ═══════════════════════════════════════════════════════════════════════════
; поиск строки в массиве
; вход:  R1 - адрес начала массива строк
;        R2 - адрес эталонной строки
; выход: R0 - номер строки * 2
; если ошибок нет,
;        R1 - указатель на конец участка совпадения в эталонной строке
; если ошибки есть
;        R1 - указатель на начало эталонной строки
STRNUM:         clr     R0
5$:             cmpb    (R1), #'$       ; конец массива ?
                beq     1$              ; да
                mov     R2, R5          ; нет - будем сравнивать
4$:             tstb    (R1)            ; строка в массиве закончилась?
                beq     2$              ; да
                cmpb    (R5)+, (R1)+    ; нет - сравним
                beq     4$              ; пока совпадает
                ; не совпало
3$:             tstb    (R1)+           ; найдём конец строки в массиве
                bne     3$
                tst     (R0)+           ; номер увеличиваем
                br      5$              ; идём сравнивать следующую строку в массиве
                ; строка совпала с эталонной
2$:             mov     R5, R1          ; указатель на конец участка совпадения эталона
                cmpb    #40, (R1)       ; если там ещё какие-то символы,
                blo     1$              ; то ошибка
                return

1$:             mov     R2, R1          ; возвращаем указатель на эталон
                sec
                return


; ═══════════════════════════════════════════════════════════════════════════
; вывод на экран восьмеричного числа
; вход:  R1 - число
OUT8:           clrb    C$FNFL(R3)      ; флаг замены ведущих нулей пробелами
                mov     #6, R2          ; количество выводимых цифр
                clr     R0              ; приёмник
                br      1$              ; пойдём принимать начальный бит
4$:             clr     R0              ; принимаем следующее трёхбитие
                rol     R1
                rol     R0
                rol     R1
                rol     R0
1$:             rol     R1              ; принимаем в приёмник бит
                rol     R0
                bne     2$              ; не 0 - выводим
                tstb    C$FNFL(R3)      ; нули подменять?
                bne     2$              ; уже нет
                cmp     #1, R2          ; последний разряд?
                beq     2$              ; тогда хоть один 0 надо вывести
                mov     #-20, R0        ; вместо 0 выведем пробел
                br      3$              ; переходим к следующей цифре

2$:             incb    C$FNFL(R3)      ; всё, нули больше не ведущие и их подменять нельзя
3$:             add     #'0, R0         ; делаем число
                iot                     ; выведем цифру
                .word   2
                sob     R2, 4$          ; выведем всё
                ; в конце выведем пробел
     ; ═══════════════════════════════════════════════════════════════════════════
; вывод пробела
SPSOUT:         mov     #40, R0
                iot
                .word   2
                return

; ═══════════════════════════════════════════════════════════════════════════
; умножение
; вход:  R1:R0 - множимое
;        R2 - множитель
; выход: R1:R0 - результат
MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
1$:             asr     R2
                bcc     2$
                add     R0, R3
                adc     R4
                add     R1, R4
2$:             asl     R0
                rol     R1
                sob     R5, 1$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ───────────────────────────────────────────────────────────────────────────
; список встроенных команд
CMDSET:         .asciz "SET"        ; 1
                .asciz "PAUSE"      ; 2
                .asciz "CLS"        ; 3
                .asciz "VER"        ; 4
                .asciz "DATE"       ; 5
                .asciz "DIR"        ; 6
                .asciz "DEL"        ; 7
                .asciz "COPY"       ; 8
                .asciz "TYPE"       ; 9
                .asciz "REN"        ; 10
                .asciz "ERA"        ; 11
                .asciz "REM"        ; 12
                .asciz "ECHO"       ; 13
                .asciz "$"
                .even
; смещения до п/п встроенных команд
CMDADR:         .word   @CM$SET     ; 1
                .word   @CM$PAU     ; 2
                .word   @CM$CLS     ; 3
                .word   @CM$VER     ; 4
                .word   @CM$DAT     ; 5
                .word   @CM$DIR     ; 6
                .word   @CM$DEL     ; 7
                .word   @CM$COP     ; 8
                .word   @CM$TYP     ; 9
                .word   @CM$REN     ; 10
                .word   @CM$DEL     ; 11
                .word   @CM$REM     ; 12
                .word   @CM$ECH     ; 13

; ═══════════════════════════════════════════════════════════════════════════
; подменяем некоторые номера ошибок другими, соответствующими номерам строк сообщений об ошибках
ERCTCH:         movb    @#ERRFDD, R2    ; получим номер ошибки
                beq     1$              ; если ошибок не было, то сразу выйдем
                .addr   R1, ERRNMS-1
3$:             inc     R1              ; к следующему коду
                movb    (R1)+, R0       ; берём код из таблицы
                beq     1$              ; таблица кончилась - выход
                cmpb    R0, R2          ; номер ошибки совпадает с тем, что мы ищем?
                bne     3$              ; нет
                ; нашли
2$:             movb    (R1), R1        ; номер строки, которую надо вывести для данной ошибки
                call    OUTERS
                sec
1$:             return
; ───────────────────────────────────────────────────────────────────────────

ERRNMS:         .byte   21,1    ; номер ошибки, индекс строки, которую надо вывести
                .byte   22,10
                .byte   23,20
                .byte   24,21
                .byte   25,4
                .byte   30,11
                .byte   33,6
                .byte   40,25
                .byte   41,27
                .byte   43,27
                .byte   44,2
                .byte   45,16
                .byte   46,26
                .byte   35,30
                .byte   0,0
CONNME:         .asciz "CON"
ERRTXT:         .asciz "Invalid drive specification"<12><15>    ; 1 *
                .asciz "Bad command or file name"<12><15>       ; 2 *
                .asciz "Strike any key to continue ..."         ; 3
                .asciz "File not found"<12><15>                 ; 4 *
                .asciz "Are you sure (Y/N)?"                    ; 5
                .asciz "Rename error"<12><15>                   ; 6 *
                .asciz "File cannot be copied onto itself"<12><15>  ; 7
                .asciz "Insufficient disk space"<12><15>        ; 10 *
                .asciz "Bad file name"<12><15>                  ; 11 *
                .asciz " file "                                 ; 12
                .asciz " byte free"                             ; 13
                .asciz "Current date is "                       ; 14
                .asciz <12><15>"Enter new date "                ; 15
                .asciz "Invalid date"<12><15>                   ; 16 *
                .asciz " bytes total disk space"<12><15>        ; 17
                .asciz "Content of destination lost before copy"<12><15>    ; 20 *
                .asciz "Disk full"<12><15>                      ; 21 *
                .asciz " <DIR> "                                ; 22
                .asciz " copied"                                ; 23
                .asciz "Echo is "                               ; 24
                .asciz "Out of environment space"<15><12>       ; 25 *
                .asciz "Invalid switch"<15><12>                 ; 26 *
                .asciz "Syntax error"<15><12>                   ; 27 *
                .asciz "Missing operand"<15><12>                ; 30 *
                .asciz <15><12>"  DXDOS version  "              ; 31
CMDVER:         .asciz <12><15>"COMMAND version 1.00"<12><15>
                .even

                .END

