
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: BK0010

; ───────────────────────────────────────────────────────────────────────────
;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB
; ───────────────────────────────────────────────────────────────────────────
; Полная таблица внутрисистемной информации:
S$BUFT=0		;		буфер для сохранения PSW, а так же флаг чтение-запись
S$DOSA=2		;		адрес начала области окружения DOS
S$CLSZ=4		;		количество кластеров на диске
S$DBLA=6		;*		адрес списка дисковых блоков.(адреса абсолютные)
S$DOSZ=10		;		длина области окружения DOS (120 байтов)
S$ER52=12		;		номер прошлой ошибки в ячейке 52
S$CRDN=14		;(1б)	номер текущего устройства прямого доступа (дисковода).
S$DRVN=15		;*(1б)	количество устройств прямого доступа в системе.
S$FLPN=16		;*(1б)	количество дисководов в системе.
S$IONC=17		;(1б)	флаг, что буфер S$BIOA и S$SIOA не совпадают.
S$FWBF=20		;*		адрес рабочей области драйвера дисковода (длина 70 байтов).
S$STBP=22		;*		значение стробирующего бита для принтера : 400-для БК0010, 40000-для БК0011.
S$DATE=24		;		текущая дата
S$NMBF=26		;		адрес буфера длиной 14 байтов имени для поиска
S$BIOA=30		;		адрес области обмена с диском (адрес чтения/записи физического сектора), который можно изменить пользователем
S$TFCB=32		;		адрес буфера FCB под параметры устройства и промежуточных данных.
S$SIOA=34		;		системный адрес области обмена с диском (адрес чтения/записи физического сектора) не изменяемый
S$PRNF=36		;(1б)	флаг вывода на принтер. !0 - выводить, 0 - не выводить
S$INKF=37		;(1б)	флаг: 0 - ввод с клавиатуры, иначе - ввод с устройства ввода
S$BINA=40		;		адрес буфера устройства ввода, длиной 2 байта
S$DSTW=42		;		номер сектора каталога, который надо обработать
S$DIRP=44		;(1б)	номер записи в каталоге (для создаваемых файлов)
S$TPLF=45		;(1б)	признак, что имя задано шаблоном (для переименования)
S$FCIA=46		;		адрес FCB стандартного устройства ввода
S$BOUA=50		;		адрес буфера устройства вывода, длиной 2 байта
S$ISSP=52		;		вершина внутрисистемного указателя стека для перехватчика emt 36
S$RENF=54		;(1б)	флаг режима переименования (используется для внутренних целей)
				;55 - свободно
S$CDSN=56		;		номер обрабатываемого сектора каталога при операциях с каталогом
S$PDOS=60		;*		адрес начала DOS.
S$ONED=62		;(1б)	Флаг, указывающий, что в системе всего один дисковод (1, если всего 1 дисковод, иначе 0)
S$RSFA=64		;*		адрес таблицы подпр.чтения сектора с устройства (при старте устанавливается 160006 для всех устройств).
S$RSLA=66		;*		адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
S$CSNW=70		;		номер сектора в буфере, который надо сохранить
S$CSNB=72		;		номер сектора, который находится в буфере чтения/записи
S$DNWS=74		;		номер дисковода, на который надо сохранить сектор
S$DNSB=76		;(1б)	номер устройства, сектор которого в буфере чтения/записи
				;		76 иногда используется как слово, а иногда как байт
S$CDDN=100		;(1б)	номер дисковода, каталог которого в буфере
S$FCOA=102		;		адрес FCB стандартного устройства вывода
S$BRDT=104		;*(1б)	тип машины 0-БК0010, 1-БК0011М,2-БК0011.
S$MONT=105		;*(1б)	тип монитора 0-БК0010,1-БК0011М,2-БК0011.
S$BTFA=106		;		адрес области BAT файлов длиной 204 байта, первое слово - уровень вложенности
S$MBPT=110		;		указатель в памяти на обрабатываемые данные (куда читать с диска, откуда писать на диск)
S$FPTR=112		;(4б)	текущее положение указателя в файле
S$NCLS=116		;		количество обрабатываемых кластеров
S$BSCC=120		;		счётчик прочитанных/записанных байтов
S$SCLC=122		;		счётчик секторов в кластере
S$BIOO=124		;		смещение в буфере текущего сектора чтения/записи
S$SDNM=126		;*		адрес списка имён символьных устройств.(имена разделены нулевым байтом).
S$SDJA=130		;*		адрес таблицы переходов для символьных устройств.
S$IOTA=132		;		адрес таблицы подпрограмм IOT диспетчера
S$ERMA=134		;		адрес таблицы символьных сообщений об ошибке, строки разделяются 0
S$FADR=136		;		адрес загрузки/записи файла
S$FCRC=140		;		CRC файла
S$FSZE=142		;		размер файла
S$CMLA=144		;		адрес командной строки
S$CMLS=146		;		длина командной строки (длина 140 байтов)
S$CEMB=150		;		адрес буфера, перехвата ЕМТ команд, для монитора БК11 * 2
S$EMCN=152		;		количество ЕМТ команд, 132 для монитора БК11 и 50 для монитора БК10
S$EXSY=154		;		адрес функции выхода в ДОС
S$OV30=156		;		адрес адреса старого вектора 30, потом нигде не используется
S$BE36=160		;		адрес буфера копии имени в перехватчике emt36 (100 байтов)
S$LE36=162		;		длина буфера копии имени в перехватчике emt36 (100 байтов)
S$HRAM=164		;*		верхний адрес пользовательского ОЗУ.
S$PPAD=166		;*		адрес параллельного порта (при старте устанавливается значение 177714).
S$BLSZ=170		;размер таблицы внутрисистемной информации. резервируется 346 байтов
;* помечены официально описанные в документации ячейки

                mov     #1000, SP
                movb    R0, FCBM10		;привод, с которого загрузились
                iot
                .word   60				;Получить версию DOS. 
                cmp     #400, R0
                beq     1$
                .addr   R1, BADVER
                br      1EX$

1$:             iot
                .word   61				;Доступ к внутрисистемной информации. 
                tstb    S$BRDT(R1)		;тип машины 0-БК0010, 1-БК0011М,2-БК0011. 
                bne     2$
                .addr   R1, BADBKT
                br      1EX$

2$:             tstb    S$MONT(R1)		;тип монитора 0-БК0010,1-БК0011М,2-БК0011. 
                bne     3$
                .addr   R1, ALREDY
1EX$:           iot
                .word   11
2EX$:           iot
                .word   0

3$:             .addr   R4, FCBM10
                iot
                .word   17				;Открыть файл методом FCB. 
                bcc     4$
                cmpb    #25, @#52
                bne     2EX$
                .addr   R1, FILENF
                br      1EX$

4$:             mov     R4, -(SP)
                cmpb    #2, S$BRDT(R1)	;это БК0011?
                beq     5$				;да
										;а для БК0011М делать так
                mov     #40000, @#177662	;включим палитру 0 и выключим таймер
                mov     #5, R0
                emt     12				;подключение страницы ОЗУ/ПЗУ; стр.5 в окно 0
                mov     #404, R0
                emt     12				;подключение страницы ОЗУ/ПЗУ; стр.4 в окно 1
                mov     @#114, R5		;возьмём копию ССП
                br      6$

5$:             mov     #5, R0
                emt     52				;подключение страницы ОЗУ/ПЗУ; стр.5 в окно 0
                mov     #404, R0
                emt     52				;подключение страницы ОЗУ/ПЗУ; стр.4 в окно 1
                mov     #40000, @#177662	;включим палитру 0 и выключим таймер
                mov     @#66, R5		;возьмём копию ССП

6$:             iot
                .word   30				;Доступ к буферам DOS. 
                mov     #204, R3
                mov     R5, R4
                bic     #20000, R4		;!!! я бы тут сделал bic #70000
                bis     #50000, R4		;в окно 0 подключаем стр.7
                mov     R4, @#177716
                mov     #76000, R4		;какие-то волшебные ячейки
                mov     #52652, (R4)+	;какие-то таинственные действия
                mov     R5, (R4)+
7$:             movb    (R0)+, (R4)+
                sob     R3, 7$
                mov     R5, @#177716	;обратно в окно 0 включаем стр.5
                mov     (SP)+, R4
                .addr   R0, EOF
                mov     R0, F$DTAD(R4)		;адрес обмена
                mov     F$FLSZ(R4), F$RCSZ(R4)	;размер файла в байтах. -> размер записи в байтах.
                iot
                .word   41				;Прямой доступ,чтение. 
                iot
                .word   20				;Закрыть файл. 
                .addr   R1, INSSYS
                iot
                .word   11
                iot
                .word   15
                iot
                .word   1
                mov     F$DTAD(R4), R0		;адрес обмена
                mov     F$FLSZ(R4), R1		;размер файла в байтах.
                mov     #100000, R2
8$:             movb    (R0)+, (R2)+
                sob     R1, 8$
                jmp     @#100000
; ───────────────────────────────────────────────────────────────────────────
FCBM10:         .byte 0
                .ascii "MBK0010 SYS"
                .blkb 52

INSSYS:         .ascii "Insert system disk"<12><15>
                .asciz "and strike any key then ready."<12><15>
                .even
ALREDY:         .asciz "BK0010 alredy installed."<12><15>
                .even
BADVER:         .asciz "Incorrect DOS version."<12><15>
                .even
FILENF:         .asciz "File MBK0010.SYS not found."<12><15>
BADBKT:         .asciz "This program is only"<12><15>"for БК-0011(М) !"<12><15>
                .even
EOF:            .word   0

                .END
