
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: FORMAT

ERRFDD=52	;адрес, куда сохраняется номер ошибки
;ячейки рабочей области драйвера дисковода
CSRW=0		;копия по записи регистра состояния КНГМД
CURTRK=2	;адрес текущей дорожки (адрес одного из следующих байтов из таблицы)
TRKTAB=4	;таблица текущих дорожек
TDOWN=10	;задержка опускания головки
TSTEP=12	;задержка перехода с дорожки на дорожку
TRKCOR=14	;дорожка начала предкомпенсации
BRETRY=15	;число попыток повтора при ошибке
FLAGS=16	;рабочая ячейка драйвера
FILLB=17	;код заполнения при форматировании
FLGPTR=20	;указатель на байт признаков (адрес одного из следующих байтов из таблицы)
FLGTAB=22	;таблица признаков
ADDR=26		;адрес начала массива данных в ОЗУ (обязательно чётный)
WCNT=30		;количество слов для пересылки
SIDE=32		;номер стороны диска
TRK=33		;номер дорожки
UNIT=34		;номер привода
SECTOR=35	;номер сектора
WRTVAR=36	;значение, записываемое при форматировании
MARKER=40	;буфер маркера при записи
FREE=42		;длина пустого остатка сектора
INTIME=44	;счётчик длительности индекса
BUF4=46		;буфер для сохранения вектора 4
BUFSP=50	;буфер для сохранения SP
BUFPSW=52	;буфер для сохранения PSW
CRETRY=54	;счётчик повторов при ошибке
TURNS=55	;число оборотов диска при поиске сектора
SECRET=56	;число повторных попыток поиска сектора
ERRNUM=57	;буфер для номера ошибки
MAXSEC=60	;число секторов на дорожке
HOLTIN=62	;время задержки после индекса
SECLEN=64	;длина сектора в словах

START:          mov     #1000, SP
                iot
                .word 60
                cmp     #400, R0		;че за версия?
                beq     1$				;наша, все в норме
                mov     #2, R1
2ERRO$:         call    OUTSTR
3$:             iot
                .word 0

4ERRO$:         mov     #27, R1
                call    OUTSTR
                br      3$

1$:             .addr   R4, SYSPAR		;рабочий буфер. разбираться и расписывать значения переменных лень.
                mov     R3, 100(R4)
                mov     R3, R5
                mov     #1, 2(R4)
                .addr   R0, EOF
                mov     R0, 50(R4)
                mov     #12, 6(R4)
                clr     26(R4)
                clr     72(R4)
                mov     #1000, 30(R4)
                mov     #1, 12(R4)
                mov     #2, 16(R4)
                mov     #117, 4(R4)
                clr     22(R4)
                .addr   R0, B10156
                mov     R0, 24(R4)
                call    SKIPWS
                cmpb    #'/, (R5)
                bne     5$
                inc     R5
                call    SKIPWS
                cmpb    #'?, (R5)
                bne     5$
                mov     #34, R1
                br      2ERRO$

5$:             movb    (R5)+, R0
                bic     #240, R0
                sub     #'A, R0
                mov     R0, 10(R4)
                cmpb    #':, (R5)+
                beq     6$
7$:             mov     #1, R1
                br      2ERRO$
6$:             inc     R0
                iot
                .word 62				;Получить адрес дисковой области.
                tst     40(R1)
                beq     8$
                asr     4(R4)
8$:             iot
                .word 61				;Доступ к внутрисистемной информации.
                movb    16(R1), 54(R4)
                mov     64(R1), R2
                asl     R0
                add     R0, R2
                mov     (R2), 62(R4)
                .addr   R0, BUF$11
                mov     R0, 66(R4)
                clr     R0
                movb    105(R1), 64(R4)	;тип монитора 0-БК0010,1-БК0011М,2-БК0011. 
                clr     R0				;!!! лишняя команда
                call    SCRSET
                call    SKIPWS
                .addr   R1, COMSPK
                iot
                .word 67				;Получить переменную из области окружения DOS. 
                bcs     4ERRO$
                movb    (R2)+, R0
                sub     #100, R0
                cmpb    #':, (R2)
                beq     9$
                iot
                .word 31				;Получение номера текущего устройства прямого доступа  
                inc     R0
9$:             mov     R0, 56(R4)
                cmpb    (R5), #40
                blo     10$
                cmpb    (R5), #'/
                bne     7$
                inc     R5
                cmpb    #'1, (R5)
                bne     11$
                clr     2(R4)
                bis     #2, 22(R4)
                br      12$

11$:            cmpb    #'4, (R5)
                bne     13$
                cmp     #47, 4(R4)
                beq     12$
                asr     4(R4)
                bis     #1, 22(R4)
                br      12$

13$:            cmpb    #'8, (R5)
                bne     14$
                mov     #10, 6(R4)
                br      12$

14$:            cmpb    #'9, (R5)
                bne     15$
                mov     #11, 6(R4)
                br      12$

15$:            cmpb    #'Q, (R5)
                bne     16$
                clr     12(R4)
                br      12$

16$:            cmpb    #'B, (R5)
                bne     17$
                mov     #1, 44(R4)
                br      12$

17$:            cmpb    #'S, (R5)
                bne     18$
                mov     #2, 44(R4)
                br      12$

18$:            cmpb    #'D, (R5)
                bne     7$
                inc     72(R4)
12$:            inc     R5
                br      8$

19$:            br      7$

10$:            .addr   R3, B10062
                call    INIT
                mov     4(R4), R0
                inc     R0
                tst     2(R4)
                beq     20$
                asl     R0
20$:            mov     6(R4), R2
                clr     R1
                call    MULTIP
                mov     R0, 32(R4)
                .addr   R0, FMTTBL
21$:            cmp     4(R4), (R0)
                bne     22$
                mov     2(R4), R1
                inc     R1
                cmp     2(R0), R1
                bne     22$
                cmp     6(R4), 4(R0)
                beq     23$
22$:            add     #20, R0
                tst     (R0)
                bne     21$
                br      19$

23$:            cmp     10(R4), 54(R4)
                blo     24$
                mov     #24, R1
                call    OUTSTR
                jmp     V4$1

24$:            .addr   R5, BUTSEC
                add     #13, R5
                add     #6, R0
                mov     30(R4), R1
                movb    R1, (R5)+
                swab    R1
                movb    R1, (R5)+
                movb    (R0), (R5)+
                mov     (R0)+, 42(R4)
                mov     #1, (R5)+
                movb    #2, (R5)+
                mov     (R0)+, R1
                mov     R1, 40(R4)
                movb    R1, (R5)+
                swab    R1
                clrb    R1
                movb    R1, (R5)+
                mov     32(R4), R1
                movb    R1, (R5)+
                clrb    R1
                swab    R1
                movb    R1, (R5)+
                movb    (R0), (R5)+
                mov     (R0)+, 36(R4)
                mov     (R0), (R5)+
                mov     (R0)+, 34(R4)
                mov     6(R4), (R5)+
                mov     2(R4), (R5)
                inc     (R5)
                mov     (R0), R5
                mov     #5, R1
                call    OUTSTR
                mov     10(R4), R0
                add     #'A, R0
                iot
                .word 2
                mov     #6, R1
                call    OUTSTR
                iot
                wait
                cmpb    R0, #15
                blos    25$
                iot
                .word 0

25$:            mov     #1, R0
                call    SCRSET
                mov     #4, R0
                mov     (R0), 74(R4)
                mov     PC, (R0)
                add     #V4$1-., (R0)
                mov     #17, R1
                call    OUTSTR
                mov     R5, R0
                clr     R1
                call    ITOA
                mov     #'K, R0
                iot
                .word 2
                call    CRLFOU
                call    CRLFOU
                call    CRLFOU
                clrb    17(R3)
                mov     16(R4), (R4)
32$:            clr     32(R3)
                clrb    34(R3)
                cmp     54(R4), #1
                beq     26$
                movb    10(R4), 34(R3)
26$:            mov     #400, 64(R3)
                mov     6(R4), 60(R3)
                mov     R4, -(SP)
                call    FORMAT
                mov     (SP)+, R4
                bcs     27$
                clrb    32(R3)
                call    FORM2$
                bcc     28$
27$:            cmpb    #7, @#ERRFDD
                bne     29$
31$:            jmp     V4$1

29$:            cmpb    #1, @#ERRFDD
                bne     30$
                mov     #22, R1
                call    OUTSTR
                br      31$

30$:            dec     (R4)
                bne     32$
                mov     #4, R1
                call    OUTSTR
                mov     #3, R1
                call    OUTSTR
                br      31$

28$:            mov     30(R4), R0
                clr     R1
                mov     6(R4), R2
                call    MULTIP
                asr     R0
                mov     R0, 76(R4)
                movb    22(R4), @20(R3)
                movb    #345, 17(R3)
35$:            mov     16(R4), (R4)
                incb    33(R3)
                cmpb    33(R3), 4(R4)
                bhi     33$
                movb    33(R3), R0
                call    PROGRS
36$:            movb    #1, 35(R3)
                call    FORMAT
                bcs     34$
                tst     12(R4)
                beq     35$
                call    FORM2$
                bcc     35$
34$:            cmpb    #7, @#ERRFDD
                beq     31$
                dec     (R4)
                bne     36$
                inc     26(R4)
                br      35$

33$:            .addr   R0, BUTSEC
                mov     R0, 26(R3)
                movb    #1, 35(R3)
                mov     #400, 30(R3)
                neg     30(R3)
                clr     32(R3)
                mov     R4, -(SP)
                call    @62(R4)
                mov     (SP)+, R4
                mov     30(R4), R0
                mov     34(R4), R2
                clr     R1
                call    MULTIP
                mov     50(R4), R1
                mov     R1, R2
37$:            clrb    (R1)+
                sob     R0, 37$
                mov     #177400, (R2)
                bis     36(R4), (R2)+
                mov     #377, (R2)
                mov     50(R4), 26(R3)
                movb    #2, R5
                movb    R5, 35(R3)
                mov     R5, -(SP)
                mov     R4, -(SP)
                mov     #400, 30(R3)
                neg     30(R3)
                call    @62(R4)
                bcc     38$
                jmp     L3756

38$:            mov     (SP)+, R4
                mov     (SP)+, R5
                add     34(R4), R5
                movb    R5, 35(R3)
                mov     #400, 30(R3)
                neg     30(R3)
                mov     50(R4), 26(R3)
                mov     R4, -(SP)
                call    @62(R4)
                bcc     39$
                jmp     L3756

39$:            mov     (SP)+, R4
                mov     #7, R1
                call    OUTSTR
                tst     44(R4)
                beq     40$
                call    COPSYS
                bcs     40$
                mov     #25, R1
                call    OUTSTR
40$:            mov     34(R4), R0
                asl     R0
                inc     R0
                sub     R0, 32(R4)
                mov     40(R4), R0
                clr     R1
                mov     #20, R2
                mov     R4, -(SP)
                call    DIVIDE
                mov     R4, R0
                mov     (SP)+, R4
                sub     R0, 32(R4)
                mov     32(R4), R0
                clr     R1
                mov     30(R4), R2
                call    MULTIP
                mov     R0, -(SP)
                mov     R1, -(SP)
                call    ITOA
                mov     #11, R1
                call    OUTSTR
                mov     52(R4), R0
                beq     41$
                clr     R1
                call    ITOA
                mov     #21, R1
                call    OUTSTR
41$:            mov     26(R4), R0
                clr     R1
                mov     30(R4), R2
                call    MULTIP
                tst     R0
                beq     42$
                call    ITOA
                mov     #12, R1
                call    OUTSTR
42$:            mov     42(R4), R0
                clr     R1
                mov     30(R4), R2
                call    MULTIP
                mov     R0, -(SP)
                call    ITOA
                mov     #15, R1
                call    OUTSTR
                mov     (SP)+, R2
                mov     (SP)+, R1
                mov     (SP)+, R0
                sub     52(R4), R0
                mov     R4, -(SP)
                call    DIVIDE
                mov     R4, R0
                mov     (SP)+, R4
                clr     R1
                call    ITOA
                mov     #16, R1
                call    OUTSTR
                call    CRLFOU
                mov     #2, R0
                call    SCRSET
                mov     #10, R1
                call    OUTSTR
                mov     74(R4), @#4
                iot
                .word 15
                iot
                .word 1
                bic     #240, R0
                cmpb    #'Y, R0
                bne     L43$
                call    CRLFOU
                mov     100(R4), R3
                jmp     START

L43$:           call    CRLFOU
                mov     #3, R0
                call    SCRSET
                mov     74(R4), @#4
                iot
                .word 0

; ═══════════════════════════════════════════════════════════════════════════
;вывод  на экран прогресса форматирования

PROGRS:         clr     R1
                mov     #100., R2
                call    MULTIP
                mov     4(R4), R2
                mov     R4, -(SP)
                call    DIVIDE
                mov     R4, R0
                mov     (SP)+, R4
                clr     R1
                call    ITOA
                mov     #'%, R0
                iot
                .word 2

                mov     #13, R1
                call    OUTSTR
                mov     #32, R5
                mov     #10, R0
1$:             iot
                .word 2
                sob     R5, 1$
                return

; ═══════════════════════════════════════════════════════════════════════════


CRLFOU:         mov     #5015, R0
                iot
                .word 2
                swab    R0
                iot
                .word 2
                return

; ═══════════════════════════════════════════════════════════════════════════
;форматирование диска

FORMAT:         mov     R4, -(SP)
                tst     72(R4)			;как форматируем
                bne     1$				;нестандартно
                call    @#160012		;стандартно
                br      2$

1$:             call    FRMTR$
2$:             mov     (SP)+, R4
                bcs     4$
                cmpb    32(R3), 2(R4)
                beq     3$
                incb    32(R3)
                br      FORMAT

3$:             clrb    32(R3)
4$:             return

; ═══════════════════════════════════════════════════════════════════════════
;ещё какой-то способ форматирования

FORM2$:         movb    #1, 35(R3)
                mov     76(R4), 30(R3)
                mov     50(R4), 26(R3)
                mov     R4, -(SP)
                call    @62(R4)
                mov     (SP)+, R4
                bcs     1$
                cmpb    32(R3), 2(R4)
                beq     2$
                incb    32(R3)
                br      FORM2$

2$:             clrb    32(R3)
1$:             return

; ───────────────────────────────────────────────────────────────────────────

L3756:          mov     #23, R1
                call    OUTSTR
V4$1:           mov     #1000, SP
                .addr   R4, SYSPAR
                mov     #20, R1
                call    OUTSTR
                jmp     L43$

; ═══════════════════════════════════════════════════════════════════════════
;манипуляции с режимами экрана

SCRSET:         mov     64(R4), R1		;тип монитора 0-БК0010,1-БК0011М,2-БК0011. 
                asl     R1
                asl     R1
                asl     R1
                asl     R0
                add     R1, R0
                add     R0, PC			;pc += R0*2 + R1*8
				;команды для БК10
                br      10$RES			;сохранение текущего режима экрана
                br      10$SYW			;переключение ширины символов
                br      10$CUR			;переключение режима отображения курсора
                br      10$RES			;восстановление режима экрана
				;команды для БК11М
                br      11MSSM			;сохранение текущего режима экрана
                br      11MSYW			;переключение ширины символов
                br      11MCUR			;переключение режима отображения курсора
                br      11MRSM			;восстановление режима экрана
				;команды для БК11
                br      11$SSM			;сохранение текущего режима экрана
                br      11$SYW			;переключение ширины символов
                br      11$CUR			;переключение режима отображения курсора
                br      11$RSM			;восстановление режима экрана
; ───────────────────────────────────────────────────────────────────────────

10$SYW:         movb    #377, @#56		;Гашение курсора (0 - выкл., 377 - вкл.)
                tstb    @#40
                beq     1$
                mov     #233, R0		;Переключение режима "32/64 символа в строке"
                emt     16
1$:             return

10$CUR:         comb    @#56			;Гашение курсора (0 - выкл., 377 - вкл.)
10$RES:         return
; ───────────────────────────────────────────────────────────────────────────

11MSSM:         emt     52				;чтение режима драйвера экрана
                mov     R0, 70(R4)
                return

11MSYW:         emt     52				;чтение режима драйвера экрана
                clr     R0
                emt     51				;установка режима драйвера экрана
                return

11MCUR:         emt     52				;чтение режима драйвера экрана
                mov     #20000, R0
11M$1:          emt     51				;установка режима драйвера экрана
                return

11MRSM:         mov     70(R4), R0
                br      11M$1
; ───────────────────────────────────────────────────────────────────────────

11$SSM:         mov     66(R4), R0
                emt     34
                mov     (R0), 70(R4)
                return

11$SYW:         mov     66(R4), R0
                bis     #20002, R0
                emt     64
                return

11$CUR:         mov     66(R4), R0
                bis     #2, R0
                emt     64
                return

11$RSM:         mov     66(R4), R0
                mov     70(R4), (R0)
                emt     64
                return

BUF$11:        .blkb 16					;буфер для БК11
; ───────────────────────────────────────────────────────────────────────────
;копирование системных файлов
COPSYS:         cmp     #1, 44(R4)
                beq     1$
                mov     #32, R1
                call    OUTSTR
1$:             mov     #2, R5
                mov     R4, R3
                .addr   R4, FCBSYS
L4310:          mov     56(R3), R0
                clr     60(R3)
                call    INSDSK
                movb    R0, (R4)
                iot
                .word 17
                bcs     2$
                mov     20(R4), 46(R3)
                cmp     #2, 44(R3)
                bne     3$
                mov     50(R3), 50(R4)
                mov     20(R4), 16(R4)
                iot
                .word 41
                bcs     2$
3$:             iot
                .word 20
                bcs     2$
                mov     10(R3), R0
                inc     R0
                inc     60(R3)
                call    INSDSK
                movb    R0, (R4)
                iot
                .word 26
                bcs     2$
                mov     46(R3), 16(R4)
                mov     50(R3), 50(R4)
                iot
                .word 42
                cmp     #1, R5
                beq     4$
                movb    #7, 47(R4)
4$:             iot
                .word 20
                .addr   R4, FCBCOM
                add     46(R3), 52(R3)
                cmp     #1, 44(R3)
                beq     5$
                dec     R5
                tst     R5
                beq     5$
                jmp     L4310

5$:             mov     R3, R4
                return

2$:             cmpb    #25, @#ERRFDD
                bne     6$
                mov     #26, R1
                br      7$

6$:             mov     #23, R1
7$:             call    OUTSTR
                clr     52(R3)
                mov     R3, R4
                sec
                return
; ───────────────────────────────────────────────────────────────────────────
;просьба вставить нужный диск в дисковод и нажать любую клавишу
INSDSK:         cmp     #1, 54(R3)
                beq     1$
                mov     10(R3), R1
                inc     R1
                cmp     R1, 56(R3)
                bne     2$
1$:             mov     #30, R1
                tst     60(R3)
                beq     3$
                mov     #31, R1
3$:             mov     56(R3), R0
                call    OUTSTR
                iot
                .word 15				;Инициализировать драйвер (контроллер) дисковода. 
                mov     56(R3), R0
                add     #100, R0
                iot
                .word 2					;Вывод символа на стандартное устройство вывода 
                mov     #33, R1
                call    OUTSTR
                iot
                .word 1
                mov     56(R3), R0
2$:             return

; ═══════════════════════════════════════════════════════════════════════════

SKIPWS:         cmpb    #40, (R5)
                bne     1$
                inc     R5
                br      SKIPWS

1$:             ccc
                return

; ═══════════════════════════════════════════════════════════════════════════

MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
2$:             asr     R2
                bcc     1$
                add     R0, R3
                adc     R4
                add     R1, R4
1$:             asl     R0
                rol     R1
                sob     R5, 2$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════

OUTSTR:         .addr   R2, STRARR
1$:             dec     R1
                ble     2$
3$:             tstb    (R2)+
                bne     3$
                br      1$

2$:             movb    (R2)+, R0
                beq     4$
                iot
                .word 2
                br      2$

4$:             return

; ───────────────────────────────────────────────────────────────────────────

ITOA:           mov     R4, -(SP)
                mov     R5, -(SP)
                mov     24(R3), R5
                mov     #6, R4
1$:             movb    #40, (R5)+
                sob     R4, 1$
2$:             tst     R1
                bne     3$
                cmp     #10., R0
                bhi     4$
3$:             mov     #10., R2
                call    DIVIDE
                add     #'0, R0
                movb    R0, -(R5)
                mov     R4, R0
                mov     R2, R1
                br      2$

4$:             add     #'0, R0
                movb    R0, -(R5)
                mov     24(R3), R1
                clr     6(R1)
                iot
                .word 11
                mov     (SP)+, R5
                mov     (SP)+, R4
                return

; ═══════════════════════════════════════════════════════════════════════════

DIVIDE:         tst     R2
                beq     1$
                mov     R3, -(SP)
                mov     R5, -(SP)
                clr     R3
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             add     #1, R4
                adc     R3
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                sub     #1, R4
                sbc     R3
                asl     R4
                rol     R3
                sob     R5, 3$
                ror     R3
                ror     R4
                mov     (SP)+, R5
                mov     R3, R2
                mov     (SP)+, R3
                return

1$:             movb    #31, @#ERRFDD
                sec
                return


; ═══════════════════════════════════════════════════════════════════════════


INIT:           clr     (R3)				; Очистим копию РС КНГМД
                mov     #-1, TRKTAB(R3)		; Заполним таблицу текущих дорожек
                mov     #-1, TRKTAB+2(R3)
                mov     #2000, TSTEP(R3)	; Время перехода дорожки
                mov     #10000., TDOWN(R3)	; Время опускания головки
                movb    #32., TRKCOR(R3)	; Дорожка начала предкомпенсации
                movb    #20., BRETRY(R3)	; Число повторов при ошибке
                clrb    FLAGS(R3)			; Очистим флаги
                clr     FLGTAB(R3)			;    и таблицу признаков
                clr     FLGTAB+2(R3)
                mov     #400, SECLEN(R3)
                mov     #10., MAXSEC(R3)	; Занесём число секторов на дорожке = 10
                return

; ═══════════════════════════════════════════════════════════════════════════
; ENGINE: П/п выбора устройства

ENGINE:         mov     #177130, R4			; Заполняем рабочие регистры
                mov     R4, R5				;    адресами PC
                tst     (R5)+ 				;    РД КНГМД
                bicb    #4, FLAGS(R3)		; Очистим признак работы двигателя
                bit     #20, (R3)			; Двигатель уже включён?
                beq     1$       			; Нет - включим
                bisb    #4, FLAGS(R3)		; Да - установим признак
1$:             bis     #20, (R3) 			; Включим двигатель
                mov     (R3), (R4)			;    и запишем в регистр
                bic     #57, (R3)			; Сбросим все другие регистры
                tstb    SIDE(R3) 			; Сторона верхняя?
                beq     2$       			; Да - идём дальше
                bis     #40, (R3)			; Нет - включим нижнюю
2$:             bicb    #177774, UNIT(R3)	; Сбросим лишние биты
                movb    UNIT(R3), R1		; Получим номер привода
                mov     PC, R0				; Получим базовый адрес
                add     #DMASK-., R0		;    таблицы масок для приводов
                add     R1, R0      		; Получим адрес нужной маски
                bisb    (R0), (R3)  		; Установим бит нужного привода
                add     R3, R1      		; Получим базовый адрес
                add     #TRKTAB, R1			;    таблицы TRKTAB
                mov     R1, CURTRK(R3)		; Настроим указатель CURTRK
                call    SETPTR				; SETPTR: Настроим указатель FLGPTR
                bitb    #4, FLAGS(R3)		; Мотор включён только что?
                bne     3$					; Нет - выходим
                clr     R1					; Да - подождём раскручивания
                sob     R1, .
                sob     R1, .
3$:             mov     (R3), (R4)			; Записываем установки в регистр
                mov     TDOWN(R3), R1		; Подождём опускания головки
                sob     R1, .
                return

; ───────────────────────────────────────────────────────────────────────────
DMASK:          .byte 1,2,4,10

; ═══════════════════════════════════════════════════════════════════════════
; SETPTR: П/п настройки указателя FLGPTR

SETPTR:         clr     FLGPTR(R3)			; Очистим указатель FLGPTR
                bicb    #177774, UNIT(R3)	; Отбросим лишние биты
                movb    UNIT(R3), FLGPTR(R3)	; Перешлём номер привода в FLGPTR
                add     R3, FLGPTR(R3)
                add     #FLGTAB, FLGPTR(R3)	;    получаем искомый адрес
                return

; ═══════════════════════════════════════════════════════════════════════════

GOTRK:          tstb    TRK(R3)				; Нужна дорожка 00?
                beq     GOTO00				; Да - позиционируем прямо на нее
                tstb    @CURTRK(R3)			; Положение головки известно?
                bpl     1$					; Да - будем искать требуемую
                call    GOTO00				; Нет - придётся сориентироваться
1$:             cmpb    @CURTRK(R3), TRK(R3)	; Нужная дорожка совпадает с текущей?
                beq     2$					; Да - так что же мы тут делаем?
                bhi     3$					; Нет - искомая ближе к центру?
                call    GOUP				; Да - шагаем к центру
                br      1$					; Проверим, дошли ли

3$:             call    GODOWN				; Нет - шагнём к периферии
                br      1$					; Проверим, дошли ли

2$:             mov     #10000., R0			; Подождём успокоения головки
                sob     R0, .
                return						; Теперь можно и выйти

; ═══════════════════════════════════════════════════════════════════════════
; GOUP: Шаг к центру

GOUP:           incb    @CURTRK(R3)			; Номер дорожки станет на 1 больше
                bmi     1$					; Таких дорожек нет - выходим с ошибкой
                bis     #100, (R3)			; Все в порядке - шагать будем вперёд
                br      3$					; Пойдём шагать

1$:             mov     #4, R0				; Выход с ошибкой 4
                jmp     ERROR

; ═══════════════════════════════════════════════════════════════════════════
; GODOWN: Шаг к периферии

GODOWN:         decb    @CURTRK(R3)			; Номер дорожки станет на 1 меньше
                bit     #1, (R4)			; Дошли до дорожки 00?
                beq     2$					; Нет - можно шагать
                clrb    @CURTRK(R3)			; Дошли: теперь текущая - 00
                return						;    и можно выйти

2$:             bic     #100, (R3)			; Шагать будем назад
3$:             mov     #200., R0			; Подготовим задержку
                mov     (R3), (R4)			; Перешлём направление шага в регистр
                sob     R0, .				; Подождём, пока контроллер "переварит"
                bis     #200, (R3)			; Установим признак шага
                mov     (R3), (R4)			;    и запишем в регистр
                mov     TSTEP(R3), R0		; Получим задержку перехода дорожки
                sob     R0, .				;    и задержимся
                bitb    #1, @FLGPTR(R3)		; Двойной шаг?
                beq     4$					; Нет - можно выходить
                bitb    #100, FLAGS(R3)		; Мы возвращаемся на 00?
                bne     4$					; Да - возвращаться надо одинарным шагом
                mov     (R3), (R4)			; Нет - придётся шагнуть ещё
                mov     TSTEP(R3), R0		; Получим задержку перехода дорожки
                sob     R0, .				;    и задержимся
4$:             bic     #200, (R3)			; Очистим признак шага
                return

; ═══════════════════════════════════════════════════════════════════════════
; GOTO00: П/п возврата на дорожку 00

GOTO00:         movb    #200, @CURTRK(R3)	; Установим счётчик дорожек
                bisb    #100, FLAGS(R3)		; Возвращаться надо одинарным шагом
1$:             call    GODOWN				; GODOWN: Шагнём к периферии
                bit     #1, (R4)			; Дошли до 00?
                bne     2$					; Да - выходим
                tstb    @CURTRK(R3)			; На какой дорожке должны находиться?
                bne     1$					; Не на нулевой - ещё шагнём
                mov     #3, R0				; На нулевой, а ее нет - ошибка 3
                bicb    #100, FLAGS(R3)		; Сбросим режим одинарного шага
                jmp     ERROR				; Выходим с ошибкой

2$:             clrb    @CURTRK(R3)			; Дошли - текущая теперь нулевая
                bicb    #100, FLAGS(R3)		; Сбросим режим одинарного шага
                return

; ═══════════════════════════════════════════════════════════════════════════
; WRMAR: П/п записи маркера данных
; Входные данные: R0 - число записываемых слов 4E4E
WRMAR:          tstb    (R4)				; Готовность есть?
                bpl     WRMAR				; Нет - дождёмся
                mov     #47116, (R5)		; Запишем 4E4E
                sob     R0, WRMAR			; Повторим заданное число раз
                mov     #6, R0				; Запишем 12. нулевых байтов
1$:             tstb    (R4)				; Готовность есть?
                bpl     1$					; Нет - ожидаем
                mov     #0, (R5)			; Записываем нули
                sob     R0, 1$				;    в нужном количестве
                bis     #1000, (R3)			; Подготовим признак записи маркера
4$:             tstb    (R4)				; Контроллер готов?
                bpl     4$					; Нет - ждём
                mov     #120641, (R5)		; Записываем маркер A1A1
                mov     (R3), (R4)			; Передаём признак в контроллер
                bic     #1000, (R3)			; Заранее снимем признак
5$:             tstb    (R4)				; Готовность есть?
                bpl     5$					; Нет - ожидаем
                mov     MARKER(R3), (R5)	; Записываем маркер из буфера
                return

; ═══════════════════════════════════════════════════════════════════════════
; CORR: П/п установки прекоррекции

CORR:           bic     #2000, (R3)			; Снимем прекоррекцию
                cmpb    TRKCOR(R3), @CURTRK(R3)	; Надо включать на текущей дорожке?
                bhi     1$					; Нет - пропустим
                bis     #2000, (R3)			; Пора - включим
1$:             mov     (R3), (R4)			; Перешлём управляющее слово
                mov     #200., R0
                sob     R0, .				; Подождём, пока контроллер воспримет
                return

; ───────────────────────────────────────────────────────────────────────────
; FORMAT: П/п форматирования
FRMTR$:         mov     SP, BUFSP(R3)		; Сохраним SP,
                mov     #4, R0
                mov     (R0), BUF4(R3)		;  @#4 в соответствующих буферах
                mov     PC, (R0)			; Переназначаем вектор @#4 на себя,
                add     #VECT4-., (R0)		;    теперь он равен 161512
                call    ENGINE				; Запустим двигатель
                call    GOTRK				; Позиционируем на нужную дорожку
                call    CORR				; Установим прекоррекцию
                bit     #4, (R4)			; Защита записи включена?
                beq     1$					; Нет - начинаем форматировать
                mov     #1, R0				; Да - ошибка 1
2$:             jmp     ERROR				; Выходим с ошибкой

1$:             swab    SIDE(R3)			; Обмениваем номера стороны и дорожки
                movb    FILLB(R3), WRTVAR(R3)	; Делаем слово-заполнитель
                movb    FILLB(R3), WRTVAR+1(R3)	;    из байта-заполнителя
                movb    MAXSEC(R3), R1		; Получим длину сектора
                mov     #1001, R2			; Запомним номер сектора и код длины
                mov     #1000., R0			; Время ожидания индекса
3$:             tst     (R4)				; Индекс есть?
                bpl     4$					; Исчез - начинаем записывать
                sob     R0, 3$				; Есть - ждём исчезновения
5$:             tst     (R5)				; Так и не исчез - прекратим запись
                mov     #6, R0				; Диск не вращается - ошибка 6
                swab    SIDE(R3)			; Вернём все на место
                br      2$					; Выходим с ошибкой
; Запись на дорожку кода 4E4E
4$:             mov     #3200., R0			; Установим максимальную длину
                mtps    #340				; При записи нам не мешать
                mov     #47116, (R5)		; Записываем 4E4E
6$:             tst     (R4)				; Индекс появился?
                bmi     7$					; Да - начинаем запись
8$:             tstb    (R4)				; Готовность есть?
                bpl     8$					; Нет - ждём
                mov     #47116, (R5)		; Записываем 4E4E
                sob     R0, 6$				; И так до конца дорожки
                br      5$					; Дорожка длинная, ошибка!

7$:             mov     #28., R0			; В маркере будет 28. 4E4E (GAP1)
9$:             mov     #177241, MARKER(R3)	; Адресный маркер (FEA1) - в буфер
                call    WRMAR				; WRMAR: Записываем адресный маркер
10$:            tstb    (R4)				; Готовность есть?
                bpl     10$					; Нет - ожидаем
                mov     SIDE(R3), (R5)		; Записываем номер стороны и дорожки
                mov     (R3), (R4)			; Перешлём управляющее слово
11$:            tstb    (R4)				; Готовность есть?
                bpl     11$					; Нет - дождёмся
                mov     R2, (R5)			; Записываем номер сектора и код длины
                mov     #11., R0			; В маркере будет 11. 4E4E (GAP2)
                mov     #175641, MARKER(R3)	; Маркер данных (FBA1) - в буфер
12$:            bit     #40000, (R4)		; Ждём записи CRC
                beq     12$
                call    WRMAR				; WRMAR: Записываем маркер данных
                mov     SECLEN(R3), R0		; Получаем длину сектора
                dec     R0					; Одно слово запишем сейчас
13$:            tstb    (R4)				; Готовность есть?
                bpl     13$					; Нет - ожидаем
                mov     WRTVAR(R3), (R5)	; Записываем заполнитель
                mov     (R3), (R4)			; Перешлём управляющее слово
14$:            tstb    (R4)				; Готовность есть?
                bpl     14$					; Нет - дождёмся
                mov     WRTVAR(R3), (R5)	; Записываем заполнитель
                sob     R0, 14$				; И так до конца сектора
                inc     R2					; Увеличим номер сектора
                mov     #18., R0			; В маркере будет 18. 4E4E (GAP3)
;    Примечание. Если увеличить GAP3 до 24-27 слов, то запись будет производиться так
; же быстро, как и чтение (обычно заголовок очередного сектора проскакивает, и дорожка
; записывается не за один, а за 10 оборотов). Однако при превышении этой величиной
; определённого значения конец последнего сектора дорожки может наложиться на ее
; же начало.
16$:            bit     #40000, (R4)		; Ждём записи CRC
                beq     16$
                sob     R1, 9$				; И так все сектора до конца дорожки
; Окончание записи дорожки
17$:            tstb    (R4)				; Готовность есть?
                bpl     17$					; Нет - ждём
                mov     #47116, (R5)		; Запишем 4E4E
                tst     (R4)				; Индекс есть?
                bpl     17$					; Нет - продолжим запись до появления
18$:            tstb    (R4)				; Готовность есть?
                bpl     18$					; Нет - дождёмся
                mov     #47116, (R5)		; Запишем 4E4E
                tst     (R5)				; Прекратим запись
                swab    SIDE(R3)			; Вернём все на место
                clr     R0
                tst     (PC)+
ERROR:          sec
                movb    R0, @#ERRFDD
                mov     BUF4(R3), @#4		; Восстановить вектор 4
                mov     BUFSP(R3), SP		; Восстановить SP
                return
; ───────────────────────────────────────────────────────────────────────────

VECT4:          mov     #7, R0
                br      ERROR
; ============== начало загрузчика ==========================================
BUTSEC:         nop                     ; загрузчик
                br      START$
                .ascii "DX-DOS"<0>
                .byte 0					; WORD Число байт в секторе
                .byte 0
                .byte 0					; BYTE Количество секторов в кластере
                .byte 0					; WORD Число секторов в загрузчике
                .byte 0
FATNUM:         .byte 0					; BYTE Число фат
MAXRFL:         .byte 0					; WORD Максимальное число файлов в корневом каталоге
                .byte 0
                .byte 0					; WORD Общее число блоков на диске
                .byte 0
MEDIAD:         .byte 0					; BYTE Media descriptor
FATSZE:         .word 0					; WORD Число секторов в одной фат
TRKSEC:         .word 0					; WORD Число секторов на дорожке
HEDNUM:         .word 0					; WORD Число головок
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 0
                .byte 51
                .byte 0
                .byte 0
                .byte 0
                .byte 0
LABEL:          .ascii "NO NAME    "	;Метка тома
FAT12:          .ascii "FAT12   "		;Идентификатор файловой системы
                .word 0

START$:         movb    FATNUM, R2
                mov     FATSZE, R1
                inc     R0				;текущий прочитанный сектор
                mov     R0, @#416		;начало FAT
                call    IMULB
                mov     R4, R0
                inc     R0				;начало каталога
                movb    MAXRFL, R2		;количество файлов в корне
                bic     #177400, R2
                mov     #20, R1			;количество записей в секторе
                call    IDIVB			;224./20 = 16 секторов
                add     R0, R4			;начало данных
                mov     R4, -(SP)
                mov     R3, R2			;адрес рабочей области контроллера дисковода
                add     #70, R2			;буфер, куда будем читать каталог
                mov     #1, R1			;количество секторов для чтения
                call    READD			;читаем первый сектор каталога
                bcs     ERRLOD
                .addr   R5, DXDOSS		;"DXDOS   SYS"
                mov     R2, R4
                mov     #13, R0			;если самая первая запись в каталоге не DXDOS   SYS
1$:             cmpb    (R5)+, (R4)+
                bne     NOSYS$			;значит диск не системный
                sob     R0, 1$
                mov     34(R2), R2		;длина файла DXDOS.SYS
                mov     #1000, R1		;размер кластера == размер сектора
                call    IDIVB
                mov     R4, R1			;кол-во кластеров
                inc     R1
                mov     (SP)+, R0		;начальный сектор файла DXDOS.SYS, должен быть сразу после каталога
                mov     #5000, R2		;адрес загрузки
                call    READD			;читаем файл DXDOS.SYS
                bcs     NOSYS$
                jmp     @#5000

; ═══════════════════════════════════════════════════════════════════════════
;чтение с диска
;вход: 
;R0 - начальный сектор
;R1 - количество кластеров
;R2 - адрес загрузки

READD:          cmpb    MEDIAD, #373
                blos    4$
                mov     #1, R5			;признаки привода, пробуем 40 дорожек
                call    READ$
                bcc     0NOER$
                clr     R5				;признаки привода
4$:             call    READ$
                bcs     NOSYS$
0NOER$:         return
; ───────────────────────────────────────────────────────────────────────────
; выводим на экран сообщение
NOSYS$:         .addr   R1, NOSYSD		; "Non system disk or disk error"
3$:             movb    (R1)+, R0
                cmp     @#30, #152112	;проверяем, БК11М или БК10, БК11?
                bne     1$
                emt     63
                br      2$

1$:             emt     16
2$:             tst     R0
                bne     3$
                clr     @#177130
                halt
;
; ═══════════════════════════════════════════════════════════════════════════
;вход:
;R0 - начальный сектор
;R1 - количество кластеров
;R2 - адрес загрузки
;R5 - признаки привода

READ$:          mov     R2, 26(R3)		;адрес начала массива данных в ОЗУ
                cmp     #2, HEDNUM		;диск скольки сторонний?
                beq     1$				;двух?
                bis     #2, R5			;нет, значит односторонний
1$:             movb    R5, @20(R3)		;зададим признаки для заданного привода
                mov     R1, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)

6$:             mov     R0, -(SP)
                mov     R2, -(SP)
                mov     R1, -(SP)
                mov     #400, 30(R3)	;количество слов для пересылки. читаем 1 сектор
                mov     #10, R4			;теперь таким длинным образом вычисляем
                mov     TRKSEC, R5		; номер сектора и дорожку, откуда начинать читать
                swab    R5

3$:             cmp     R5, R0
                bhi     2$
                sub     R5, R0
                sec
2$:             rol     R0
                sob     R4, 3$
                movb    R0, R4
                clrb    R0
                swab    R0
                inc     R0
                clrb    32(R3)
                cmp     R0, TRKSEC
                ble     4$
                incb    32(R3)
                sub     TRKSEC, R0
4$:             bitb    #2, @20(R3)
                beq     5$
                asrb    32(R3)
                rolb    R4
5$:             movb    R4, 33(R3)		;номер дорожки
                movb    R0, 35(R3)		;номер сектора
                call    @#160006		;чтение/запись по номеру сектора
                mov     (SP)+, R1
                mov     (SP)+, R2
                mov     (SP)+, R0
                bcs     ERRLOD
                inc     R0
                add     #1000, 26(R3)	;передвигаем указатель адреса, чтобы читать следующий кластер
                sob     R1, 6$

ERRLOD:         mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
;деление R2 на R1
;выход: R4 - результат

IDIVB:          clr     R5
                clr     R4
3$:             inc     R5
                asl     R1
                bcc     3$
2$:             ror     R1
1$:             inc     R4
                sub     R1, R2
                bcc     1$
                add     R1, R2
                dec     R4
                asl     R4
                sob     R5, 2$
                ror     R4
                return

; ═══════════════════════════════════════════════════════════════════════════
;умножение R2 на R1
;выход: R4 - результат

IMULB:          mov     #8., R5
                clr     R4
2$:             asr     R1
                bcc     1$
                add     R2, R4
1$:             asl     R2
                sob     R5, 2$
                return

; ───────────────────────────────────────────────────────────────────────────
DXDOSS:         .asciz "DXDOS   SYS"
NOSYSD:         .asciz "Non system disk or disk error"
				.even
                .blkw 31
                .word 125125
;============= конец загрузчика =============================================
COMSPK:         .asciz "COMSPEC="
                .even

FCBSYS:         .byte 0
                .ascii "DXDOS   SYS"
                .blkb 46

FCBCOM:         .byte 0
                .ascii "COMMAND COM"
                .blkb 44

SYSPAR:         .blkb 102

B10062:         .blkb 74

B10156:         .blkb 16
;таблица форматов
FMTTBL:         .word 047, 1, 10, 1, 100, 376, 1, 240
                .word 047, 1, 11, 1, 100, 374, 2, 264
                .word 047, 2, 10, 2, 160, 377, 1, 500
                .word 047, 2, 11, 2, 160, 375, 2, 550
                .word 117, 1, 10, 2, 160, 367, 1, 500
                .word 117, 1, 11, 2, 160, 370, 2, 550
                .word 117, 2, 10, 2, 160, 373, 2, 1200
                .word 117, 2, 11, 2, 160, 371, 3, 1320
                .word 117, 2, 12, 1, 340, 360, 5, 1440
                .word 047, 2, 12, 1, 340, 360, 3, 620
                .word 0
STRARR:         .asciz "Parameters not compatible."<12><15>							;1
                .asciz "Incorrect DOS version."<12><15>								;2
                .asciz "Track 0 bad - disk unisable."<12><15>						;3
                .asciz "Format failure."<12><15>									;4
                .asciz "Insert new diskette for drive "								;5
                .asciz ":"<12><15>"and strike ENTER when ready..."<12><15>			;6
                .asciz "Format complete.               "<12><15><12><15><12><15>	;7
                .asciz "Format another (Y/N)? "										;10
                .asciz " bytes total disk space."<12><15>							;11
                .asciz " bytes in bad sectors."<12><15>								;12
                .asciz " percent completed."										;13
                .asciz " bytes available on disk."<12><15>							;14
                .asciz " bytes in each allocation unit."<12><15>					;15
                .asciz " allocation units available on disk."<12><15>				;16
                .asciz "Formatting  "												;17
                .asciz <15><12>"Format termitated."									;20
                .asciz " byte used by system."<12><15>								;21
                .asciz "Disk write protected."<12><15>								;22
                .asciz "Write failure, disk unusable."<12><15>						;23
                .asciz "Invalid drive specification."<12><15>						;24
                .asciz <12><15>"System transferrend."<12><15><12><15>				;25
                .asciz "System files not found."<12><15>							;26
                .asciz "Fatal error: COMSPEC not found !"							;27
                .asciz "Insert system disk in drive "								;30
                .asciz <12><15>"Insert target disk in drive "						;31
                .asciz "Copies DX-DOS system files and command interpreter."<12><15><12><15>	;32
                .asciz ":"<12><15>"and strike any key then ready."<12><15>		;33
                .ascii " FORMAT диcк:/пapaмeтpы"<12><15>
                .ascii "                    - фopмaтиpoвaниe диcкoв(внeшняя кoмaндa)"<12><15>
                .ascii " Пapaмeтpы :"<12><15>
                .ascii " /1                 Фopмaтиpoвaниe oднoй cтopoны диcкeты."<12><15>
                .ascii " /4                 Ha 80-ти дopoжeчнoм диcкoвoдe диcкeтa"<12><15>
                .ascii "                    фopмaтиpyeтcя нa 40 дopoжeк."<12><15>
                .ascii " /8                 Пpи фopмaтиpoвaнии нa кaждoй дopoжкe"<12><15>
                .ascii "                    paзмeщaeтcя 8 ceктopoв."<12><15>
                .ascii " /9                 Пpи фopмaтиpoвaнии нa кaждoй дopoжкe"<12><15>
                .ascii "                    paзмeщaeтcя 9 ceктopoв."<12><15>
                .ascii "                   (Пo yмoлчaнию 10 ceктopoв нa дopoжкe)"<12><15>
                .ascii " /B                 Пocлe фopмaтиpoвaния нa диcкe"<12><15>
                .ascii "                    peзepвиpyeтcя мecтo для зaпиcи cиcтeмы."<12><15>
                .ascii " /S                 Пocлe фopмaтиpoвaния нa диcк пepeнocитcя"<12><15>
                .ascii "                    cиcтeмa,диcк cтaнoвитcя cиcтeмным."<12><15>
                .ascii " /?                 Bывoд cпpaвoчнoй инфopмaции."<12><15>
                .ascii " /D                 Пpи фopмaтиpoвaнии иcпoльзyeтcя"<12><15>
                .ascii "                     нecтaндapтный дpaйвep."<12><15>
                .ascii "Boзмoжнo coвмecтнoe иcпoльзoвaниe ключeй кpoмe /B /S"<12><15>
                .ascii "Kлючи /8 /9 мoжнo иcпoльзoвaть тoлькo c ПЗУ 326,"<12><15>
                .asciz "либo c ключoм /D."<12><15>									;34
				.even
EOF:            .word 0


                .END
