library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_ARITH.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;


entity myserializer is 
port
(
-- fx2lp connection
	fx2_data : inout std_logic_vector(7 downto 0);
	fx2_clk  : in  std_logic; -- clock for data exchange from GPIF

	fx2_read_write_switch  : in  std_logic; -- write from fx2lp when low
	fx2_cmd_dat_switch  : in  std_logic; -- use dat-line when low
	fx2_ready_from_epm  : out  std_logic; -- busy to next from epm when low
	fx2_low_speed_switch  : in  std_logic; -- low initial speed when low

-- emmc connection for 3.3 and 1.8
	emmc_clk33 : out std_logic;
	emmc_cmd33 : inout std_logic;
	emmc_dat33 : inout std_logic;
	emmc_clk18 : out std_logic;
	emmc_cmd18 : inout std_logic;
	emmc_dat18 : inout std_logic;
	
-- epm system connection
	epm_master_clk  : in  std_logic; -- input from fx2lp 48MHz or quartz-gen 50MHz
	epm_clk_divby2_jumper  : in  std_logic; -- 48MHz -> 24MHz when low
	slow_clk_divby2_jumper  : in  std_logic; -- 400kHz -> 200kHz when low
	
-- led status
	led_status : out std_logic -- pin 77
-- maybe reset?
);
end myserializer;

architecture serial_convert of myserializer is

	signal clk_counter  : std_logic_vector(7 downto 0):=(others=>'0');	
	signal wait_counter_fall  : std_logic_vector(2 downto 0):=(others=>'0');
	signal isp_clock  : std_logic := '0'; -- isp clock slow for init
	signal shift_counter  : std_logic_vector(2 downto 0):=(others=>'0'); -- 8bits cnt	

	signal isp_cmd_dat_lock  : std_logic := '1'; -- low for dat0
	signal ask_isp_tx_start : std_logic := '0'; -- 1 request tx start	
	signal isp_tx_in_progress : std_logic := '0'; -- 1 when tx started

	signal reg_tx_data : std_logic_vector( 7 downto 0 );
	signal reg_rcv_dat0 : std_logic_vector( 7 downto 0 );
	signal reg_rcv_cmd : std_logic_vector( 7 downto 0 );
		
	signal out_to_fx2_data_latch_cmd : std_logic_vector( 7 downto 0 );
	signal out_to_fx2_data_latch_dat : std_logic_vector( 7 downto 0 );	
	signal in_from_fx2_data_latch : std_logic_vector( 7 downto 0 );	

	signal out_to_emmc_clk_gate  : std_logic := '0';

	signal ready_to_fx2_latch  : std_logic := '0';
	signal ready_to_fx2_ahead  : std_logic := '0';	
	
	signal reg1_free  : std_logic := '1';
	signal reg2_free  : std_logic := '1';		

begin

fx2_data <= out_to_fx2_data_latch_cmd when (fx2_read_write_switch = '1' and (reg2_free = '0') and fx2_cmd_dat_switch = '1') else
 out_to_fx2_data_latch_dat when (fx2_read_write_switch = '1' and (reg2_free = '0') and fx2_cmd_dat_switch = '0') else "ZZZZZZZZ";

emmc_cmd33 <= reg_tx_data(7) when ((isp_tx_in_progress = '1') and isp_cmd_dat_lock = '1') else 'Z';
emmc_cmd18 <= reg_tx_data(7) when ((isp_tx_in_progress = '1') and isp_cmd_dat_lock = '1') else 'Z';
emmc_dat33 <= reg_tx_data(7) when ((isp_tx_in_progress = '1') and isp_cmd_dat_lock = '0') else 'Z';
emmc_dat18 <= reg_tx_data(7) when ((isp_tx_in_progress = '1') and isp_cmd_dat_lock = '0') else 'Z';
	
--	isp_clock_switch
isp_clock <= clk_counter(0) when (fx2_low_speed_switch = '1' and epm_clk_divby2_jumper = '1') else
	clk_counter(1) when (fx2_low_speed_switch = '1' and epm_clk_divby2_jumper = '0') else
	clk_counter(6) when (fx2_low_speed_switch = '0' and slow_clk_divby2_jumper = '1') else clk_counter(7);

ready_to_fx2_ahead <= wait_counter_fall(1);
	
emmc_clk33 <= isp_clock and out_to_emmc_clk_gate;
emmc_clk18 <= isp_clock and out_to_emmc_clk_gate;

-- gate for ready
fx2_ready_from_epm <= ready_to_fx2_latch and ready_to_fx2_ahead and not(fx2_read_write_switch and (reg2_free or reg1_free));

-- led
led_status <= isp_tx_in_progress;
------------------------------------------------------	
	clock_divider: process(epm_master_clk, fx2_clk, isp_clock)
	begin	
	if(rising_edge(epm_master_clk)) then
	clk_counter <= clk_counter + 1;
	end if;	

	if (rising_edge(fx2_clk)) then	
		if (fx2_read_write_switch = '0') then
		isp_cmd_dat_lock <= fx2_cmd_dat_switch;
		in_from_fx2_data_latch <= fx2_data; -- load data from fx2
		end if;	
	end if;	
	
	if(falling_edge(isp_clock)) then
		if(wait_counter_fall /= "011") then wait_counter_fall <= wait_counter_fall + 1;
		end if;	
	end if;	
	
	if(fx2_clk = '1') then
	wait_counter_fall <= "000";
	end if;

	end process clock_divider;	

------------------------------------------------------		
	emmc_isp_rw: process(isp_clock, isp_tx_in_progress, ask_isp_tx_start, isp_cmd_dat_lock, reg_tx_data, fx2_read_write_switch, reg1_free, reg2_free, fx2_cmd_dat_switch, shift_counter, ready_to_fx2_ahead, ready_to_fx2_latch)
	begin

if (rising_edge(isp_clock)) then	
	if isp_tx_in_progress = '1' then		
			if (ask_isp_tx_start = '1')then	
			shift_counter <= "000";
			else	
			shift_counter <= shift_counter + '1';
			end if;

	-- rcv isp
	elsif (fx2_read_write_switch = '1' and out_to_emmc_clk_gate = '1') then
      reg_rcv_dat0 <= reg_rcv_dat0(6 downto 0) & (emmc_dat33 and emmc_dat18);		
      reg_rcv_cmd <= reg_rcv_cmd(6 downto 0) & (emmc_cmd33 and emmc_cmd18);	
		shift_counter <= shift_counter + '1';

	else shift_counter <= "000";
	end if;
end if;

if (falling_edge(isp_clock)) then	 -- if falling edge	----------------

	if (isp_tx_in_progress = '1') then	
	ask_isp_tx_start <= '0';

		if	(shift_counter = "000") then -- 8 bits already clocked

			if (reg2_free = '0') then
			out_to_emmc_clk_gate <= '1'; -- double, can be delete
			reg_tx_data <= in_from_fx2_data_latch;		
			reg2_free <= '1';
			else
			isp_tx_in_progress <= '0';
			out_to_emmc_clk_gate <= '0';	
			reg1_free <= '1';			
			end if;

		else -- counter in progress		
			out_to_emmc_clk_gate <= '1'; -- double, can be delete		
			reg_tx_data <= reg_tx_data(6 downto 0) & '1'; -- shift left
					
			if (ready_to_fx2_ahead = '0' and ready_to_fx2_latch = '1') then
			ready_to_fx2_latch <= '0';
			reg2_free <= '0';	
			elsif (reg2_free = '1' and fx2_read_write_switch = '0' and ready_to_fx2_ahead = '1') then
			ready_to_fx2_latch <= '1';		
			end if;	
		end if;	

	elsif (fx2_read_write_switch = '0') then
			if (ready_to_fx2_ahead = '0' and ready_to_fx2_latch = '1') then
			ready_to_fx2_latch <= '0';
			reg2_free <= '0';	
			reg1_free <= '1';	
			isp_tx_in_progress <= '1';
			ask_isp_tx_start <= '1';
			else 
			out_to_emmc_clk_gate <= '0';	
				if (ready_to_fx2_ahead = '1') then	ready_to_fx2_latch <= '1';	
				end if;
			end if;

	elsif (fx2_read_write_switch = '1') then 
		
		if	(shift_counter = "000") then

			if (reg1_free = '1') then
			out_to_emmc_clk_gate <= '1';
			reg2_free <= '1';
			reg1_free <= '0';-- for next
			ready_to_fx2_latch <= '0';
			else			
					
							if (ready_to_fx2_ahead = '0' and ready_to_fx2_latch = '1') then
							ready_to_fx2_latch <= '0';	
							reg2_free <= '1';
							else

						if (ready_to_fx2_ahead = '1') then	ready_to_fx2_latch <= '1';	
						end if;
						if (reg2_free = '0') then out_to_emmc_clk_gate <= '0';
						else
						out_to_fx2_data_latch_cmd <= reg_rcv_cmd;
						out_to_fx2_data_latch_dat <= reg_rcv_dat0;
						out_to_emmc_clk_gate <= '1';	
						reg2_free <= '0';
						end if;

							end if;

			end if;

		else
				out_to_emmc_clk_gate <= '1'; -- double
				if (ready_to_fx2_ahead = '0' and ready_to_fx2_latch = '1') then
				ready_to_fx2_latch <= '0';
				reg2_free <= '1';
				elsif (reg2_free = '0' and ready_to_fx2_ahead = '1') then
				ready_to_fx2_latch <= '1';
				end if;
		end if;

	end if;
end if;
	end process emmc_isp_rw;
------------------------------------------------------		

end serial_convert;