-- Copyright (C) 1991-2013 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-- VENDOR "Altera"
-- PROGRAM "Quartus II 32-bit"
-- VERSION "Version 13.1.0 Build 162 10/23/2013 SJ Web Edition"

-- DATE "12/29/2025 03:08:54"

-- 
-- Device: Altera EPM240T100C5 Package TQFP100
-- 

-- 
-- This VHDL file should be used for ModelSim-Altera (VHDL) only
-- 

LIBRARY IEEE;
LIBRARY MAXII;
USE IEEE.STD_LOGIC_1164.ALL;
USE MAXII.MAXII_COMPONENTS.ALL;

ENTITY 	myserializer IS
    PORT (
	fx2_data : BUFFER std_logic_vector(7 DOWNTO 0);
	fx2_clk : IN std_logic;
	fx2_read_write_switch : IN std_logic;
	fx2_cmd_dat_switch : IN std_logic;
	fx2_ready_from_epm : BUFFER std_logic;
	fx2_low_speed_switch : IN std_logic;
	emmc_clk33 : BUFFER std_logic;
	emmc_cmd33 : BUFFER std_logic;
	emmc_dat33 : BUFFER std_logic;
	emmc_clk18 : BUFFER std_logic;
	emmc_cmd18 : BUFFER std_logic;
	emmc_dat18 : BUFFER std_logic;
	epm_master_clk : IN std_logic;
	epm_clk_divby2_jumper : IN std_logic;
	slow_clk_divby2_jumper : IN std_logic;
	led_status : BUFFER std_logic
	);
END myserializer;

-- Design Ports Information
-- fx2_ready_from_epm	=>  Location: PIN_7,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: 8mA
-- emmc_clk33	=>  Location: PIN_37,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: 16mA
-- emmc_clk18	=>  Location: PIN_91,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
-- led_status	=>  Location: PIN_77,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
-- fx2_data[0]	=>  Location: PIN_15,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[1]	=>  Location: PIN_16,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[2]	=>  Location: PIN_17,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[3]	=>  Location: PIN_18,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[4]	=>  Location: PIN_47,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[5]	=>  Location: PIN_48,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[6]	=>  Location: PIN_49,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- fx2_data[7]	=>  Location: PIN_50,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
-- emmc_cmd33	=>  Location: PIN_38,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 16mA
-- emmc_dat33	=>  Location: PIN_39,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 16mA
-- emmc_cmd18	=>  Location: PIN_90,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
-- emmc_dat18	=>  Location: PIN_89,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
-- fx2_read_write_switch	=>  Location: PIN_2,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: Default
-- fx2_clk	=>  Location: PIN_61,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default
-- slow_clk_divby2_jumper	=>  Location: PIN_34,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: Default
-- fx2_low_speed_switch	=>  Location: PIN_67,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default
-- epm_clk_divby2_jumper	=>  Location: PIN_28,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: Default
-- epm_master_clk	=>  Location: PIN_12,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: Default
-- fx2_cmd_dat_switch	=>  Location: PIN_66,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default


ARCHITECTURE structure OF myserializer IS
SIGNAL gnd : std_logic := '0';
SIGNAL vcc : std_logic := '1';
SIGNAL unknown : std_logic := 'X';
SIGNAL devoe : std_logic := '1';
SIGNAL devclrn : std_logic := '1';
SIGNAL devpor : std_logic := '1';
SIGNAL ww_devoe : std_logic;
SIGNAL ww_devclrn : std_logic;
SIGNAL ww_devpor : std_logic;
SIGNAL ww_fx2_data : std_logic_vector(7 DOWNTO 0);
SIGNAL ww_fx2_clk : std_logic;
SIGNAL ww_fx2_read_write_switch : std_logic;
SIGNAL ww_fx2_cmd_dat_switch : std_logic;
SIGNAL ww_fx2_ready_from_epm : std_logic;
SIGNAL ww_fx2_low_speed_switch : std_logic;
SIGNAL ww_emmc_clk33 : std_logic;
SIGNAL ww_emmc_cmd33 : std_logic;
SIGNAL ww_emmc_dat33 : std_logic;
SIGNAL ww_emmc_clk18 : std_logic;
SIGNAL ww_emmc_cmd18 : std_logic;
SIGNAL ww_emmc_dat18 : std_logic;
SIGNAL ww_epm_master_clk : std_logic;
SIGNAL ww_epm_clk_divby2_jumper : std_logic;
SIGNAL ww_slow_clk_divby2_jumper : std_logic;
SIGNAL ww_led_status : std_logic;
SIGNAL \fx2_data[0]~0\ : std_logic;
SIGNAL \fx2_data[1]~1\ : std_logic;
SIGNAL \fx2_data[2]~2\ : std_logic;
SIGNAL \fx2_data[3]~3\ : std_logic;
SIGNAL \fx2_data[4]~4\ : std_logic;
SIGNAL \fx2_data[5]~5\ : std_logic;
SIGNAL \fx2_data[6]~6\ : std_logic;
SIGNAL \fx2_data[7]~7\ : std_logic;
SIGNAL \emmc_cmd33~0\ : std_logic;
SIGNAL \emmc_dat33~0\ : std_logic;
SIGNAL \emmc_cmd18~0\ : std_logic;
SIGNAL \emmc_dat18~0\ : std_logic;
SIGNAL \fx2_low_speed_switch~combout\ : std_logic;
SIGNAL \epm_clk_divby2_jumper~combout\ : std_logic;
SIGNAL \isp_clock~4_combout\ : std_logic;
SIGNAL \epm_master_clk~combout\ : std_logic;
SIGNAL \clk_counter[1]~5\ : std_logic;
SIGNAL \clk_counter[1]~5COUT1_22\ : std_logic;
SIGNAL \clk_counter[2]~13\ : std_logic;
SIGNAL \clk_counter[2]~13COUT1_24\ : std_logic;
SIGNAL \clk_counter[3]~11\ : std_logic;
SIGNAL \clk_counter[3]~11COUT1_26\ : std_logic;
SIGNAL \clk_counter[4]~9\ : std_logic;
SIGNAL \clk_counter[5]~7\ : std_logic;
SIGNAL \clk_counter[5]~7COUT1_28\ : std_logic;
SIGNAL \slow_clk_divby2_jumper~combout\ : std_logic;
SIGNAL \isp_clock~2_combout\ : std_logic;
SIGNAL \clk_counter[6]~3\ : std_logic;
SIGNAL \clk_counter[6]~3COUT1_30\ : std_logic;
SIGNAL \isp_clock~1_combout\ : std_logic;
SIGNAL \isp_clock~3_combout\ : std_logic;
SIGNAL \isp_clock~0_combout\ : std_logic;
SIGNAL \isp_clock~combout\ : std_logic;
SIGNAL \fx2_clk~combout\ : std_logic;
SIGNAL \fx2_read_write_switch~combout\ : std_logic;
SIGNAL \out_to_fx2_data_latch_dat[0]~3_combout\ : std_logic;
SIGNAL \out_to_emmc_clk_gate~0_combout\ : std_logic;
SIGNAL \isp_tx_in_progress~0_combout\ : std_logic;
SIGNAL \isp_tx_in_progress~regout\ : std_logic;
SIGNAL \reg_rcv_dat0[0]~2_combout\ : std_logic;
SIGNAL \ask_isp_tx_start~regout\ : std_logic;
SIGNAL \shift_counter~0_combout\ : std_logic;
SIGNAL \Add2~0_combout\ : std_logic;
SIGNAL \reg1_free~2_combout\ : std_logic;
SIGNAL \reg1_free~2_wirecell_combout\ : std_logic;
SIGNAL \reg1_free~4_combout\ : std_logic;
SIGNAL \reg1_free~regout\ : std_logic;
SIGNAL \out_to_fx2_data_latch_dat[0]~2_combout\ : std_logic;
SIGNAL \out_to_emmc_clk_gate~1_combout\ : std_logic;
SIGNAL \out_to_emmc_clk_gate~regout\ : std_logic;
SIGNAL \Add2~1_combout\ : std_logic;
SIGNAL \Equal1~0_combout\ : std_logic;
SIGNAL \reg2_free~0_combout\ : std_logic;
SIGNAL \reg2_free~1_combout\ : std_logic;
SIGNAL \reg2_free~2_combout\ : std_logic;
SIGNAL \reg2_free~regout\ : std_logic;
SIGNAL \ready_to_fx2_latch~0_combout\ : std_logic;
SIGNAL \ready_to_fx2_latch~1_combout\ : std_logic;
SIGNAL \ready_to_fx2_latch~2_combout\ : std_logic;
SIGNAL \ready_to_fx2_latch~regout\ : std_logic;
SIGNAL \fx2_ready_from_epm~0_combout\ : std_logic;
SIGNAL \fx2_ready_from_epm~1_combout\ : std_logic;
SIGNAL \emmc_clk33~0_Duplicate_1_combout\ : std_logic;
SIGNAL \emmc_clk33~0_combout\ : std_logic;
SIGNAL \fx2_data~16_combout\ : std_logic;
SIGNAL \reg_rcv_dat0[0]~4_combout\ : std_logic;
SIGNAL \out_to_fx2_data_latch_dat[0]~4_combout\ : std_logic;
SIGNAL \fx2_cmd_dat_switch~combout\ : std_logic;
SIGNAL \fx2_data[0]~17\ : std_logic;
SIGNAL \fx2_data[1]~18\ : std_logic;
SIGNAL \fx2_data[2]~19\ : std_logic;
SIGNAL \fx2_data[3]~20\ : std_logic;
SIGNAL \fx2_data[4]~21\ : std_logic;
SIGNAL \fx2_data[5]~22\ : std_logic;
SIGNAL \fx2_data[6]~23\ : std_logic;
SIGNAL \fx2_data[7]~24\ : std_logic;
SIGNAL \reg_tx_data[0]~1_combout\ : std_logic;
SIGNAL \isp_cmd_dat_lock~regout\ : std_logic;
SIGNAL \emmc_cmd33~2_combout\ : std_logic;
SIGNAL \emmc_dat33~2_combout\ : std_logic;
SIGNAL wait_counter_fall : std_logic_vector(2 DOWNTO 0);
SIGNAL out_to_fx2_data_latch_cmd : std_logic_vector(7 DOWNTO 0);
SIGNAL out_to_fx2_data_latch_dat : std_logic_vector(7 DOWNTO 0);
SIGNAL shift_counter : std_logic_vector(2 DOWNTO 0);
SIGNAL reg_tx_data : std_logic_vector(7 DOWNTO 0);
SIGNAL reg_rcv_dat0 : std_logic_vector(7 DOWNTO 0);
SIGNAL reg_rcv_cmd : std_logic_vector(7 DOWNTO 0);
SIGNAL clk_counter : std_logic_vector(7 DOWNTO 0);
SIGNAL in_from_fx2_data_latch : std_logic_vector(7 DOWNTO 0);
SIGNAL \ALT_INV_isp_clock~combout\ : std_logic;
SIGNAL \ALT_INV_isp_tx_in_progress~regout\ : std_logic;
SIGNAL \ALT_INV_fx2_read_write_switch~combout\ : std_logic;

BEGIN

fx2_data <= ww_fx2_data;
ww_fx2_clk <= fx2_clk;
ww_fx2_read_write_switch <= fx2_read_write_switch;
ww_fx2_cmd_dat_switch <= fx2_cmd_dat_switch;
fx2_ready_from_epm <= ww_fx2_ready_from_epm;
ww_fx2_low_speed_switch <= fx2_low_speed_switch;
emmc_clk33 <= ww_emmc_clk33;
emmc_cmd33 <= ww_emmc_cmd33;
emmc_dat33 <= ww_emmc_dat33;
emmc_clk18 <= ww_emmc_clk18;
emmc_cmd18 <= ww_emmc_cmd18;
emmc_dat18 <= ww_emmc_dat18;
ww_epm_master_clk <= epm_master_clk;
ww_epm_clk_divby2_jumper <= epm_clk_divby2_jumper;
ww_slow_clk_divby2_jumper <= slow_clk_divby2_jumper;
led_status <= ww_led_status;
ww_devoe <= devoe;
ww_devclrn <= devclrn;
ww_devpor <= devpor;
\ALT_INV_isp_clock~combout\ <= NOT \isp_clock~combout\;
\ALT_INV_isp_tx_in_progress~regout\ <= NOT \isp_tx_in_progress~regout\;
\ALT_INV_fx2_read_write_switch~combout\ <= NOT \fx2_read_write_switch~combout\;

-- Location: PIN_15,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[0]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[0]~17\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(0),
	combout => \fx2_data[0]~0\);

-- Location: PIN_16,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[1]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[1]~18\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(1),
	combout => \fx2_data[1]~1\);

-- Location: PIN_17,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[2]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[2]~19\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(2),
	combout => \fx2_data[2]~2\);

-- Location: PIN_18,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[3]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[3]~20\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(3),
	combout => \fx2_data[3]~3\);

-- Location: PIN_47,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[4]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[4]~21\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(4),
	combout => \fx2_data[4]~4\);

-- Location: PIN_48,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[5]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[5]~22\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(5),
	combout => \fx2_data[5]~5\);

-- Location: PIN_49,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[6]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[6]~23\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(6),
	combout => \fx2_data[6]~6\);

-- Location: PIN_50,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 8mA
\fx2_data[7]~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => \fx2_data[7]~24\,
	oe => \fx2_data~16_combout\,
	padio => ww_fx2_data(7),
	combout => \fx2_data[7]~7\);

-- Location: PIN_38,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 16mA
\emmc_cmd33~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => reg_tx_data(7),
	oe => \emmc_cmd33~2_combout\,
	padio => ww_emmc_cmd33,
	combout => \emmc_cmd33~0\);

-- Location: PIN_39,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: 16mA
\emmc_dat33~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => reg_tx_data(7),
	oe => \emmc_dat33~2_combout\,
	padio => ww_emmc_dat33,
	combout => \emmc_dat33~0\);

-- Location: PIN_90,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
\emmc_cmd18~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => reg_tx_data(7),
	oe => \emmc_cmd33~2_combout\,
	padio => ww_emmc_cmd18,
	combout => \emmc_cmd18~0\);

-- Location: PIN_89,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
\emmc_dat18~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "bidir")
-- pragma translate_on
PORT MAP (
	datain => reg_tx_data(7),
	oe => \emmc_dat33~2_combout\,
	padio => ww_emmc_dat18,
	combout => \emmc_dat18~0\);

-- Location: PIN_67,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default
\fx2_low_speed_switch~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_fx2_low_speed_switch,
	combout => \fx2_low_speed_switch~combout\);

-- Location: PIN_28,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: Default
\epm_clk_divby2_jumper~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_epm_clk_divby2_jumper,
	combout => \epm_clk_divby2_jumper~combout\);

-- Location: LC_X2_Y3_N1
\isp_clock~4\ : maxii_lcell
-- Equation(s):
-- \isp_clock~4_combout\ = ((\fx2_low_speed_switch~combout\ & ((\epm_clk_divby2_jumper~combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cc00",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \fx2_low_speed_switch~combout\,
	datad => \epm_clk_divby2_jumper~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~4_combout\);

-- Location: PIN_12,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: Default
\epm_master_clk~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_epm_master_clk,
	combout => \epm_master_clk~combout\);

-- Location: LC_X3_Y3_N8
\clk_counter[0]\ : maxii_lcell
-- Equation(s):
-- clk_counter(0) = DFFEAS((((!clk_counter(0)))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00ff",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	datad => clk_counter(0),
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(0));

-- Location: LC_X3_Y3_N1
\clk_counter[1]\ : maxii_lcell
-- Equation(s):
-- clk_counter(1) = DFFEAS(clk_counter(0) $ ((clk_counter(1))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[1]~5\ = CARRY((clk_counter(0) & (clk_counter(1))))
-- \clk_counter[1]~5COUT1_22\ = CARRY((clk_counter(0) & (clk_counter(1))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "6688",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	dataa => clk_counter(0),
	datab => clk_counter(1),
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(1),
	cout0 => \clk_counter[1]~5\,
	cout1 => \clk_counter[1]~5COUT1_22\);

-- Location: LC_X3_Y3_N2
\clk_counter[2]\ : maxii_lcell
-- Equation(s):
-- clk_counter(2) = DFFEAS((clk_counter(2) $ ((\clk_counter[1]~5\))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[2]~13\ = CARRY(((!\clk_counter[1]~5\) # (!clk_counter(2))))
-- \clk_counter[2]~13COUT1_24\ = CARRY(((!\clk_counter[1]~5COUT1_22\) # (!clk_counter(2))))

-- pragma translate_off
GENERIC MAP (
	cin0_used => "true",
	cin1_used => "true",
	lut_mask => "3c3f",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	datab => clk_counter(2),
	aclr => GND,
	cin0 => \clk_counter[1]~5\,
	cin1 => \clk_counter[1]~5COUT1_22\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(2),
	cout0 => \clk_counter[2]~13\,
	cout1 => \clk_counter[2]~13COUT1_24\);

-- Location: LC_X3_Y3_N3
\clk_counter[3]\ : maxii_lcell
-- Equation(s):
-- clk_counter(3) = DFFEAS(clk_counter(3) $ ((((!\clk_counter[2]~13\)))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[3]~11\ = CARRY((clk_counter(3) & ((!\clk_counter[2]~13\))))
-- \clk_counter[3]~11COUT1_26\ = CARRY((clk_counter(3) & ((!\clk_counter[2]~13COUT1_24\))))

-- pragma translate_off
GENERIC MAP (
	cin0_used => "true",
	cin1_used => "true",
	lut_mask => "a50a",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	dataa => clk_counter(3),
	aclr => GND,
	cin0 => \clk_counter[2]~13\,
	cin1 => \clk_counter[2]~13COUT1_24\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(3),
	cout0 => \clk_counter[3]~11\,
	cout1 => \clk_counter[3]~11COUT1_26\);

-- Location: LC_X3_Y3_N4
\clk_counter[4]\ : maxii_lcell
-- Equation(s):
-- clk_counter(4) = DFFEAS((clk_counter(4) $ ((\clk_counter[3]~11\))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[4]~9\ = CARRY(((!\clk_counter[3]~11COUT1_26\) # (!clk_counter(4))))

-- pragma translate_off
GENERIC MAP (
	cin0_used => "true",
	cin1_used => "true",
	lut_mask => "3c3f",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	datab => clk_counter(4),
	aclr => GND,
	cin0 => \clk_counter[3]~11\,
	cin1 => \clk_counter[3]~11COUT1_26\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(4),
	cout => \clk_counter[4]~9\);

-- Location: LC_X3_Y3_N5
\clk_counter[5]\ : maxii_lcell
-- Equation(s):
-- clk_counter(5) = DFFEAS((clk_counter(5) $ ((!\clk_counter[4]~9\))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[5]~7\ = CARRY(((clk_counter(5) & !\clk_counter[4]~9\)))
-- \clk_counter[5]~7COUT1_28\ = CARRY(((clk_counter(5) & !\clk_counter[4]~9\)))

-- pragma translate_off
GENERIC MAP (
	cin_used => "true",
	lut_mask => "c30c",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	datab => clk_counter(5),
	aclr => GND,
	cin => \clk_counter[4]~9\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(5),
	cout0 => \clk_counter[5]~7\,
	cout1 => \clk_counter[5]~7COUT1_28\);

-- Location: LC_X3_Y3_N6
\clk_counter[6]\ : maxii_lcell
-- Equation(s):
-- clk_counter(6) = DFFEAS(clk_counter(6) $ (((((!\clk_counter[4]~9\ & \clk_counter[5]~7\) # (\clk_counter[4]~9\ & \clk_counter[5]~7COUT1_28\))))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )
-- \clk_counter[6]~3\ = CARRY(((!\clk_counter[5]~7\)) # (!clk_counter(6)))
-- \clk_counter[6]~3COUT1_30\ = CARRY(((!\clk_counter[5]~7COUT1_28\)) # (!clk_counter(6)))

-- pragma translate_off
GENERIC MAP (
	cin0_used => "true",
	cin1_used => "true",
	cin_used => "true",
	lut_mask => "5a5f",
	operation_mode => "arithmetic",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	dataa => clk_counter(6),
	aclr => GND,
	cin => \clk_counter[4]~9\,
	cin0 => \clk_counter[5]~7\,
	cin1 => \clk_counter[5]~7COUT1_28\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(6),
	cout0 => \clk_counter[6]~3\,
	cout1 => \clk_counter[6]~3COUT1_30\);

-- Location: PIN_34,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: Default
\slow_clk_divby2_jumper~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_slow_clk_divby2_jumper,
	combout => \slow_clk_divby2_jumper~combout\);

-- Location: LC_X2_Y3_N0
\isp_clock~2\ : maxii_lcell
-- Equation(s):
-- \isp_clock~2_combout\ = (((\slow_clk_divby2_jumper~combout\ & !\fx2_low_speed_switch~combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00f0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \slow_clk_divby2_jumper~combout\,
	datad => \fx2_low_speed_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~2_combout\);

-- Location: LC_X3_Y3_N7
\clk_counter[7]\ : maxii_lcell
-- Equation(s):
-- clk_counter(7) = DFFEAS((clk_counter(7) $ ((!(!\clk_counter[4]~9\ & \clk_counter[6]~3\) # (\clk_counter[4]~9\ & \clk_counter[6]~3COUT1_30\)))), GLOBAL(\epm_master_clk~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	cin0_used => "true",
	cin1_used => "true",
	cin_used => "true",
	lut_mask => "c3c3",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "cin",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \epm_master_clk~combout\,
	datab => clk_counter(7),
	aclr => GND,
	cin => \clk_counter[4]~9\,
	cin0 => \clk_counter[6]~3\,
	cin1 => \clk_counter[6]~3COUT1_30\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => clk_counter(7));

-- Location: LC_X3_Y3_N0
\isp_clock~1\ : maxii_lcell
-- Equation(s):
-- \isp_clock~1_combout\ = (\isp_clock~2_combout\ & (!clk_counter(6))) # (!\isp_clock~2_combout\ & (((!clk_counter(7)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "4747",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => clk_counter(6),
	datab => \isp_clock~2_combout\,
	datac => clk_counter(7),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~1_combout\);

-- Location: LC_X2_Y3_N4
\isp_clock~3\ : maxii_lcell
-- Equation(s):
-- \isp_clock~3_combout\ = ((\fx2_low_speed_switch~combout\ & ((!\epm_clk_divby2_jumper~combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00cc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \fx2_low_speed_switch~combout\,
	datad => \epm_clk_divby2_jumper~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~3_combout\);

-- Location: LC_X3_Y3_N9
\isp_clock~0\ : maxii_lcell
-- Equation(s):
-- \isp_clock~0_combout\ = ((\isp_clock~3_combout\ & (!clk_counter(1))) # (!\isp_clock~3_combout\ & ((\isp_clock~1_combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "33f0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => clk_counter(1),
	datac => \isp_clock~1_combout\,
	datad => \isp_clock~3_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~0_combout\);

-- Location: LC_X2_Y3_N2
isp_clock : maxii_lcell
-- Equation(s):
-- \isp_clock~combout\ = LCELL(((\isp_clock~4_combout\ & ((clk_counter(0)))) # (!\isp_clock~4_combout\ & (!\isp_clock~0_combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cf03",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \isp_clock~4_combout\,
	datac => \isp_clock~0_combout\,
	datad => clk_counter(0),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_clock~combout\);

-- Location: PIN_61,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default
\fx2_clk~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_fx2_clk,
	combout => \fx2_clk~combout\);

-- Location: LC_X6_Y1_N5
\wait_counter_fall[0]\ : maxii_lcell
-- Equation(s):
-- wait_counter_fall(0) = DFFEAS((wait_counter_fall(1)) # ((!wait_counter_fall(0))), !GLOBAL(\isp_clock~combout\), !GLOBAL(\fx2_clk~combout\), , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "bbbb",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => wait_counter_fall(1),
	datab => wait_counter_fall(0),
	aclr => \fx2_clk~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => wait_counter_fall(0));

-- Location: LC_X6_Y1_N4
\wait_counter_fall[1]\ : maxii_lcell
-- Equation(s):
-- wait_counter_fall(1) = DFFEAS((wait_counter_fall(1)) # ((wait_counter_fall(0))), !GLOBAL(\isp_clock~combout\), !GLOBAL(\fx2_clk~combout\), , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "eeee",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => wait_counter_fall(1),
	datab => wait_counter_fall(0),
	aclr => \fx2_clk~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => wait_counter_fall(1));

-- Location: PIN_2,	 I/O Standard: 3.3V Schmitt Trigger Input,	 Current Strength: Default
\fx2_read_write_switch~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_fx2_read_write_switch,
	combout => \fx2_read_write_switch~combout\);

-- Location: LC_X4_Y2_N8
\out_to_fx2_data_latch_dat[0]~3\ : maxii_lcell
-- Equation(s):
-- \out_to_fx2_data_latch_dat[0]~3_combout\ = (!\reg2_free~regout\ & (((wait_counter_fall(1)) # (!\ready_to_fx2_latch~regout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "5055",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \reg2_free~regout\,
	datac => wait_counter_fall(1),
	datad => \ready_to_fx2_latch~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \out_to_fx2_data_latch_dat[0]~3_combout\);

-- Location: LC_X4_Y2_N0
\out_to_emmc_clk_gate~0\ : maxii_lcell
-- Equation(s):
-- \out_to_emmc_clk_gate~0_combout\ = (\ready_to_fx2_latch~regout\ & (((\out_to_emmc_clk_gate~regout\ & !wait_counter_fall(1)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00a0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \ready_to_fx2_latch~regout\,
	datac => \out_to_emmc_clk_gate~regout\,
	datad => wait_counter_fall(1),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \out_to_emmc_clk_gate~0_combout\);

-- Location: LC_X4_Y2_N2
\isp_tx_in_progress~0\ : maxii_lcell
-- Equation(s):
-- \isp_tx_in_progress~0_combout\ = (!\fx2_read_write_switch~combout\ & (((\ready_to_fx2_latch~regout\ & !wait_counter_fall(1)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0050",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \fx2_read_write_switch~combout\,
	datac => \ready_to_fx2_latch~regout\,
	datad => wait_counter_fall(1),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \isp_tx_in_progress~0_combout\);

-- Location: LC_X5_Y3_N4
isp_tx_in_progress : maxii_lcell
-- Equation(s):
-- \isp_tx_in_progress~regout\ = DFFEAS((\isp_tx_in_progress~regout\ & (((!\reg1_free~2_combout\)))) # (!\isp_tx_in_progress~regout\ & (\isp_tx_in_progress~0_combout\)), !GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "22ee",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \isp_tx_in_progress~0_combout\,
	datab => \isp_tx_in_progress~regout\,
	datad => \reg1_free~2_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \isp_tx_in_progress~regout\);

-- Location: LC_X5_Y3_N5
\reg_rcv_dat0[0]~2\ : maxii_lcell
-- Equation(s):
-- \reg_rcv_dat0[0]~2_combout\ = (\fx2_read_write_switch~combout\ & (((!\isp_tx_in_progress~regout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0a0a",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \fx2_read_write_switch~combout\,
	datac => \isp_tx_in_progress~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg_rcv_dat0[0]~2_combout\);

-- Location: LC_X5_Y3_N8
ask_isp_tx_start : maxii_lcell
-- Equation(s):
-- \ask_isp_tx_start~regout\ = DFFEAS(((!\isp_tx_in_progress~regout\ & ((\ask_isp_tx_start~regout\) # (\isp_tx_in_progress~0_combout\)))), !GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00fc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datab => \ask_isp_tx_start~regout\,
	datac => \isp_tx_in_progress~0_combout\,
	datad => \isp_tx_in_progress~regout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \ask_isp_tx_start~regout\);

-- Location: LC_X5_Y3_N0
\shift_counter~0\ : maxii_lcell
-- Equation(s):
-- \shift_counter~0_combout\ = (((\isp_tx_in_progress~regout\ & !\ask_isp_tx_start~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00f0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_tx_in_progress~regout\,
	datad => \ask_isp_tx_start~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \shift_counter~0_combout\);

-- Location: LC_X6_Y2_N8
\shift_counter[0]\ : maxii_lcell
-- Equation(s):
-- shift_counter(0) = DFFEAS((!shift_counter(0) & ((\shift_counter~0_combout\) # ((\out_to_emmc_clk_gate~regout\ & \reg_rcv_dat0[0]~2_combout\)))), GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "3320",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	dataa => \out_to_emmc_clk_gate~regout\,
	datab => shift_counter(0),
	datac => \reg_rcv_dat0[0]~2_combout\,
	datad => \shift_counter~0_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => shift_counter(0));

-- Location: LC_X4_Y2_N9
\Add2~0\ : maxii_lcell
-- Equation(s):
-- \Add2~0_combout\ = ((shift_counter(1) $ (shift_counter(0))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0ff0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => shift_counter(1),
	datad => shift_counter(0),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \Add2~0_combout\);

-- Location: LC_X6_Y2_N5
\shift_counter[1]\ : maxii_lcell
-- Equation(s):
-- shift_counter(1) = DFFEAS((\Add2~0_combout\ & ((\shift_counter~0_combout\) # ((\out_to_emmc_clk_gate~regout\ & \reg_rcv_dat0[0]~2_combout\)))), GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	dataa => \out_to_emmc_clk_gate~regout\,
	datab => \shift_counter~0_combout\,
	datac => \reg_rcv_dat0[0]~2_combout\,
	datad => \Add2~0_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => shift_counter(1));

-- Location: LC_X6_Y2_N6
\reg1_free~2\ : maxii_lcell
-- Equation(s):
-- \reg1_free~2_combout\ = (!shift_counter(0) & (!\reg2_free~regout\ & (!shift_counter(1) & !shift_counter(2))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0001",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => shift_counter(0),
	datab => \reg2_free~regout\,
	datac => shift_counter(1),
	datad => shift_counter(2),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg1_free~2_combout\);

-- Location: LC_X6_Y3_N5
\reg1_free~2_wirecell\ : maxii_lcell
-- Equation(s):
-- \reg1_free~2_wirecell_combout\ = (((!\reg1_free~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0f0f",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \reg1_free~2_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg1_free~2_wirecell_combout\);

-- Location: LC_X5_Y3_N6
\reg1_free~4\ : maxii_lcell
-- Equation(s):
-- \reg1_free~4_combout\ = (!\reg1_free~regout\ & ((\isp_tx_in_progress~regout\) # ((!\Equal1~0_combout\) # (!\fx2_read_write_switch~combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "4555",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \reg1_free~regout\,
	datab => \isp_tx_in_progress~regout\,
	datac => \fx2_read_write_switch~combout\,
	datad => \Equal1~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg1_free~4_combout\);

-- Location: LC_X5_Y3_N7
reg1_free : maxii_lcell
-- Equation(s):
-- \reg1_free~regout\ = DFFEAS((!\reg1_free~4_combout\ & ((\isp_tx_in_progress~regout\ & (!\reg1_free~2_combout\)) # (!\isp_tx_in_progress~regout\ & ((!\isp_tx_in_progress~0_combout\))))), !GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0027",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \isp_tx_in_progress~regout\,
	datab => \reg1_free~2_combout\,
	datac => \isp_tx_in_progress~0_combout\,
	datad => \reg1_free~4_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \reg1_free~regout\);

-- Location: LC_X6_Y2_N1
\out_to_fx2_data_latch_dat[0]~2\ : maxii_lcell
-- Equation(s):
-- \out_to_fx2_data_latch_dat[0]~2_combout\ = (!shift_counter(0) & (\reg1_free~regout\ & (!shift_counter(1) & !shift_counter(2))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0004",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => shift_counter(0),
	datab => \reg1_free~regout\,
	datac => shift_counter(1),
	datad => shift_counter(2),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \out_to_fx2_data_latch_dat[0]~2_combout\);

-- Location: LC_X6_Y3_N3
\out_to_emmc_clk_gate~1\ : maxii_lcell
-- Equation(s):
-- \out_to_emmc_clk_gate~1_combout\ = ((\out_to_fx2_data_latch_dat[0]~3_combout\) # ((\out_to_emmc_clk_gate~0_combout\) # (!\out_to_fx2_data_latch_dat[0]~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "fcff",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \out_to_fx2_data_latch_dat[0]~3_combout\,
	datac => \out_to_emmc_clk_gate~0_combout\,
	datad => \out_to_fx2_data_latch_dat[0]~2_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \out_to_emmc_clk_gate~1_combout\);

-- Location: LC_X6_Y3_N4
out_to_emmc_clk_gate : maxii_lcell
-- Equation(s):
-- \out_to_emmc_clk_gate~regout\ = DFFEAS((\fx2_read_write_switch~combout\ & (((\out_to_emmc_clk_gate~1_combout\)))) # (!\fx2_read_write_switch~combout\ & (\out_to_emmc_clk_gate~0_combout\)), !GLOBAL(\isp_clock~combout\), VCC, , , 
-- \reg1_free~2_wirecell_combout\, , , \isp_tx_in_progress~regout\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ee22",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \out_to_emmc_clk_gate~0_combout\,
	datab => \fx2_read_write_switch~combout\,
	datac => \reg1_free~2_wirecell_combout\,
	datad => \out_to_emmc_clk_gate~1_combout\,
	aclr => GND,
	sload => \isp_tx_in_progress~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \out_to_emmc_clk_gate~regout\);

-- Location: LC_X4_Y2_N3
\Add2~1\ : maxii_lcell
-- Equation(s):
-- \Add2~1_combout\ = (shift_counter(2) $ (((shift_counter(1) & shift_counter(0)))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "3cf0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => shift_counter(1),
	datac => shift_counter(2),
	datad => shift_counter(0),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \Add2~1_combout\);

-- Location: LC_X6_Y2_N2
\shift_counter[2]\ : maxii_lcell
-- Equation(s):
-- shift_counter(2) = DFFEAS((\Add2~1_combout\ & ((\shift_counter~0_combout\) # ((\out_to_emmc_clk_gate~regout\ & \reg_rcv_dat0[0]~2_combout\)))), GLOBAL(\isp_clock~combout\), VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	dataa => \out_to_emmc_clk_gate~regout\,
	datab => \shift_counter~0_combout\,
	datac => \reg_rcv_dat0[0]~2_combout\,
	datad => \Add2~1_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => shift_counter(2));

-- Location: LC_X6_Y2_N3
\Equal1~0\ : maxii_lcell
-- Equation(s):
-- \Equal1~0_combout\ = ((!shift_counter(2) & (!shift_counter(1) & !shift_counter(0))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0003",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => shift_counter(2),
	datac => shift_counter(1),
	datad => shift_counter(0),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \Equal1~0_combout\);

-- Location: LC_X5_Y2_N7
\reg2_free~0\ : maxii_lcell
-- Equation(s):
-- \reg2_free~0_combout\ = (!\reg1_free~regout\ & (!shift_counter(1) & (!shift_counter(2) & !shift_counter(0))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0001",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \reg1_free~regout\,
	datab => shift_counter(1),
	datac => shift_counter(2),
	datad => shift_counter(0),
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg2_free~0_combout\);

-- Location: LC_X4_Y2_N7
\reg2_free~1\ : maxii_lcell
-- Equation(s):
-- \reg2_free~1_combout\ = (\isp_tx_in_progress~regout\) # ((\reg2_free~0_combout\) # ((\ready_to_fx2_latch~regout\ & !wait_counter_fall(1))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ffce",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \ready_to_fx2_latch~regout\,
	datab => \isp_tx_in_progress~regout\,
	datac => wait_counter_fall(1),
	datad => \reg2_free~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg2_free~1_combout\);

-- Location: LC_X4_Y2_N1
\reg2_free~2\ : maxii_lcell
-- Equation(s):
-- \reg2_free~2_combout\ = ((\isp_tx_in_progress~regout\ & ((\Equal1~0_combout\))) # (!\isp_tx_in_progress~regout\ & (\fx2_read_write_switch~combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "fc30",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \isp_tx_in_progress~regout\,
	datac => \fx2_read_write_switch~combout\,
	datad => \Equal1~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg2_free~2_combout\);

-- Location: LC_X4_Y2_N5
reg2_free : maxii_lcell
-- Equation(s):
-- \reg2_free~regout\ = DFFEAS((\reg2_free~2_combout\ & (!\reg2_free~1_combout\ & ((\Equal1~0_combout\) # (!\out_to_fx2_data_latch_dat[0]~3_combout\)))) # (!\reg2_free~2_combout\ & (!\out_to_fx2_data_latch_dat[0]~3_combout\)), !GLOBAL(\isp_clock~combout\), 
-- VCC, , , , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0d55",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \out_to_fx2_data_latch_dat[0]~3_combout\,
	datab => \Equal1~0_combout\,
	datac => \reg2_free~1_combout\,
	datad => \reg2_free~2_combout\,
	aclr => GND,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \reg2_free~regout\);

-- Location: LC_X6_Y1_N7
\ready_to_fx2_latch~0\ : maxii_lcell
-- Equation(s):
-- \ready_to_fx2_latch~0_combout\ = (wait_counter_fall(1) & ((\ready_to_fx2_latch~regout\) # ((!\fx2_read_write_switch~combout\ & !\reg2_free~regout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "a0a2",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => wait_counter_fall(1),
	datab => \fx2_read_write_switch~combout\,
	datac => \ready_to_fx2_latch~regout\,
	datad => \reg2_free~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \ready_to_fx2_latch~0_combout\);

-- Location: LC_X6_Y2_N4
\ready_to_fx2_latch~1\ : maxii_lcell
-- Equation(s):
-- \ready_to_fx2_latch~1_combout\ = ((!\Equal1~0_combout\ & ((\ready_to_fx2_latch~regout\) # (\reg2_free~regout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00fc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \ready_to_fx2_latch~regout\,
	datac => \reg2_free~regout\,
	datad => \Equal1~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \ready_to_fx2_latch~1_combout\);

-- Location: LC_X6_Y2_N9
\ready_to_fx2_latch~2\ : maxii_lcell
-- Equation(s):
-- \ready_to_fx2_latch~2_combout\ = (wait_counter_fall(1) & (((\ready_to_fx2_latch~1_combout\) # (\out_to_fx2_data_latch_dat[0]~2_combout\)) # (!\fx2_read_write_switch~combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "aaa2",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => wait_counter_fall(1),
	datab => \fx2_read_write_switch~combout\,
	datac => \ready_to_fx2_latch~1_combout\,
	datad => \out_to_fx2_data_latch_dat[0]~2_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \ready_to_fx2_latch~2_combout\);

-- Location: LC_X6_Y2_N7
ready_to_fx2_latch : maxii_lcell
-- Equation(s):
-- \ready_to_fx2_latch~regout\ = DFFEAS(((\Equal1~0_combout\ & ((\ready_to_fx2_latch~regout\))) # (!\Equal1~0_combout\ & (\ready_to_fx2_latch~0_combout\))), !GLOBAL(\isp_clock~combout\), VCC, , , \ready_to_fx2_latch~2_combout\, , , 
-- !\isp_tx_in_progress~regout\)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ccaa",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \ready_to_fx2_latch~0_combout\,
	datab => \ready_to_fx2_latch~regout\,
	datac => \ready_to_fx2_latch~2_combout\,
	datad => \Equal1~0_combout\,
	aclr => GND,
	sload => \ALT_INV_isp_tx_in_progress~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \ready_to_fx2_latch~regout\);

-- Location: LC_X4_Y2_N6
\fx2_ready_from_epm~0\ : maxii_lcell
-- Equation(s):
-- \fx2_ready_from_epm~0_combout\ = ((\reg1_free~regout\ & (\reg2_free~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "c0c0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \reg1_free~regout\,
	datac => \reg2_free~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_ready_from_epm~0_combout\);

-- Location: LC_X4_Y2_N4
\fx2_ready_from_epm~1\ : maxii_lcell
-- Equation(s):
-- \fx2_ready_from_epm~1_combout\ = (\ready_to_fx2_latch~regout\ & (wait_counter_fall(1) & ((\fx2_ready_from_epm~0_combout\) # (!\fx2_read_write_switch~combout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "8808",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \ready_to_fx2_latch~regout\,
	datab => wait_counter_fall(1),
	datac => \fx2_read_write_switch~combout\,
	datad => \fx2_ready_from_epm~0_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_ready_from_epm~1_combout\);

-- Location: LC_X4_Y3_N9
\emmc_clk33~0_Duplicate_1\ : maxii_lcell
-- Equation(s):
-- \emmc_clk33~0_Duplicate_1_combout\ = (((GLOBAL(\isp_clock~combout\) & \out_to_emmc_clk_gate~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "f000",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_clock~combout\,
	datad => \out_to_emmc_clk_gate~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \emmc_clk33~0_Duplicate_1_combout\);

-- Location: LC_X4_Y3_N5
\emmc_clk33~0\ : maxii_lcell
-- Equation(s):
-- \emmc_clk33~0_combout\ = (((GLOBAL(\isp_clock~combout\) & \out_to_emmc_clk_gate~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "f000",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_clock~combout\,
	datad => \out_to_emmc_clk_gate~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \emmc_clk33~0_combout\);

-- Location: LC_X6_Y1_N8
\fx2_data~16\ : maxii_lcell
-- Equation(s):
-- \fx2_data~16_combout\ = ((\fx2_read_write_switch~combout\ & ((\reg2_free~regout\))))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cc00",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \fx2_read_write_switch~combout\,
	datad => \reg2_free~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data~16_combout\);

-- Location: LC_X6_Y3_N9
\reg_rcv_dat0[0]~4\ : maxii_lcell
-- Equation(s):
-- \reg_rcv_dat0[0]~4_combout\ = ((\fx2_read_write_switch~combout\ & (\out_to_emmc_clk_gate~regout\ & !\isp_tx_in_progress~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00c0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datab => \fx2_read_write_switch~combout\,
	datac => \out_to_emmc_clk_gate~regout\,
	datad => \isp_tx_in_progress~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg_rcv_dat0[0]~4_combout\);

-- Location: LC_X5_Y1_N2
\reg_rcv_dat0[0]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(0) = DFFEAS((((\emmc_dat18~0\ & \emmc_dat33~0\))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "f000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datac => \emmc_dat18~0\,
	datad => \emmc_dat33~0\,
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(0));

-- Location: LC_X6_Y2_N0
\out_to_fx2_data_latch_dat[0]~4\ : maxii_lcell
-- Equation(s):
-- \out_to_fx2_data_latch_dat[0]~4_combout\ = (\fx2_read_write_switch~combout\ & (!\isp_tx_in_progress~regout\ & (\out_to_fx2_data_latch_dat[0]~3_combout\ & \out_to_fx2_data_latch_dat[0]~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "2000",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	dataa => \fx2_read_write_switch~combout\,
	datab => \isp_tx_in_progress~regout\,
	datac => \out_to_fx2_data_latch_dat[0]~3_combout\,
	datad => \out_to_fx2_data_latch_dat[0]~2_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \out_to_fx2_data_latch_dat[0]~4_combout\);

-- Location: LC_X5_Y2_N9
\out_to_fx2_data_latch_dat[0]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(0) = DFFEAS((((reg_rcv_dat0(0)))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datad => reg_rcv_dat0(0),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(0));

-- Location: LC_X5_Y1_N4
\reg_rcv_cmd[0]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(0) = DFFEAS((((\emmc_cmd33~0\ & \emmc_cmd18~0\))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "f000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datac => \emmc_cmd33~0\,
	datad => \emmc_cmd18~0\,
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(0));

-- Location: PIN_66,	 I/O Standard: 2.5V Schmitt Trigger Input,	 Current Strength: Default
\fx2_cmd_dat_switch~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "input")
-- pragma translate_on
PORT MAP (
	oe => GND,
	padio => ww_fx2_cmd_dat_switch,
	combout => \fx2_cmd_dat_switch~combout\);

-- Location: LC_X5_Y2_N4
\out_to_fx2_data_latch_cmd[0]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[0]~17\ = (\fx2_data~16_combout\ & ((\fx2_cmd_dat_switch~combout\ & ((out_to_fx2_data_latch_cmd[0]))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(0))))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(0)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e4cc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \fx2_data~16_combout\,
	datab => out_to_fx2_data_latch_dat(0),
	datac => reg_rcv_cmd(0),
	datad => \fx2_cmd_dat_switch~combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[0]~17\,
	regout => out_to_fx2_data_latch_cmd(0));

-- Location: LC_X5_Y2_N0
\reg_rcv_dat0[1]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(1) = DFFEAS((reg_rcv_dat0(0)), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "aaaa",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	dataa => reg_rcv_dat0(0),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(1));

-- Location: LC_X5_Y2_N1
\out_to_fx2_data_latch_dat[1]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(1) = DFFEAS(((reg_rcv_dat0(1))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datab => reg_rcv_dat0(1),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(1));

-- Location: LC_X5_Y1_N5
\reg_rcv_cmd[1]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(1) = DFFEAS(((reg_rcv_cmd(0))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_cmd(0),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(1));

-- Location: LC_X5_Y2_N8
\out_to_fx2_data_latch_cmd[1]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[1]~18\ = (\fx2_data~16_combout\ & ((\fx2_cmd_dat_switch~combout\ & ((out_to_fx2_data_latch_cmd[1]))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(1))))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(1)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e4cc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \fx2_data~16_combout\,
	datab => out_to_fx2_data_latch_dat(1),
	datac => reg_rcv_cmd(1),
	datad => \fx2_cmd_dat_switch~combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[1]~18\,
	regout => out_to_fx2_data_latch_cmd(1));

-- Location: LC_X7_Y3_N7
\reg_rcv_dat0[2]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(2) = DFFEAS(((reg_rcv_dat0(1))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(1),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(2));

-- Location: LC_X7_Y2_N1
\out_to_fx2_data_latch_dat[2]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(2) = DFFEAS((((reg_rcv_dat0(2)))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datad => reg_rcv_dat0(2),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(2));

-- Location: LC_X5_Y2_N5
\reg_rcv_cmd[2]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(2) = DFFEAS(GND, GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, reg_rcv_cmd(1), , , VCC)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datac => reg_rcv_cmd(1),
	aclr => GND,
	sload => VCC,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(2));

-- Location: LC_X5_Y2_N3
\out_to_fx2_data_latch_cmd[2]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[2]~19\ = (\fx2_data~16_combout\ & ((\fx2_cmd_dat_switch~combout\ & ((out_to_fx2_data_latch_cmd[2]))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(2))))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(2)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e4cc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \fx2_data~16_combout\,
	datab => out_to_fx2_data_latch_dat(2),
	datac => reg_rcv_cmd(2),
	datad => \fx2_cmd_dat_switch~combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[2]~19\,
	regout => out_to_fx2_data_latch_cmd(2));

-- Location: LC_X7_Y3_N5
\reg_rcv_dat0[3]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(3) = DFFEAS(((reg_rcv_dat0(2))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(2),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(3));

-- Location: LC_X7_Y2_N3
\out_to_fx2_data_latch_dat[3]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(3) = DFFEAS(((reg_rcv_dat0(3))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datab => reg_rcv_dat0(3),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(3));

-- Location: LC_X6_Y3_N8
\reg_rcv_cmd[3]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(3) = DFFEAS((((reg_rcv_cmd(2)))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datad => reg_rcv_cmd(2),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(3));

-- Location: LC_X7_Y2_N2
\out_to_fx2_data_latch_cmd[3]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[3]~20\ = (\fx2_cmd_dat_switch~combout\ & ((\fx2_data~16_combout\ & ((out_to_fx2_data_latch_cmd[3]))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(3))))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(3)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e2aa",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => out_to_fx2_data_latch_dat(3),
	datab => \fx2_cmd_dat_switch~combout\,
	datac => reg_rcv_cmd(3),
	datad => \fx2_data~16_combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[3]~20\,
	regout => out_to_fx2_data_latch_cmd(3));

-- Location: LC_X6_Y3_N6
\reg_rcv_dat0[4]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(4) = DFFEAS(((reg_rcv_dat0(3))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(3),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(4));

-- Location: LC_X5_Y2_N2
\out_to_fx2_data_latch_dat[4]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(4) = DFFEAS(GND, !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, reg_rcv_dat0(4), , , VCC)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datac => reg_rcv_dat0(4),
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(4));

-- Location: LC_X6_Y3_N1
\reg_rcv_cmd[4]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(4) = DFFEAS(((reg_rcv_cmd(3))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_cmd(3),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(4));

-- Location: LC_X5_Y2_N6
\out_to_fx2_data_latch_cmd[4]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[4]~21\ = (\fx2_data~16_combout\ & ((\fx2_cmd_dat_switch~combout\ & ((out_to_fx2_data_latch_cmd[4]))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(4))))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(4)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e4cc",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \fx2_data~16_combout\,
	datab => out_to_fx2_data_latch_dat(4),
	datac => reg_rcv_cmd(4),
	datad => \fx2_cmd_dat_switch~combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[4]~21\,
	regout => out_to_fx2_data_latch_cmd(4));

-- Location: LC_X6_Y3_N2
\reg_rcv_dat0[5]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(5) = DFFEAS(((reg_rcv_dat0(4))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(4),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(5));

-- Location: LC_X7_Y2_N6
\out_to_fx2_data_latch_dat[5]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(5) = DFFEAS(GND, !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, reg_rcv_dat0(5), , , VCC)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datac => reg_rcv_dat0(5),
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(5));

-- Location: LC_X7_Y3_N0
\reg_rcv_cmd[5]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(5) = DFFEAS((((reg_rcv_cmd(4)))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datad => reg_rcv_cmd(4),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(5));

-- Location: LC_X7_Y2_N5
\out_to_fx2_data_latch_cmd[5]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[5]~22\ = (\fx2_cmd_dat_switch~combout\ & ((\fx2_data~16_combout\ & ((out_to_fx2_data_latch_cmd[5]))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(5))))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(5)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e2aa",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => out_to_fx2_data_latch_dat(5),
	datab => \fx2_cmd_dat_switch~combout\,
	datac => reg_rcv_cmd(5),
	datad => \fx2_data~16_combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[5]~22\,
	regout => out_to_fx2_data_latch_cmd(5));

-- Location: LC_X6_Y3_N0
\reg_rcv_dat0[6]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(6) = DFFEAS(((reg_rcv_dat0(5))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(5),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(6));

-- Location: LC_X7_Y2_N4
\out_to_fx2_data_latch_dat[6]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(6) = DFFEAS((((reg_rcv_dat0(6)))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datad => reg_rcv_dat0(6),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(6));

-- Location: LC_X7_Y3_N2
\reg_rcv_cmd[6]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(6) = DFFEAS((reg_rcv_cmd(5)), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "aaaa",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	dataa => reg_rcv_cmd(5),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(6));

-- Location: LC_X7_Y2_N9
\out_to_fx2_data_latch_cmd[6]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[6]~23\ = (\fx2_cmd_dat_switch~combout\ & ((\fx2_data~16_combout\ & ((out_to_fx2_data_latch_cmd[6]))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(6))))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(6)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e2aa",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => out_to_fx2_data_latch_dat(6),
	datab => \fx2_cmd_dat_switch~combout\,
	datac => reg_rcv_cmd(6),
	datad => \fx2_data~16_combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[6]~23\,
	regout => out_to_fx2_data_latch_cmd(6));

-- Location: LC_X6_Y3_N7
\reg_rcv_dat0[7]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_dat0(7) = DFFEAS(((reg_rcv_dat0(6))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_dat0(6),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_dat0(7));

-- Location: LC_X7_Y2_N8
\out_to_fx2_data_latch_dat[7]\ : maxii_lcell
-- Equation(s):
-- out_to_fx2_data_latch_dat(7) = DFFEAS((((reg_rcv_dat0(7)))), !GLOBAL(\isp_clock~combout\), VCC, , \out_to_fx2_data_latch_dat[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	datad => reg_rcv_dat0(7),
	aclr => GND,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => out_to_fx2_data_latch_dat(7));

-- Location: LC_X7_Y3_N6
\reg_rcv_cmd[7]\ : maxii_lcell
-- Equation(s):
-- reg_rcv_cmd(7) = DFFEAS(((reg_rcv_cmd(6))), GLOBAL(\isp_clock~combout\), VCC, , \reg_rcv_dat0[0]~4_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "cccc",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \isp_clock~combout\,
	datab => reg_rcv_cmd(6),
	aclr => GND,
	ena => \reg_rcv_dat0[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_rcv_cmd(7));

-- Location: LC_X7_Y2_N7
\out_to_fx2_data_latch_cmd[7]\ : maxii_lcell
-- Equation(s):
-- \fx2_data[7]~24\ = (\fx2_cmd_dat_switch~combout\ & ((\fx2_data~16_combout\ & ((out_to_fx2_data_latch_cmd[7]))) # (!\fx2_data~16_combout\ & (out_to_fx2_data_latch_dat(7))))) # (!\fx2_cmd_dat_switch~combout\ & (out_to_fx2_data_latch_dat(7)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "e2aa",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "qfbk",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => out_to_fx2_data_latch_dat(7),
	datab => \fx2_cmd_dat_switch~combout\,
	datac => reg_rcv_cmd(7),
	datad => \fx2_data~16_combout\,
	aclr => GND,
	sload => VCC,
	ena => \out_to_fx2_data_latch_dat[0]~4_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \fx2_data[7]~24\,
	regout => out_to_fx2_data_latch_cmd(7));

-- Location: LC_X5_Y4_N8
\in_from_fx2_data_latch[0]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(0) = DFFEAS(GND, GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, \fx2_data[0]~0\, , , VCC)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datac => \fx2_data[0]~0\,
	aclr => GND,
	sload => VCC,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(0));

-- Location: LC_X5_Y4_N9
\reg_tx_data[0]~1\ : maxii_lcell
-- Equation(s):
-- \reg_tx_data[0]~1_combout\ = (((\isp_tx_in_progress~regout\ & !\reg1_free~2_combout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00f0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_tx_in_progress~regout\,
	datad => \reg1_free~2_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \reg_tx_data[0]~1_combout\);

-- Location: LC_X5_Y4_N5
\reg_tx_data[0]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(0) = DFFEAS((((in_from_fx2_data_latch(0)) # (!\Equal1~0_combout\))) # (!\reg2_free~regout\), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff5f",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(0),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(0));

-- Location: LC_X5_Y4_N2
\in_from_fx2_data_latch[1]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(1) = DFFEAS((((\fx2_data[1]~1\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[1]~1\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(1));

-- Location: LC_X5_Y4_N7
\reg_tx_data[1]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(1) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(1)))) # (!\Equal1~0_combout\ & (reg_tx_data(0))))) # (!\reg2_free~regout\ & (reg_tx_data(0))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ea2a",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => reg_tx_data(0),
	datab => \reg2_free~regout\,
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(1),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(1));

-- Location: LC_X5_Y4_N1
\in_from_fx2_data_latch[2]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(2) = DFFEAS((((\fx2_data[2]~2\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[2]~2\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(2));

-- Location: LC_X5_Y4_N6
\reg_tx_data[2]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(2) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(2)))) # (!\Equal1~0_combout\ & (reg_tx_data(1))))) # (!\reg2_free~regout\ & (reg_tx_data(1))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ea2a",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => reg_tx_data(1),
	datab => \reg2_free~regout\,
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(2),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(2));

-- Location: LC_X5_Y4_N3
\in_from_fx2_data_latch[3]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(3) = DFFEAS((((\fx2_data[3]~3\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[3]~3\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(3));

-- Location: LC_X5_Y4_N4
\reg_tx_data[3]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(3) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(3)))) # (!\Equal1~0_combout\ & (reg_tx_data(2))))) # (!\reg2_free~regout\ & (reg_tx_data(2))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec4c",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datab => reg_tx_data(2),
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(3),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(3));

-- Location: LC_X6_Y4_N9
\in_from_fx2_data_latch[4]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(4) = DFFEAS((((\fx2_data[4]~4\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[4]~4\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(4));

-- Location: LC_X6_Y4_N5
\reg_tx_data[4]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(4) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(4)))) # (!\Equal1~0_combout\ & (reg_tx_data(3))))) # (!\reg2_free~regout\ & (reg_tx_data(3))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec4c",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datab => reg_tx_data(3),
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(4),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(4));

-- Location: LC_X6_Y4_N3
\in_from_fx2_data_latch[5]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(5) = DFFEAS(GND, GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, \fx2_data[5]~5\, , , VCC)

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0000",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "on")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datac => \fx2_data[5]~5\,
	aclr => GND,
	sload => VCC,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(5));

-- Location: LC_X6_Y4_N7
\reg_tx_data[5]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(5) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(5)))) # (!\Equal1~0_combout\ & (reg_tx_data(4))))) # (!\reg2_free~regout\ & (reg_tx_data(4))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec4c",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datab => reg_tx_data(4),
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(5),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(5));

-- Location: LC_X6_Y4_N8
\in_from_fx2_data_latch[6]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(6) = DFFEAS((((\fx2_data[6]~6\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[6]~6\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(6));

-- Location: LC_X6_Y4_N2
\reg_tx_data[6]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(6) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(6)))) # (!\Equal1~0_combout\ & (reg_tx_data(5))))) # (!\reg2_free~regout\ & (reg_tx_data(5))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec4c",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datab => reg_tx_data(5),
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(6),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(6));

-- Location: LC_X6_Y4_N1
\in_from_fx2_data_latch[7]\ : maxii_lcell
-- Equation(s):
-- in_from_fx2_data_latch(7) = DFFEAS((((\fx2_data[7]~7\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ff00",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datad => \fx2_data[7]~7\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => in_from_fx2_data_latch(7));

-- Location: LC_X6_Y4_N6
\reg_tx_data[7]\ : maxii_lcell
-- Equation(s):
-- reg_tx_data(7) = DFFEAS((\reg2_free~regout\ & ((\Equal1~0_combout\ & ((in_from_fx2_data_latch(7)))) # (!\Equal1~0_combout\ & (reg_tx_data(6))))) # (!\reg2_free~regout\ & (reg_tx_data(6))), !GLOBAL(\isp_clock~combout\), VCC, , \reg_tx_data[0]~1_combout\, , 
-- , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "ec4c",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \ALT_INV_isp_clock~combout\,
	dataa => \reg2_free~regout\,
	datab => reg_tx_data(6),
	datac => \Equal1~0_combout\,
	datad => in_from_fx2_data_latch(7),
	aclr => GND,
	ena => \reg_tx_data[0]~1_combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => reg_tx_data(7));

-- Location: LC_X5_Y3_N3
isp_cmd_dat_lock : maxii_lcell
-- Equation(s):
-- \isp_cmd_dat_lock~regout\ = DFFEAS((((!\fx2_cmd_dat_switch~combout\))), GLOBAL(\fx2_clk~combout\), VCC, , !\fx2_read_write_switch~combout\, , , , )

-- pragma translate_off
GENERIC MAP (
	lut_mask => "0f0f",
	operation_mode => "normal",
	output_mode => "reg_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	clk => \fx2_clk~combout\,
	datac => \fx2_cmd_dat_switch~combout\,
	aclr => GND,
	ena => \ALT_INV_fx2_read_write_switch~combout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	regout => \isp_cmd_dat_lock~regout\);

-- Location: LC_X5_Y3_N9
\emmc_cmd33~2\ : maxii_lcell
-- Equation(s):
-- \emmc_cmd33~2_combout\ = (((\isp_tx_in_progress~regout\ & !\isp_cmd_dat_lock~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "00f0",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_tx_in_progress~regout\,
	datad => \isp_cmd_dat_lock~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \emmc_cmd33~2_combout\);

-- Location: LC_X5_Y3_N1
\emmc_dat33~2\ : maxii_lcell
-- Equation(s):
-- \emmc_dat33~2_combout\ = (((\isp_tx_in_progress~regout\ & \isp_cmd_dat_lock~regout\)))

-- pragma translate_off
GENERIC MAP (
	lut_mask => "f000",
	operation_mode => "normal",
	output_mode => "comb_only",
	register_cascade_mode => "off",
	sum_lutc_input => "datac",
	synch_mode => "off")
-- pragma translate_on
PORT MAP (
	datac => \isp_tx_in_progress~regout\,
	datad => \isp_cmd_dat_lock~regout\,
	devclrn => ww_devclrn,
	devpor => ww_devpor,
	combout => \emmc_dat33~2_combout\);

-- Location: PIN_7,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: 8mA
\fx2_ready_from_epm~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "output")
-- pragma translate_on
PORT MAP (
	datain => \fx2_ready_from_epm~1_combout\,
	oe => VCC,
	padio => ww_fx2_ready_from_epm);

-- Location: PIN_37,	 I/O Standard: 3.3-V LVTTL,	 Current Strength: 16mA
\emmc_clk33~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "output")
-- pragma translate_on
PORT MAP (
	datain => \emmc_clk33~0_Duplicate_1_combout\,
	oe => VCC,
	padio => ww_emmc_clk33);

-- Location: PIN_91,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
\emmc_clk18~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "output")
-- pragma translate_on
PORT MAP (
	datain => \emmc_clk33~0_combout\,
	oe => VCC,
	padio => ww_emmc_clk18);

-- Location: PIN_77,	 I/O Standard: 1.8 V,	 Current Strength: 6mA
\led_status~I\ : maxii_io
-- pragma translate_off
GENERIC MAP (
	operation_mode => "output")
-- pragma translate_on
PORT MAP (
	datain => \isp_tx_in_progress~regout\,
	oe => VCC,
	padio => ww_led_status);
END structure;


