// BlockBoulder.cpp: implementation of the CBlockBoulder class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "BlockBoulder.h"
#include "BlockDinamic.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBoulderApp theApp;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBlockBoulder::CBlockBoulder()
{
}

CBlockBoulder::~CBlockBoulder()
{

}

//////////////////////////////////////////////////////////////////////
void CBlockBoulder::DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap)
{
	theApp.DrawSprite (pDc, 11 + (m_state >> 8) + (m_state % 256) / 2, ptPos, m_ptOfs);
	CBlockDinamic::DrawBlock (pDc, ptPos, bDrawAllMap);
}

//////////////////////////////////////////////////////////////////////
void CBlockBoulder::IncreaseState ()
{
	if (m_movement == NOMOVEMENT)
	{
		m_state = (m_state + 1) % 8;
		return;
	}

	switch (m_movement)
	{
	case MOVEMENT_RIGHT_ONGROUP:
	case VK_RIGHT:
		m_state %= 256;
		m_state = (m_state + 1) % 4;
		m_state = (4 << 8) | m_state;
	break;
	case MOVEMENT_LEFT_ONGROUP:
	case VK_LEFT:
		m_state %= 256;
		m_state = (m_state + 1) % 4;
		m_state = (6 << 8) | m_state;
	break;
	case VK_DOWN:
		m_state %= 256;
		m_state = (m_state + 1) % 4;
		m_state = (8 << 8) | m_state;
	break;
	case VK_UP:
		m_state %= 256;
		m_state = (m_state + 1) % 4;
		m_state = (10 << 8) | m_state;
	break;
	case BETWEEN_MOVEMENT:
		m_movement = NOMOVEMENT;
	break;
	}
}

