// BlockDinamic.h: interface for the CBlockDinamic class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BLOCKDINAMIC_H__5D2F0D43_6710_11D5_874B_00A0C9697DFA__INCLUDED_)
#define AFX_BLOCKDINAMIC_H__5D2F0D43_6710_11D5_874B_00A0C9697DFA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BlockStatic.h"

class CBlockDinamic : public CBlockStatic  
{
protected:
	CPoint				m_ptOfs;
	CPoint				m_ptOfsOld;

	int					m_movement;

	BOOL				m_bEnableTail;			
		
	void				SetOfs (CPoint ptOfs){m_ptOfsOld = ptOfs; m_ptOfs = (0, 0);} // Do not use in public section!
	// couse uncorrect work with tails


public:
	CBlockDinamic();
	virtual ~CBlockDinamic();

	virtual int			GetAbstractType (){return ABSTRACT_DINAMIC;}
	virtual void		DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap = TRUE);

	void				DrawTail (CDC* pDc, CPoint ptPos, CPoint ptOfs, CPoint ptOfsOld);
	void				ClearBlock (CDC* pDc, CPoint ptPos);

	int					GetMovement (){return m_movement;}
	void				SetMovement (int movement){m_movement = movement;}

	CPoint				GetOfs (){return m_ptOfs;}
	int					GetXOfs (){return m_ptOfs.x;}
	int					GetYOfs (){return m_ptOfs.y;}

	BOOL				AddXOfs (int add);
	BOOL				SubXOfs (int sub);
	BOOL				AddYOfs (int add);
	BOOL				SubYOfs (int sub);

	void				SetXOfs (int xOfs){SetOfs (CPoint (xOfs, m_ptOfs.y));}
	void				SetYOfs (int yOfs){SetOfs (CPoint (m_ptOfs.x, yOfs));}
	
	void				EnableTail (BOOL bTail);
};

#endif // !defined(AFX_BLOCKDINAMIC_H__5D2F0D43_6710_11D5_874B_00A0C9697DFA__INCLUDED_)
