// BlockGold.cpp: implementation of the CBlockGold class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Boulder.h"
#include "BlockGold.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBoulderApp theApp;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBlockGold::CBlockGold()
{
}

CBlockGold::~CBlockGold()
{
}

//////////////////////////////////////////////////////////////////////
void CBlockGold::DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap)
{
	theApp.DrawSprite (pDc, 3 + m_state, ptPos, m_ptOfs);
	
	CBlockDinamic::DrawBlock (pDc, ptPos, bDrawAllMap);
}

//////////////////////////////////////////////////////////////////////
void CBlockGold::IncreaseState ()
{
	switch (m_movement)
	{
	case MOVEMENT_DROP_RIGHT:
		m_state = (m_state + 1) % 4;
		break;
	case MOVEMENT_DROP_LEFT:
		m_state = m_state > 0 ? m_state - 1 : 3;
		break;
	case MOVEMENT_DOWN:
	case NOMOVEMENT:
		m_state = 0;
		break;
	}
}

