// BoulderMap.h: interface for the CBoulderMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOULDERMAP_H__C7BB524F_64B8_11D5_874B_00A0C9697DFA__INCLUDED_)
#define AFX_BOULDERMAP_H__C7BB524F_64B8_11D5_874B_00A0C9697DFA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MapBlock.h"

class CBoulderMap  
{
	static	CString			m_strFindFileName;
	static	BYTE			m_totalLevelNum;
	static	int				m_curLevelIndex;

	int						m_levelNum;
	CMapBlock***			m_pMap;

	int						m_nGold;
	int						m_nTotalGold;
	int						m_nMonsters;
	int						m_nTotalMonsters;
	int						m_nExplosion;

	void					DestroyMap ();

public:
	CBoulderMap ();
	CBoulderMap (int levelNum, int fill);
	CBoulderMap (int levelNum, CString strFileName);
	CBoulderMap (CBoulderMap* pMap);
	virtual ~CBoulderMap();

	operator CMapBlock***	(){return m_pMap;};

	CMapBlock*				CreateNewBlock (int type);
	CMapBlock*				GetMapItem (CPoint ptPos);
	CMapBlock*				GetMapItemIndirect (CPoint ptPos);
	void					DeleteBlock (CMapBlock* block);
	void					DeleteBlock (CPoint ptPos);
	void					ChangeMapPointer (CPoint ptPos, int type);
	void					ChangeMapPointer (CPoint ptPos, CMapBlock* pBlock);
	void					ChangeMapItem (CPoint ptPos, int type);
	void					ChangeMapItem (CPoint ptPos, CMapBlock* pBlock);
	void					ChangeMapItem (CMapBlock* pBlock, int type);
	int						ConvertFileIndex (BYTE index);
	BYTE					ConvertMapIndex (int index);
	void					DrawMap (CDC *pDc, BOOL bDrawAllMap = TRUE);
	void					DrawMap (CDC *pDc, CPoint ptPos);
	CMapBlock*				SetBoulderPos (CPoint ptPos);
	CMapBlock*				GetBoulder ();
	CPoint					GetBoulderPos ();
	void					SetLevelNumber (int number){m_levelNum = number;}
	int						GetLevelNumber (){return m_levelNum;}
	int						GetGoldNumber (){return m_nGold;}
	int						GetMonstersNumber (){return m_nMonsters;}
	int						GetTotalGoldNumber (){return m_nTotalGold;}
	int						GetTotalMonstersNumber (){return m_nTotalMonsters;}
	int						GetExplosionsNumper (){return m_nExplosion;}

	void					LoadMap (int levelNum, CString strFileName);
	void					SaveMap (CString strFileName);
	static void				DeleteMap (int levelNum, CString strFileName);
	static BOOL				CreateEmptyMapFile (CString strFileName);
	static BOOL				FindFirstLevel (CString name, BYTE* nLevel);
	static BOOL				FindNextLevel (BYTE* nLevel);
};

#endif // !defined(AFX_BOULDERMAP_H__C7BB524F_64B8_11D5_874B_00A0C9697DFA__INCLUDED_)
