// Globals definitions (Globals.h)

#include "stdafx.h"

// Map Blocks
enum BLOCKS {
	BLOCK_NULL =		   -1,
	BLOCK_SPACE	=			0,
	BLOCK_GROUND,
	BLOCK_ARMOR,
	BLOCK_GOLD,
	BLOCK_STONE,
	BLOCK_BOULDER,
	BLOCK_MONSTER,
	BLOCK_MONSTER1,
	BLOCK_MONSTER2,
	BLOCK_EXPLOSION
};

// Block Types
enum ABSTRACT_TYPE {
	ABSTRACT_SIMPLE =		0,
	ABSTRACT_STATIC,
	ABSTRACT_DINAMIC
};

// Movement types
enum MOVEMENT {
	NOMOVEMENT =			0,
	MOVEMENT_RIGHT,
	MOVEMENT_LEFT,
	MOVEMENT_DOWN,
	MOVEMENT_UP,
	MOVEMENT_DROP_RIGHT,
	MOVEMENT_DROP_LEFT,
	MOVEMENT_RIGHT_ONGROUP,
	MOVEMENT_LEFT_ONGROUP,
	MOVEMENT_UP_ONGROUP,
	BETWEEN_MOVEMENT,
};

// Axis
enum AXIS {
	AXISX =					0,
	AXISY
};

// Edit tool types
enum TOOLS {
	EDIT_TOOL_NORMAL =		0,
	EDIT_TOOL_LINE,
	EDIT_TOOL_PAINT,
	EDIT_TOOL_FILL
};

// Wave samles
enum WAVE {
	CLOSE_WAVE =		   -2,
	WAIT_WAVE =			   -1,
	WAVE_START =			0,
	WAVE_DROP,
	WAVE_STONEDROP,
	WAVE_EXPLOSION,
	WAVE_THEME
};

// Timers
enum TIMER {
	TIMER_GAME =			0,
	TIMER_PULL,
	TIMER_COMPLETED,
	TIMER_FAILED,
	TIMER_EDITOR
};

// Main definetions

// Total map sprites number
#define MAP_SPRITES_NUM					34

// Status sprites number
#define STATUS_SPRITES_NUM				10

// Map block sizes
#define BLOCK_WIDTH						32
#define BLOCK_HEIGHT					32

// Map sizes in blocks
#define MAP_WIDTH						16
#define MAP_HEIGHT						16

// Steps
#define MOVE_RIGHT_STEP					8
#define MOVE_LEFT_STEP					8
#define MOVE_DOWN_STEP					8
#define MOVE_UP_STEP					8

// Timer settings
#define BOULDER_INTERNAL_TIMER_DELAY	50
#define EDITOR_INTERNAL_TIMER_DELAY		100
#define PREVIEW_INTERNAL_TIMER_DELAY	50
#define SCORETABLE_TIMER_DELAY			100
#define COMPLETED_LEVEL_TIMER			200
#define FAILED_LEVEL_TIMER				2000

// Preview parameters
#define PREVIEW_TITLE_HEIGHT			40	

// Scoretable parameters
#define PLAYERS_IN_SCORETABLE			30
#define SCORE_PER_ONE_GOLD				10
#define SCORE_PER_ONE_MONSTER			0
#define SCORE_PER_ONE_LEAVED_MONSTER	0
#define NUMBER_OF_LIVES_ON_START		10
#define LIVES_PER_ONE_LEVEL				1
#define LIVES_ON_LEVEL_FAILED			1
#define START_LEVEL						0

#define STATUS_APPLE_STUMP				4000
#define STATUS_APPLE					6000
#define STATUS_MONNY					8000
#define STATUS_WOOD						10000
#define STATUS_IRON						12000
#define STATUS_STONE					15000
#define STATUS_GOLD						20000
#define STATUS_RUBY						25000
#define STATUS_EMERALD					30000
