// MapEngine.cpp: implementation of the CMapEngine class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "MapEngine.h"
#include "BlockStatic.h"
#include "BlockDinamic.h"
#include "BlockSpace.h"
#include "BlockStone.h"
#include "BlockMonster.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBoulderApp theApp;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMapEngine::CMapEngine()
{
	m_pMap = NULL;
	m_pBoulder = NULL;
	m_ptBoulderPos.x = 0;
	m_ptBoulderPos.y = 0;

	m_curKeyPressed = 0;
	m_bAllUnpressed = TRUE;

	m_nGold = 0;
}

CMapEngine::CMapEngine(CBoulderMap* pMap)
{
	m_pMap = pMap;
	InitBoulder ();
	
	m_curKeyPressed = 0;
	m_bAllUnpressed = TRUE;
}

CMapEngine::~CMapEngine()
{
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::Create (CBoulderMap* pMap)
{
	m_pMap = pMap; 
	InitBoulder ();
	
	m_curKeyPressed = 0;
	m_bAllUnpressed = TRUE;

	m_nGold = 0;
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::MoveDinamicBlocks ()
{
	// Init blocks that can drop down 
	for (int y = 0; y < MAP_HEIGHT; y++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			CBlockDinamic* block = (CBlockDinamic*)m_pMap->GetMapItem (CPoint (x, y));
			int type = block->GetBlockType ();

			// Compare for moving down
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) && y < MAP_HEIGHT - 1
				&&(m_pMap->GetMapItem (CPoint (x, y + 1)))->GetBlockType () == BLOCK_SPACE)
			{
				if (block->GetMovement () == NOMOVEMENT)
				{
					block->SetMovement (MOVEMENT_DOWN);
					((CBlockStone*)block)->SetHeight (0);
				}
			}
			else
			// Compare for moving right
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) && y < MAP_HEIGHT - 1 && x < MAP_WIDTH - 1
				&&(m_pMap->GetMapItem (CPoint (x + 1, y)))->GetBlockType () == BLOCK_SPACE
				&&(m_pMap->GetMapItem (CPoint (x + 1, y + 1)))->GetBlockType () == BLOCK_SPACE)
			{	
				if (block->GetMovement () == NOMOVEMENT)
				{
					block->SetMovement (MOVEMENT_DROP_RIGHT);
				}
			}
			else
			// Compare for moving left
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) && y < MAP_HEIGHT - 1 && x > 0
				&&(m_pMap->GetMapItem (CPoint (x - 1, y)))->GetBlockType () == BLOCK_SPACE
				&&(m_pMap->GetMapItem (CPoint (x - 1, y + 1)))->GetBlockType () == BLOCK_SPACE)
			{	
				if (block->GetMovement () == NOMOVEMENT)
				{
					block->SetMovement (MOVEMENT_DROP_LEFT);
				}
			}
			

		}

	ShiftDinamicBlocks ();
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::ShiftDinamicBlocks ()
{
	for (int y = 0; y < MAP_HEIGHT; y++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{	
			CBlockDinamic* block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x, y));
			int type = block->GetBlockType ();

			// If block droping down
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) 
				&& block->GetMovement () == MOVEMENT_DOWN)
			{
				CBlockStone* sblock = (CBlockStone*)block;
				
				sblock->SetHeight (sblock->GetHeight () + 1);

				if (sblock->AddYOfs (MOVE_DOWN_STEP))
				{
					sblock->SetMovement (NOMOVEMENT);
					
					m_pMap->ChangeMapItem (CPoint (x, y + 1), sblock);
					m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
					
					if (y < MAP_HEIGHT - 2)
					{
						if ((m_pMap->GetMapItemIndirect (CPoint (x, y + 2)))->GetBlockType () != BLOCK_SPACE
							&& (m_pMap->GetMapItemIndirect (CPoint (x, y + 2)))->GetBlockType () != BLOCK_BOULDER
							&& (m_pMap->GetMapItemIndirect (CPoint (x, y + 2)))->GetBlockType () != BLOCK_MONSTER)
							{
								sblock->SetHeight (0);
								if (type == BLOCK_GOLD)
									//theApp.m_pSnd->PlaySound (WAVE_DROP);
									theApp.m_pSnd->Play (WAVE_DROP);
								else
									//theApp.m_pSnd->PlaySound (WAVE_STONEDROP);
									theApp.m_pSnd->Play (WAVE_STONEDROP);

							}
					}
					else
					{
						sblock->SetHeight (0);
						if (type == BLOCK_GOLD)
							//theApp.m_pSnd->PlaySound (WAVE_DROP);
							theApp.m_pSnd->Play (WAVE_DROP);
						else
							//theApp.m_pSnd->PlaySound (WAVE_STONEDROP);
							theApp.m_pSnd->Play (WAVE_STONEDROP);
					}
				}
			}
			else
			// If block droping right
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) 
				&& block->GetMovement () == MOVEMENT_DROP_RIGHT)
			{

				if (block->AddXOfs (MOVE_RIGHT_STEP))
				{
					block->SetMovement (MOVEMENT_DOWN);
					m_pMap->ChangeMapItem (CPoint (x + 1, y), block);
					m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
				}
			}
			else
			// If block droping left
			if ((type == BLOCK_GOLD || type == BLOCK_STONE) 
				&& block->GetMovement () == MOVEMENT_DROP_LEFT)
			{

				if (block->SubXOfs (MOVE_LEFT_STEP))
				{
					block->SetMovement (MOVEMENT_DOWN);
					m_pMap->ChangeMapItem (CPoint (x - 1, y), block);
					m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
				}
			}
			else
			// If block moving right on group
			if ((type == BLOCK_GOLD || type == BLOCK_STONE || type == BLOCK_BOULDER) 
				&& block->GetMovement () == MOVEMENT_RIGHT_ONGROUP)
			{
				if (block->AddXOfs (MOVE_RIGHT_STEP))
				{
					// Calculate how much blocks moving with current block
					for (int i = 0; i < MAP_WIDTH; i++)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x + i, y));

						if (block->GetAbstractType () != ABSTRACT_DINAMIC)
							break;
						else
							if (block->GetMovement () != MOVEMENT_RIGHT_ONGROUP)
								break;
					}
					
					// Moving all blocks in group
					for (int n = i; n > 0; n--)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x + n - 1, y));

						if (block->GetBlockType () == BLOCK_BOULDER)						
							m_ptBoulderPos.x++;
					
						block->SetMovement (NOMOVEMENT);
						block->EnableTail (TRUE);
						
						if (block->GetBlockType () != BLOCK_BOULDER)
							block->AddXOfs (MOVE_RIGHT_STEP);
						
						if (n == i)
							m_pMap->ChangeMapItem (CPoint (x + n, y), block);
						else
							m_pMap->ChangeMapPointer (CPoint (x + n, y), block);
					}
					
					m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
				}
			}
			else
			// If block moving left on group
			if ((type == BLOCK_GOLD || type == BLOCK_STONE || type == BLOCK_BOULDER) 
				&& block->GetMovement () == MOVEMENT_LEFT_ONGROUP)
			{

				if (block->SubXOfs (MOVE_LEFT_STEP))
				{
					// Calculate how much blocks moving with current block
					for (int i = 0; i < MAP_WIDTH - x; i++)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x + i, y));

						if (block->GetAbstractType () != ABSTRACT_DINAMIC)
							break;
						else
							if (block->GetMovement () != MOVEMENT_LEFT_ONGROUP)
								break;
					}

					// Moving all blocks in group
					for (int n = 0; n < i; n++)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x + n, y));

						if (block->GetBlockType () == BLOCK_BOULDER)						
							m_ptBoulderPos.x--;
					
						block->SetMovement (NOMOVEMENT);
						block->EnableTail (TRUE);
						
						if (n)
							block->SubXOfs (MOVE_LEFT_STEP);
						
						if (!n)
							m_pMap->ChangeMapItem (CPoint (x + n - 1, y), block);
						else
							m_pMap->ChangeMapPointer (CPoint (x + n - 1, y), block);
					}
					
					m_pMap->ChangeMapPointer (CPoint (x + i - 1, y), BLOCK_SPACE);
				}
			}
			else
			// If block moving up on group
			if ((type == BLOCK_GOLD || type == BLOCK_STONE || type == BLOCK_BOULDER) 
				&& block->GetMovement () == MOVEMENT_UP_ONGROUP)
			{

				if (block->SubYOfs (MOVE_UP_STEP))
				{
					// Calculate how much blocks moving with current block
					for (int i = 0; i < MAP_HEIGHT - y; i++)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x, y + i));

						if (block->GetAbstractType () != ABSTRACT_DINAMIC)
							break;
						else
							if (block->GetMovement () != MOVEMENT_UP_ONGROUP)
								break;
					}

					// Moving all blocks in group
					for (int n = 0; n < i; n++)
					{
						block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x, y + n));

						if (block->GetBlockType () == BLOCK_BOULDER)						
							m_ptBoulderPos.y--;
					
						block->SetMovement (NOMOVEMENT);
						block->EnableTail (TRUE);
						
						if (n)
							block->SubYOfs (MOVE_UP_STEP);
						
						if (!n)
							m_pMap->ChangeMapItem (CPoint (x, y + n - 1), block);
						else
							m_pMap->ChangeMapPointer (CPoint (x, y + n - 1), block);
					}
					
					m_pMap->ChangeMapPointer (CPoint (x, y + i - 1), BLOCK_SPACE);
				}
			}
			
		}
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::MoveBoulder (int key, BOOL allUnpressed)
{
	if (m_pBoulder && (m_pBoulder->GetMovement () == NOMOVEMENT
		||m_pBoulder->GetMovement () == BETWEEN_MOVEMENT))
	{
		if (allUnpressed)
		{
			// Show boulder face, if no movement and no keys pressed
			m_pBoulder->SetMovement (NOMOVEMENT);
		}

		switch (key)
		{
		// Compare for moving right
		case VK_RIGHT:
			if (m_ptBoulderPos.x < MAP_WIDTH - 1)
			{
				switch (CheckForEat (CPoint (m_ptBoulderPos.x + 1, m_ptBoulderPos.y)))
				{
				case BLOCK_SPACE:
					m_pBoulder->SetMovement (VK_RIGHT);
					break;
				case BLOCK_GROUND:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x + 1, m_ptBoulderPos.y), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_RIGHT);
					break;
				case BLOCK_GOLD:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x + 1, m_ptBoulderPos.y), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_RIGHT);
					theApp.m_pSnd->Play (WAVE_DROP);
					m_nGold++;
					break;
				case BLOCK_STONE:
					ShiftStonesRight (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y));
					break;
				}
			}

		break;

		// Compare for moving left
		case VK_LEFT:
			if (m_ptBoulderPos.x > 0)
			{
				switch (CheckForEat (CPoint (m_ptBoulderPos.x - 1, m_ptBoulderPos.y)))
				{
				case BLOCK_SPACE:
					m_pBoulder->SetMovement (VK_LEFT);
					break;
				case BLOCK_GROUND:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x - 1, m_ptBoulderPos.y), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_LEFT);
					break;
				case BLOCK_GOLD:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x - 1, m_ptBoulderPos.y), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_LEFT);
					theApp.m_pSnd->Play (WAVE_DROP);
					m_nGold++;
					break;
				case BLOCK_STONE:
					ShiftStonesLeft (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y));
					break;
				}
			}
		break;

		// Compare for moving Down
		case VK_DOWN:
			if (m_ptBoulderPos.y < MAP_HEIGHT - 1)
			{
				switch (CheckForEat (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y + 1)))
				{
				case BLOCK_SPACE:
					m_pBoulder->SetMovement (VK_DOWN);
					break;
				case BLOCK_GROUND:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y + 1), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_DOWN);
					break;
				case BLOCK_GOLD:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y + 1), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_DOWN);
					theApp.m_pSnd->Play (WAVE_DROP);
					m_nGold++;
					break;
				}
			}
		break;
		// Compare for moving Up
		case VK_UP:
			if (m_ptBoulderPos.y > 0)
			{
				switch (CheckForEat (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1)))
				{
				case BLOCK_SPACE:
					m_pBoulder->SetMovement (VK_UP);
					break;
				case BLOCK_GROUND:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_UP);
					break;
				case BLOCK_GOLD:
					m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1), BLOCK_SPACE);
					m_pBoulder->SetMovement (VK_UP);
					theApp.m_pSnd->Play (WAVE_DROP);
					m_nGold++;
					break;
				case BLOCK_STONE:
					ShiftStonesUp (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y));
					break;
				}
			}
		break;

		}
	}

	ShiftBoulder ();
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::ShiftBoulder ()
{
	if (m_pBoulder)
	{
		switch (m_pBoulder->GetMovement ())
		{
		case VK_RIGHT:
			if (m_pBoulder->AddXOfs (MOVE_RIGHT_STEP))
			{
				m_pBoulder->SetMovement (BETWEEN_MOVEMENT);
				m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x + 1, m_ptBoulderPos.y), m_pBoulder);
				m_pMap->ChangeMapPointer (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y), BLOCK_SPACE);
				m_ptBoulderPos.x++;
			}
		break;

		case VK_LEFT:
			if (m_pBoulder->SubXOfs (MOVE_LEFT_STEP))
			{
				m_pBoulder->SetMovement (BETWEEN_MOVEMENT);
				m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x - 1, m_ptBoulderPos.y), m_pBoulder);
				m_pMap->ChangeMapPointer (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y), BLOCK_SPACE);
				m_ptBoulderPos.x--;
			}
		break;

		case VK_DOWN:
			if (m_pBoulder->AddYOfs (MOVE_DOWN_STEP))
			{
				m_pBoulder->SetMovement (BETWEEN_MOVEMENT);
				m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y + 1), m_pBoulder);
				m_pMap->ChangeMapPointer (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y), BLOCK_SPACE);
				m_ptBoulderPos.y++;
			}
		break;

		case VK_UP:
			if (m_pBoulder->SubYOfs (MOVE_UP_STEP))
			{
				m_pBoulder->SetMovement (BETWEEN_MOVEMENT);
				m_pMap->ChangeMapItem (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1), m_pBoulder);
				m_pMap->ChangeMapPointer (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y), BLOCK_SPACE);
				m_ptBoulderPos.y--;
			}
		break;
		}
	}
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::InitBoulder ()
{
	m_pBoulder = (CBlockBoulder*)m_pMap->GetBoulder ();
	m_ptBoulderPos = m_pMap->GetBoulderPos ();
}

//////////////////////////////////////////////////////////////////////
CPoint CMapEngine::GetBoulderPos ()
{
	return m_ptBoulderPos;
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::KillBoulder ()
{
	m_pBoulder = NULL;
	m_ptBoulderPos = CPoint (-1, -1);
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::IsBoulderDied ()
{
	if (m_pBoulder)
		return FALSE;
	
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::MoveMonsters ()
{
	for (int y = 0; y < MAP_HEIGHT; y ++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			CBlockMonster* block = (CBlockMonster*)m_pMap->GetMapItemIndirect (CPoint (x, y));

			if (block->GetBlockType () == BLOCK_MONSTER)
				if (block->GetMovement () == NOMOVEMENT)
				{
					int movement = NOMOVEMENT, oldmovement = block->GetOldMovement ();
					
					if (TranslateMovementToAxis (oldmovement) == AXISX || oldmovement == NOMOVEMENT)
					{
						block->EnableInverceByYAxis (FALSE);

						if (oldmovement == NOMOVEMENT)
						{
							block->EnableInverceByXAxis (FALSE);
							oldmovement = FindMonsterMovement (AXISX, CPoint (x, y));
						}
						
						movement = FindMonsterMovement (AXISY, CPoint (x, y));

						if (CanMonsterMove (movement, CPoint (x, y)))
							block->SetMovement (movement);
						else
						if (CanMonsterMove (oldmovement, CPoint (x, y)))
						{
							movement = oldmovement;
							block->SetMovement (movement);
						}
						else
						{
							block->EnableInverceByYAxis (TRUE);

							movement = FindMonsterMovement (AXISY, CPoint (x, y));
							
							if (CanMonsterMove (movement, CPoint (x, y)))
								block->SetMovement (movement);
							else
							{
								block->EnableInverceByXAxis (TRUE);

								movement = FindMonsterMovement (AXISX, CPoint (x, y));
							
								if (CanMonsterMove (movement, CPoint (x, y)))
									block->SetMovement (movement);
								else
								{
									movement = NOMOVEMENT;
									block->SetMovement (movement);
								}


							}
						}
					}

					//block->SetOldMovement (movement);

					if (TranslateMovementToAxis (oldmovement) == AXISY || oldmovement == NOMOVEMENT)
					{
						block->EnableInverceByXAxis (FALSE);

						if (oldmovement == NOMOVEMENT)
						{
							block->EnableInverceByYAxis (FALSE);
							oldmovement = FindMonsterMovement (AXISY, CPoint (x, y));
						}
						
						movement = FindMonsterMovement (AXISX, CPoint (x, y));

						if (CanMonsterMove (movement, CPoint (x, y)))
							block->SetMovement (movement);
						else
						if (CanMonsterMove (oldmovement, CPoint (x, y)))
						{
							movement = oldmovement;
							block->SetMovement (movement);
						}
						else
						{
							block->EnableInverceByXAxis (TRUE);

							movement = FindMonsterMovement (AXISX, CPoint (x, y));
							
							if (CanMonsterMove (movement, CPoint (x, y)))
								block->SetMovement (movement);
							else
							{
								block->EnableInverceByYAxis (TRUE);

								movement = FindMonsterMovement (AXISY, CPoint (x, y));
							
								if (CanMonsterMove (movement, CPoint (x, y)))
									block->SetMovement (movement);
								else
								{
									movement = NOMOVEMENT;
									block->SetMovement (movement);
								}


							}
						}
					}	

					block->SetOldMovement (movement);
				}
		}

	ShiftMonsters ();
}

//////////////////////////////////////////////////////////////////////
int CMapEngine::FindMonsterMovement (int axis, CPoint ptPos)
{
	BOOL inverce = axis == AXISX
		?((CBlockMonster*)m_pMap->GetMapItem (ptPos))->IsInverceByXAxis ()
		:((CBlockMonster*)m_pMap->GetMapItem (ptPos))->IsInverceByYAxis ();

	switch (axis)
	{
	case AXISX:
		if (m_ptBoulderPos.x - ptPos.x > 0)
			if (!inverce)
				return MOVEMENT_RIGHT;
			else
				return MOVEMENT_LEFT;
			
		if (m_ptBoulderPos.x - ptPos.x < 0)
			if (!inverce)
				return MOVEMENT_LEFT;
			else
				return MOVEMENT_RIGHT;

		if (rand () % 2)
			return MOVEMENT_RIGHT;
		else
			return MOVEMENT_LEFT;

	case AXISY:
		if (m_ptBoulderPos.y - ptPos.y > 0)
			if (!inverce)
				return MOVEMENT_DOWN;
			else
				return MOVEMENT_UP;
		
		if (m_ptBoulderPos.y - ptPos.y < 0)
			if (!inverce)
				return MOVEMENT_UP;
			else
				return MOVEMENT_DOWN;

		if (rand () % 2)
			return MOVEMENT_DOWN;
		else
			return MOVEMENT_UP;
		

		return NOMOVEMENT;
	}
	ASSERT (FALSE);
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::CanMonsterMove (int movement, CPoint ptPos)
{
	switch (movement)
	{
	case MOVEMENT_RIGHT:
		if (ptPos.x >= MAP_WIDTH - 1)
			return FALSE;

		if (m_pMap->GetMapItem (CPoint (ptPos.x + 1, ptPos.y))->GetBlockType () == BLOCK_SPACE)
			return TRUE;
		break;
	case MOVEMENT_LEFT:
		if (ptPos.x <= 0)
			return FALSE;

		if (m_pMap->GetMapItem (CPoint (ptPos.x - 1, ptPos.y))->GetBlockType () == BLOCK_SPACE)
			return TRUE;
		break;
	case MOVEMENT_DOWN:
		if (ptPos.y >= MAP_HEIGHT - 1)
			return FALSE;

		if (m_pMap->GetMapItem (CPoint (ptPos.x, ptPos.y + 1))->GetBlockType () == BLOCK_SPACE)
			return TRUE;
		break;
	case MOVEMENT_UP:
		if (ptPos.y <= 0)
			return FALSE;

		if (m_pMap->GetMapItem (CPoint (ptPos.x, ptPos.y - 1))->GetBlockType () == BLOCK_SPACE)
			return TRUE;
		break;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::IsBlockHasZerroOffset (CPoint ptPos, int type)
{
	if (ptPos.x >= 0 && ptPos.x < MAP_WIDTH && ptPos.y >=0 && ptPos.y < MAP_HEIGHT - 1)
		if (m_pMap->GetMapItem (ptPos)->GetBlockType () == type)
		{
			int movement = ((CBlockDinamic*)m_pMap->GetMapItem (ptPos))->GetMovement ();

			if (movement == NOMOVEMENT || movement == BETWEEN_MOVEMENT)
				return TRUE;
		}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
int CMapEngine::TranslateMovementToAxis (int movement)
{
	switch (movement)
	{
	case NOMOVEMENT:
		return -1;
	case MOVEMENT_RIGHT:
	case MOVEMENT_LEFT:
		return AXISX;
	case MOVEMENT_DOWN:
	case MOVEMENT_UP:
		return AXISY;
	}
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::ShiftMonsters ()
{
	for (int y = 0; y < MAP_HEIGHT; y ++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			CBlockMonster* block = (CBlockMonster*)m_pMap->GetMapItemIndirect (CPoint (x, y));
			
			if (block->GetBlockType () == BLOCK_MONSTER)
			{
				switch (block->GetMovement ())
				{
				case MOVEMENT_RIGHT:
					if (block->AddXOfs (MOVE_RIGHT_STEP))
					{
						block->SetMovement (NOMOVEMENT);
						m_pMap->ChangeMapItem (CPoint (x + 1, y), block);
						m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
					}
				break;

				case MOVEMENT_LEFT:
					if (block->SubXOfs (MOVE_LEFT_STEP))
					{
						block->SetMovement (NOMOVEMENT);
						m_pMap->ChangeMapItem (CPoint (x - 1, y), block);
						m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
					}
				break;

				case MOVEMENT_DOWN:
					if (block->AddYOfs (MOVE_DOWN_STEP))
					{
						block->SetMovement (NOMOVEMENT);
						m_pMap->ChangeMapItem (CPoint (x, y + 1), block);
						m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
					}
				break;

				case MOVEMENT_UP:
					if (block->SubYOfs (MOVE_UP_STEP))
					{
						block->SetMovement (NOMOVEMENT);
						m_pMap->ChangeMapItem (CPoint (x, y - 1), block);
						m_pMap->ChangeMapPointer (CPoint (x, y), BLOCK_SPACE);
					}
				break;

				case NOMOVEMENT:
				break;

				default:
					ASSERT (FALSE);
				}
			}
		}
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::IncreaseState ()
{
	for (int y = 0; y < MAP_HEIGHT; y ++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			int type = (m_pMap->GetMapItemIndirect (CPoint (x, y)))->GetAbstractType ();
			if (type == ABSTRACT_DINAMIC || type == ABSTRACT_STATIC)
				((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x, y)))->IncreaseState ();
		}
}

//////////////////////////////////////////////////////////////////////
int CMapEngine::DoExplosion (CPoint ptPos)
{
	int nMon = 0;
	
	int xbeg = ptPos.x - 1;
	int xend = ptPos.x + 1;
	int ybeg = ptPos.y - 1;
	int	yend = ptPos.y + 1;

	for (int y = max (0, ybeg); y <= min (MAP_HEIGHT - 1, yend); y++)
		for (int x = max (0, xbeg); x <= min (MAP_WIDTH - 1, xend); x++)
		{	
			if (m_pMap->GetMapItem (CPoint (x, y))->GetAbstractType () == ABSTRACT_DINAMIC)
			{
				if (m_pMap->GetMapItem (CPoint (x, y))->GetBlockType () == BLOCK_BOULDER)
					KillBoulder ();		
				
				nMon++;
			}

			m_pMap->ChangeMapItem (m_pMap->GetMapItem (CPoint (x, y)), BLOCK_SPACE);
			m_pMap->ChangeMapItem (m_pMap->GetMapItemIndirect (CPoint (x, y)), BLOCK_EXPLOSION);
		}

	xbeg--; xend++; ybeg--; yend++;

	for (y = max (0, ybeg); y <= min (MAP_HEIGHT - 1, yend); y++)
		for (int x = max (0, xbeg); x <= min (MAP_WIDTH - 1, xend); x++)
			m_pMap->GetMapItem (CPoint (x, y))->SetRedrawFlag (TRUE);

	//theApp.m_pSnd->PlaySound (WAVE_EXPLOSION);
	theApp.m_pSnd->Play (WAVE_EXPLOSION);

	return nMon;
}

//////////////////////////////////////////////////////////////////////
void CMapEngine::ClearOldExplosion (int type)
{
	for (int y = 0; y < MAP_HEIGHT; y ++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			if ((m_pMap->GetMapItemIndirect (CPoint (x, y)))->GetBlockType () == BLOCK_EXPLOSION)
				if (((CBlockStatic*)m_pMap->GetMapItemIndirect (CPoint (x, y)))->GetState () == 10)
				{
					m_pMap->ChangeMapItem (CPoint (x, y), type);
					m_pMap->GetMapItem (CPoint (x, y))->SetRedrawFlag (TRUE);
				}
		}
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::CheckForBoulderExplosion ()
{
	if (m_pBoulder)
	{
		if (m_ptBoulderPos.y > 0)
		{
			CBlockDinamic* block = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1));
			int type = block->GetBlockType ();

			if ((type == BLOCK_GOLD || type == BLOCK_STONE) 
				&& ((CBlockStone*)block)->GetHeight ())
			{
				DoExplosion (m_ptBoulderPos);
				KillBoulder ();
				return TRUE;
			}
		}

		if (
			IsBlockHasZerroOffset (CPoint (m_ptBoulderPos.x + 1, m_ptBoulderPos.y), BLOCK_MONSTER)
		  ||IsBlockHasZerroOffset (CPoint (m_ptBoulderPos.x - 1, m_ptBoulderPos.y), BLOCK_MONSTER)
		  ||IsBlockHasZerroOffset (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y + 1), BLOCK_MONSTER)
		  ||IsBlockHasZerroOffset (CPoint (m_ptBoulderPos.x, m_ptBoulderPos.y - 1), BLOCK_MONSTER))
		{
			DoExplosion (m_ptBoulderPos);
			KillBoulder ();
			return TRUE;
		}
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
int CMapEngine::CheckForEat (CPoint ptPos)
{
	switch ((m_pMap->GetMapItem (ptPos))->GetBlockType ())
	{
	case BLOCK_SPACE:
		return BLOCK_SPACE;
	case BLOCK_GROUND:
		return BLOCK_GROUND;
	case BLOCK_GOLD:
		{
			int movement = ((CBlockDinamic*)m_pMap->GetMapItem (ptPos))->GetMovement ();

			if (movement == NOMOVEMENT || movement == BETWEEN_MOVEMENT)
				return BLOCK_GOLD;
		}
	break;
	case BLOCK_STONE:
		{
			int movement = ((CBlockDinamic*)m_pMap->GetMapItem (ptPos))->GetMovement ();

			if (movement == NOMOVEMENT || movement == BETWEEN_MOVEMENT)
				return BLOCK_STONE;
		}
	break;
	}

	return BLOCK_NULL;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::CheckForMonstersExplosion ()
{
	BOOL bExplosion = FALSE;
	
	for (int y = 0; y < MAP_HEIGHT; y ++)
		for (int x = 0; x < MAP_WIDTH; x++)
		{
			CBlockDinamic* block = (CBlockDinamic*)m_pMap->GetMapItem (CPoint (x, y));

			if (block->GetBlockType () == BLOCK_MONSTER)
			{
				if (y > 0)
				{
					CBlockDinamic* sblock = (CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (x, y - 1));
					int type = sblock->GetBlockType ();

					if ((type == BLOCK_GOLD || type == BLOCK_STONE) 
						&& ((CBlockStone*)sblock)->GetHeight ())
					{
						DoExplosion (CPoint (x, y));
						bExplosion = TRUE;
					}
				}
			}
		}

	return bExplosion;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::CheckForLevelComplete ()
{
	if (!m_pMap->GetGoldNumber () && !m_pMap->GetExplosionsNumper ())
		return TRUE;

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::ShiftStonesRight (CPoint ptPos)
{
	for (int i = 1; i < MAP_WIDTH; i++)
	{
		int type = (m_pMap->GetMapItem (CPoint (ptPos.x + i, ptPos.y)))->GetBlockType ();

		if (type != BLOCK_GOLD && type != BLOCK_STONE)
		{
			if (type != BLOCK_SPACE)
				return FALSE;
			else
			{
				for (int n = i - 1; n >= 0; n--)
				{
					((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x + n, ptPos.y)))->SetMovement (MOVEMENT_RIGHT_ONGROUP);
					if (((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x + n, ptPos.y)))->GetBlockType () != BLOCK_BOULDER)
						((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x + n, ptPos.y)))->EnableTail (FALSE);
				}

				return TRUE;
			}
			ASSERT (FALSE);
		}

		int movement = ((CBlockDinamic*)(m_pMap->GetMapItem (CPoint (ptPos.x + i, ptPos.y))))->GetMovement ();

		if (movement != NOMOVEMENT || ptPos.x + i >= MAP_WIDTH - 1)
			return FALSE;
	}

	 return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::ShiftStonesLeft (CPoint ptPos)
{
	for (int i = 1; i < MAP_WIDTH; i++)
	{
		int type = (m_pMap->GetMapItem (CPoint (ptPos.x - i, ptPos.y)))->GetBlockType ();

		if (type != BLOCK_GOLD && type != BLOCK_STONE)
		{
			if (type != BLOCK_SPACE)
				return FALSE;
			else
			{
				for (int n = i - 1; n >= 0; n--)
				{
					((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x - n, ptPos.y)))->SetMovement (MOVEMENT_LEFT_ONGROUP);
					if (((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x - n, ptPos.y)))->GetBlockType () != BLOCK_BOULDER)
						((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x - n, ptPos.y)))->EnableTail (FALSE);
				}
				
				return TRUE;
			}
			ASSERT (FALSE);
		}

		int movement = ((CBlockDinamic*)(m_pMap->GetMapItem (CPoint (ptPos.x - i, ptPos.y))))->GetMovement ();

		if (movement != NOMOVEMENT || ptPos.x - i <= 0)
			return FALSE;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CMapEngine::ShiftStonesUp (CPoint ptPos)
{
	for (int i = 1; i < MAP_HEIGHT; i++)
	{
		int type = (m_pMap->GetMapItem (CPoint (ptPos.x, ptPos.y - i)))->GetBlockType ();

		if (type != BLOCK_GOLD && type != BLOCK_STONE)
		{
			if (type != BLOCK_SPACE)
				return FALSE;
			else
			{
				for (int n = i - 1; n >= 0; n--)
				{
					((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x, ptPos.y - n)))->SetMovement (MOVEMENT_UP_ONGROUP);
					if (((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x, ptPos.y - n)))->GetBlockType () != BLOCK_BOULDER)
						((CBlockDinamic*)m_pMap->GetMapItemIndirect (CPoint (ptPos.x, ptPos.y - n)))->EnableTail (FALSE);
				}
				
				return TRUE;
			}
			ASSERT (FALSE);
		}

		int movement = ((CBlockDinamic*)(m_pMap->GetMapItem (CPoint (ptPos.x, ptPos.y - i))))->GetMovement ();

		if (movement != NOMOVEMENT || ptPos.y - i <= 0)
			return FALSE;
	}

	return FALSE;
}