// ScoreTable.cpp : implementation file
//

#include "stdafx.h"
#include "boulder.h"
#include "ScoreTable.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CBoulderApp theApp; 

/////////////////////////////////////////////////////////////////////////////
// CScoreTable

CScoreTable::CScoreTable()
{
	m_pBmBack = NULL;

	m_pMap = NULL;
	m_pEngine = NULL;

	m_txt.EnableBorder (TRUE);
}

CScoreTable::~CScoreTable()
{
	delete m_pEngine;
	delete m_pMap;

	delete m_pBmBack;
}


BEGIN_MESSAGE_MAP(CScoreTable, CListCtrl)
	//{{AFX_MSG_MAP(CScoreTable)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_WM_SHOWWINDOW()
	ON_WM_DESTROY()
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScoreTable message handlers

int CScoreTable::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CListCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_pMap = new CBoulderMap (0, BLOCK_SPACE);
	m_pEngine = new CMapEngine (m_pMap);

	for (int y = 1; y < MAP_HEIGHT - 1; y++)
		for (int x = 0; x < MAP_WIDTH; x+= MAP_WIDTH / 5)
		{
			if (y&1)
				m_pMap->ChangeMapItem (CPoint (x, y), BLOCK_MONSTER1);
			else
				m_pMap->ChangeMapItem (CPoint (x, y), BLOCK_MONSTER2);
		}

	m_pEngine->SetBoulderPos (CPoint (0, 0));
	
	CBitmap bm;
	bm.LoadBitmap (IDB_STATUS);
	m_imgList.Create(BLOCK_WIDTH, BLOCK_HEIGHT, ILC_COLORDDB, STATUS_SPRITES_NUM, STATUS_SPRITES_NUM);
	m_imgList.Add(&bm, RGB (0, 0, 0));
	SetImageList (&m_imgList, LVSIL_SMALL);
	
	// Inser header to score table
	CString strColumnName;
	LVCOLUMN lvc;
	lvc.mask = LVCF_TEXT|LVCF_WIDTH;
	lvc.cx = 10;
	
	strColumnName.LoadString (IDS_COLUMN_0);
	lvc.pszText = (LPSTR)(LPCSTR)strColumnName;
	InsertColumn (0, &lvc);
	
	strColumnName.LoadString (IDS_COLUMN_1);
	lvc.pszText = (LPSTR)(LPCSTR)strColumnName;
	InsertColumn (1, &lvc);

	strColumnName.LoadString (IDS_COLUMN_2);
	lvc.pszText = (LPSTR)(LPCSTR)strColumnName;
	InsertColumn (2, &lvc);

	strColumnName.LoadString (IDS_COLUMN_3);
	lvc.pszText = (LPSTR)(LPCSTR)strColumnName;
	InsertColumn (3, &lvc);

	strColumnName.LoadString (IDS_COLUMN_4);
	lvc.pszText = (LPSTR)(LPCSTR)strColumnName;
	InsertColumn (4, &lvc);
	
	InitPlayerList ();

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::OnDestroy() 
{
	SavePlayerList ();
	
	CListCtrl::OnDestroy();
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::InitPlayerList ()
{
	CFile file;
	CFileStatus status;

	CString	strFileName;
	strFileName.LoadString (IDS_SCORE_FILE_NAME);
	
	if (!file.GetStatus (theApp.m_strCurrentPath + strFileName, status))
	{
		for (int i = 0; i < PLAYERS_IN_SCORETABLE; i++)
		{
			CString str;
			str.LoadString (IDS_EMPTY_PLAYER_NAME);
			InsertItem (i, str, 0);
			SetItemData (i, 0);
		}

		SavePlayerList ();
		DeleteAllItems ();
	}
	
	file.Open (theApp.m_strCurrentPath + strFileName, CFile::modeRead);
	CArchive ar(&file, CArchive::load);

	CPlayer player;
	for (int i = 0; i < PLAYERS_IN_SCORETABLE; i++)
	{
		player.Serialize (ar);
		InsertItem (i, player.m_strPlayerName, player.m_playerStatus);
		int data = player.m_nTotalScore | (player.m_nLevelsComplete << 16); 
		SetItemData (i, data);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::SavePlayerList ()
{
	CFile file;
	
	CString	strFileName;
	strFileName.LoadString (IDS_SCORE_FILE_NAME);
	
	file.Open (theApp.m_strCurrentPath + strFileName, CFile::modeCreate|CFile::modeWrite);
	CArchive ar(&file, CArchive::store);

	CPlayer player;
	for (int i = 0; i < PLAYERS_IN_SCORETABLE; i++)
	{
		player.m_strPlayerName = GetItemText (i, 0);
		player.m_playerStatus = 0;
		player.m_nTotalScore = LOWORD (GetItemData (i));
		player.m_nLevelsComplete = HIWORD (GetItemData (i));
		player.m_nCurLevelNum = 0;
		player.m_nLives = 0;
		player.Serialize (ar);
	}
}

/////////////////////////////////////////////////////////////////////////////
BOOL CScoreTable::OnEraseBkgnd(CDC* pDC) 
{
	CRect rc;
	GetClientRect (&rc);

	CDC memDC;
	memDC.CreateCompatibleDC (pDC);
	CBitmap* bmOld = memDC.SelectObject (m_pBmBack);
	memDC.FillSolidRect (0, 0, rc.Width (), rc.Height (), RGB (0, 0, 0));
	memDC.SelectObject (bmOld);

	return TRUE;
	//return CListCtrl::OnEraseBkgnd(pDC);
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::OnSize(UINT nType, int cx, int cy) 
{
	if (m_pBmBack)
		delete m_pBmBack;

	CClientDC clntDC (this);
	CDC memDC;
	memDC.CreateCompatibleDC (&clntDC);

	m_pBmBack = new CBitmap;
	m_pBmBack->CreateCompatibleBitmap (&clntDC, cx, cy);

	CBitmap* bmOld = memDC.SelectObject (m_pBmBack);
	memDC.FillSolidRect (0, 0, cx, cy, RGB (0, 0, 0));
	memDC.SelectObject (bmOld);
	
	// Set columnt widths
	SetColumnWidth (0, 48);
	SetColumnWidth (1, 48);
	SetColumnWidth (2, (cx - 48 - 48 - 96) / 2);
	SetColumnWidth (3, (cx - 48 - 48 - 96) / 2);
	SetColumnWidth (4, (cx - 2 * (cx - 48 - 48) / 2));

	//CListCtrl::OnSize(nType, cx, cy);
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CListCtrl::OnShowWindow(bShow, nStatus);
	
	if (bShow)
	{
		GetHeaderCtrl ()->EnableWindow (FALSE);
		SetTimer (0, SCORETABLE_TIMER_DELAY, NULL);
	}
	else
		KillTimer (0);
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	int id = lpDrawItemStruct->itemID;

	int beg = GetTopIndex ();
	int end = GetCountPerPage ();
	
	if (id >= beg && id <= beg + end)
	{
		CDC DC, memDC;
		DC.Attach (lpDrawItemStruct->hDC);
		
		memDC.CreateCompatibleDC (&DC);
		CBitmap* bmOld = memDC.SelectObject (m_pBmBack);
		
		if (id == beg)
		{
			memDC.SetWindowOrg (0, 17);
			theApp.SetMonoFlag (TRUE);
			m_pMap->DrawMap (&memDC, FALSE);
			theApp.SetMonoFlag (FALSE);
			memDC.SetWindowOrg (0, 0);
		}
		
		CRect rcClient, rc;
		rcClient = lpDrawItemStruct->rcItem;
		rc = rcClient;
		
		CString str;
		
		//Draw "Number" column of score table
		str.Format ("%i.", id + 1);
		int cw0 = GetColumnWidth (0);
		rc.right = rc.left + cw0;
			
		m_txt.SetTextColor (RGB (255, 255, 255));
		m_txt.DrawText (&memDC, str, rc, DT_CENTER);
		
		//Draw "Status" column of score table
		int cw1 = GetColumnWidth (1);
		if (LOWORD (GetItemData (id)))
			m_imgList.Draw (&memDC, ReturnStatus (LOWORD (GetItemData (id))), CPoint (rc.left + cw0, rc.top), ILD_NORMAL);

		//Draw "Name" column of score table
		int cw2 = GetColumnWidth (2);
		rc.left = cw0 + cw1;
		rc.right= rc.left + cw2;

		m_txt.SetTextColor (RGB (255, 255, id * 255 / PLAYERS_IN_SCORETABLE));
		m_txt.DrawText (&memDC, GetItemText (id, 0), rc, DT_LEFT);

		//Draw "Score" column of score table
		int cw3 = GetColumnWidth (3);
		rc.left = rc.left + cw2;
		rc.right= rc.left + cw3;

		str.Format ("%07i", LOWORD (GetItemData (id)));
		m_txt.SetTextColor (RGB (id * 128 / PLAYERS_IN_SCORETABLE, 255 - id * 128 / PLAYERS_IN_SCORETABLE, id * 128 / PLAYERS_IN_SCORETABLE));
		m_txt.DrawText (&memDC, str, rc, DT_CENTER);

		//Draw "Levels" column of score table
		int cw4 = GetColumnWidth (4);
		rc.left = rc.left + cw3;
		rc.right= rc.left + cw4;

		str.Format ("%03i", HIWORD (GetItemData (id)));
		m_txt.SetTextColor (RGB (255, 255, 255));
		m_txt.DrawText (&memDC, str, rc, DT_CENTER);

		//Draw list control background
		DC.BitBlt (rcClient.left, rcClient.top, rcClient.Width (), rcClient.Height (), 
			&memDC, rcClient.left, rcClient.top, SRCCOPY);

		DC.Detach ();

		memDC.SelectObject (bmOld);
	}
}

/////////////////////////////////////////////////////////////////////////////
BOOL CScoreTable::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	/*
	static bFlag = FALSE;

	HD_NOTIFY	*pHDN = (HD_NOTIFY*)lParam;

	if(!bFlag && (pHDN->hdr.code == HDN_ITEMCHANGINGW || pHDN->hdr.code == HDN_ITEMCHANGINGA))
	{
		CRect rc;
		GetClientRect (&rc);
		bFlag = TRUE;
		SetColumnWidth (2, max (0, rc.Width () - GetColumnWidth (0) - GetColumnWidth (1)));
		bFlag = FALSE;
		
		
		CClientDC clntDC (this);
		CDC memDC;
		memDC.CreateCompatibleDC (&clntDC);
		CBitmap* bmOld = memDC.SelectObject (m_pBmBack);
		memDC.FillSolidRect (0, 0, rc.Width (), rc.Height (), RGB (0, 0, 0));
		memDC.SelectObject (bmOld);

		Invalidate ();
		UpdateWindow ();
		//return TRUE;
	}
	*/
	
	return CListCtrl::OnNotify(wParam, lParam, pResult);
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::OnTimer(UINT nIDEvent) 
{	
	static t = 0;
	m_pEngine->MoveMonsters ();
	m_pEngine->IncreaseState ();
	t++;

	if (t == 100)
	{
		m_pEngine->SetBoulderPos (CPoint (rand () % MAP_WIDTH, rand () % MAP_HEIGHT));
		t = 0;
	}

	Invalidate ();
	UpdateWindow ();
}

/////////////////////////////////////////////////////////////////////////////
int CALLBACK SortFunc(LPARAM lParam1, LPARAM lParam2, 
   LPARAM lParamSort)
{
	int score1 = LOWORD (lParam1);
	int score2 = LOWORD (lParam2);
	return score2 - score1;
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::AddPlayerToPlayerList (CPlayer &player)
{
	InsertItem (PLAYERS_IN_SCORETABLE, player.m_strPlayerName, player.m_playerStatus);
	int data = player.m_nTotalScore | (player.m_nLevelsComplete << 16); 
	SetItemData (PLAYERS_IN_SCORETABLE, data);

	SortItems (SortFunc, 0);
	DeleteItem (PLAYERS_IN_SCORETABLE);
}

/////////////////////////////////////////////////////////////////////////////
void CScoreTable::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	
	Invalidate ();
	UpdateWindow ();
	
	CListCtrl::OnVScroll(nSBCode, nPos, pScrollBar);
}

/////////////////////////////////////////////////////////////////////////////
int CScoreTable::ReturnStatus (int score)
{
	if (score < STATUS_APPLE_STUMP)
		return STATUS_SPRITES_NUM - 1;

	if (score < STATUS_APPLE)
		return STATUS_SPRITES_NUM - 2;

	if (score < STATUS_MONNY)
		return STATUS_SPRITES_NUM - 3;

	if (score < STATUS_WOOD)
		return STATUS_SPRITES_NUM - 4;

	if (score < STATUS_IRON)
		return STATUS_SPRITES_NUM - 5;

	if (score < STATUS_STONE)
		return STATUS_SPRITES_NUM - 6;

	if (score < STATUS_GOLD)
		return STATUS_SPRITES_NUM - 7;

	if (score < STATUS_RUBY)
		return STATUS_SPRITES_NUM - 8;

	if (score < STATUS_EMERALD)
		return STATUS_SPRITES_NUM - 9;

	return STATUS_SPRITES_NUM - 10;
}
