// Sound.cpp: implementation of the CSound class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Sound.h"
#include "DST.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

DEFINE_GUID(IID_IDirectSoundNotify, 0xb0210783, 0x89cd, 0x11d0, 0xaf, 0x8, 0x0, 0xa0, 0xc9, 0x25, 0xcd, 0x16);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSound::CSound()
{
	CDSTHResult hr;
	hr = DirectSoundCreate (0, &m_IDSound, 0);
	hr = m_IDSound->SetCooperativeLevel (AfxGetMainWnd ()->m_hWnd, DSSCL_PRIORITY);	
}

CSound::~CSound()
{
	POSITION pos;
	pos = m_listBuffers.GetHeadPosition ();
	while (pos)
	{
		SoundBuffer* pSoundBuffer = m_listBuffers.GetNext (pos);
		delete pSoundBuffer;
	}
}

//////////////////////////////////////////////////////////////////////
CSound::SoundBuffer* CSound::FindBuffer (int index)
{
	POSITION pos;
	pos = m_listBuffers.GetHeadPosition ();
	while (pos)
	{
		SoundBuffer* pSoundBuffer = m_listBuffers.GetNext (pos);
		if (pSoundBuffer->index == index)
			return pSoundBuffer;
	}

	return NULL;
}

//////////////////////////////////////////////////////////////////////
BOOL CSound::LoadWaveFromFile (LPCSTR pFileName, int index)
{
	CFile waveFile;
	if (!waveFile.Open (pFileName, CFile::modeRead))
		return TRUE;

	struct WaveHeader
	{
		long				riffTag;
		long				size;
		long				waveTag;
		long				fmtTag;
		long				fmtSize;
	} waveHeader;
	waveFile.Read (&waveHeader, sizeof (WaveHeader));

	if (waveHeader.riffTag != 0x46464952 || waveHeader.fmtTag != 0x20746d66)
		return TRUE;

	WAVEFORMATEX wfx;
	waveFile.Read (&wfx, waveHeader.fmtSize);
	wfx.cbSize = 0;

	if (wfx.wFormatTag != WAVE_FORMAT_PCM)
		return TRUE;

	struct DataHeader
	{
		long				dataTag;
		long				dataSize;
	} dataHeader;
	waveFile.Read (&dataHeader, sizeof (DataHeader));
	
	if (dataHeader.dataTag != 0x61746164)
		return TRUE;

	if (dataHeader.dataSize < DSBSIZE_MIN || dataHeader.dataSize > DSBSIZE_MAX)
		return TRUE;

	SoundBuffer* pSoundBuffer = new SoundBuffer;
	pSoundBuffer->bd.dwSize = sizeof (DSBUFFERDESC);
	pSoundBuffer->bd.dwFlags = DSBCAPS_CTRLPAN/*|DSBCAPS_CTRLVOLUME*/|DSBCAPS_CTRLFREQUENCY/*|DSBCAPS_CTRLPOSITIONNOTIFY*/;
	pSoundBuffer->bd.dwBufferBytes = dataHeader.dataSize;
	pSoundBuffer->bd.lpwfxFormat = &pSoundBuffer->wfx;
	pSoundBuffer->bd.dwReserved = 0;

	memcpy (&pSoundBuffer->wfx, &wfx, sizeof (WAVEFORMATEX));
	pSoundBuffer->strFileName = pFileName;
	pSoundBuffer->index = index;
	
	try
	{
		CDSTHResult hr;
		hr = m_IDSound->CreateSoundBuffer (&pSoundBuffer->bd, &pSoundBuffer->IBuffer, 0);
		//hr.CheckInterface (pSoundBuffer->INotify = pSoundBuffer->IBuffer);

		BYTE* pBuff;
		DWORD size;
		hr = pSoundBuffer->IBuffer->Lock (0, 0, (void**)&pBuff, &size, 0, 0, DSBLOCK_ENTIREBUFFER);
		waveFile.Read (pBuff, size);
		hr = pSoundBuffer->IBuffer->Unlock (pBuff, size, 0, 0);
	}
	catch (CDSTFailQueryInterfaceException error)
	{
		delete pSoundBuffer;
		return TRUE;
	}

	m_listBuffers.AddTail (pSoundBuffer);
	
	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CSound::Play (int index, int mode)
{
	SoundBuffer* pSoundBuffer;
	pSoundBuffer = FindBuffer (index);

	if (!pSoundBuffer)
		return TRUE;

	try
	{
		CDSTHResult hr;

		if (mode == ONCE)
			hr = pSoundBuffer->IBuffer->Play (0, 0, 0);
		else
			hr = pSoundBuffer->IBuffer->Play (0, 0, DSBPLAY_LOOPING);
	}
	catch (CDSTFailQueryInterfaceException error)
	{
		return TRUE;
	}

	return FALSE;
}