// BlockDinamic.cpp: implementation of the CBlockDinamic class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "boulder.h"
#include "BlockDinamic.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBoulderApp theApp;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBlockDinamic::CBlockDinamic()
{
	m_ptOfs.x = 0;
	m_ptOfs.y = 0;
	
	m_ptOfsOld.x = 0;
	m_ptOfsOld.y = 0;

	m_bEnableTail = TRUE;

	m_state = 0;
	m_movement = NOMOVEMENT;
}

CBlockDinamic::~CBlockDinamic()
{
}

//////////////////////////////////////////////////////////////////////
void CBlockDinamic::DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap)
{
	if (bDrawAllMap)
	{
		CPoint mapPos (ptPos.x * BLOCK_WIDTH, ptPos.y * BLOCK_HEIGHT);

		if (m_ptOfs.x > 0)
		{
			pDc->PatBlt (mapPos.x, mapPos.y, m_ptOfs.x, BLOCK_HEIGHT, BLACKNESS);
			pDc->PatBlt (mapPos.x + BLOCK_WIDTH + m_ptOfs.x, mapPos.y, BLOCK_WIDTH - m_ptOfs.x, BLOCK_HEIGHT, BLACKNESS); 
		}
		if (m_ptOfs.x < 0)
		{
			pDc->PatBlt (mapPos.x - BLOCK_WIDTH, mapPos.y, BLOCK_WIDTH + m_ptOfs.x, BLOCK_HEIGHT, BLACKNESS);
			pDc->PatBlt (mapPos.x + BLOCK_WIDTH + m_ptOfs.x , mapPos.y, -m_ptOfs.x, BLOCK_HEIGHT, BLACKNESS);
		}

		if (m_ptOfs.y > 0)
		{
			pDc->PatBlt (mapPos.x, mapPos.y, BLOCK_WIDTH, m_ptOfs.y, BLACKNESS);
			pDc->PatBlt (mapPos.x, mapPos.y + BLOCK_HEIGHT + m_ptOfs.y, BLOCK_WIDTH, BLOCK_HEIGHT - m_ptOfs.y, BLACKNESS);
		}
		if (m_ptOfs.y < 0)
		{
			pDc->PatBlt (mapPos.x, mapPos.y - BLOCK_HEIGHT, BLOCK_WIDTH, BLOCK_HEIGHT + m_ptOfs.y, BLACKNESS);
			pDc->PatBlt (mapPos.x, mapPos.y + BLOCK_HEIGHT + m_ptOfs.y, BLOCK_WIDTH, -m_ptOfs.y, BLACKNESS);
		}
	}

	DrawTail (pDc, ptPos, m_ptOfs, m_ptOfsOld);
}

//////////////////////////////////////////////////////////////////////
void CBlockDinamic::DrawTail (CDC* pDc, CPoint ptPos, CPoint ptOfs, CPoint ptOfsOld)
{
	if (m_bEnableTail)
	{
		CPoint mapPos (ptPos.x * BLOCK_WIDTH + m_ptOfs.x, ptPos.y * BLOCK_HEIGHT + m_ptOfs.y);

		if (m_ptOfsOld.x)
		{
			if (m_ptOfsOld.x > 0) 
				pDc->PatBlt (mapPos.x - m_ptOfsOld.x, mapPos.y - m_ptOfsOld.y, m_ptOfsOld.x, BLOCK_HEIGHT, BLACKNESS);
			else
				pDc->PatBlt (mapPos.x + BLOCK_WIDTH, mapPos.y - m_ptOfsOld.y, -m_ptOfsOld.x, BLOCK_HEIGHT, BLACKNESS);
		}

		if (m_ptOfsOld.y)
		{
			if (m_ptOfsOld.y > 0) 
				pDc->PatBlt (mapPos.x - m_ptOfsOld.x, mapPos.y - m_ptOfsOld.y, BLOCK_WIDTH, m_ptOfsOld.y, BLACKNESS);
			else
				pDc->PatBlt (mapPos.x - m_ptOfsOld.x, mapPos.y + BLOCK_HEIGHT, BLOCK_WIDTH, -m_ptOfsOld.y, BLACKNESS);
		}

		m_ptOfsOld.x = 0;
		m_ptOfsOld.y = 0;
	}
}

//////////////////////////////////////////////////////////////////////
void CBlockDinamic::ClearBlock (CDC* pDc, CPoint ptPos)
{
	theApp.DrawSprite (pDc, 0, ptPos, m_ptOfs);
}

//////////////////////////////////////////////////////////////////////
void CBlockDinamic::EnableTail (BOOL bTail)
{
	m_bEnableTail = bTail;

	//m_ptOfsOld.x = 0;
	//m_ptOfsOld.y = 0;
}

//////////////////////////////////////////////////////////////////////
BOOL CBlockDinamic::AddXOfs (int add)
{
	m_ptOfsOld.x = m_ptOfs.x;
	m_ptOfs.x += add;
	m_ptOfsOld.x = m_ptOfs.x - m_ptOfsOld.x;
	
	if (m_ptOfs.x == BLOCK_WIDTH) 
	{
		m_ptOfs.x -= BLOCK_WIDTH;
		return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CBlockDinamic::SubXOfs (int sub)
{
	m_ptOfsOld.x = m_ptOfs.x;
	m_ptOfs.x -= sub;
	m_ptOfsOld.x = m_ptOfs.x - m_ptOfsOld.x;
	
	if (m_ptOfs.x == -BLOCK_WIDTH) 
	{
		m_ptOfs.x += BLOCK_WIDTH;
		return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CBlockDinamic::AddYOfs (int add)
{
	m_ptOfsOld.y = m_ptOfs.y;
	m_ptOfs.y += add;
	m_ptOfsOld.y = m_ptOfs.y - m_ptOfsOld.y;

	if (m_ptOfs.y == BLOCK_HEIGHT) 
	{
		m_ptOfs.y -= BLOCK_HEIGHT;
		return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////
BOOL CBlockDinamic::SubYOfs (int sub)
{
	m_ptOfsOld.y = m_ptOfs.y;
	m_ptOfs.y -= sub;
	m_ptOfsOld.y = m_ptOfs.y - m_ptOfsOld.y;

	if (m_ptOfs.y == -BLOCK_HEIGHT) 
	{
		m_ptOfs.y += BLOCK_HEIGHT;
		return TRUE;
	}
	return FALSE;
}
