// BlockMonster.cpp: implementation of the CBlockMonster class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Boulder.h"
#include "BlockMonster.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBoulderApp theApp;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBlockMonster::CBlockMonster(int type)
{
	m_type = type;
	m_bInverceXAxis = FALSE;
	m_bInverceYAxis = FALSE;
	m_oldMovement = NOMOVEMENT;
}

CBlockMonster::~CBlockMonster()
{
}

//////////////////////////////////////////////////////////////////////
void CBlockMonster::DrawBlock (CDC* pDc, CPoint ptPos, BOOL bDrawAllMap)
{
	switch (m_type)
	{
	case BLOCK_MONSTER1:
		theApp.DrawSprite (pDc, 23 + m_state, ptPos, m_ptOfs);
		break;
	case BLOCK_MONSTER2:
		theApp.DrawSprite (pDc, 27 + m_state, ptPos, m_ptOfs);
		break;
	}

	CBlockDinamic::DrawBlock (pDc, ptPos, bDrawAllMap);
}

//////////////////////////////////////////////////////////////////////
void CBlockMonster::IncreaseState ()
{
	m_state = (m_state + 1) % 4;
}