// Boulder.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "Boulder.h"

#include "MainFrm.h"
#include "Sound.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBoulderApp

BEGIN_MESSAGE_MAP(CBoulderApp, CWinApp)
	//{{AFX_MSG_MAP(CBoulderApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBoulderApp construction

CBoulderApp::CBoulderApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBoulderApp object

CBoulderApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBoulderApp initialization

BOOL CBoulderApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	AfxEnableControlContainer (); //  Call this when using ActiveX controls

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LPCSTR pBuff = m_strCurrentPath.GetBufferSetLength (1024);
	GetModuleFileName (AfxGetInstanceHandle (), (char*)pBuff, m_strCurrentPath.GetLength ());
	m_strCurrentPath.ReleaseBuffer ();
	int slash_pos = m_strCurrentPath.ReverseFind ('\\');
	m_strCurrentPath = m_strCurrentPath.Left (slash_pos + 1);
	
	//Loading and initializing image list
	CBitmap bm, bmMono;
	bm.LoadBitmap (IDB_MAPSPRITES);
	bmMono.LoadBitmap (IDB_MAPSPRITESMONO);
	m_imgList.Create(BLOCK_WIDTH, BLOCK_HEIGHT, ILC_COLORDDB, MAP_SPRITES_NUM, MAP_SPRITES_NUM);
	m_imgList.Add(&bm, RGB (0, 0, 0));
	m_imgListMono.Create(BLOCK_WIDTH, BLOCK_HEIGHT, ILC_COLORDDB, MAP_SPRITES_NUM, MAP_SPRITES_NUM);
	m_imgListMono.Add(&bmMono, RGB (0, 0, 0));
	m_bMono = FALSE;

	//Initializing sound module
	//try
	{	
		/*
		m_pSnd->LoadResourceFile ("WAVE_START", WAVE_START);
		m_pSnd->LoadResourceFile ("WAVE_DROP", WAVE_DROP);
		m_pSnd->LoadResourceFile ("WAVE_STONEDROP", WAVE_STONEDROP);
		m_pSnd->LoadResourceFile ("WAVE_EXPLOSION", WAVE_EXPLOSION);
		m_pSnd->LoadResourceFile ("WAVE_THEME", WAVE_THEME);
		*/
	}
	/*
	catch (SNDERR error)
	{
		CString strError;
		strError.LoadString (IDS_SOUND_ERROR);
		AfxMessageBox (strError, MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	*/

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	// create and load the frame with its resources

	pFrame->Create (NULL, "Boulder dash", WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, CRect (0, 0, 800, 600), NULL, 0);

	// The one and only window has been initialized, so show and update it.
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();

	m_pSnd = new CSound;
	m_pSnd->LoadWaveFromFile (theApp.m_strCurrentPath + "\\start.wav", WAVE_START);
	m_pSnd->LoadWaveFromFile (theApp.m_strCurrentPath + "\\drop.wav", WAVE_DROP);
	m_pSnd->LoadWaveFromFile (theApp.m_strCurrentPath + "\\stonedrop.wav", WAVE_STONEDROP);
	m_pSnd->LoadWaveFromFile (theApp.m_strCurrentPath + "\\explosion.wav", WAVE_EXPLOSION);
	m_pSnd->LoadWaveFromFile (theApp.m_strCurrentPath + "\\theme.wav", WAVE_THEME);
	

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
int CBoulderApp::ExitInstance() 
{
	delete m_pSnd;
	
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
// CBoulderApp message handlers

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CBoulderApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CBoulderApp message handlers

/////////////////////////////////////////////////////////////////////////////
void CBoulderApp::DrawSprite (CDC* pDc, int num, CPoint ptPos, CPoint ptOfs)
{
	//m_imgList.DrawIndirect (pDc, num, CPoint (ptPos.x * BLOCK_WIDTH + ptOfs.x,
		//ptPos.y * BLOCK_HEIGHT + ptOfs.y), CSize (BLOCK_WIDTH, BLOCK_HEIGHT), CPoint (0, 0));

	///*
	if (!m_bMono)
	{
		m_imgList.Draw (pDc, num, CPoint (ptPos.x * BLOCK_WIDTH + ptOfs.x,
			ptPos.y * BLOCK_HEIGHT + ptOfs.y), SRCCOPY);
	}
	else
	{
		m_imgListMono.Draw (pDc, num, CPoint (ptPos.x * BLOCK_WIDTH + ptOfs.x,
			ptPos.y * BLOCK_HEIGHT + ptOfs.y), SRCCOPY);
	}
	//*/

	/*
	m_bImgList.Draw (pDc, num, CPoint (ptPos.x * BLOCK_WIDTH + ptOfs.x,
		ptPos.y * BLOCK_HEIGHT + ptOfs.y));
	*/
}
