// GameField.cpp : implementation file
//

#include "stdafx.h"
#include "boulder.h"
#include "GameField.h"

#include "FileExeption.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CBoulderApp theApp; 

/////////////////////////////////////////////////////////////////////////////
// CGameField

IMPLEMENT_DYNCREATE(CGameField, CView)

CGameField::CGameField()
{
	m_pEngine = NULL;
	m_pMap = NULL;
	m_pScore = NULL;

	m_nKeysPressed = 0;
	m_curKey = NOMOVEMENT;

	m_nPreviewState = FALSE;
	m_yOfs = 0;
	m_idCurTimer = TIMER_GAME;

	m_bComletedTimerIsSet = FALSE;
	m_bFailedTimerIsSet = FALSE;
	m_bReturnToEditorOnComlete = FALSE;
}

CGameField::~CGameField()
{
	delete m_pEngine;
	delete m_pMap;
}


BEGIN_MESSAGE_MAP(CGameField, CView)
	//{{AFX_MSG_MAP(CGameField)
	ON_WM_TIMER()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_ERASEBKGND()
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGameField drawing

void CGameField::OnDraw(CDC* pDC)
{
	if (m_bPreview)
	{
		pDC->SetWindowOrg (0, m_yOfs);
		pDC->FillSolidRect (0, 0, MAP_WIDTH * BLOCK_WIDTH, m_yOfs, RGB (0, 0, 0));
		if (m_nPreviewState == 1)
			pDC->FillSolidRect (0, PREVIEW_TITLE_HEIGHT, MAP_WIDTH * BLOCK_WIDTH, 
				MAP_HEIGHT * BLOCK_HEIGHT + m_yOfs, ::GetSysColor (COLOR_3DFACE));

		DrawTitle (pDC);

		if (m_nPreviewState == 2)
		{
			pDC->SetWindowOrg (0, m_yOfs - PREVIEW_TITLE_HEIGHT);
			m_pMap->DrawMap (pDC);
		}
	}
	else
	if (m_pMap)
		m_pMap->DrawMap (pDC, FALSE);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::DrawTitle (CDC* pDC)
{
	int mapWidth = MAP_WIDTH * BLOCK_WIDTH;
	
	static CBitmap bmTitle;
	if (!bmTitle.m_hObject)
		bmTitle.CreateCompatibleBitmap (pDC, mapWidth, PREVIEW_TITLE_HEIGHT);

	CDC memDC;
	memDC.CreateCompatibleDC (pDC);
	
	CRect rc (0 ,0, mapWidth, PREVIEW_TITLE_HEIGHT);
	
	CBitmap* bmOld = memDC.SelectObject (&bmTitle);
	memDC.FillSolidRect (&rc, RGB (0, 0, 255));
	
	CString str, strLevelTitle;
	strLevelTitle.LoadString (IDS_LEVEL_TITLE);
	str.Format (strLevelTitle, m_player.m_nCurLevelNum + 1, m_player.m_nLives, m_player.m_nTotalScore);

	m_txt.SetTextSize (200);
	m_txt.SetTextColor (RGB (255, 255 ,255));
	m_txt.DrawText (&memDC, str, rc, DT_CENTER|DT_VCENTER);
	
	pDC->BitBlt (0, 0, mapWidth, PREVIEW_TITLE_HEIGHT, &memDC, 0, 0, SRCCOPY);	
	memDC.SelectObject (bmOld);
}

/////////////////////////////////////////////////////////////////////////////
// CGameField diagnostics

#ifdef _DEBUG
void CGameField::AssertValid() const
{
	CView::AssertValid();
}

void CGameField::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGameField message handlers

/////////////////////////////////////////////////////////////////////////////
void CGameField::StartEngine ()
{
	StopTimer (TIMER_GAME);

	if (m_pEngine)
		delete m_pEngine;
	
	m_pEngine = new CMapEngine (m_pMap);

	CClientDC dc (this);
	
	m_pMap->DrawMap (&dc);

	m_nKeysPressed = 0;
	StartTimer (TIMER_GAME);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::StartNewGame (CBoulderMap* pMap)
{
	m_bComletedTimerIsSet = FALSE;
	m_bFailedTimerIsSet = FALSE;
	
	try
	{
		if (m_pMap)
			delete m_pMap;
			
		if (!pMap)
			m_pMap = new CBoulderMap (m_player.m_nCurLevelNum, theApp.m_strCurrentPath + m_player.m_strMapName);
		else
		{
			m_pMap = new CBoulderMap (pMap);
			m_player = CPlayer (CString (""), pMap->GetLevelNumber ());
			m_bReturnToEditorOnComlete = TRUE;
		}
	}
	catch (CFileExeption error)
	{
		AfxMessageBox (error);
		return;
	}
	
	if (m_pEngine)
	{
		delete m_pEngine;
		m_pEngine = NULL;
	}

	PullOutMap (TRUE);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::OnTimer(UINT nIDEvent) 
{
	switch (nIDEvent)
	{
	case TIMER_GAME:
		GameStep ();
		break;
	
	case TIMER_PULL:
		PullOutMap ();
		break;
	
	case TIMER_FAILED:
		StopTimer (TIMER_FAILED);
		m_player.m_nLives -= LIVES_ON_LEVEL_FAILED;
		if (!m_bReturnToEditorOnComlete)
			StartNewGame ();
		else
			StartNewGame ();
		break;

	case TIMER_COMPLETED:
		StopTimer (TIMER_COMPLETED);
		m_player.m_nCurLevelNum++;
		m_player.m_nLevelsComplete++;
		m_player.m_nTotalScore += m_pMap->GetTotalGoldNumber () * SCORE_PER_ONE_GOLD;
		m_player.m_nLives += LIVES_PER_ONE_LEVEL;
		
		if (!m_bReturnToEditorOnComlete)
		{
			CString str, strDir;
			strDir.LoadString (IDS_SAVE_DIR_NAME);
			::CreateDirectory (theApp.m_strCurrentPath + strDir, NULL);
			str.Format ("%s%s.sav", theApp.m_strCurrentPath + strDir, m_player.m_strPlayerName);
			m_player.SavePlayer (str);

			StartNewGame ();
		}
		else
			GetParent ()->SendMessage (WM_COMMAND, ID_EDIT_STARTEDITOR);
		break;
	}

	CView::OnTimer(nIDEvent);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (!(nFlags & 0x4000))
	{
		m_nKeysPressed++;
		m_curKey = nChar;
	}

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (m_nKeysPressed > 0)
		m_nKeysPressed--;
	
	if (m_nKeysPressed == 0)
		m_curKey = NOMOVEMENT;	

	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::StartTimer ()
{
	StartTimer (m_idCurTimer);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::StartTimer (int id)
{
	switch (id)
	{
	case TIMER_GAME:
		if (IsGameEngineStarted ())
			SetTimer (TIMER_GAME, BOULDER_INTERNAL_TIMER_DELAY, NULL);
		break;
	case TIMER_PULL:
		SetTimer (TIMER_PULL, PREVIEW_INTERNAL_TIMER_DELAY, NULL);
		break;
	case TIMER_COMPLETED:
		SetTimer (TIMER_COMPLETED, COMPLETED_LEVEL_TIMER, NULL);
		break;
	case TIMER_FAILED:
		SetTimer (TIMER_FAILED, FAILED_LEVEL_TIMER, NULL);
		break;
	}

	m_idCurTimer = id;
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::StopTimer ()
{
	StopTimer (m_idCurTimer);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::StopTimer (int id)
{
	KillTimer (id);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CView::OnShowWindow(bShow, nStatus);

	if (bShow)
		StartTimer ();
	else
		StopTimer ();
}

/////////////////////////////////////////////////////////////////////////////
BOOL CGameField::OnEraseBkgnd(CDC* pDC) 
{
	if (m_pMap && !m_bPreview)
	{
		m_pMap->DrawMap (pDC);
		return TRUE;
	}
	
	if (m_nPreviewState == 4)
	{
		CRect rc;
		GetClientRect (&rc);

		CBrush br, *oldBr;
		br.CreateSolidBrush (::GetSysColor (COLOR_3DFACE));
		oldBr = pDC->SelectObject (&br);
		pDC->PatBlt (0, 0, rc.Width (), rc.Height (), PATCOPY);
		pDC->SelectObject (oldBr);
	}

	return TRUE;
	//return CView::OnEraseBkgnd(pDC);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::GameStep ()
{
	m_pEngine->MoveDinamicBlocks ();
	m_pEngine->MoveBoulder (m_curKey, m_nKeysPressed);
	m_pEngine->MoveMonsters ();
	m_pEngine->IncreaseState ();
	
	if (m_pEngine->IsBoulderDied ())
		if (!m_bFailedTimerIsSet && !m_bComletedTimerIsSet)
		{
			m_bFailedTimerIsSet = TRUE;
			StartTimer (TIMER_FAILED);
		}

	if (m_pEngine->CheckForLevelComplete ())
		if (!m_bComletedTimerIsSet && !m_bFailedTimerIsSet)
		{
			m_bComletedTimerIsSet = TRUE;
			StartTimer (TIMER_COMPLETED);
		}

	if (!m_bComletedTimerIsSet)
	{
		m_pEngine->CheckForBoulderExplosion ();
		m_pEngine->CheckForMonstersExplosion ();
	}
	
	Invalidate (FALSE);
	UpdateWindow ();

	m_pEngine->ClearOldExplosion (BLOCK_GOLD);
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::PullOutMap (BOOL bBegin)
{
	int mapHeight = BLOCK_HEIGHT * MAP_HEIGHT;

	if (bBegin) 
		m_nPreviewState = 0;

	switch (m_nPreviewState)
	{
	case 0:
		StopTimer (TIMER_GAME);
		Cleaning ();

		m_bPreview = TRUE;
		m_nPreviewState = 1;
		m_yOfs = PREVIEW_TITLE_HEIGHT;
		
		// 
		if (m_player.m_nLives)
			StartTimer (TIMER_PULL);
		else
		{
			m_nPreviewState = 4;
			StopTimer (TIMER_PULL);
			if(!m_bReturnToEditorOnComlete)
			{
				ShowWindow (SW_HIDE);
				m_pScore->AddPlayerToPlayerList (m_player);
				m_pScore->ShowWindow (SW_SHOW);
			}
			else
				GetParent ()->SendMessage (WM_COMMAND, ID_EDIT_STARTEDITOR);
		}

		//
		break;

	case 1:
		
		m_yOfs -= mapHeight / 100;

		Invalidate (FALSE);
		UpdateWindow ();

		if (m_yOfs < -mapHeight + PREVIEW_TITLE_HEIGHT)
		{
			StartTimer (TIMER_PULL);
			//theApp.m_pSnd->PlaySound (WAVE_START);
			theApp.m_pSnd->Play (WAVE_START);
			m_nPreviewState = 2;
		}
		break;

	case 2:
		Invalidate (FALSE);
		UpdateWindow ();

		m_yOfs += mapHeight / 20;

		if (m_yOfs >=0)
		{
			m_bPreview = FALSE;
			StopTimer (TIMER_PULL);
			//theApp.m_pSnd->PlaySound (WAVE_THEME);
			//theApp.m_pSnd->Play (WAVE_THEME, CSound::LOOPING);
			m_nPreviewState = 3;

			StartEngine ();
		}
		break;
	}
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::Cleaning (CDC* pDC)
{
	int width = MAP_WIDTH * BLOCK_WIDTH;
	int height = MAP_HEIGHT * BLOCK_HEIGHT;

	
	int bNoDC = FALSE;
	
	if (pDC == NULL)
	{
		pDC = new CClientDC (this);
		bNoDC = TRUE;
	}
	
	for (int y = 0; y < height; y+=10)
	{
		pDC->BitBlt (0, y + 10, width, height - y, pDC, 0, y, SRCCOPY); 
		pDC->FillSolidRect (0, y, width, 10, ::GetSysColor (COLOR_3DFACE));
	}

	if (bNoDC)
	{
		delete pDC;
		pDC = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
void CGameField::RestartLevel ()
{
	CPoint ptPos = m_pEngine->GetBoulderPos ();
	if (ptPos.x != - 1 && ptPos.y != -1)
		m_pEngine->DoExplosion (ptPos);
}

/////////////////////////////////////////////////////////////////////////////
BOOL CGameField::IsGameEngineStarted ()
{
	if (m_pEngine)
		return TRUE;

	return FALSE;
}
