#if !defined(AFX_GAMEFIELD_H__35E5F541_AE74_11D5_ADEB_00E098920EFC__INCLUDED_)
#define AFX_GAMEFIELD_H__35E5F541_AE74_11D5_ADEB_00E098920EFC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GameField.h : header file
//

#include "MapEngine.h"
#include "MapEditor.h"
#include "ScoreTable.h"
#include "Player.h"
#include "BoulderText.h"

/////////////////////////////////////////////////////////////////////////////
// CGameField view

class CGameField : public CView
{
protected:
	DECLARE_DYNCREATE(CGameField)

// Attributes
public:
	CGameField();
	virtual ~CGameField();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGameField)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	
	//{{AFX_MSG(CGameField)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:	
	CPlayer					m_player;

	void					StartNewGame (CBoulderMap* pMap = NULL);
	void					StartTimer ();
	void					StartTimer (int id);
	void					StopTimer ();
	void					StopTimer (int id);

	void					AttachScoreTable (CScoreTable* pScore){m_pScore = pScore;}
	void					RestartLevel ();
	BOOL					IsGameEngineStarted ();

protected:
	CMapEngine*				m_pEngine;
	CBoulderMap*			m_pMap;
	CScoreTable*			m_pScore;

	int						m_curKey;
	int						m_nKeysPressed;

	BOOL					m_bPreview;
	int						m_nPreviewState;
	int						m_yOfs;
	int						m_idCurTimer;
	CBoulderText			m_txt;
	BOOL					m_bComletedTimerIsSet;
	BOOL					m_bFailedTimerIsSet;
	BOOL					m_bReturnToEditorOnComlete;

	void					StartEngine ();
	void					GameStep ();
	void					PullOutMap (BOOL bBegin = FALSE);
	void					DrawTitle (CDC* pDC);
	void					Cleaning (CDC* pDC = NULL);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GAMEFIELD_H__35E5F541_AE74_11D5_ADEB_00E098920EFC__INCLUDED_)
