// NewGameDlg.cpp : implementation file
//

#include "stdafx.h"
#include "boulder.h"
#include "NewGameDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNewGameDlg dialog


CNewGameDlg::CNewGameDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNewGameDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNewGameDlg)
	m_strPlayerName = _T("");
	//}}AFX_DATA_INIT
}


void CNewGameDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNewGameDlg)
	DDX_Text(pDX, IDC_NG_EDIT, m_strPlayerName);
	DDV_MaxChars(pDX, m_strPlayerName, 20);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNewGameDlg, CDialog)
	//{{AFX_MSG_MAP(CNewGameDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNewGameDlg message handlers

BOOL CNewGameDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString str;
	str.LoadString (IDS_DEFAULT_PLAYER_NAME);
	CEdit* pEdit = (CEdit*)GetDlgItem (IDC_NG_EDIT);
	pEdit->SetWindowText (str);
	pEdit->SetSel (0, -1);
	pEdit->SetFocus ();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
void CNewGameDlg::OnOK() 
{
	CString str;
	CEdit* pEdit = (CEdit*)GetDlgItem (IDC_NG_EDIT);
	pEdit->GetWindowText (str);

	if (str == "")
	{
		str.LoadString (IDS_WRONG_PLAYER_NAME);
		AfxMessageBox (str, MB_OK|MB_ICONSTOP);
		return;
	}

	if (!TestPlayerName (str))
		return;
	
	CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
BOOL CNewGameDlg::IsSymbolLegal (BYTE ch)
{
	if (ch == ' ' || ch == '-' || ch == '_' || (ch >= '0' && ch <= '9') 
		|| (ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z'))
		return TRUE;
	else
		return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CNewGameDlg::TestPlayerName (CString &strName)
{
	for (int i = 0; i < strName.GetLength (); i++)
	{
		if (!IsSymbolLegal (strName[i]))
		{
			CString strError;
			strError.LoadString (IDS_ILLEGAL_PLAYER_NAME);
			AfxMessageBox (strError, MB_OK);
			return FALSE;
		}
	}

	return TRUE;
}