// UndoRedo.h: interface for the CUndoRedo class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UNDOREDO_H__73191AC1_BC23_11D5_ADEB_00E098920EFC__INCLUDED_)
#define AFX_UNDOREDO_H__73191AC1_BC23_11D5_ADEB_00E098920EFC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "BoulderMap.h"

class CUndoRedo  
{
public:
	CUndoRedo();
	virtual ~CUndoRedo();
	
	void				Undo (CBoulderMap* pMap);
	void				Redo (CBoulderMap* pMap);
	void				Update (CBoulderMap* pMap);
	BOOL				CanUndo ();
	BOOL				CanRedo ();
	void				Reset ();

protected:

	CTypedPtrList<CPtrList, BYTE*> m_undoList;
	CTypedPtrList<CPtrList, BYTE*> m_redoList;
	
	void				ConvertMapToIndexes (CBoulderMap* pMap, BYTE* pBuff);
	void				ConvertIndexesToMap (CBoulderMap* pMap, BYTE* pBuff);
};

#endif // !defined(AFX_UNDOREDO_H__73191AC1_BC23_11D5_ADEB_00E098920EFC__INCLUDED_)
