
; Xlat.Asm	(C) 1996-7, AtH
;
; Convert file via 80x86 XLAT.  Customized tables in binary file XLAT.DAT.
; Also can encode/decode file useing simple script in command-line.

SIZE_BUFFER	equ	4000h
SIZE_STACK	equ	1024		; in bytes

		.model	tiny
		.code
		org	100h
Start:
		mov	dx,offset msgCopyright
		mov	ah,9
		int	21h

		mov	sp,(lastbyte-Start+10Fh)and not 3
		mov	dx,(lastbyte-Start+10Fh)shr 4
		mov	ah,4Ah			; Expand Memory Block
		int	21h

		call	GetParameters		; Give Help&Exit if error
		call	FindOutFilename
		call	LoadTable		; Abort if error
		call	XlatFile
		mov	dx,offset msgAllOkay
		mov	ah,9
		int	21h
		mov	ax,4C00h		; Exit(0)
		int	21h

GetParameters	proc	near
		mov	bl,ds:[80h]
		cmp	bl,0FFh-81h
		ja	gpError
		sub	bh,bh
		mov	si,81h
		mov	byte ptr [si+bx],0	; To be sure <128 chars
gpSkip1:	lodsb			; Wait 4 "/table", "/?" or source name
		cmp	al,' '
		jz	gpSkip1
		cmp	al,9
		jz	gpSkip1
		or	al,al
		jz	gpError
		cmp	al,'/'
		jnz	gpGetSource
		lodsb
		cmp	al,'?'
		jnz	gpNotHelp
		mov	dx,offset msgHelp	; As Requested
		mov	ah,9
		int	21h
		mov	ax,4C00h		; Exit(0) Help req - help got
		int	21h
gpNotHelp:
		mov	di,offset strOperations
		mov	cx,N_OPERATIONS
	repne	scasb
		jne	gpGetTable
		mov	byte ptr flgRoutine,1
		call	MakeRoutine
		jmp	short gpGetSource1
gpGetTable:
		mov	di,offset strTable
		mov	cx,16
		dec	si
gpGTloop:	lodsb
		cmp	al,' '
		jz	gpEOT
		cmp	al,9
		jz	gpEOT
		or	al,al
		jz	gpError
		cmp	al,'z'
		ja	gpGTstore
		cmp	al,'a'
		jb	gpGTstore
		sub	al,20h
gpGTstore:	stosb
		loop	gpGTloop
		lodsb
		cmp	al,' '
		jz	gpGetSource0
		cmp	al,9
		jz	gpGetSource0
gpError:
		mov	dx,offset msgErrorSyntax
		mov	ah,9
		int	21h
		mov	ax,4C01h	; Exit(1)
		int	21h
gpEOT:
		sub	al,al
	rep	stosb
		cmp	byte ptr strTable,0
		jz	gpError
gpGetSource0:
		lodsb
gpGetSource1:	cmp	al,' '
		jz	gpGetSource0
		cmp	al,9
		jz	gpGetSource0
gpGetSource:
		mov	di,offset strSource
		dec	si
gpGSloop:	lodsb
		cmp	al,' '
		jz	gpGetDestination0
		cmp	al,9
		jz	gpGetDestination0
		or	al,al
		jz	gpError
		stosb
		jmp	gpGSloop
gpGetDestination0:
		sub	al,al
		stosb
		cmp	al,strSource
		jz	gpError
gpGDskip:	lodsb
		cmp	al,' '
		jz	gpGDskip
		cmp	al,9
		jz	gpGDskip

		mov	di,offset strDestination
		dec	si
gpGDloop:	lodsb
		cmp	al,' '
		jz	gpGDok
		cmp	al,9
		jz	gpGDok
		or	al,al
		jz	gpEOL
		stosb
		jmp	gpGDloop
gpGDok:
		lodsb
		cmp	al,' '
		jz	gpGDok
		cmp	al,9
		jz	gpGDok
		or	al,al
		jnz	gpError
gpEOL:					; In every brunch AL=0
		stosb
		cmp	al,strDestination
		jz	gpError
		ret
GetParameters	endp

; In:	AL	ASCII character
; Out:	CF	not a digit, AL preserved
;	NC	a hexadecimal digit in AL
;
;
ASCIItoHex	proc	near
		cmp	al,'0'
		jb	athFault
		cmp	al,'9'
		ja	athChk4alpha
		sub	al,'0'
		ret
athChk4alpha:	cmp	al,'f'
		ja	athFault
		cmp	al,'a'
		jb	athChk4upper
		sub	al,'a'-0ah
		ret
athChk4upper:	cmp	al,'F'
		ja	athFault
		cmp	al,'A'
		jb	athFault
		sub	al,'A'-0ah
		ret
athFault:	stc
		ret
ASCIItoHex	endp


MakeRoutine	proc	near
		mov	di,offset DecryptRoutine
mrNextOperation:
		cmp	al,'+'
		jz	mrAdd
		cmp	al,'-'
		jz	mrSub
		cmp	al,'^'
		jz	mrXor
		cmp	al,'}'
		jz	mrRight
		cmp	al,'{'
		jz	mrLeft
		cmp	al,'&'
		jz	mrAnd
		cmp	al,'|'
		jz	mrOr
		cmp	al,' '
		jz	mrExit
		cmp	al,9
		jz	mrExit
		or	al,al
		jz	mrExit
mrErrorOperation:
		mov	dx,offset msgErrorOperation
		mov	ah,9
		int	21h
		mov	ax,4C07h		; Exit(7)
		int	21h
mrExit:		mov	byte ptr [di],0C3h	; near RET
		ret
mrLeft:		mov	ax,0C0D0h		; ROL AL,1
		stosw
		lodsb
		jmp	mrNextOperation
mrRight:	mov	ax,0C8D0h		; ROR AL,1
		stosw
		lodsb
		jmp	mrNextOperation
mrAdd:		mov	al,4			; ADD AL,imm_byte
		jmp	short mrParameter
mrSub:		mov	al,2Ch			; SUB AL,imm_byte
		jmp	short mrParameter
mrAnd:		mov	al,24h			; AND AL,imm_byte
		jmp	short mrParameter
mrOr:		mov	al,0Ch			; OR AL,imm_byte
		jmp	short mrParameter
mrXor:		mov	al,34h			; XOR AL,imm_byte
mrParameter:	stosb
		lodsb
		call	ASCIItoHex
		jnc	mrGoodDigit1
		mov	dx,offset msgErrorOperand
		mov	ah,9
		int	21h
		mov	ax,4C08h		; Exit(8)
		int	21h
mrGoodDigit1:	mov	ah,al
		stosb
		lodsb
		call	ASCIItoHex
		jc	mrNextOperation
		mov	cl,4
		shl	ah,cl			; i286+ SHL AH,4
		or	al,ah
		mov	[di-1],al
		lodsb
		jmp	mrNextOperation
MakeRoutine	endp


FindOutFilename	proc	near
		push	es
		mov	es,ds:[2Ch]	; Scan DOS Environment
		sub	ax,ax
		mov	di,ax
		mov	cx,8000h
fofLoop:	scasw
		je	fofFind
		dec	di
		loop	fofLoop
		pop	es		; Not found
		ret
fofFind:	scasw			; Skip 01 00 bytes
		mov	si,di
		push	es
		push	ds
		pop	es
		pop	ds
		mov	di,offset strFilename
		mov	cx,127
		mov	byte ptr [di]+127,0
fofCopy:
		lodsb
		stosb
		or	al,al
		loopne	fofCopy
		pop	ds
		dec	di
		cmp	di,offset strFilename+4
		jb	fofAddExt0
		cmp	byte ptr [di]-1,'.'	; 'M'
		jz	fofAddExt
		dec	di
		cmp	byte ptr [di]-1,'.'	; 'O'
		jz	fofAddExt
		dec	di		; I don't checking for '\'
		cmp	byte ptr [di]-1,'.'	; 'C'
		jz	fofAddExt
		dec	di
		cmp	byte ptr [di]-1,'.'	; '.'
		jz	fofAddExt
		add	di,3
fofAddExt0:	mov	al,'.'
		stosb
fofAddExt:	mov	ax,'AD'
		stosw
		mov	ax,'T'
		stosw
		ret
FindOutFilename	endp


LoadTable	proc	near
		mov	dx,offset strFilename
		mov	ax,3D00h	; Open R/O
		int	21h
		jnc	lt21ok1
		mov	dx,offset msgErrorNoDat
		mov	ah,9
		int	21h
		mov	ax,4C02h	; Exit(2)
		int	21h
lt21ok1:
		xchg	ax,bx
ltReadDirectory:
		mov	dx,offset tblXlat
		mov	cx,256
		mov	ah,3Fh		; Read
		int	21h
		jc	ltErrorDat
		cmp	ax,cx
		jz	lt21ok2
ltErrorDat:
		mov	ah,3Eh		; Close
		int	21h
		mov	dx,offset msgErrorDat
		mov	ah,9
		int	21h
		mov	ax,4C03h	; Exit(3)
		int	21h
lt21ok2:
		mov	si,offset strDirectory
		mov	di,offset tblXlat
		mov	cx,8
	repe	cmpsw
		jnz	ltErrorDat

		mov	di,offset tblXlat+10h
ltNextLine:	push	di
		mov	si,offset strTable
		mov	cx,8
	repe	cmpsw
		pop	di
		jnz	ltCompareFailed
		sub	di,offset tblXlat+10h
		mov	cl,4
		shl	di,cl
		mov	dx,di
		sub	cx,cx
		mov	ax,4201h	; Lseek from current
		int	21h
		jc	ltErrorDat
		mov	dx,offset tblXlat
		mov	cx,256
		mov	ah,3Fh
		int	21h
		jc	ltErrorDat
		cmp	ax,cx
		jnz	ltErrorDat
		mov	ah,3Eh		; Close
		int	21h
		ret

ltCompareFailed:
		add	di,10h
		cmp	di,offset tblXlat+100h
		jb	ltNextLine

		mov	ax,4201h	; Lseek from current
		mov	dx,256*15	; Goto next directory
		sub	cx,cx
		int	21h
		jc	ltErrorDat
		jmp	ltReadDirectory
LoadTable	endp


XlatFile	proc	near
		mov	dx,offset strSource
		mov	ax,3D30h	; Open R/O, permit writing
		mov	bx,00
		int	21h
		jnc	xf21ok1
		mov	dx,offset msgErrorNoSource
		mov	ah,9
		int	21h
		mov	ax,4C04h	; Exit(4)
		int	21h
xf21ok1:	mov	wHandleIn,ax
		mov	dx,offset strDestination
		mov	ax,3D21h	; Open W/O, permit reading
		int	21h
		jnc	xf21ok2
		mov	ah,3Ch		; Create file
		sub	cx,cx
		int	21h
		jnc	xf21ok2
		mov	bx,wHandleIn
		mov	ah,3Eh		; Close
		int	21h
		mov	dx,offset msgErrorNoDestination
		mov	ah,9
		int	21h
		mov	ax,4C05h	; Exit(5)
		int	21h
xf21ok2:	mov	wHandleOut,ax
xfLoop:
		mov	bx,wHandleIn
		mov	cx,SIZE_BUFFER
		mov	dx,offset buffer
		mov	ah,3Fh		; Read
		int	21h
		jnc	xf21ok3
xfErrorIO:
		call	xfCloseAll
		mov	dx,offset msgErrorIO
		mov	ah,9
		int	21h
		mov	ax,4C06h	; Exit(6)
		int	21h
xf21ok3:
		mov	bx,offset tblXlat
		mov	si,offset buffer
		mov	di,si
		xchg	cx,ax
		jcxz	xfDone

		push	cx
		test	flgRoutine,-1
		jz	xfReallyXlat
xfFakeXlat:	lodsb
		call	near ptr DecryptRoutine
		stosb
		loop	xfFakeXlat
		jmp	short xfXlated

xfReallyXlat:	lodsb
		xlat
		stosb
		loop	xfReallyXlat
xfXlated:	pop	cx

		mov	bx,wHandleOut
		mov	dx,offset buffer
		mov	ah,40h		; Write
		int	21h
		jc	xfErrorIO
		cmp	ax,cx
		jnz	xfErrorIO
		cmp	cx,SIZE_BUFFER
		je	xfLoop
xfDone:
		mov	bx,wHandleOut		; Can jump to here before xlat
		mov	dx,offset buffer	; Let it be...
		mov	ah,40h			; Write
		sub	cx,cx			; Cut file
		int	21h
xfCloseAll:
		mov	bx,wHandleIn
		mov	ah,3Eh		; Close
		int	21h
		mov	bx,wHandleOut
		mov	ah,3Eh		; Close
		int	21h
		ret
XlatFile	endp


msgCopyright	label	byte
 db 'XLAT v1.1   Customized text file convertor.  (C) 1996-7, AtH, 2:5020/287',0dh,0ah
 db '$'

msgHelp 	label	byte
 db 'Usage:   Xlat [/(<table_name>|<expression>)] <source_file> <destination>',0dh,0ah
 db 'Example: Xlat /Dos2Win funny.txt funny1.txt',0dh,0ah
 db '     or  Xlat /+1^F2 crypted.exe decrypt.exe',0dh,0ah
 db '$'

msgErrorSyntax	label	byte
 db 'Command line syntax error.  Note, that',0dh,0ah
 db ' 1. You must specify both source and destination filenames.  No defaults.',0dh,0ah
 db ' 2. Table name must be from 1 to 16 characters.  Default is "Win2Dos".',0dh,0ah
 db '$'

msgErrorNoDat	label	byte
 db "Can't find XLAT.DAT.  Be sure to place it in my home directory.",0dh,0ah
 db '$'

msgErrorDat	label	byte
 db 'Error reading table from XLAT.DAT.  May be typee in table name?',0dh,0ah
 db 'Or wrong XLAT.DAT format?  Read XLAT.DOC for details.',0dh,0ah
 db '$'

msgErrorNoSource label	byte
 db "Can't open source file.",0dh,0ah
 db '$'

msgErrorNoDestination label byte
 db "Can't open destination file.",0dh,0ah
 db '$'

msgErrorIO	label	byte
 db "I/O error during converson, aborted.  Partial output, however, still exists.",0dh,0ah
 db '$'

msgErrorOperation label	byte
 db 'Sorry, wrong operation.  Legal operations are:',0dh,0ah
 db '  +xx    Add hexadecimal value xx to byte',0dh,0ah
 db '  -xx    Subtract xx',0dh,0ah
 db '  ^xx    XOR with xx',0dh,0ah
 db '  &xx    AND with xx',0dh,0ah
 db '  |xx    OR with xx',0dh,0ah
 db '  }      Cyclic rotate to right',0dh,0ah
 db '  {      Cyclic rotate to left',0dh,0ah
 db '$'

msgErrorOperand	label	byte
 db 'You must specify one or two hexadecimal digits after add, sub or xor',0dh,0ah
 db 'operations.',0dh,0ah
 db '$'

msgAllOkay	label	byte
 db 'XLAT:: converted successfully.  Thank you for choosing XLAT.',0dh,0ah
 db '$'

wHandleIn	dw	?
wHandleOut	dw	?
flgRoutine	db	0
strOperations	db	'+-^{}&|'
N_OPERATIONS	equ	$-strOperations
strDirectory	db	'XLAT Directory',1Ah,0
strTable	db	'WIN2DOS',9 dup (0)

tblXlat		label	byte
strFilename	db	"XLAT.TBL",0	; Table file name

buffer		equ	tblXlat+256
strSource	equ	buffer
strDestination	equ	buffer+128
DecryptRoutine	equ	buffer+SIZE_BUFFER
lastbyte	equ	DecryptRoutine+SIZE_STACK
		end	Start
