
Program BkServer;  { ***** Bk/Link SERVER  (c) 2003-2004 alex savelev / dwg }

{ BK Link uses LPT connection on IBM PC side and 177714 i/o on BK-0011M side

   BK IN port (177714o)      |   PC Out LPT Dataport (WRITE 378h)
 ----------------------------+-----------------------------------------------
   Bit 14, B29 40000o <-- inverted --* bit 3  mask 08h, PIN 5 on DB25
   Bit 13, A29 20000o <-- inverted --* bit 2  mask 04h  PIN 4
   Bit 12, B30 10000o <-- inverted --* bit 1  mask 02h  PIN 3
   Bit 11, A32 4000o  <-- inverted --* bit 0  mask 01h  PIN 2
 ============================================================================
   BK Out port (177714o)     |   PC LPT Input StatusPort (READ 379h)
   (bk share two ports on    |
   same i/o address)         |

  Bit 11, B27 4000o *---- normal ----> bit 7, BSY signal  mask 80h, PIN 11
  Bit 10, A27 2000o *--- inverted ---> bit 5, PE  signal  mask 20h, PIN 12
  Bit 9,  B28 1000o *--- inverted ---> bit 4, SLCT signal mask 10h, PIN 13

  GROUND AB11,18,19 *----------------* PIN 18, 19, 20, 21, 22, 23, 24, 25

{$M 65536, 0, 655360}                          { * Stack, HeapMin,HeapMax * }
{$F+}                                          { FAR call model for procs   }
{$N+}                                          { allow x87  code generation }
{$E+}                                          { link FPU emulation library }
{$S+}                                          { Stack overflow checking ON }
{$X+}                                          { Borland extended syntax ON }
{$W-}                                          { Windows stack frame is OFF }
{$A+}                                          { only even/WORD  data align }
{$B+}                                          { fast boolean evaluation OFF}
{$Q-}                                          { DISABLE overflow checking  }
{$R-}                                          { array range cheking is OFF }
{$G+}                                          { 286+ code for faster exec. }
uses  CRASH, DOS, CRT;                         { CRASH.TPU can be excluded! }
type  BorderType = (DoubleBorder, SingleBorder, EmptyBorder);
const max_buf_len       = 127*512;             { 127 sectors max.in fdc r/w }
      sectors_per_track : byte = 10;           { ten sectors per one track  }
      max_err_retries   : byte = 8;            { real floppy: max err retry }
      IOBase0           : word = $3BC;         { LPT0 base addr on mda/herc }
      IOBase1           : word = $378;         { LPT1 base addr ** used **  }
      IOBase3           : word = $278;         { LPT2 base addr             }
      BlockSIze         = 512;                 { logical block length,bytes }
      Major_Version     : byte = 1;            { Major BK-Server version    }
      Minor_Version     : byte = 5;            { Minor BK-Server version    }
      Server_Build      : byte = 8;            { BK-Server revision byte    }
      Busy_Mask         : byte = $80;          { Status Port bit7 mask      }
      PE_Mask           : byte = $20;          { Status Port bit5 mask      }
      SLCT_Mask         : byte = $10;          { Status Port bit4 mask      }
      Server_Features   : word = $0000;        { auxilary server info word  }
      NETWORK_SENSE     : word = $DCF3;        { magic word:net up & running}
      MaxPage           = 3;                   { textmode maximum page num  }
      PageSize          = 4096;                { textmode page size, bytes  }
      MaxChar           = 80;                  { textmode 03 - Max. X coord }
      MaxLine           = 25;                  { textmode 03 - Max. Y coord }
      VMemory           = $B800;               { textmode 03 - vmem.segment }
      CmdPromptString   : string[5] = 'cmd> '; { net command prompt string  }
      cfgname           : string [12] =
                          'bkserver.cfg';      { configuratuion file name   }
      HexArray          : array [$00..$0F] of char = ( { Hexadecimal array  }
			  '0', '1', '2', '3', '4', '5',
			  '6', '7', '8', '9', 'A', 'B',
			  'C', 'D', 'E', 'F');

var IOBase                            : integer;
    Award_BIOS_FLAG                   : boolean;
    real_floppy_first_time_flag       : boolean;
    sectors_to_rw                     : byte;
    block_number                      : word;
    DataPort, StatusPort, CommandPort : word;
    i, j, k                           : word;
    ch                                : char;
    Escape_Pressed_Flag               : boolean;          {true if ESC press}
    Timeout_flag                      : boolean;
    Client_Version                    : word;             {hi:major lo:minor}
    Client_Features                   : word;
    Int1CSave                         : pointer;
    Ticker                            : word;
    r                                 : registers;
    s1, s2, s3, Version_String        : string;
    msec                              : real;
    f                                 : array [0..16] of file;
    AccessMode                        : array [0..16] of byte; {0=r/o, 2=r/w}
    IO_Buffer                         : array [0..BlockSize-1] of byte;
    ImageFileName                     : array [0..16] of string;
    Timeout                           : word;
    Verbose_Mode_Str                  : string;
    MaxOpenFiles                      : word;
    ftflag                            : byte;
    track, side, sector               : byte;
    big_sector_buffer                 : pointer;
    current_offset_in_BIG_buffer      : word;
    actual_sec_transferred            : byte;
    failed_I                          : word;
    failed_byte                       : byte;
    Global_ShowDrivesMap_flag         : boolean;
    Global_ExitIfIOError_flag         : boolean;
    operation_result                  : byte;

{ =========================================================================

                            LOW LEVEL NETWORK I/O

 ========================================================================== }

Function EventCheck : boolean;                      { ESC / timeout if TRUE }
const ESC : char = #27;                             { ** ESCAPE KBD CODE ** }
var   ch  : char;
      c   : boolean;
begin
  c  := false;
  ch := #00;
  if keypressed then begin
    ch := ReadKey;
    if ch = #00 then ch := Readkey;
  end;
  if ch = ESC then begin
    c := true;
    Escape_Pressed_Flag := true;
  end;
  if (ch = 'm') or (ch = 'M') and (global_ShowDrivesMap_flag = false) then
  Global_ShowDrivesMap_flag := true;
  if Ticker > Timeout then begin
    Ticker := 0;
    c := true;
    Timeout_flag := true;
  end;
  EventCheck := c;
end;

{ < FastSend4bits >: Send low 4 bit of byte to BK,used internally by PutByte}
Function FastSend4bits (data : byte) : boolean;
var result : boolean;
    data2  : byte;
begin
  result := false;
  Timeout_Flag := false;
  Ticker := 0;
  Port [DataPort] := $00;   { read as 74000 oct at BK side of connection }
  repeat until ((Port [StatusPort] and Busy_Mask) <> 0) or
	       (EventCheck = true);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
    Port [DataPort] := $FF;
    exit;
  end;
  data2 := data;
  if (data and $0f) = 0     { if LOW 4 bits of data = 0         } then begin
    data2 := $FA;           { send $FA instead of zero          }
    Result := true;         { set flag: 0 was substituted by FA }
  end;
  Port [DataPort] := data2; { actual data send }
  Ticker := 0;
  repeat until ((Port [StatusPort] and Busy_Mask) = 0) or
	       (EventCheck = true);
  Port [DataPort] := $FF;                                 { end w/ 0 at BK }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  FastSend4bits := Result;
end;

{ < PutByte > : Send single byte to BK (FAST VERSION, 100% TESTED & WORKS)  }
Procedure PutByte (data : byte);
var answer : byte;
    res    : boolean;
begin
  answer := 1;
  res := FastSend4Bits (data);      { send low 4 bits }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  if res = true then answer := 2;   { $0FA send instead of 0 during 1st send}
  res := FastSend4Bits (data shr 4);{ send high 4 bits }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  if res = true then begin          { $0FA send instead of 0 during 2nd send}
    if answer = 1 then answer := 3; { 3 = 0 in high 4 bit, <> 0 in low bits }
    if answer = 2 then answer := 4; { 4 =  ࠤ 뫨 ﬨ }
  end;
  res := FastSend4Bits (answer);    { 1 =  ࠤ 뫨 㫥묨 }
end;                                { 2 = 0 in low 4 bits, <>0 in high bits }

{ < GetDoubleBit > : receive 2 bits from BK, internally used by GetByte     }
Function GetDoubleBit  : byte;
var b1, b2, v : byte;
begin
  Port [DataPort] := $FF;                                 { start w/0 at bk }
  Timeout_Flag := false;
  Ticker := 0;
  repeat
  v := Port [StatusPort]
  until ( (((v and Busy_Mask) = 0)                        { wait for bsy = 0}
  and   ((v and PE_Mask) = 0)) and                        { and PE = 0 bk:1 }
  ( (v and SLCT_Mask) <> 0 )                              { and SLCT=1 bk:0 }
  )
  or (EventCheck = true);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then Port [DataPort] := $FF;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  Port [DataPort] := $04;                                 { bsy=1(0),err=0/1}
  Ticker := 0;
  repeat until ((Port [StatusPort] and Busy_Mask) <> 0)   { wait for bsy = 1}
	 or    (EventCheck = true);                       { true if escape  }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  b1 := Port [StatusPort];                                { actual dataread }
  b2 := ((b1 shr 4) and $03);
  Port [DataPort] := $00;                                 { bsy=0 init port }
  Ticker := 0;
  repeat v := Port [StatusPort] until ( ( ((v and Busy_Mask) = 0) and
				      ((v and PE_Mask) <> 0) ) and (
				      ((v and SLCT_Mask) <> 0) ) ) or
				      (EventCheck = true);
  port [DataPort] := $FF;                                 { end w/ 0 at bk  }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag) = true then exit;
  GetDoubleBit := b2;
end;

{ < GetByte > : Receive single byte from BK (FAST VERSION,100% TESTED,WORKS)}
function GetByte : byte;
var i     : word;
    b1,b2 : byte;
begin
  b2 := $00;
  i := 0;
  repeat
    b1 := (GetDoubleBit and $03);        { clear all but received data bits }
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
    b2 := b2 or (b1 shl i);
    i := i + 2;
  until (i = 8);
  GetByte := b2;
end;

{ < Calculate_CRC > : BK style CRC calculator; entry: IO_buffer, Count      }
function Calculate_CRC (count : word) : word;
var i, c : word;
    c1   : longint;
begin
  c := 0;
  c1:= 0;
  for i := 0 to (count-1) do begin
    c := c + IO_Buffer[i];
    c1:= c1+ IO_Buffer[i];
    if c1 > 65535 {  overflow   } then begin
      c := c + 1; {ADC emulation}
      c1:= longint(c);
    end;
  end;
  Calculate_CRC := c;
end;

{ < PutBlock> : Send 512 bytes of IO_Buffer's data to BK                    }
procedure PutBlock (count : word);
var i : word;
begin
  for i := 0 to (count-1) do begin
    PutByte (IO_Buffer[i]);
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
      failed_i    := i;
      failed_byte := IO_Buffer[i];
      exit;
    end;
  end;
end;

{ <GetBlock>: Receive Count (usually 512) bytes from BK client to IO_Buffer}
Procedure GetBlock (count : word);
var i : word;
begin
  for i := 0 to (count-1) do begin
    IO_Buffer [i] := GetByte;
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  end;
end;

{ < GetWord > : receive single word FROM BK                                 }
function GetWord : word;
var b1, b2 : byte;
begin
  b1 := GetByte;                                          { get low byte }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  b2 := GetByte;                                          { get high byte }
  GetWord := (b2 * 256) + b1;
end;

{ < PutWord > : send single word TO BK }
procedure PutWord (data : word);
begin
  PutByte (Lo(data));
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  PutByte (Hi(data));
end;

{ < GetString > : Receive string from BK (string length byte goes first)    }
function GetString : string;
var i, l : byte;
    s    : string;
begin
  l := GetByte;                                           { Get Str. Length }
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  s := '';
  for i := 1 to l do begin
    s := s + char(GetByte);
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  end;
  GetString := s;
end;

{ < PutString > : Send string TO BK (string length byte goes first)         }
procedure PutString (data : string);
var i : word;
    c : string;
begin
  PutByte (byte(Length(data)));
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  for i := 1 to Length (data) do begin
    c := Copy (data, i, 1);
    PutByte (byte(c[1]));
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  end;
end;

{ =========================== TEXTMODE SUPPORT CODE ======================= }

Procedure Colors (text, back : byte);
begin
  TextColor (text);
  TextBackGround (back);
end;

procedure NormalScreen;
begin
  Colors (LightGray, Black);
  Window (1,1,MaxChar,MaxLine);
  ClrScr;
end;

Procedure CursorOn;
begin
  with r do begin
    AH := 1;
    CH := 6;
    CL := 7;
  end;
  Intr ($10, r);
end;

Procedure CursorOff;
begin
  with r do begin
    AH := 1;
    CH := $20;
  end;
  Intr ($10, r);
end;

Procedure PutChar (page : byte; cr : char);
begin
  if page <= MaxPage then with r do begin
    AH := 10;
    AL := ord(cr);
    BH := page;
    CX := 1;
    Intr ($10, r);
  end;
end;

Procedure Border (x1, y1, x2, y2 : integer; Bord : BorderType);
const c : array [BorderType, 1..6] of char =
	  ((#201, #205, #187, #186, #200, #188),
	   (#218, #196, #191, #179, #192, #217),
	   (#32,  #32,  #32,  #32,  #32,  #32));
var x, y, i : integer;
begin
  x := WhereX; y := WhereY;
  if not ((x1 < 1) or (x2 <= x1) or (y1 < 1) or (y2 <= y1) or (x2 > MaxChar)
  or (y2 > MaxLine) ) then begin
    GotoXY (x1, y1); write (c[Bord,1]);
    for i := 1 to x2-x1-1 do write (c[Bord,2]);
    write (c[Bord,3]);
    for i := 1 to y2 - y1 - 1 do begin
      GotoXY (x1, y1+i); write (c[Bord, 4]);
      GotoXY (x2, y1+i); write (c[Bord, 4]);
    end;
    GotoXY (x1, y2); write (c[Bord, 5]);
    for i := 1 to x2-x1-1 do write (c[Bord,2]);
    PutChar (0,c[Bord, 6]);
    GotoXY (x,y);
  end;
end;

procedure SetWindow (x1, y1, x2, y2 : integer; Bord : bordertype;
		     c1, b1, c2, b2 : byte; header : string);
begin
  if (x1 < 1) or (x2 > MaxChar) or (x1 >= x2) or (y2 > MaxLine) or
  (y1 >= y2) then exit;
  Colors (c1, b1);
  Window (x1, y1, x2, y2);
  ClrScr;
  Border (1,1,x2-x1+1,y2-y1+1,Bord);
  Colors (c2, b2);
  GotoXY ( ((MaxChar-Length(header)) div 2), 1);
  write (header);
  Colors (c1, b1);
  if Bord <> EmptyBorder then begin
    if x2-x1 > 2 then dec(x2);
    if y2-y1 > 2 then dec(y2);
    Window (x1+2, y1+2, x2, y2);
  end;
  GotoXY (1,1)
end;

{ ======================= AUXILARY HELPFUL PROCEDURES ===================== }

Function OctWord (data : word) : string;                  { word -> oct.str }
var s, s1 : string;
    i     : integer;
begin
  s1 := HexArray [ (data shr 15) and $01];
  i := 12;
  repeat
    s := HexArray [ (data shr i) and $07];
    s1 := s1 + s;
    i := i - 3;
  until i < 0;
  OctWord := s1;
end;

Function HexByte (data : byte; dlz : boolean) : string;   { byte -> hex.str }
var s1, s2 : char;
begin
  s1 := HexArray [(data shr 4) and $0F];
  s2 := HexArray [data and $0F];
  if (dlz = true) and (s1 = '0') then HexByte := s2 else
  HexByte := s1 + s2;
end;

Function HexWord (data : word; dlz : boolean) : string;   { word -> hex.str }
var s1, s2 : string;
begin
  s1 := HexByte (lo(data), false);
  s2 := HexByte (hi(data), dlz);
  HexWord := s2 + s1;
end;

{$S-}                                          { stack overflow checks off  }
procedure TimerHandler; interrupt;             { to help measure net delays }
  begin
    Ticker := Ticker + 1;
  end;
{$S+}                                          { stack overflow checking on }

{ Power := value ^ n }                         { value^N; missing in TP/BP  }
function Power (value, n : integer) : longint;
var p : longint;
    i : word;
begin
  p := 1;
  if n > 0 then for i := 1 to n do p := p * value;
  Power := p;
end;

{ < VAL_HEX > - Convert string with hexadecimal value to longint }
function Val_Hex (data : string) : longint;
var v, i, j, number : word;
begin
  v := 0;
  j := Length (data);
  while (j > 0) do begin
    number := 16;
    for i := 0 to 15 do if data [j] = HexArray [i] then number := i;
    if number = 16 then Val_Hex := -1;
    if number = 16 then exit;
    v := v + (number * (Power (16, (Length(data) - j) )));
    j := j - 1;
  end;
  Val_Hex := v;
end;

{ < Read_Config_File > - load and parse BKSERVER.CFG configuration file }
procedure Read_Config_File;
label 1;
const parse_Error : string[30] = 'Bad config file -- parse error';
var   Code        : integer;
      f1          : text;
      temp_str    : string;
      TimeOut_Str : string;
      IOBase_Str  : string;
      Name_Str    : string;
      i,j         : word;
begin
  {$I-}
  FileMode := 0; { Read Only }
  Assign (f1, cfgname);
  Reset (f1);
  if IOResult <> 0 then begin
    writeln ('Unable to load configuration file ', cfgname);
    Halt (1);
  end;
  readln (f1, temp_str); if IOResult <> 0 then begin
    writeln (parse_error, ': cannot retrieve AWARD_BIOS_FLAG bool variable');
    halt (1);
  end;
  if (temp_str = '1') or (temp_str = 'ON') or (temp_str = 'on') or (temp_str = 'ENABLE')
  or (temp_str = 'enable') then Award_BIOS_FLAG := true else Award_BIOS_FLAG := false;
  readln (f1, IOBase_Str); if IOResult <> 0 then begin
    writeln (parse_Error, ': failed to read base I/O port address');
    Halt (1);
  end;
  IOBase := Val_Hex (IOBase_Str);
  if IOBase = -1 then begin
    writeln (parse_Error, ': Invalid I/O port - ',IOBase_Str);
    Halt (1);
  end;
  readln (f1, TimeOut_Str); if IOResult <> 0 then begin
    writeln (parse_Error, ': unable to obtain timeout value');
    Halt (1);
  end;
  Verbose_Mode_Str := 'VERBOSE';
  readln (f1, Verbose_Mode_Str); if IOResult <> 0 then begin
    writeln (parse_error, ': error in VERBOSE/QUIET parameter');
    Halt (1);
  end;
  if verbose_mode_Str = 'verbose' then Verbose_Mode_Str := 'VERBOSE';
  if verbose_mode_Str = 'quiet' then Verbose_Mode_Str := 'QUIET';
  if (verbose_mode_str <> 'VERBOSE') and (verbose_mode_str <> 'QUIET') then begin
    writeln (parse_error, ': parameter must be either VERBOSE or QUIET');
    halt (1);
  end;
  readln (f1, temp_str); if IOResult <> 0 then begin
    writeln (parse_error, ': cannot retrieve CRIT_ERR_FLAG bool variable');
    halt (1);
  end;
  if (temp_str = '1') or (temp_str = 'ON') or (temp_str = 'on') or (temp_str = 'ENABLE')
  or (temp_str = 'enable') then Global_ExitIfIOError_flag := true else
  Global_ExitIfIOError_flag := false;
  Val (TimeOut_Str, Timeout, Code);
  if Code <> 0 then begin
    writeln (parse_Error, ': cannot convert Timeout value to integer');
    Halt (1);
  end;
  i := 0;
  while not (EOF(f1)) do begin
    readln (f1, Name_Str); if IOResult <> 0 then begin
      writeln (parse_Error, ': cannot obtain IMAGE file location');
      Halt (1);
    end;
    if Length (Name_Str) = 0 then goto 1;
    for j := 1 to Length(Name_Str) do if (Name_Str[j] = ';') or (Name_Str[j] = '$')
    then goto 1;
    ImageFileName [i] := Name_Str;
    i := i + 1;
  end;
1:
  if i > 0 then MaxOpenFiles := i-1 else MaxOpenFiles := 0;
  Close (f1);
end;

{ < ConvertToBig > - convert ImageFileName array to all - capitals }
procedure ConvertToBig;
var i, j : integer;
    ts   : string;
begin
  for i := 0 to MaxOpenFiles do begin
    ts := ImageFileName [i];
    for j := 1 to Length (ImageFileName[i]) do begin
      if (byte (ts[j]) >= 97) and (byte (ts[j]) <= 122) then
      ts [j] := char ( byte(ts[j]) - 32);
    end;
    ImageFileName [i] := ts;
  end;
end;

{ < Clear_IO_Buffer > - fills internal 512 byte sector buffer with zeroes }
procedure Clear_IO_Buffer;
var i : word;
begin
  for i := 0 to (BlockSize-1) do IO_Buffer [i] := $00;
end;

{ < Clear_BIG_Buffer > - clear all bytes of Big_Sector_Buffer }
procedure Clear_BIG_Buffer;
var dst_seg, dst_ofs : word;

begin
  dst_seg := Seg (big_sector_buffer^);
  dst_ofs := Ofs (big_sector_buffer^);
  asm
    mov  es, dst_seg                   { es := segment }
    mov  di, dst_ofs                   { di := offset  }
    mov  cx, max_buf_len               { bytes to fill }
    shr  cx, 1                         { words to fill }
    sub  ax, ax                        { zero filler   }
    cld                                { std direction }
    rep  stosw                         { es:di <- AX   }
  end;
end;

{                   procedure FillAccessAray
                   ==========================

   ᨢ AccessMode [0..16] 祭ﬨ:
  0       -  䠩  ࠧ  ० Read-Only
  2       -  䠩  ࠧ  ० Read-Write
  7+drive - 뫪  䨧᪨ drive (䫮) IBM PC
  66      - dummy value

  ஬ ஥ ᨢ AccessMode 楤 뢠 (Assign; Reset;
  Open) 䠩  ॡ㥬 ० (R/O  R/W)  뢠   䠩
  ६ f[i]
                                                                       }
procedure FillAccessArray;
var i            : word;
    drv_str      : string;
    drv_char     : char;
    drv_hit_flag : boolean;

begin
  for i := 0 to 16 do AccessMode [i] := 66;     { dummy value to avoid bugs }
  for i := 0 to MaxOpenFiles do begin
    drv_str      := '';
    drv_char     := 'A';
    drv_hit_flag := false;
    if (Copy (ImageFileName [i], 1, 1) <> '*') then begin
      Assign (f[i], ImageFileName[i]);
      {$I-}
      FileMode := 2;                            { try r/w access mode first }
      Reset (f[i], BlockSize);
      {$I+}
      if IOResult <> 0 then begin               { open error                }
        {$I-}
        FileMode := 0;                          { try read-only access mode }
        Reset (f[i], BlockSize);
        {$I+}
        if IOResult <> 0 then begin             { file missing or corrupted }
          writeln ('Unable to open ',ImageFileName[i]);
	  halt (1);
        end;                                    { if IOResult<>0 then begin }
        AccessMode [i] := 0;                    { R/O                       }
      end;                                      { if IOResult...            }
    end                                         { if Copy                   }
      else begin
        drv_str  := Copy (ImageFileName [i], 2, 1);
        drv_char := drv_str [1];
        if drv_char = '' then drv_char := 'A';
        if ord (drv_char) < ord('A') then drv_char := 'A';
        if ord (drv_char) > ord('Z') then drv_char := 'Z';
        AccessMode [i] := 7 + (ord (drv_char) - ord ('A'));
        drv_hit_flag := true;
      end;
    if (AccessMode [i] <> 0) and (drv_hit_flag = false)
    then AccessMode [i] := 2 else drv_hit_flag := false;
  end;                                          { for                       }
end;                                            { procedure                 }

procedure StartUp;                              { ========= Set up ======== }
begin
  Award_BIOS_FLAG := false;                     { allow multi-sector reads  }
  global_ShowDrivesMap_flag := false;           { M key is not pressed yet  }
  global_ExitIfIOError_flag := true;            { use FATAL exit if i/o err }
  CreateErrorLog := true;                       { CRASH : create ERROR.LOG  }
  Read_Config_File;                             { load BKSERVER.CFG file    }
  ConvertToBig;                                 { use uppercase names only  }
  FillAccessArray;                              { build AccessMode array    }
  DataPort := IOBase;                           { READ/write port (378h)    }
  StatusPort := DataPort + 1;                   { READ port (379h)          }
  CommandPort := DataPort + 2;                  { READ/WRITE port (37Ah)    }
  Port [DataPort] := $FF;                       { $FF->dataport,0 at BK side}
  Escape_Pressed_Flag := false;                 { Everything okay flag      }
  Timeout_Flag := false;                        { no timeout, all just fine }
  GetIntVec($1C, Int1CSave);                    { ** intercept vector 1C ** }
  SetIntVec($1C, Addr(TimerHandler));           { $1C=irq0 timer redirected }
  ftflag := 0;                                  { real floppy handler: flag }
  if MaxAvail < max_buf_len then begin
    writeln ('fatal error: cannot allocate ',max_buf_len,
    ' bytes for sector buffer');
    Halt (1);
  end;
  GetMem (big_sector_buffer,max_buf_len);       { allocate 127 sector buffer}
end;

procedure Cleanup;                              { == Cleanup before exit == }
var i, res : word;
begin
  SetIntVec($01C, Int1CSave);                   { Restore original 1C vector}
  Port [DataPort] := $FF;                       { $FF->dataport,0 at BK side}
  for i := 0 to MaxOpenFiles do if AccessMode [i] <= 2 then
    begin
      {$I-}
      Close (f[i]);
      res := IOResult;
      {$I+}
    end;
  FreeMem (big_sector_buffer,max_buf_len);      { Release allocated HEAP mem}
end;

{ < Write_Cond >-write data to screen only if Verbose_mode_Str = 'VERBOSE' }
procedure write_cond (data : string);
begin
  if verbose_mode_str = 'VERBOSE' then write (data);
end;

{ < WriteLn_Cond > - same as Write_Cond but with carriage return after data }
procedure writeln_cond (data : string);
begin
  if verbose_mode_str = 'VERBOSE' then writeln (data);
end;

{ < FileError > - write erraic filename to screen at DATA string&exit to DOS}
procedure FileError (data : string);
begin
  if Global_ExitIfIOError_flag = true then begin
    NormalScreen;
    writeln ('Image file ',data,' bad: access error #',operation_result);
    Cleanup;
    halt (0);
  end;
end;

{ < MoveData2IOBuffer > - copy 512 bytes of data from Big_Sector_Buffer,
  starting from current_offset_in_BIG_buffer to IO_Buffer array          }
procedure MoveData2IOBuffer;
var src_seg, src_ofs, dst_seg, dst_ofs : word;
begin
  src_seg := seg (big_sector_buffer^);
  src_ofs := ofs (big_sector_buffer^) + current_offset_in_BIG_buffer;
  dst_seg := Seg (IO_Buffer);
  dst_ofs := Ofs (IO_Buffer);
  asm
    push ds
    mov  ds, src_seg
    mov  si, src_ofs
    mov  es, dst_seg
    mov  di, dst_ofs
    mov  cx, 256                       { 256 words to copy;512 bytes total }
    cld
    rep  movsw
    pop  ds
  end;
end;

{ < Calculate_Track_Side_Sec > - calculate track,side & sector from block_n }
{  this code is DIRECT PORT from BY: driver by (c) copyright A. A. Sayapin! }

procedure calculate_track_side_sector (block_n : word); assembler;
asm                                     { we should keep BP, SP, SS, DS }
      clc
      mov     ax, block_n
      mov     cx, 8                     { 10 octal                      }
      mov     bh, sectors_per_track
      xor     bl, bl
@@1:  cmp     bx, ax
      ja      @@2
      sub     ax, bx
      stc
@@2:  rcl     ax, 1                     { RCL reg, 1 = ROL reg          }
      loop    @@1
      mov     track, al                 { track calc is done            }
      sub     al, al
      xchg    al, ah
      inc     ax                        { sector calc is ALMOST done    }
      mov     sector, al
      xor     bl, bl                    { side calculation started,DOWN }
      cmp     al, sectors_per_track
      jbe     @@3                       { JBE = BLE                     }
      inc     bl                        { 1 = UP side }
      mov     cl, sectors_per_track
      sub     sector, cl
@@3:  mov     side, bl                  { store side# (head) to memory  }
end;

{ < Read_One_Sector > - reads data from real IBM floppy to Big_Sector_Buffer}
function read_one_sector (block_n : word; drive : byte) : boolean;
var
    err_count              : byte;
    status                 : byte;
    IO_SEG, IO_OFS         : word;
    cur_secs               : byte;

begin
      status := 0;                      { assume OK }
      err_count := max_err_retries;
      calculate_track_side_sector (block_n);
      if     real_floppy_first_time_flag = true then begin (*read all first*)
        writeln (' REAL FLOPPY DRIVE=', drive,' block=', block_n,' track=',track, ' side=',side,' sector=',sector,
        ' sectors to rw=',sectors_to_rw);
        IO_SEG := Seg (big_sector_buffer^);
        IO_OFS := Ofs (big_sector_buffer^);
        actual_sec_transferred := 0;
        if Award_BIOS_Flag = true then  { AWARD dont support multi-sec read }
        asm
@@again:  xor     ax, ax                { func#0 - recalibrate  }
          mov     dl, drive
          int     13h			{ recalibrate (reset) drive DL }
          mov     al, 1                 { read just ONE sector }
          mov     ah, 02h		{ call BIOS floppy handler }
          mov     ch, track
          mov     cl, sector
          mov     dh, side
          mov     dl, drive
          mov     es, IO_seg            { es:bx - io buffer }
          mov     bx, IO_ofs
          int     13h                   { call BIOS to read real IBM floppy }
          jnc     @@good
          dec     err_count             { floppy error }
          jnz     @@again
          mov     ah, 0FFh              { set error flag at Status }
          jmp     @@quit
@@good:   sub     ah, ah
@@quit:   mov     status, ah
        end else

        asm
@@again:  mov     al, sectors_to_rw     { we must read sectors_to_rw sec-rs }
          mov     ah, sector            { first sector # }
          add     ah, al
          cmp     ah, 11
          jbe     @@go                  { all we need is just 1 int 13h read}
          xor     al, al                { calculate sec# needed for 1st read}
          mov     ah, sector
@@inc:    inc     al
          dec     sectors_to_rw
          inc     ah
          cmp     ah, 11
          jb      @@inc
          jmp     @@now
@@go:     mov     al, sectors_to_rw
          sub     ah, ah
          mov     sectors_to_rw, ah     { clear this field }
@@now:    mov     cur_secs, al
@@try:    cmp     ftflag, 0
          jne     @@read
          inc     ftflag                { ftflag = 0 here, increment it }
          xor     ax, ax                { func#0 - recalibrate  }
          mov     dl, drive
          int     13h			{ recalibrate (reset) drive DL }
@@read:   mov     al, cur_secs          { read cur_secs sectors }
          mov     ah, 02h		{ call BIOS floppy handler }
          mov     ch, track
          mov     cl, sector
          mov     dh, side
          mov     dl, drive
          mov     es, IO_seg            { es:bx - io buffer }
          mov     bx, IO_ofs
          int     13h                   { call BIOS to read real IBM floppy }
          jnc     @@ok                  { carry not set - no error }
          mov     ftflag, 0             { floppy error; we must recalibrate }
          mov     actual_sec_transferred, al
          dec     err_count
          jnz     @@try
          inc     ftflag                { do not recalibrate }
          mov     status, 0FFh          { set error flag at Status }
          jmp     @@exi                 { emergency exit }
@@ok:     mov     al, sectors_to_rw     { are we all done now?? }
          or      al, al
          je      @@done
          mov     cl, cur_secs          { we sucessfully read CL sectors }
          xor     ch, ch
          mov     bx, IO_Ofs
@@add:    add     bx, 512
          loop    @@add
          mov     IO_Ofs, bx            { update new IO_Offset              }
          mov     al, side
          or      al, al
          je      @@next
          inc     track                 { side was = 1, go to next track    }
          mov     side, 0               { start with UP side of that track  }
          mov     sector, 1             { all next reads start with sec#1   }
          jmp     @@again               { read the remainder of sectors     }
@@next:   inc     side                  { side was = 0, go to next side     }
          mov     sector, 1             { on same track,start with sec 1 now}
          mov     al, max_err_retries
          mov     err_count, al
          jmp     @@again
@@done:   mov     ah, 0                 { status := ok                      }
@@exi:    mov     status, ah
        end;
        if status <> 0 then read_one_sector := false else begin
         read_one_sector := true;
         real_floppy_first_time_flag  := false;
         current_offset_in_BIG_buffer := $0000;
         MoveData2IOBuffer;             { copy first portion of data }
         current_offset_in_BIG_buffer := current_offset_in_BIG_buffer + 512;
        end;
      end else begin                    { all other sequencional calls }
        if Award_BIOS_Flag = true then  { AWARD dont support multi-sec read }
        begin
          IO_SEG := Seg (big_sector_buffer^);
          IO_OFS := current_offset_in_BIG_buffer;
          asm
           jmp     @@skip
@@error:   xor     ax, ax               { func#0 - recalibrate  }
           mov     dl, drive
           int     13h			{ recalibrate (reset) drive DL }
@@skip:    mov     al, 1                { read just ONE sector }
           mov     ah, 02h		{ call BIOS floppy handler:READ f/n }
           mov     ch, track
           mov     cl, sector
           mov     dh, side
           mov     dl, drive
           mov     es, IO_seg           { es:bx - io buffer }
           mov     bx, IO_ofs
           int     13h                  { call BIOS to read real IBM floppy }
           jnc     @@okay
           dec     err_count            { floppy error }
           jnz     @@error              { go recalibrate and read again }
           mov     ah, 0FFh             { set error flag at Status }
           jmp     @@done
@@okay:    sub     ah, ah
@@done:    mov     status, ah
          end;
        end;
        if status = 0 then begin
          MoveData2IOBuffer;            { all the next read are from memory }
          current_offset_in_BIG_buffer := current_offset_in_BIG_buffer + 512;
          read_one_sector := true;
        end else read_one_sector := false;
      end;
end;

{ < Write_One_Sector >; write data from IO_Buffer to real IBM floppy drive }
function write_one_sector (block_n : word; drive : byte; n_blk:word) : byte;
var
    err_count              : byte;
    status                 : byte;
    IO_SEG, IO_OFS         : word;
    cur_secs               : byte;
begin
    status := 0;
    err_count := max_err_retries;
    calculate_track_side_sector (block_n);
    write(' WRITE TO REAL FDC DRIVE=',drive,' block=',block_n,'(',n_blk,')',
    ' track=',track, ' side=',side,' sector=',sector,'...');
    IO_SEG := Seg (IO_Buffer);
    IO_OFS := Ofs (IO_Buffer);
    asm
@@again:xor     ax, ax                  { fdc func #0 - recalibrate  }
        mov     dl, drive
        int     13h			{ recalibrate (reset) drive DL }
        mov     al, 1                   { write just ONE sector }
        mov     ah, 3		        { fdc func #3: write sector(s) }
        mov     ch, track
        mov     cl, sector
        mov     dh, side
        mov     dl, drive
        mov     es, IO_seg              { es:bx - io buffer }
        mov     bx, IO_ofs
        int     13h                     { call BIOS to write real IBM fdc }
        jnc     @@good
        dec     err_count               { floppy error }
        cmp     err_count, 0
        jne     @@again                 { go recalibrate and write again }
        mov     ah, 0FFh                { set error flag at Status }
        jmp     @@quit
@@good: sub     ah, ah
@@quit: mov     status, ah
    end;
    write_one_sector := status;
end;


{ < Show_Mapped_Drives >-show drives assignment table,depends on AccessMode }
procedure show_mapped_drives;
var i : word;
begin
  for i := 0 to MaxOpenFiles do begin
    Colors (Cyan, Blue);
    if AccessMode [i] = 0 then write ('R/O ') else
    {if AccessMode [i] = 2 then} write ('R/W ');
    Colors (LightRed, blue);
    if i = 0 then ch := 'A' else ch := chr(i+9+65);
    write   ('drive ',ch,': = ');
    if (AccessMode [i] <= 2) and (AccessMode [i] <> 66) then
    writeln (ImageFileName[i]) else writeln ('physical drive ',
    chr((AccessMode[i]-7)+ord('A')),':');
  end;
end;

{ < CPU_ID > - return intel central processor unit code;
  low byte:  generic code;
  high byte: specific code (zero if no specific CPU code available) }
function Cpu_ID : word; external;
{$L CpuID.obj }

{ < Func_Version > - called from Dispatcher; AF01 function implementation   }
procedure Func_Version;    { server identification / check is network is up }
var s, s1, s2, s3, cool_string : string;
begin
  Colors (Cyan, Blue);
  writeln (' -- Got VERSION/NETWORK SENSE request from client');
  write_cond ('Sending magic responce word to client...  ');
  PutWord (NETWORK_SENSE);
  if (Escape_Pressed_Flag = true) or (TimeOut_Flag = true) then
  writeln_cond ('FAIL');
  If (Escape_Pressed_Flag = true) or (TimeOut_flag = true) then exit;
  writeln_cond ('Okay');
  write_cond ('Sending server INFO string to client ...  ');
  str (Major_Version, s1);
  str (Minor_Version, s2);
  str (Server_Build,  s3);
  cool_string := 'BKLINK SERVER '+s1+'.'+s2+'/BUILD #'+s3+' IBM PC PLATFORM READY';
  PutString (cool_string);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('FAIL');
  if (Escape_Pressed_Flag = true) or (TimeOut_Flag = true) then exit;
  writeln_cond ('Okay');
  write_cond ('Sending server VERSION word to client ... ');
  PutWord ((Major_Version*256)+Minor_Version);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('FAIL');
  if (Escape_Pressed_Flag = true) then exit;
  writeln_cond ('Okay');
  write_cond ('Sending server FEATURES word to client... ');
  PutWord (Server_Features);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('FAIL');
  if (Escape_Pressed_Flag = true) then exit;
  writeln_cond ('Okay');
  s := GetString;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('*** NEGOTIATION FAILED - UNABLE TO RECEIVE CLIENT INFO STRING ***');
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  writeln_cond ('Received responce: client info string   = '+s);
  Client_Version := GetWord;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('*** NEGOTIATION FAILED - CANNOT RECEIVE CLIENT VERSION WORD ***');
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  Str (Hi(Client_Version), s1);
  Str (Lo(Client_Version), s2);
  writeln_cond ('Received responce: client version word  = '+s1+'.'+s2);
  Client_Features := GetWord;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
  writeln_cond ('*** NEGOTIATION ERROR - FAILED TO RECEIVE CLIENT FEATURES WORD ***');
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  writeln_cond ('Received responce: client features word = '+HexWord(Client_Features, false));
end;

{ < Func_GetFile > - called from Dispatcher; AF02 function implementation   }
procedure Func_Getfile;                      { function not implemented yet }
begin
end;

{ < Func_PutFile > - called from Dispatcher; AF03 function implementation   }
procedure Func_Putfile;                      { function not implemented yet }
begin
end;

{ < Func_SendTextFile >-called from Dispatcher; AF04 function implementation}
procedure Func_SendTestFile;                  { for network DEBUG purposes  }
var i : word;
begin
  write (' -- Sending 40000 bytes test pattern...');
  Randomize;
  for i := 1 to 16384 div 2 do begin
    PutWord (i);
    if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then
    writeln ('FAIL');
    if (Escape_Pressed_Flag = true) or (TimeOut_Flag = true) then exit;
  end;
  writeln ('Okay');
end;

{ < Func_ReadBlock > - called from Dispatcher;AF05 function implementation  }
{ *****  read data from image file/physical drive and send it to BK  ****** }
Procedure Func_ReadBlock;
label 1;
var Client_CRC, Server_CRC   : word;
    Client_Responce          : byte;
    number                   : word;
    word_count               : longint;
    drive_number             : byte;
    my_count, count2         : word;
    b1, b2                   : string;
    word_count_str           : string;
    count2_str               : string;
    virt_drive               : byte;
    word_style_word_count    : word;
begin
  Colors (LightGreen, Blue);
  write (' -- READ logical block ');
  drive_number := GetByte;
  if (Escape_Pressed_Flag = true) or (Timeout_flag = true) then writeln ('FAIL');
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  write ('from drive ', chr(drive_number+65)+':');
  if drive_number<>0 then drive_number := drive_number - 9;
  if drive_number > MaxOpenFiles then writeln (' - REJECTED');
  if drive_number > MaxOpenFiles then exit;
  virt_drive := 66;
  if (AccessMode [drive_number] >= 7) and (AccessMode [drive_number] <> 66)
  then begin
    virt_drive := AccessMode [drive_number] - 7;
    writeln (' (mapped to physical drive ',chr(virt_drive + ord('A')),':)');
  end else writeln (', accessing IMAGE file');
  block_number := GetWord;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  Str (Block_Number, b1);
  writeln_cond (' Block Number = '+OctWord(block_number)+' octal / '+b1+' decimal');
  word_style_word_count := GetWord;
  word_count := longint (word_style_word_count);
  sectors_to_rw := 0;
  if virt_drive <> 66 then asm
    mov    ax, word_style_word_count;
    mov    dx, 1
@@1:sub	   ax, 256
    js     @@2
    je     @@2
    inc    dx
    jmp	   @@1
@@2:mov    sectors_to_rw, dl		{ Sector(s) to r/w from real floppy }
  end;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  if (virt_drive <> 66) and (sectors_to_rw > 127) then
  writeln ('REAL FLOPPY - SECTOR COUNT (',sectors_to_rw,') OVERFLOW ERROR, MUST BE <= 127');
  if (virt_drive <> 66) and (sectors_to_rw > 127) then exit;
  count2 := word_count div (BlockSize div 2);
  if word_count > ((word_count div (blocksize div 2)) * (blocksize div 2))
  then count2 := count2 + 1;
  Str (count2, count2_Str);
  Str (word_count, word_count_str);
  writeln_cond (' Word Counter = '+OctWord(word_count)+' octal / '+word_count_str+' decimal ('+count2_str+' blocks total)');
  number := 1;
  real_floppy_first_time_flag := true;
  Clear_BIG_Buffer;
  while (word_count > 0) do begin
   Clear_IO_Buffer;                     { prepare small 0.5kb buf }
   operation_result := 0;               { assume all okay for now }
   if virt_drive = 66 then begin        { READing from IMAGE <66> }
     {$I-}                              { turn off i/o err checks }
     Seek (f [drive_number], block_number);
     operation_result := lo (IOResult);
     if operation_result <> 0 then FileError (ImageFileName [i]);
     BlockRead (f [drive_number], IO_Buffer, 1);
     operation_result := lo (IOResult);
     if operation_result <> 0 then begin
       FileError (ImageFileName [i]);
       exit;                            { fail bk client with timeout }
     end;
     {$I+}
   end else                             { READ from REAL IBM PC floppy }
     if read_one_sector (block_number, virt_drive) = false then
     begin
       Colors (LightRed, Blue);
       writeln ('FLOPPY FAILURE: START PARAMS WAS TRACK=',track,
        ' SIDE=',side, ' SECTOR=',sector, ' SECTORS LEFT=',sectors_to_rw);
       block_number := block_number + actual_sec_transferred;
       calculate_track_side_sector (block_number);
       writeln ('READ ERROR AT TRACK=',track, ' SIDE=',side, ' SECTOR=',sector);
       exit;                            { fail client with time-out error }
     end;
  1:
   Str (block_number, b1);
   Str (number, b2);
   write_cond (' Cur.Blk='+b1+' ('+b2+')');
   my_count := BlockSize div 2;
   if word_count < my_count then my_count := word_count;
   Str (my_count*2, b2);
   write_cond (' len='+b2);
   PutBlock (my_count*2);
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     Str (failed_i, b1);
     Str (failed_byte, b2);
     writeln_cond (', PutBlock FAILED at offset='+b1+', data='+b2);
     exit;
   end;
   Server_CRC := Calculate_CRC (my_count*2);
   write_cond (', Server CRC = '+HexWord (Server_CRC, false));
   PutWord (Server_CRC);
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   Client_CRC := GetWord;
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   write_cond (', Client CRC = '+HexWord (Client_CRC, false));
   Client_Responce := GetByte;
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   Str (Client_Responce, b1);
   write_cond (', R:'+b1);
   if (Client_CRC <> Server_CRC) or (Client_Responce <> 0) then begin
     writeln_cond (' ERROR');
     PutByte ($FE);
     if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
     goto 1;
   end;
   PutByte ($00);
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (',FAIL');
     exit;
   end;
   writeln_cond (' Ok');
   word_count := word_count - (BlockSize div 2);
   block_number := block_number + 1;
   number := number + 1;
  end;
  writeln_cond ('* NetBlockRead finished normally');
end;

{ < Func_WriteBlock > - called from Dispatcher;AF06 function implementation }
{ **** receive data from BK and write it to image file or real IBM fdc **** }
Procedure Func_WriteBlock;
label 1;
var Client_CRC, Server_CRC   : word;
    Client_Responce          : byte;
    number                   : word;
    word_count               : longint;
    word_style_word_count    : word;
    my_count, count2         : word;
    drive_number             : byte;
    virt_drive               : byte;
    b1, b2                   : string;
    count2_str               : string;
    word_count_str           : string;
begin
  Colors (Yellow, Blue);
  write (' -- WRITE logical block...');
  drive_number := GetByte;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then writeln ('FAIL');
  if (Escape_Pressed_Flag = true) or (TimeOut_Flag = true) then exit;
  write ('drive '+chr(drive_number+65)+':');
  if drive_number <> 0 then drive_number := drive_number - 9;
  if drive_number > MaxOpenFiles then writeln (' - REJECTED');
  if drive_number > MaxOpenFiles then exit;
  virt_drive := 66;
  if (AccessMode [drive_number] = 0) or (AccessMode [drive_number] = 66) then
  begin
    Colors (LightRed, Blue);
    writeln (' Error - Image file is READ ONLY!');
    PutByte ($FF);			{ report write FAILURE to BK client }
  end;
  if (AccessMode [drive_number] = 0) or (AccessMode [drive_number] = 66) then
  exit;
  if (AccessMode [drive_number] >= 7) and (AccessMode [drive_number] <> 66)
  then begin
    virt_drive := AccessMode [drive_number] - 7;
    writeln (' (mapped to physical drive ',chr(virt_drive + ord('A')),':)');
  end else writeln (', accessing IMAGE file');
  PutByte ($00);			{ report ACCEPTED (zero) to client }
  if (Escape_Pressed_Flag = true) or (TimeOut_Flag = true) then exit;
  block_number := GetWord;
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  Str (block_number, b1);
  writeln_cond (' Block Number = '+OctWord(block_number)+' octal / '+b1+' decimal');
  word_style_word_count := GetWord;     { receive words to write from BK }
  word_count := longint (word_style_word_count);
  if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
  count2 := word_count div (BlockSize div 2);
  if word_count > ((word_count div (blocksize div 2)) * (blocksize div 2))
  then count2 := count2 + 1;
  Str (count2, count2_Str);
  Str (word_count, word_count_str);
  writeln_cond (' Word Counter = '+OctWord(word_count)+' octal / '+word_count_str+' decimal ('+count2_str+' blocks total)');
  number := 1;
  while (word_count > 0) do begin
  Clear_IO_Buffer;                      { prepare I/O buffer for GetBlock }
  operation_result := 0;                { assume all ok for now }
  1:
   Str (block_number, b1);
   Str (number, b2);
   write_cond (' Current Block = '+b1+' ('+b2+')');
   my_count := BlockSize div 2;         { 512 bytes / 256 words by default }
   if word_count < my_count then my_count := word_count;       { remainder }
   GetBlock (my_count*2);               { receive blk from BK to IO_buffer }
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   Server_CRC := Calculate_CRC (my_count*2);
   write_cond (', Server CRC = '+HexWord (Server_CRC, false));
   PutWord (Server_CRC);
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   Client_CRC := GetWord;
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   write_cond (', Client CRC = '+HexWord (Client_CRC, false));
   Client_Responce := GetByte;
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond (', FAIL');
     exit;
   end;
   Str (Client_Responce, b1);
   write_cond (', R: '+b1);
   if (Client_CRC <> Server_CRC) or (Client_Responce <> 0) then begin
     writeln_cond (' ERROR');
     PutByte ($FE);
     if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then exit;
     goto 1;
   end;
   writeln_cond (' OK');                { all CRC checks passed; Hooray !! }
   if virt_drive = 66 then begin        { --- image file --- }
     {$I-}
     Seek (f [drive_number], block_number);
     operation_result := lo (IOResult);
     if operation_result <> 0 then FileError (ImageFileName[i]);
     BlockWrite (f [drive_number], IO_Buffer, 1);
     operation_result := lo (IOResult);
     if operation_result <> 0 then FileError (ImageFileName[i]);
     {$I+}
   end else begin                       { --- real ibm pc floppy drive --- }
     operation_result := write_one_sector (block_number,virt_drive, number);
     if operation_result = 0 then writeln ('PASS') else begin
       Colors (LightRed, Blue);
       writeln ('FAIL');
     end;
   end;
   PutByte (operation_result);          { report OK or FAILURE to BK client }
   if (Escape_Pressed_Flag = true) or (Timeout_Flag = true) then begin
     writeln_cond ('ABORTED');
     exit;
   end;
   if operation_result <> 0 then exit;  { exit if fdc write fail / io error }
   word_count := word_count - (BlockSize div 2);
   block_number := block_number + 1;
   number := number + 1;
  end;                                  { while (word_count > 0) }
  writeln_cond ('* NetBlockWrite finished normally');
end;

{ < Func_Format > - called from Dispatcher; AF07 function implementation    }
procedure Func_Format;                                { AF07 - format drive }
begin
end;

{ < Dispatcher > - main service:receive function# and call proper procedure }
Procedure Dispatcher;
var func : word;
    ch   : char;
label 1,2;
begin
  repeat
2:
  Colors (White, Blue);
  write  (CmdPromptString);
1:func := 0;
  Timeout_Flag := false;
  Escape_Pressed_Flag := false;
  Ticker := 0;
  Func := GetWord;
  if Global_ShowDrivesMap_flag = true then begin
     writeln;
     global_ShowDrivesMap_flag := false;
     show_mapped_drives;
     Colors (white, blue);
     if timeout_flag = true then write (CmdPromptString);
  end;
  if TimeOut_Flag = true then goto 1;
  if Escape_Pressed_Flag = true then begin
    writeln;
    write ('ESCAPE signal, please confirm quit by pressing ESC again... ');
    Ticker := 0;
    ch := #00;
    repeat
      if keypressed then ch := ReadKey;
    until (Ticker > 18*2) or (ch = #27);
    Ticker := 0;
    if ch = #27 then exit else begin
                                writeln ('cancelled');
                                goto 2;
  end;                         end;
  write (HexWord (Func, false));
  case Func of
    $AF01 : Func_Version;               { net sense / check      }
    $AF02 : Func_Getfile;               { read file from client  }
    $AF03 : Func_Putfile;               { write file from client }
    $AF04 : Func_SendTestFile;          { debug: send test file  }
    $AF05 : Func_ReadBlock;             { read logical block     }
    $AF06 : Func_WriteBlock;            { write logical block    }
    $AF07 : Func_Format;                { format image / drive   }
  else writeln (' -- invalid/unsupported code received');
  end;
  until false;
end;


begin { ------------------------------- MAIN ----------------------------- }
  Startup;
  ClrScr;
  Str (Major_Version, s1);
  Str (Minor_Version, s2);
  Str (Server_Build, s3);
  Version_String := s1 + '.' + s2 + ' build '+s3;
  SetWindow (1,1,MaxChar,MaxLine,DoubleBorder,LightGray,Blue,White,Green,
  ' Bk/Link version '+Version_String+' -- Server is running ');
  Colors (Yellow, Blue);
  msec := Timeout / 18;
  write ('Setup: Max Timeout=',msec:6:2,'s, I/O Port=',
  HexWord(DataPort, true),'  CPU=');
  case lo(cpu_ID) of
    0  : write ('intel 8086/i8088 - compatible');
    1  : write ('i80186 or i80188 - compatible');
    2  : write ('i286-compatible, at real mode');
    3  : write ('286-compatible,protected mode');
    4  : write ('intel/AMD 386sx/dx, real mode');
    5  : write ('intel/AMD 386, protected mode');
    6  : write ('intel/AMD 486sx/dx, real mode');
    7  : write ('486-compatible,protected mode');
    8  : write ('Intel/AMD Pentium-class, real');
    9  : write ('Pentium-class, protected mode');
    10 : write ('Pentium 2/Pro/3/4+, real mode');
    11 : write ('Pentium 2/Pro/3/4+, protected');
    12 : write ('Pentium 4 or Athlon, realmode');
    13 : write ('Pentium 4 or Athlon,protected');
  else   begin
         write ('unknown x86 processor,code=');
         s3 := HexByte (lo(cpu_id), false);
         write (s3);
         end;
  end;
  writeln;
  write   ('Heap=',MemAvail+max_buf_len, ' total;');
  writeln ('Largest free=', MaxAvail, ';ESC twice to shut down, M to show MAP');
  write   ('AWARD_BIOS_FLAG = ',Award_BIOS_FLAG, ', multi-sector FDC read is ');
  if Award_BIOS_FLAG = true then writeln ('DISABLED, slow real floppy') else
  writeln ('ON  (only with AMI BIOS!)');
  write   ('DEBUG_MSG=');
  if verbose_mode_str = 'VERBOSE' then write ('VERBOSE') else
  write ('SILENCE');
  write (';  Crit_Error_Flag: ');
  if global_ExitIfIOError_flag = true then write ('TRUE ') else
  write ('FALSE');
  write (' (fatal exit on i/o error is ');
  if global_ExitIfIOError_flag = true then writeln ('ON!)') else
  writeln ('OFF)');
  Colors (LightRed, blue);
  writeln;
  show_mapped_drives;
  writeln;
  Dispatcher;
  NormalScreen;
  write ('Cleaning up... ');
  Cleanup;
  writeln ('exiting');
end.  { ------------------------------------------------------------------ }
