
{> Cut here. FileName= CRASH.MSG 
    Hi, All !

  ᥬ   run-time errors, p  CRASH.TPx, p p
 뤠 楯 맮, p  p (ᯮ pp
⥪).   ExitProc  Exception 13. ⢥ 祣   -
 ⫠ ⥪ p㡥p (stack overflow).   㥬.
    p졥,  -쪮

Run-time errors tracer for pascal

 p᭮, p  2:4641/41 22.00-8.00 䠩 crash.rar.}


{   祣  ᯮ,  ⮫쪮  ணࠬ  }
{ 楯 室.  ਩ 襭  ணࠬ 뢮   }
{ ᯫ 楯 ᮢ 맮,  ਢ  訡...          }
{  ଠ쭮 ࠡ   ᫥    ᥪ樨     }
{ USES ணࠬ (  ).                                         }
{ Written by A. Guts. Oct 94, Jan 95.                        Good luck! }

unit Crash;
{$IFDEF DPMI}
{$C FIXED PRELOAD PERMANENT}
{$ELSE}
{$O-}
{$ENDIF}

{$S-,R-,I-,Q-}

interface

type
  FStr = string[79];

const
  CreateErrorLog: boolean = false;
  LogFileName: FStr = 'ERROR.LOG';
  
implementation

uses objects;

const
  MaxStkDump = 63;

var
  additional_zero : string [1];
  add_zero_2month : string [1];
  SaveExit: pointer;
  SPLimit : word;
  VMode   : byte;

{$IFDEF DPMI}

var
  ErrCode: Word;
  _AX,_BX,_CX,_DX,_SI,_DI,_BP,_DS,_ES,_Flags: Word;
  limDS, limES, limSS: longint;
  Stk: Pointer;
  At:  Pointer;
  StkDump: array[0..MaxStkDump] of Word;

procedure SaveGPhandler; near; assembler;
asm
        dd 0
end;

procedure GPhandler; near; assembler;
asm
        push bp
        mov bp,sp
        push ds
        push ax
        mov ax,seg @DATA
        mov ds,ax
        mov _BX,bx
        mov _CX,cx
        mov _DX,dx
        mov _SI,si
        mov _DI,di
        mov ax,[bp-4]
        mov _AX,ax
        mov ax,[bp]
        mov _BP,ax
{ Stack context relative bp:
-04h    WORD    saved AX
-02h    WORD    saved DS
 00h    WORD    saved BP
 02h    DWORD   return CS:IP
 06h    WORD    error code
 08h    DWORD   CS:IP of exception
 0Ch    WORD    flags
 0Eh    DWORD   SS:SP }
        mov ax,[bp+6]
        mov ErrCode,ax
        mov ax,[bp+8]
        mov word ptr At,ax
        mov ax,[bp+0Ah]
        mov word ptr At+2,ax
        mov ax,[bp+0Ch]
        mov _Flags,ax
        mov ax,[bp+0Eh]
        mov word ptr Stk,ax
        mov ax,[bp+10h]
        mov word ptr Stk+2,ax
        mov ax,[bp-2]
        mov _DS,ax
        mov _ES,es
        pop ax
        cmp Test8086,1
        jne @@386
        push ax
        push bx
        mov ax,[bp-2] { ds }
        lsl bx,ax
        jnz @@1
        mov word ptr limDS,bx
@@1:    mov ax,es
        lsl bx,ax
        jnz @@2
        mov word ptr limES,bx
@@2:    mov ax,[bp+0Eh]
        lsl bx,ax
        jnz @@3
        mov word ptr limSS,bx
@@3:    pop bx
        pop ax
        jmp @@Q
@@386:  db 66h; push ax                 { push eax }
        db 66h; push bx                 { push ebx }
        db 66h; xor ax,ax               { xor eax,eax }
        mov ax,[bp-2] { ds }
        db 66h; lsl bx,ax               { lsl ebx,eax }
        jnz @@01
        db 66h; mov word ptr limDS,bx   { mov limDS, ebx }
@@01:   mov ax,es
        db 66h; lsl bx,ax
        jnz @@02
        db 66h; mov word ptr limES,bx
@@02:   mov ax,[bp+10h]
        db 66h; lsl bx,ax
        jnz @@03
        db 66h; mov word ptr limSS,bx
@@03:   db 66h; pop bx                  { pop  ebx }
        db 66h; pop ax                  { pop  eax }
@@Q:    pop ds
        pop bp
        jmp dword ptr cs:[offset SaveGPhandler]
end;

procedure SetGPhandler; near; assembler;
asm
        mov ax,202h
        mov bx,13
        int 31h
        jc @@Q
        mov ax,cs
        add ax,8    { alias selector }
        mov es,ax
        mov bx,offset SaveGPhandler
        mov es:[bx],dx
        mov es:[bx+2],cx
        mov ax,203h
        mov bx,13
        mov cx,cs
        mov dx,offset GPhandler
        int 31h
@@Q:
end;

{$ENDIF}

{ in: dx:ax - address, cx,di leave unchanged }
function  IsCallerCode: word; near; assembler;
asm
{$IFDEF DPMI}
        verr dx      { can read ? }
        jnz @@N      { no, invalid }
        verw dx      { can write ? }
        jz @@N       { no, it is not code segment }
        lsl bx,dx    { offset is out of segment ? }
        cmp ax,bx
        ja @@N       { yes, invalid }
        mov bx,ax    { analyse opcode for far calls }
        mov es,dx
        cmp bx,7
        jb @@1
        cmp byte ptr es:[bx-5],9Ah { direct far call ? }
        jne @@1                    { no, analyse another call type }
        mov ax,es:[bx-2]           { test segment part of call target }
        verr ax
        jnz @@1
        verw ax
        jz @@1
        lsl dx,ax                  { test offset part of call target }
        cmp es:[bx-4],dx
        jbe @@Y
        jmp @@N
@@1:    cmp bx,5
        jb @@N
        cmp word ptr es:[bx-3],5DFFh { check opcode for call far [di+XX] }
        jne @@N
{$ELSE}
        cmp dx,seg @data  { check for code range }
        jae @@N
        mov bx,PrefixSeg
        add bx,10h
        cmp dx,bx
        jb @@N
        mov es,dx
        xchg bx,ax
        cmp byte ptr es:[bx-5],9Ah
        jne @@1
        mov dx,word ptr es:[bx-2]
        cmp dx,seg @data
        jae @@1
        cmp dx,ax
        jae @@Y
        jmp @@N
@@1:    cmp word ptr es:[bx-3],5DFFh
        jne @@N
{$ENDIF}
@@Y:    clc
        retn
@@N:    stc
end;

{$IFNDEF WINDOWS}

const
  MaxPasses = 24;
  ErrorList : array[0..MaxPasses-1] of word =
       (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  Count: Integer = 0;

procedure IntStr; near; assembler;
{
; Convert integer to string
; In    DX:AX = Value
;       ES:DI = String pointer
; Out   CX    = String length
;       ES:DI = String pointer
 }
asm
        PUSH    DI
        CLD
        MOV     BX,AX
        OR      DX,DX
        JGE     @@1
        NOT     BX
        NOT     DX
        ADD     BX,1
        ADC     DX,0
        MOV     AL,'-'
        STOSB
@@1:    MOV     SI,OFFSET @Pwr10Tab
        MOV     CL,9
@@2:    CMP     DX,CS:[SI+2]
        JB      @@3
        JA      @@4
        CMP     BX,CS:[SI]
        JAE     @@4
@@3:    ADD     SI,4
        DEC     CL
        JNE     @@2
@@4:    INC     CL
@@5:    MOV     AL,'0'-1
@@6:    INC     AL
        SUB     BX,CS:[SI]
        SBB     DX,CS:[SI+2]
        JNC     @@6
        ADD     BX,CS:[SI]
        ADC     DX,CS:[SI+2]
        ADD     SI,4
        STOSB
        DEC     CL
        JNE     @@5
        MOV     CX,DI
        POP     DI
        SUB     CX,DI
        RETN

@Pwr10Tab:

        DD      1000000000
        DD      100000000
        DD      10000000
        DD      1000000
        DD      100000
        DD      10000
        DD      1000
        DD      100
        DD      10
        DD      1
end;

procedure Digits; near; assembler;
asm
        db '0123456789ABCDEF'
end;

function HexW(W : Word) : String; near; assembler;
asm
        mov bx,offset Digits
        les di,@Result
        mov al,4
        cld
        stosb
        mov cx,4
        mov dx,W
@@1:    rol dx,4
        mov al,dl
        and al,15
        segcs xlat
        stosb
        loop @@1
end;

function Hex(L : LongInt) : String; near; assembler;
asm
        mov bx,offset Digits
        les di,@Result
        mov al,8
        cld
        stosb
        mov cx,4
        mov dx,word ptr L+2
        call @@1
        mov dx,word ptr L
        mov cx,4
        call @@1
        jmp @@Q

@@1:    rol dx,4
        mov al,dl
        and al,15
        segcs xlat
        stosb
        loop @@1
        retn

@@Q:
end;

function Int2Str(I : Integer) : String; near; assembler;
asm
        les di,@Result
        inc di
        mov ax,I
        cwd
        call IntStr
        dec di
        mov es:[di],cl
end;

procedure ProcessStack; near; assembler;
asm
{$IFDEF DPMI}
        cmp ExitCode,216
        jne @@NotGP
        mov ax,203h
        mov bx,13
        mov cx,word ptr cs:[(offset SaveGPhandler)+2]
        mov dx,word ptr cs:[offset SaveGPhandler]
        jcxz @@NotGP
        int 31h
@@NotGP:
{$ENDIF}
        mov ax,word ptr ErrorAddr+2
        or ax,word ptr ErrorAddr
        jz @@Q
        xor ax,ax
        mov al,VMode
        int 10h

        push bp
        mov di,offset ErrorList
        cld
        mov cx,MaxPasses
@@3:    cmp bp,SPlimit
        ja @@1
        mov  ax,[bp+2]
        mov dx,[bp+4]
        call IsCallerCode
        jnc @@2
        add bp,2 { process next word in stack }
        jmp @@3

@@2:    mov [di],bp
        inc Count
        add di,2
        mov bp,[bp]
        loop @@3
@@1:    pop bp
@@Q:    mov ax,word ptr SaveExit
        mov word ptr ExitProc,ax
        mov ax,word ptr SaveExit+2
        mov word ptr ExitProc+2,ax
end;

procedure Display(S: String); near; assembler;
asm
        les si,S
        xor cx,cx
        mov cl,es:[si]
        jcxz @@Q
        inc si
@@1:    mov ah,14
        cld
        seges lodsb
        mov bx,7
        push bp
        int 10h
        pop bp
        loop @@1
@@Q:
end;

var Log: TDosStream;

procedure OutLine(M: String); near;
begin
  M := M+^M^J; Display(M);
  if CreateErrorLog then Log.Write(M[1],Length(M));
end;

var
  Date: record
    D,M: Byte;
    Y: Word;
  end;

  Time: record
    H,M: Byte;
  end;

procedure GetDate; near; assembler;
asm
        mov ah,2Ah
        int 21h
        mov Date.D,dl
        mov Date.M,dh
        mov Date.Y,cx
end;

procedure GetTime; near; assembler;
asm
        mov es,seg0040
        pushf
        cli
        mov ax,es:[$6C]
        mov dx,es:[$6E]
        popf
        mov bx,65520
        div bx
        mov Time.H,al
        mov ax,dx
        xor dx,dx
        mov bx,1092
        div bx
        mov Time.M,al
end;

function  StackAddr(Frame: Word): Longint; near; assembler;
asm
        mov bx,Frame
        mov ax,ss:[bx+2]
        mov dx,ss:[bx+4]
{$IFDEF DPMI}
        mov es,dx
        mov dx,es:[0]
{$ELSE}
        sub dx,PrefixSeg
        sub dx,10h
{$ENDIF}
end;

procedure Report; near;
type
  PRec = record
    O,S: Word;
  end;

var
  err_descr : string;
  I: Integer;
  S: String[87];
  L: LongInt;

begin
  if ErrorAddr = nil then Exit;
  if CreateErrorLog then begin
    Log.Init(LogFileName,stOpen);
    if Log.Status <> stOk then begin
      Log.Done; Log.Init(LogFileName,stCreate);
    end else Log.Seek(Log.GetSize);
  end;
  GetDate;
  GetTime;
  additional_zero := '';
  if Time.M < 10 then additional_Zero := '0';
  add_zero_2month := '';
  if Date.M < 10 then add_zero_2month := '0';

  S := Int2Str(Date.D)+'.' + Add_Zero_2Month + Int2Str(Date.M)
  +'.'+Int2Str(Date.Y)+', '+Int2Str(Time.H)+':'+additional_zero
  +Int2Str(Time.M)+', runtime error '+Int2Str(ExitCode)+'.';
  err_descr := '';
  case ExitCode of
    1  : err_descr := 'File not found';
    3  : err_descr := 'Path not found';
    4  : err_descr := 'Too many open files';
    5  : err_descr := 'File access denied';
    6  : err_descr := 'Invalid file handle';
    12 : err_descr := 'Invalid file access code';
    15 : err_descr := 'Invalid drive number';
    16 : err_descr := 'Cannot remove current directory';
    17 : err_descr := 'Cannot rename across drives';
    100: err_descr := 'Disk read error:READ behind end of file';
    101: err_descr := 'Disk write error';
    102: err_descr := 'File not assigned';
    103: err_descr := 'File not opened';
    104: err_descr := 'File not open for input';
    105: err_descr := 'File not open for output';
    106: err_descr := 'Invalid numeric format';
    150: err_descr := 'Disk is write protected';
    151: err_descr := 'Unknown unit';
    152: err_descr := 'Drive not ready';
    153: err_descr := 'Unknown command';
    154: err_descr := 'CRC error in data';
    155: err_descr := 'Bad drive request';
    156: err_descr := 'Disk seek error';
    157: err_descr := 'Unknown media type';
    158: err_descr := 'Sector not found';
    159: err_descr := 'Printer is out of paper';
    160: err_descr := 'Device write fault';
    161: err_descr := 'Device read fault';
    162: err_descr := 'Hardware failure';
    200: err_descr := 'Division by zero';
    201: err_descr := 'Range checking error';
    202: err_descr := 'Stack overflow';
    203: err_descr := 'Heap overflow error';
    204: err_descr := 'Invalid pointer operation';
    205: err_descr := 'Floating point overflow';
    206: err_descr := 'Floating point underflow';
    207: err_descr := 'Invalid floating point operation';
    208: err_descr := 'Overlay not installed';
    209: err_descr := 'Overlay file read error';
  end;

  OutLine(S+' '+err_descr);
  OutLine('Call stack:');
  S := '';
  for I := Count-1 downto -1 do begin
    if I > -1 then L := StackAddr(ErrorList[i])
    else L := LongInt(ErrorAddr);
    S := S+HexW(PRec(L).S)+':'+HexW(PRec(L).O)+' '#26' ';
    if Length(S) >= 60 then begin
      OutLine(S); S := '';
    end;
  end;
  if Length(S) > 3 then begin
    Dec(Byte(S[0]),3); OutLine(S);
  end;
  OutLine('---------------------------------------'+
          '---------------------------------------');
{$IFDEF DPMI}
  if ExitCode = 216 then begin
    OutLine('General protection fault context:');
    OutLine('Address '+HexW(PRec(At).S)+':'+HexW(PRec(At).O)+
            ', error code '+HexW(ErrCode));
    OutLine('Stack '+HexW(PRec(Stk).S)+':'+HexW(PRec(Stk).O)+
            ', limit='+Hex(limSS)+'h');
    OutLine('AX='+HexW(_AX)+' BX='+HexW(_BX)+
           ' CX='+HexW(_CX)+' DX='+HexW(_DX)+^M^J+
            'SI='+HexW(_SI)+' DI='+HexW(_DI)+
           ' BP='+HexW(_BP)+' FL='+HexW(_Flags));
    OutLine('DS='+HexW(_DS)+', limit='+Hex(limDS)+'h'+^M^J+
            'ES='+HexW(_ES)+', limit='+Hex(limES)+'h');
  end;
{$ENDIF}
  OutLine('');
  if CreateErrorLog then Log.Done;
end;

procedure CrashExit; far; assembler;
asm
        call ProcessStack
        call Report
end;

begin
{$IFDEF DPMI}
  SetGPhandler;
{$ENDIF}
  SaveExit := ExitProc;
  ExitProc := @CrashExit;
  SPlimit  := Sptr-8;
  VMode := Mem[seg0040:$49];
{$ENDIF}
end.
