; ===========================================================================
;
; ࠩ LPT-Link',  ASM.EXE by A.Osipov  ࠧ饭 
;  170000 (    ஫ ᪮ -0011).饭
;  ਢ A:  K: - Z: 墠뢠 ( 稨 ).
;    ᯮ짮 ⥪, ࠢ  .
; ᫥ ॢ: 23.11.2002, 0:00  (c) copyright Alex Savelev / DWG
;
;   BK IN port (177714o)      |   PC Out LPT Dataport (WRITE 378h)
; ----------------------------+----------------------------------------------
;  Bit 14, B29 40000o <-- inverted --* bit 3  mask 08h, PIN 5 on DB25
;  Bit 13, A29 20000o <-- inverted --* bit 2  mask 04h  PIN 4
;  Bit 12, B30 10000o <-- inverted --* bit 1  mask 02h  PIN 3
;  Bit 11, A32 4000o  <-- inverted --* bit 0  mask 01h  PIN 2
;
;  BK Out port (177714o)      |   PC LPT Input StatusPort (READ 379h)
;
; Bit 11, B27 4000o *---- normal ----> bit 7, BSY  signal mask 80h, PIN 11
; Bit 10, A27 2000o *--- inverted ---> bit 5, PE   signal mask 20h, PIN 12
; Bit 9,  B28 1000o *--- inverted ---> bit 4, SLCT signal mask 10h, PIN 13
;
; GROUND AB11,18,19 *----------------* PIN 18, 19, 20, 21, 22, 23, 24, 25

	.psect  170000                  ; network addon to 327 FDC/HDD driver
	senddl=130                      ; timer div=4, single pass on, start!
	rcvdl=70			; timer div=16,single pass on, start!
        fastdl=13000			; was:5670 (for 2nd and future check)
        vfd=2500                        ; delay for very fast check
	vlong=177776			; very long timer delay (~11 seconds)

id_str: .asciz  /LPT-NETWORK DRIVER V1.5 (C) DWG!/

; ===========================================================================
;
;                      LPT LINK - LOW LEVEL NETWORK I/O
;
; ===========================================================================


; < F_Rcv4 >
;
; ਥ 4 ⮢  R0. 4 㫥  । 栬 (0  ).
; ⠭  C  ⠩. ᯮ⥫쭠 楤  GetByt.
;   祭 ॣ஢ ஬ R0
;
f_rcv4: mov     r1, -(sp)
        mov     r2, -(sp)
        mov     #177712, r1
	mov     #rcvdl, @r1             ; 45 sec delay for receive
2:      mov     @#177714, r2
	bic     #103777, r2
	cmp     #74000, r2              ; wait until PC writes 00 to dataport
	beq     1
	bit     #20, @r1
	bne     2
5:      clr     @#177714                ; end with PC: BSY=0, PE=1, SLCT=1
	sec                             ; erraic end
7:      mov     (sp)+, r2
        mov     (sp)+, r1
	rts     pc
1:      mov     #4000, @#177714         ; PC: BSY=1, PE=1, SLCT=1
	mov     #rcvdl, @r1             ; 45 sec delay for receive
3:      mov     @#177714, r2
	bic     #103777, r2
	cmp     #74000, r2              ; wait until PC removes 0 from port
	bne     4
	bit     #20, @r1
	bne     3
	br      5
4:      mov     @#177714, r0	        ; finally receive 4 bit data from PC
	mov     #13, r2
6:      asr     r0
	sob     r2, 6
	com     r0
	bic     #177760, r0
	clr     @#177714                ; end with PC: BSY=0, PE=1, SLCT=1
	clc                             ; all ok
	br      7                       ; jump to exit


; < GetByt>
;
; ਥ   R0. ⠭  C  ⠩. ᯮ
; 楤 F_RCV4. R1, R2 ࠭  ⠭.
;
getbyt: mov     r1, -(sp)
	mov     r2, -(sp)
	call    f_rcv4                  ; ਥ ࢮ ࠤ  R0
	bcs     1
	mov     r0, r1                  ; R1 := ࢠ ࠤ
	call    f_rcv4                  ; ਥ ன ࠤ  R0
	bcs     1
	mov     r0, r2                  ; R2 :=  ࠤ
	call    f_rcv4                  ; ਥ .  answer  R0
	bcs     1
	cmpb    r0, #1                  ; both tetrades was non-zero?
	beq     2                       ; yes - goto 2 (assemble final byte)
	cmpb    r0, #2                  ; only low 4 bits was zero?
	bne     3                       ; NO - goto 3
	clr     r1                      ; .ࠤ=0 ( r1):clear low 4bits
	br      2                       ; go assemble final byte
3:      cmpb    r0, #3                  ; only high 4 bits was zero?
	beq     4                       ; yes - goto 4
	clr     r0                      ; answer = 4 (all the byte was zero!)
	br      1
4:      clr     r2                      ;  ࠤ=0 (   r2)
2:      clr     r0                      ; ᮡࠥ ᫠     r0
	bis     r1, r0
	asl     r2
	asl     r2
	asl     r2
	asl     r2
	bis     r2, r0
1:      mov     (sp)+, r2
	mov     (sp)+, r1
	rts     pc


; < PutBit >
;
; Put TWO bits in LOW BYTE/LOW BITS of R0 TO PC. Set bit C if operation timed
; out. Used internally by PutByt (see below).
; Registers usage: R1, R2 (saved & restored properly), R0 (TRASHED !!!)
;
; Entry point: R0 = bits to send (low byte/low bits)
;
putbit: clr     @#177714                ; start with PC: BSY=0, PE=1, SLCT=1
	mov	r1, -(sp)
	mov	#177712, r1
	mov     r2, -(sp)
	mov     #senddl,@r1             ; START TIMER, 11 sec SEND delay (6)
10:     mov     @#177714, r2            ; get lpt-link port value
	bic     #103777, r2		; remove 1 000 011 111 111 111
	beq     5			; goto 5 if zeroes on bits 14-11
	bit     #20, @r1	        ; timer still counting??
	bne     10		        ; yes - goto 10
	br      11		        ; timer stopped, fire exit!
5:      com     r0                      ; prepare (invert) data
	bic     #177774, r0             ; bsy=0, clear all except data bits
	mov     #11, r2                 ; = 9 decimal
2:      asl     r0
	sob     r2, 2                   ; shift bit in r0 to pos.9 slct/10 PE
	bis     #4000, r0               ; add bsy = 1 (position 11)
	mov     #2000, @#177714         ; bsy=0 PE=1 (0 in PC) SLCT=0 (PC:1)
	mov     #senddl, @r1            ; setup & start timer
1:      mov     @#177714, r2
	bit     #20000, r2              ; wait for PC ready (BSY/str goes 0)
	bne     12
	bit     #10000, r2              ; poss. 6 okay
	bne     6
12:     bit     #20, @r1
	bne     1
11:     clr     @#177714                ; timeout.end w/ PC:BSY=0,PE=1,SLCT=1
	sec                             ; Set bit C (report error) and exit
7:      mov     (sp)+, r2
	mov	(sp)+, r1
	rts     pc
6:      mov     r0, @#177714            ; data with strobe (bsy=1 until now)
	mov     #senddl, @r1
3:      bit     #20000, @#177714        ; wait for bsy/str goes 1
	bne     4
	bit     #20, @R1
	bne     3
	br      11
4:      clr     @#177714                ; okay, end with PC:BSY=0,PE=1,SLCT=1
	clc
	br      7                       ; exit, report OK


; <PutByt>
;
; 뫪   R0  PC. ⠭  C  ⠩. ᯮ
; 楤 PUTBIT  뫪  ⮢   ਥ.  R3, R4
; ࠭  ⠭  ⥪. R0  . R1 ⠪
; ⠥ .
;
putbyt: mov     r3, -(sp)
	mov     r4, -(sp)
	clr     r3
3:      mov     r0, r4
	tst     r3
	beq     1
	mov     r3, -(sp)
2:      asr     r4
	sob     r3, 2
	mov     (sp)+, r3
1:      mov     r0, -(sp)
	mov     r4, r0
	call    putbit                  ; putbit corrupts R0
	mov     (sp)+, r0
	bcs     4
	tst     (r3)+                   ; add #2, r3
	cmp     r3, #10
	bne     3
4:      mov     (sp)+, r4
	mov     (sp)+, r3
	rts     pc


; < PutWrd >
;
; 뫪 ᫮  R0  IBM PC. ⠭  C  ⠩.
;   祭 ॣ஢
;
putwrd: call    putbyt                  ; send lo byte of R0 to PC, r0 intact
	bcs     1
	swab    r0                      ; Swap bytes order
	call    putbyt                  ; send hi byte of R0 to IBM PC
	swab    r0                      ; restore original R0
1:      rts     pc


; < GetWrd >
;
; ⥭ ᫮  IBM PC  R0. ⠭  C  訡. ᯮ R1
; (࠭  ⠭  ॣ  ⥪).
;
getwrd: mov     r1, -(sp)
	call    getbyt
	bcs     1
	clr     r1
	mov     r0, r1
	swab    r1
	call    getbyt
	bis     r0, r1
	swab    r1
	mov     r1, r0
1:      mov     (sp)+, r1
	rts     pc


; < GetStr >
;
; ⥭   ப ᨬ 祭  IBM PC.
; R1 = 㤠 ࠭ . ᫨ R1 = 0  ப ਭ 
;   ࠭. ᯮ (࠭  ⠭  ⥪) R3.
; :  ॣ R0 !!  室 R1=㪠⥫  ᫥ ਭ
; ᨬ+1,  0.
;
getstr: mov     r3, -(sp)
	call    getbyt                  ; get str len BYTE to R0
	bcs     2
	movb    r0, r3			; movb set flag Z if zero
	beq     2
	bic	#177400, r3		; use only low byte (max.len=255)
1:      call    getbyt			; get string databyte
	bcs     2
	tst     r1			; adr=0??
	beq     3
	movb    r0, (r1)+
3:      sob     r3, 1
2:      mov     (sp)+, r3
	rts     pc


; < PutStr >
;
; 뫪 ப ᨬ    IBM PC
; Entry: R1 -  ப, R2 -  ப  .
;  R1, R2  砥 ᯥ譮 뫪.  R0 (!!)
;
putstr: mov     r2, r0			; mov set flag Z if zero
	beq     2                       ; zero len
	call    putbyt			; send string length byte
	bcs     2			; error during send?? goto 2
1:      movb    (r1)+, r0		; get current string databyte
	call    putbyt			; send it to IBM
	bcs     2
	sob     r2, 1
2:      rts     pc


; < CRC_C >
;
;  ஫쭮 㬬 ⪠   R0. R2 - , R4 - .
;  R1,  R2  R4.
;
CRC_C:  clr     r0
1:      clr     r1
	bisb    (r2)+, r1
	add     r1, r0
	adc     r0
	sob     r4, 1
	rts     pc


; < GetDsk >
;
;  160006 (⥭/ 䨧᪮ ᥪ). 室 ࠬ:
;
; R3     - disk drive parameter table
; 33(r3) - track# (00..79 decimal), 1 byte len
; 32(r3) - side# (0=down, 1=up), 1 byte len. ࢮ   ஭
; 35(r3) - sector# (1..10 decimal), 1 byte len
; 30(r3) - word count (write=negative). 2 byte len
; 26(r3) - target(write) or source (write) memory address, 2 byte len
;
; ८ࠧ㥬   䨣   
;  㫥 block# = (Track * 20) + (Side * 10) + Sector
;
; entry: r3 - disk drive parameter table
;
getdsk: movb    33(r3), r0              ; track # (0..79 decimal)
	bic     #177400, r0             ; track range 0..255 decimal
	asl     r0                      ; r0 := r0 * 2
	asl     r0                      ; r0 := r0 * 4
	mov     r0, r1                  ; r1 := r0 * 4
	asl     r0                      ; r0 := r0 * 8
	asl     r0                      ; r0 := r0 * 16
	add     r1, r0                  ; r0 := 4*r0 + 16*r0 = 20 (dec) * r0!
	movb    32(r3), r1              ; r1 := side (0=down/strt, 1=up)
	beq     down                    ; down side, add nothing (1)
	add     #12, r0                 ; upper side, add 10. sectors
down:   movb    35(r3), r1              ; r1 := sector #
	bic     #177400, r1             ; sector range 0..255 decimal
	add     r1, r0                  ; finally, r0 := r0 + sector# - 1
	dec	r0			; calculated logical block start with 0
	mov     30(r3), r1              ; WCNT
	mov     26(r3), r2              ; ADDR


; ==========================================================================
;
;      < GetBlk > -  ⥭/   ᪠ IMG instead of 160004
;
; Entry: r0 - block #
;        r1 - word count (negative if write)
;        r2 - target (read) / source (write) memory address
;        r3 - disk drive parameter table
;
;                       vector 4 saved at 46 (R3)
;                       SP       saved at 50 (R3)
;                       PSW      saved at 52 (R3)
;
; this maintans compability with BK floppy ROM V253/326/327 by Sayapin A.A.
;
; Returns: @#52 - 0  no error
;                 3  format net drive failed,FORMAT report only (was:no trk0)
;                 6  network down,NETCHECK report only (was:disk not spins)
;                 7  trap to 4 happened (STOP/ROM write/read unreadable mem)
;                 12 network failure (was: non-standart disk on real FDC ROM)
;
; ==========================================================================
;
getblk: mov     @#4, 46(r3)             ; save previous vector 4
        mov     #stop, @#4              ; set up OUR vector
        mov     r0, -(sp)               ; 12(SP)        block #
	mov     r5, -(sp)               ; 10(SP)        used
	mov     r2, -(sp)               ; 6(SP)         addr
	mov     r3, -(sp)               ; 4(SP)         fdc param table
	mov     r4, -(sp)               ; 2(SP)         used
	mov     r1, -(sp)               ; @SP           word count
        mov     sp, 50(r3)              ; save SP to memory
        mov     r3, r5                  ; R5 will be always = FDC param adr
	clr     @#177714                ; clear i/o port
	mov     #vlong, @#177706	; normal delay
	mov     #127405, r0             ; server cmd: read
	tst     r1                      ; write?
	bpl     6
	neg     r1
	inc     r0                      ; #127406 = write
6:      call    putwrd                  ; send command word to IBM
	bcs     1
	mov	r0, -(sp)		; save 127405 (R)/127406 (W) to stack
	movb	34(r3), r0		; drive# (0=A:, 12=K: .. 30=Z:)
	call	putbyt
	mov	(sp)+, r0		; restore command word from stack
	bcs	1			; mov/movb leave bit C intact!!
	cmp	r0, #127406		; write?
	bne	10			; no->read,skip READ SERVER RESPONCE1
	call	getbyt			; get responce byte (disk may be W/P)
	bcs	1			; error during receiving server resp.
	tstb	r0			; disk is write protected??
	bne	1			; yes-->fatal exit
10:	mov     12(sp), r0              ; block # (r0)
	call    putwrd
	bcs     1
	mov     r1, r0                  ; word count (r1)
	call    putwrd
	bcs     1

; r2 = current source/target memory addr
; r1 = current word count

5:      mov     r2, r3                  ; r3 = temp. mem. addr
	mov     #400, r4
	cmp     r1, r4                  ; word count >= 400 octal???
	bhis    13                      ; yes - goto 2
	mov     r1, r4                  ; r1<400. process the remainder
13:     asl     r4
2:      tst     @sp                     ; LOOP,@SP=original R1, <0 if write !
	bpl     7                       ; READ?; yes - goto 7
	movb    (r3)+, r0               ; write loop
	call    putbyt
	bcs     1
	sob     r4, 2
	br      11
7:      call    getbyt                  ; read loop
	bcs     1
	movb    r0, (r3)+
	sob     r4, 2
11:     call    getwrd                  ; get server crc to r0
	bcs     1
	mov     r0, r3                  ; r3 := SERVER CRC
	mov     r2, -(sp)
	mov     r1, -(sp)               ; 塞 client CRC. r2 = st. adr
	mov     #400, r4                ; 512 bytes = 256 (400 oct) words
	cmp     r1, r4
	bhis    12
	mov     r1, r4
12:     asl     r4                      ; convert words to bytes
	call    CRC_C                   ; calculate CRC <- r0 (r1 intact)
        mov     (sp)+, r1
	mov     (sp)+, r2
	call    putwrd                  ; send client CRC to server (in r0)
	bcs     1
	cmp     r0, r3                  ; compare CRCs...
	bne     3
	clr     r0                      ; crc okay. put responce, read answer
	call    putbyt			; send okay to server
	bcs     1
	call    getbyt                  ; get server answer
	bcs     1
	tst     r0			; everything fine??
	bne     5			; nope - goto 5
	add     #1000, r2               ; next address
	sub     #400, r1                ; decrease word counter
	beq     14			; =0? goto 14
	bmi     14                      ; <0? goto 14 (yes - all is done)
	br      5                       ; else next block
14:     clrb    @#52			; normal exit, no error, all is fine!
        mov     46(r5), @#4             ; restore original vector 4
        clr     42(r5)                  ; FAST future netcheks (net is fine)
        clr     44(r5)                  ; (destory magic words 3 & 4)
        mtps    52(r5)                  ; restore saved PSW using R5
	clc                             ; report OK
	br      4                       ; exit

; something very nasty happens... fire exit (report error #12 to caller!)
; err#12 (physical) = non-standart disk format or invalid command parameters
; also set VERY LONG delay for all the next net-checks
;
1:      movb    #12, @#52               ; @sp=r1, 2(sp)=r4, 4(sp)=r3
        mtps    52(r5)                  ; restore PSW from FDC table via R5
        mov     46(r5), @#4             ; restore original vector 4
        mov     #040302, 42(r5)		; magic word #3
	mov	#147306, 44(r5)		; magic word #4
	sec
4:      mov     (sp)+, r1
	mov     (sp)+, r4
	mov     (sp)+, r3
	mov     (sp)+, r2
	jmp	plate                   ; plate timer fix
3:      mov     #254, r0                ; bad CRC, put negative answer,resend
	call    putbyt                  ; current block
	bcs     1
	call    getbyt
	bcs     1
	br      5

; interrupt vector 4 handler, either STOP key pressed or trying to write
; to ROM area / read unreadable memory region
;
stop:   mov     50(r5), sp              ; restore SP
        movb    #7, @#52                ; report TRAP to 4 to caller
        mov     46(r5), @#4             ; restore vec.4
        mov	#vlong, @#177706	; PLATE patch
	mov	#1, @#177712		; copy from 177706 to 177710
        mov     (sp)+, r1               ; restore all regs
        mov     (sp)+, r4
        mov     (sp)+, r3
        mov     (sp)+, r2
        mov     (sp)+, r5
        mov     (sp)+, r0
        mtps    52(r3)                  ; restore caller's PSW using R3
        sec                             ; report ERROR
        rts     pc                      ; return to caller

; ===========================================================================
; ⢥ ⥫ ࠩ.drv1 - 室  160004 (r/w ᪮ )
; drv2 - 室  160006 (r/w ᥪ), drv3 - 室  160012 (format)

drv1:   call    clean                   ; save PSW to memory, clear T-bit
        tst     (sp)+
        tstb	34(r3)			; replace drive A: with network drive
	beq	2
	cmpb	34(r3), #12		; drive K:?
	blo	v1			; drive less than K:
2:	cmp	36(r3), #110275		; magic word #1
	bne	3
	cmp	40(r3), #070605		; magic word #2
	beq	vfc1			; very fast check
3:	call    netchk                  ; drive K:-Z: Check if network is up
	bcs     v1                      ; no, use normal fdd/hdd driver
	jmp     getblk                  ; yes, try to load/save from NET
v1:     mov	#110275, 36(r3)		; store magic word #1
	mov	#070605, 40(r3)		; and #2 to avoid future net cheks!
        mtps    52(r3)                  ; restore PSW by Clean
	jmp     @#160250                ; jump to original 160004 subroutine

drv2:   call    clean
        tst     (sp)+
        tstb	34(r3)			; #2-r/w physical sector
	beq	2
	cmpb	34(r3), #12
	blo	w1
2:	cmp	36(r3), #110275
	bne	3
	cmp	40(r3), #070605
	beq	vfc2
3:	call    netchk
	bcs     w1
	jmp     getdsk                  ; 160006 substitute
w1:     mov	#110275, 36(r3)
	mov	#070605, 40(r3)
        mtps    52(r3)                  ; restore PSW saved by CLEAN
	jmp     @#160372                ; original 160006 subroutine

drv3:	jmp	drv3ok

vfc1:	mov	#va1, -(sp)
	mov     r0, -(sp)
        mov     r5, -(sp)
        mov     #177706, r5
        clr     @#177714
        mov     #vfd, @r5
        jmp     entry
va1:    bcs     v1jump
        clr     36(r3)                  ; net is up again.destroy magic words
        clr     40(r3)                  ; all next checks will be long
        jmp     getblk                  ; read/write from net

drv3ok:	tstb	34(r3)			; #3-format
	beq	2
	cmpb	34(r3), #12
	blo	1			; not our drive...
2:	cmp	40(r3), #070605		; unsuccesful tests was already made?
	beq	1			; yes - avoid netchk
3:	call	netchk
	bcs	1
        mov     r0, -(sp)               ; proceed with format
	mov     r5, -(sp)
	mov     r2, -(sp)
	mov     r3, -(sp)
	mov     r4, -(sp)
	mov     r1, -(sp)
        mov     #127407, r0             ; send command: FORMAT (AF07)
        call    putWrd
        bcs     4
        movb    34(r3), r0
        call    putbyt                  ; send drive
        bcs     4
        movb    33(r3), r0
        call    putbyt                  ; send track
        bcs     4
        movb    32(r3), r0
        call    putbyt                  ; send side
        bcs     4
        movb    17(r3), r0
        call    putbyt                  ; send filler byte
        bcs     4
        call    getbyt                  ; get server responce byte
        bcs     4
        tstb    r0                      ; zero?
        bne     4
        clrb	@#52			; report NO error
        clr     42(r3)
        clr     44(r3)
        clc
        br      5
4:      movb    #3, @#52                ; report err#3 (originally no track0)
        mov     #040302, 42(r3)		; magic word #3
	mov	#147306, 44(r3)		; magic word #4
	sec
5:      mov     (sp)+, r1
	mov     (sp)+, r4
	mov     (sp)+, r3
	mov     (sp)+, r2
	jmp	plate                   ; plate timer fix
1:	mov	#070605, 40(r3)		; set flag - DO NOT TRY NETCHK again
	jmp	@#163412		; original 160012 handler

v1jump:	jmp	v1

vfc2:   mov	#va2, -(sp)
	mov     r0, -(sp)
        mov     r5, -(sp)
        mov     #177706, r5
        clr     @#177714
        mov     #vfd, @r5
        jmp     entry
va2:    bcs     w1
        clr     36(r3)                  ; net is up again.destroy magic words
        clr     40(r3)                  ; all next checks will be long
        jmp     getdsk                  ; read/write from net

clean:  mfps	52(r3)			; save original psw in FDC table
	mov	#340, -(sp)		; disable interrupts, clear T bit
	mov	2(sp), -(sp)		; place return address to stack
	rtt                             ; perform RTS PC function

; < NetChk > - check to see if network is up and running
;
; we'll try to minimize stack use to avoid possible conflict with CSI-DOS
; (that DOS use SP=166 and R3 (FDC parameter table)=54) at point of this call
;
; regs used: R0, R5
;
netchk: mov     r0, -(sp)		; r0 used internally
	mov     r5, -(sp)		; r5 used internally
	mov     #177706, r5
	clr     @#177714
	mov     #fastdl, @r5		; fast net check
	cmp	42(r3), #040302		; magic word #3
	bne	entry
	cmp	44(r3), #147306		; magic word #4
	bne	entry
	mov	#vlong, @r5		; full delay for the 1st TIME
	clr	42(r3)			; destroy magic words to avoid
	clr	44(r3)			; possible future delays...
entry:	mov     #127401, r0
	call    putwrd                  ; AF01
	bcs     1                       ; network is DOWN
	mov	#vlong, @r5		; net alive,do handshake (long delay)
	call    getwrd                  ; R0 should be 156363
	bcs     1
	cmp     r0, #156363		; is magic word correct?
	bne     1			; nope, quit
	mov     r1, -(sp)               ; we will additionaly use R1&R2
	mov     r2, -(sp)
	clr     r1			; do NOT store server string
	call    getstr                  ; get server info string
	bcs     2
	call    getwrd                  ; get server version word
	bcs     2
	call    getwrd                  ; get server features word
	bcs     2
	mov     #id_str, r1		; my cool string!
	mov     #40, r2			; string len
	call    putstr			; send client info string
	bcs     2
	mov     #405, r0
	call    putwrd			; send client version word (1.5)
	bcs     2
	clr     r0
	call    putwrd			; send client features word
	bcs     2
	mov     (sp)+, r2
	mov     (sp)+, r1
        clc
        br      plate
2:      mov     (sp)+, r2               ; shit happens!! restore r1 & r2
	mov     (sp)+, r1
1:      movb	#6, @#52                ; err 6=no disk or disk not spinning
	sec
plate:	mov	#vlong, @#177706	; this is plate fix
	mov	#1, @#177712		; pause, copy from 177706 to 177710
	mov	(sp)+, r5               ; normal exit
	mov	(sp)+, r0               ; mov/movb leave bit c intact
	rts	pc
	.end
