
; ===========================================================================
;
;   This is a main module for *.PSG files BK player (c) alex savelev - 2003
;
; Compiled for: DEFCOM (Converted from DEFCOM.AY -> DEFCOM.PSG by AyPlay.exe)
; ===========================================================================

	.psect  1000                    ; compile at 1000

; --- <<< loader >>> ---
;
loader: mov     #776, sp
        mtps    sp
        reset
        mov     #disab, 4               ; disable stop-key
        mov     #177716, r5
        mov     #16200, @r5             ; 5:4
        call    clr4                    ; clear page 5
        mov     #75400, @r5             ; 6:3
        call    clr4                    ; clear page 6
        call    600                     ; show logo at screen #6
        mov     #16200, @r5             ; page 5 at 40000,page 4 at 100000
        mov     #140000,177662          ; show scr page 6, timer OFF
        mov     #6, r4
        mov     #40000, r1
        call    doload                  ; load block6 to 40000
        mov     #15400, 177716          ; 5:3
        call    copy
        mov     #16200, 177716          ; 5:4
        mov     #5, r4
        mov     #40000, r1
        call    doload                  ; load block5 to 40000
        mov     #15000, 177716          ; 5:2
        call    copy                    ; copy 16kb datablock to ram page2
        mov     #16200, 177716          ; 5:4
        mov     #4, r4
        mov     #40000, r1
        call    doload                  ; load block4 to 40000
        mov     #14000, 177716          ; 5:1
        call    copy
        mov     #16200, r0              ; normal 5:4 memory setup
        mov     r0, 177716
        mov     r0, cur716
	mov     #1, r4
        mov     #3000, r1
        call    doload                  ; load block1 (3000)
        mov     #3, r4
        mov     #120000, r1
        call    doload                  ; load block3 (120000)
        mov     #7, r4                  ; load packed block7 at 40000, page5
        mov     #40000, r1              ; (double packed :)
        call    doload
        clr     r4                      ; load packed block0 at 53000, page5
        mov     #53000, r1
        call    doload
        mov     #230, 177664            ; turn on small screen
        mov     #17400, 177716          ; 5:6
        mov     #40000, r0
        mov     #14000, r1              ; copy 30000 bytes from page 5 to p.6
        mov     #100000, r2
copy2:  mov     (r0)+, (r2)+
        sob     r1, copy2
        mov     #16200, 177716          ; 5:4
        mov     #2, r4
        mov     #40000, r1
        call    doload                  ; load block2 (40000) at page #5
        mov     #nxt, 4                 ; just in case (for diskless BK)
        clr     177130                  ; spin down floppy drive (for aodos)
        br      notrp
nxt:    cmp     (sp)+, (sp)+
notrp:  mov     #76400, 177716          ; 6:7
        mov     #53000, r0              ; copy packed block0 form 5 to 7
        mov     #110000, r1
        mov     #15100, r2
cpy7:   movb    (r0)+, (r1)+
        sob     r2, cpy7
        mov     #10000, 177716          ; disable STOP key
        mov     #unpack, 4
        jmp     110000                  ; unpack block0 to 110000 (7)
unpack: cmpb    (sp)+, (sp)+            ; restore STACK POINTER
        mov     #first, 4
        mov     #40000, pc              ; unpack (1st time) block7 to page 6
first:  bit     (sp)+, (sp)+            ; add #4, sp
        mov     #cool, 4
        jmp     40000                   ; unpack (2nd time) block7 to page 6
cool:   bitb    (sp)+, (sp)+            ; restore STACK
        mov     #done, 4                ; user can cancel music playback
        call    shut                    ; fully initialize AY soundchip
        mov     #hand, 100              ; set up 50 hz timer handler
	mov     #343, 102
        clr     r0
        mov     r0, 177716              ; re-enable stop again
        mov     #3000, cur              ; buffer #1 st.adr
again:  mtps    r0
        movb    #1, type                ; starting buffer# := 1 !
        mov     preg, 177663            ; turn ON 50hz timer,scr page6,pal 12
        mov     #75400, 177716          ; 6:3 (map screen 6 at 40000)

; --- <<< infinite loop:draw AY-3-8910 channel A, B and C volume bars >>> ---
;
redraw: mov     #77312, r5              ; volume A - bar: SCREEN address
        movb    vola, r4                ; get actual channel A volume
        mov     #52525, r1
        call    chan                    ; draw bar for ch.A
        mov     #77335, r5              ; volume B - bar: SCREEN address
        movb    volb, r4
        mov     #177777, r1
        call    chan                    ; draw bar for ch.B
        mov     #77360, r5              ; volume C - bar: SCREEN address
        movb    volc, r4
        mov     #52525, r1
        call    chan                    ; draw bar for ch.C
        br      redraw

; --- <<< redraw single channel:r5=scr address of bottom line, r4=vol >>> ---
;
chan:   mov     #40, r3                 ; max vol = 16*2
        bic     #177760, r4             ; convert volume value to 0..15 range
	aslb	r4			; x2
cloop:  clr     r2                      ; empty fill
        tstb    r4                      ; zero already??
        beq     okfill
        mov     r1, r2                  ; filler
        decb    r4
okfill: movb    r2, @r5                 ; put data to screen
        movb    r2, 1(r5)
        movb    r2, 2(r5)
        movb    r2, 3(r5)
        movb    r2, 4(r5)               ; wide bars (3 words)
        movb    r2, 5(r5)
        sub     #100, r5
        sob     r3, cloop
        rts     pc

; --- <<< stop key handler, for use during loader phase >>> ---
;
disab:  sub     @pc, @sp                ; fully disable STOP key
        rtt

; ---- <<< clear area 40000-100000 >>> ----
;
clr4:   mov     #40000, r3              ; clear screen page 5
        mov     #20000, r4
cln0:   clr     (r3)+
        sob     r4, cln0
        ret

; ---- <<< copy RAM page >>> ----
;
copy:   mov     #40000, r0
        mov     #100000, r1
        mov     #20000, r2
0:      mov     (r0)+, (r1)+
        sob     r2, 0
        ret

; ---- <<< shut down AY-3-8910 >>> ---
;
shut:   mov     #377, r0                ; ay reg #
        movb    #377, r1                ; ay data (zero)
        mov     #177714, r2             ; port
        mov     #20, r3                 ; counter (16 regs)
fill:   mov     r0, @r2                 ; send ay reg# (WORD)
        movb    r1, @r2                 ; send ay data (inverted zero), BYTE
        dec     r0                      ; next ay reg
        sob     r3, fill
        ret

; --- <<< retrieve musicdata, update pointer >>> ---
;
fetch:  mov     cur, r1                 ; get current address to R1
        mov     cur716, 177716          ; we must gain access to musicdata !!
        movb    (r1)+, r0               ; fetch data from (R1)+ to R0
        mov     #75400, 177716          ; 6:3 (map screen 6 at 40000)
        mov     r1, cur                 ; update address
        cmp     r1, #77476              ; * <-- Melody Endpoint
        blo     okay
        tstb    type                    ; overflow of buffer #0 ?
        beq     total                   ; we are done with this tune :)
okay:   cmp     r1, #100000             ; overflow of buffers 0, 1 & 2??
        beq     new
        cmp     r1, #70000              ; overflow of buffer #7 ?
        bne     norm
        cmpb    type, #7
        beq     almtot
norm:   cmp     r1, #140000             ; overflow of buffers #3, #4, #5 & #6
        beq     next
        ret
next:   cmpb    type, #3
        beq     med
        cmpb    type, #4
        beq     high
        cmpb    type, #5
        beq     ultra
        incb    type                    ; (6->7)
        mov     #40000, cur
        mov     #75400, cur716          ; 6:3
        ret
ultra:  mov     #15400, r1              ; (5->6)
        incb    type                    ; 5:3
gen:    mov     r1, cur716              ; save important value at memory
        mov     #100000, cur            ; 3, 4, 5
        ret
high:   mov     #15000, r1              ; 5:2
        incb    type
        br      gen
med:    mov     #14000, r1              ; 5:1
        incb    type                    ; buffer #4
        br      gen
new:    movb    #3, type                ; we do not need to change 11m setup
        mov     #120000, cur            ; *********** BUFFER #3 *************
        ret
almtot: clrb    type                    ; buffer #0
        mov     #50000, cur
        mov     #55400, cur716          ; 7:3
        ret
total:  incb    @#2743                  ; byte pointer to PREG
        bicb    #177760, @#2743
        bisb    #200, @#2743
        mov     #16200, cur716          ; 5:4 (normal setup)
        mov     #776, sp
        clr     r0
        mov     #23700, cur             ; * <-- Melody LOOP (restart) Point
        jmp     again                   ; restart playback

; --- <<< stop key handler, for use during playback >>> ---
;
done:   mtps    sp                      ; disable interrupts (pause timer)
        call    shut                    ; shut down AY-3-8910 music chip
        mov     #17400, 177716          ; 5:6
        mov     #40000, sp
        mov     sp, r3
clntot: clr     (sp)+                   ; clear both page 5 and page 6
        sob     r3, clntot
        mov     #75000, 37717(sp)       ; 6:2; SP = 140000 now
        mov     #140300, r5
        swab    sp
        com     sp
        mov     #5307, 140277(sp)       ; dec PC to 137776
        add     r5, sp
        mov     sp, pc                  ; restart computer (jump to 137777)


; --- <<< 50 hz player >>> ---
;
hand:   mov     r0, -(SP)               ; r0 used
        mov     r1, -(SP)               ; r1 used
more:   call    fetch                   ; retrieve next music byte to R0
        cmpb    #377, r0                ; end of INTR (0FFh) ??
        beq     eoi                     ; done
        bic     #177760, r0
        mov     r0, -(sp)               ; temporary save ay reg# to stack
        com     r0                      ; convert to BK style
        mov     r0, @#177714            ; send AY reg# to AY :-)
        call    fetch                   ; get AY data (normal) to R0
        cmp     @sp, #7
        beq     mixer
        cmp     @sp, #10                ; write to volume A register?
        beq     va
        cmp     @sp, #11                ; write to volume B register?
        beq     vb
        cmp     @sp, #12                ; write to volume C register?
        bne     std
        bitb    #20, r0                 ; envelope on volume C?? (10 000)
        beq     vcstd                   ; no - normal volume
        movb    #7, volC                ; interpolated envelope volume on C
        br      std
vcstd:  movb    r0, volC                ; save actual volume to VOL_C var
        br      std
vb:     bitb    #20, r0
        beq     vbstd
        movb    #7, volb                ; interpolated envelope volume on B
        br      std
vbstd:  movb    r0, volB                ; save actual volume to VOL_B var
        br      std
va:     bitb    #20, r0
        beq     vastd
        movb    #7, volA                ; interpolated envelope volume on A
        br      std
vastd:  movb    r0, volA                ; save actual volume to VOL_A var
        br      std
mixer:  com     r0                      ; invert for testing with / bitb
        bitb    #11, r0                 ; channel A is totally OFF?
        beq     aoff
cmix:   bitb    #22, r0
        beq     boff
cmix1:  bitb    #44, r0                 ; channel C is totally OFF??
        beq     coff                    ; yep
        br      std1                    ; (r0 inverted already)
aoff:   clrb    vola
        br      cmix                    ; continue testing
boff:   clrb    volb
        br      cmix1
coff:   clrb    volc                    ; clear volume C
        br      std1                    ; r0 inverted already
std:    com     r0                      ; convert ay data to bk style
std1:   tstb    (sp)+                   ; restore stack
        movb    r0, @#177714
        br      more
eoi:    mov     (SP)+, r1
        mov     (SP)+, r0
        rtt

; --- <<< move file addr, name and do EMT 36 >>> ---
; entry: R1 - block address; R4 - block#
;
doload: mov     #320, r2
        mov     r2, r3
        mov     #param, r5
        mov     #16, r0
dl1:    mov     (r5)+, (r2)+
        sob     r0, dl1
        mov     r1, 322                 ; put address
        mov     r3, r1                  ; 320
        add     #60, r4
        movb    r4, 334                 ; put block#
        emt     36
        rts     pc

; --- <<< data >>> ---
;
cur:    .word   3000                    ; current buffer address
cur716: .word   16200                   ; current bk11m pages setup
preg:   .word   104000                  ; bk11m palette/timer/scr reg. copy
volA:   .byte   0                       ; AY-3-8910 channel A volume (0-15)
volB:   .byte   0                       ; --------"-------  B
volC:   .byte   0                       ; --------"-------  C
type:   .byte   1                       ; buffer # (1,2,3,4,5,6)

param:  .word   3                       ; load cmd
	.word   0
	.word   0
        .ascii  'DEFCOMx.DAT     '
	.word   0

	.end
