
; ===========================================================================
;
;   This is a main module for *.PSG files BK player (c) alex savelev - 2003
;
;   Compiled for: Norosoft.vtx (converted to PSG by AY_Emul) & Glider Rider
;                 tune (glider.AY -> converted to Glider.PSG by AyPlay.EXE)
;
; ===========================================================================


	.psect  1000                    ; compile at 1000

; --- <<< loader >>> ---
;
loader: sxt     @#177706
        mov     #177707, r5
        xor     r5, (r5)+               ; 177711
        mov     #776, sp
        mtps    sp
        reset                           ; reset bus, disable kbd intr
        mov     #120, 2(r5)
        call    shut                    ; fully initialize AY soundchip
        mov     177663, r0              ; clear keyboard buffer
        mov     #disab, 4               ; disable stop
        mov     #16200, @#177717        ; 5:4
        call    clr4                    ; clear page 5
        mov     #42000, 177663          ; stop timer, show scr page 5, pal=4
        mov     #75400, 177717          ; 6:3
        call    clr4                    ; clear page 6
        mov     #4000, r5
        mov     #41000,r2
        mov     #14000, r0
welc:   mov     (r5)+, (r2)+            ; copy intro screen to page 6
        sob     r0, welc
        mov     #pro, 10
        jmp     41000                   ; unpack
pro:    mov     #16200, r0              ; 5:4
        mov     r0, 177717              ; page 5 at 40000, page 4 at 100000
        mov     r0, cur716              ; this is for AY player
        mov     #142000, 177663         ; show scr page 6, timer OFF, pal=4
        mov     #file8, r1              ; load intro tune at 40000, page5
        call    doload
        mov     4, -(sp)
        mov     #unp, 4
        mov     #40000, -(sp)
        jmp     @0(sp)                  ; unpack tune (packed w/ bkpack)
unp:    bitb    (sp)+, (sp)+            ; restore stack
        mov     (sp)+, cur
        mov     (sp)+, @#4
        movb    #666, type              ; flag: now playing intro tune
	mov     #hand, 100              ; set up 50 hz timer handler
        mov     #340, 16
        mov     #v14e, @#14
	mov     #277, @#102             ; bit I set, bit T clear (257)
        clr     177130
        mov     #102000, 177663         ; turn ON 50hz timer,scr page=6,pal 4
        mov     #main, 4                ; user MUST cancel music playback,
        mov     60, 2                   ; either with STOP or press to any
        mov     274, 0                  ; other key...
        mov     4, 60
        mov     60, 274
        clr     177661                  ; enable keyboard intrs
intro:  mov     #20, r0                 ; rotate counter
        clr     r1                      ; mode=0/just put; 1/clear & rotate
        mtps    r1                      ; allow interrupts, start intro play
drot:   wait                            ; move dots every 1/50 second
        call    timer
        mov     #dots, r5               ; dot masks and their screen addr-s
        mov     #22, r4                 ; we have 18 dots total in array
dmov:   mov     (r5)+, r3               ; get addr to r3
        mov     @r5, r2                 ; get mask to r2
        xor     r2, @r3                 ; xor-put data to screen
        tstb    r1
        beq     ndot
        cmp     #1, r0
        beq     ndot
        asl     r2                      ; shift our mask
        asl     r2
        mov     r2, (r5)                ; store new mask to memory
ndot:   tst     (r5)+
        sob     r4, dmov
        comb    r1
        sob     r0, drot
        mov     #dots, r3               ; update memory array
        mov     #22, r1
upd:    mov     @r3, r0                 ; r0=scr adr
        tst     (r0)+                   ; add #2, r0
        mov     r0, r5
        bic     #177700, r5
        bne     nadr                    ; screen line overflow?
        sub     #100, r0                ; restart from beginning of scr.line
nadr:   mov     r0, (r3)+
        mov     (r3), r4
        asl     r4
        rol     r4
        rol     r4
        mov     r4, (r3)+               ; store new color mask to memory
        sob     r1, upd
        br      intro
main:   bisb    (sp)+, (sp)+            ; restore stack from prev.interrupt
        mov     #disab, 4               ; disable stop again
        mov     2, 60                   ; restore keyboard vector1
        mov     0, 274                  ; restore keyboard vector2
        mtps    sp                      ; disable interrupts again
        reset                           ; reset bus, disable keyboard intrs
        mov     #142000, 177663         ; show scr page 6, timer OFF, pal=4
        call    shut                    ; shut down AY-3-8910 music chip
        mov     #17400, 177716          ; map 5:6
        mov     #40000, r0
        mov     #20000, r1
cln9:   clr     (r0)+                   ; clear page 5
        sob     r1, cln9
        reset
        mov     #42000, 177663          ; show scr page 5, timer OFF, pal=4
        mov     #20000, r1
cln8:   clr     (r0)+                   ; clear page 6
        sob     r1, cln8
        mov     #21000, r5
        mov     #114300,r2
        mov     #3340, r0
welc2:  mov     (r5)+, (r2)+            ; copy "loading" screen to page 6
        sob     r0, welc2
        mov     #142000, 177663         ; show scr page 6, timer OFF, pal=4
        mov     #16200, 177717          ; 5:4
        mov     #file6, r1
        call    doload                  ; load block6 to 40000
        mov     #15400, 177717          ; 5:3
        call    copy                    ; copy 16kb datablock to ram page3
        mov     #16200, @#177716        ; 5:4
        mov     #file5, r1
        call    doload                  ; load block5 to 40000
        mov     #15000, 177717          ; 5:2
        call    copy                    ; copy 16kb datablock to ram page2
        mov     #16200, 177717          ; 5:4
        mov     #file4, r1
        call    doload                  ; load block4 to 40000
        mov     #14000, @#177717        ; 5:1
        call    copy                    ; copy 16kb datablock to ram page1
        mov     #16200, 177717          ; normal 5:4 memory setup
	mov     #file1, r1
        call    doload                  ; load block1 (3000)
        call    clr4                    ; clear page5
        mov     #file7, r1              ; load block7 to 40000, page5
        call    doload                  ; (screen page 6 still on)
        mov     #17400, 177717          ; 5:6
        mov     #230, 177664            ; enable small screen (last 6 lines)
        call    copy                    ; copy datablock from 5 to 6
        mov     #16200, @#177716        ; 5:4
        mov     #file3, r1
        call    doload                  ; load block3 (120000), page5
        mov     #16200, r0
        mov     r0, 177717              ; set bk11m memory
        mov     r0, cur716              ; 5:4
	mov     #file2, r1
        call    doload                  ; load block2 (40000), page 5
        mov     #626, 110720
        mov     #600, r1                ; load block8 to 40000, page 7
        mov     r1, sp
        jmp     doload
        mov     #776, sp
        call    shut                    ; fully initialize AY soundchip
        bic     #20, 102                ; clear T-bit
        mov     #4000, cur              ; *********** BUFFER #1 *************
        mov     #103000, r0
        mov     r0, preg
        mov     r0, 177663              ; turn ON 50hz timer,scr page=6,pal 6
        movb    #1, r3                  ; starting buffer# := 1 !!
again:  movb    r3, type
	mtps    r3                      ; allow interrupts
        mov     #done, 4                ; user can cancel music playback !
        mov     #75400, 177717          ; 6:3 (map screen 6 at 40000)

; --- <<< infinite loop:draw AY-3-8910 channel A, B and C volume bars >>> ---
;
redraw: mov     #77312, r5              ; volume A - bar: SCREEN address
        movb    vola, r4                ; get actual channel A volume
        mov     #125252, r1             ; "green" color for first bar
        call    chan                    ; draw bar for ch.A
        mov     #77335, r5              ; volume B - bar: SCREEN address
        movb    volb, r4
        mov     #177777, r1             ; "red" color for second bar
        call    chan                    ; draw bar for ch.B
        mov     #77360, r5              ; volume C - bar: SCREEN address
        movb    volc, r4
        mov     #125252, r1             ; "green" color agian for third bar
        call    chan                    ; draw bar for ch.C
        br      redraw

; --- <<< redraw single channel:r5=scr address of bottom line, r4=vol >>> ---
;
chan:   mov     #40, r3                 ; max vol = 16*2
        bic     #177760, r4             ; convert volume value to 0..15 range
	aslb	r4			; x2
cloop:  clr     r2                      ; empty fill
        tstb    r4                      ; zero already??
        beq     okfill
        mov     r1, r2                  ; filler
        decb    r4
okfill: mov     #5, r0
wide:   movb    r2, (r5)+               ; put data to screen
        sob     r0, wide                ; wide bars
        sub     #105, r5
        sob     r3, cloop
        rts     pc

timer:  mov     177711, r5
        swab    r5
        xor     r5, @#177706
        call    @#666                   ; mov 177706,r5/swab r5/xor r5,177712
        add     rw1, 177707             ; com 177712/ret
        add     rw1, @#177712
        add     #7, rw1
        rts     pc

; --- <<< stop key handler, for use during loader phase >>> ---
;
disab:  sub     @pc, @sp                ; fully disable STOP key
        rti

; ---- <<< clear area 40000-100000 >>> ----
;
clr4:   mov     #40000, r3              ; clear screen page 5
        mov     #20000, r4
cln0:   clr     (r3)+
        sob     r4, cln0
        ret

; ---- <<< copy RAM page >>> ----
;
copy:   mov     #40000, r0
        mov     #100000, r1
        mov     #20000, r2
0:      mov     (r0)+, (r1)+
        sob     r2, 0
        ret

done:   mtps    4(pc)
        mov     #17400, @#177716        ; 5:6
        mov     #40000, r3
        mov     r3, r5
dclr:   clr     (r3)+
        sob     r5, dclr
        mov     #140000, -(sp)

; ---- <<< shut down AY-3-8910 >>> ---
;
shut:   mov     #377, r0                ; ay reg #
        movb    #377, r1                ; ay data (zero)
        mov     #177714, r2             ; port
        mov     #20, r3                 ; counter (16 regs)
fill:   mov     r0, @r2                 ; send ay reg# (WORD)
        movb    r1, @r2                 ; send ay data (inverted zero), BYTE
        dec     r0                      ; next ay reg
        sob     r3, fill
        ret

; --- <<< retrieve musicdata, update pointer >>> ---
;
fetch:  mov     cur, r1                 ; get current address to R1
        mov     cur716, @#177717        ; we must gain access to musicdata !!
        movb    (r1)+, r0               ; fetch data from (R1)+ to R0
        mov     #75400, 177717          ; 6:3 (map screen 6 at 40000)
        mov     r1, cur                 ; update address
        cmp     r1, #100000             ; overflow of buffer 1 & 2??
        beq     new
        cmp     r1, #116660             ; <-- end of melody point !!!
        bne     norm
        cmpb    type, #11
        beq     total
norm:   cmp     r1, #130000             ; overflow of buffer 7??
        bne     not7
        cmpb    type, #7
        beq     ovr7
not7:   cmp     r1, #140000             ; overflow of buffers #3,4,5,6 or 10?
        beq     next
        ret
next:   cmpb    type, #3
        beq     med                     ; switch 3->4
        cmpb    type, #4
        beq     high                    ; switch 4->5
        cmpb    #5, type
        beq     shi                     ; switch 5->6
        cmpb    #6, type
        beq     sw7                     ; switch 6->7
        mov     #16200, r1              ; 5:4
        movb    #11, type               ; switch 10->11
        br      gen
sw7:    mov     #17400, r1              ; 5:6 (switch 6->7)
        movb    #7, type
        br      gen
ovr7:   mov     #16400, r1              ; 5:7
        movb    #10, type               ; 7->10
        br      gen
shi:    mov     #15400, r1              ; 5:3
        movb    #6, type
gen:    mov     r1, cur716              ; save important value at memory
        mov     #100000, cur            ; 3, 4, 5, 6, 7, 10, 11
        ret
high:   mov     #15000, r1              ; 5:2
        movb    #5, type
        br      gen
med:    mov     #14000, r1              ; 5:1
        movb    #4, type                ; buffer #4
        br      gen
new:    cmpb    type, #666
        bne     stdn
        mov     #40000, cur             ; restart intro from beginning
rotp:   incb    @#3361
        bicb    #177760, @#3361
        bisb    #200, @#3361
        mov     preg, @#177663          ; new pal
        ret
stdn:   movb    #3, type                ; we do not need to change 11m setup
        mov     #120000, cur            ; *********** BUFFER #2 *************
        ret
total:  mov     #15000, cur716
        mov     #100000, cur            ; <-- melody loop address!
        call    rotp
        mov     #5, r3                  ; <-- melody loop buffer# !
        jmp     again                   ; restart playback

; --- <<< 50 hz player >>> ---
;
hand:   mov     r0, -(SP)               ; r0 used
        mov     r1, -(SP)               ; r1 used
more:   call    fetch                   ; retrieve next music byte to R0
        cmpb    #377, r0                ; end of INTR (0FFh) ??
        beq     eoi                     ; done
        bic     #177760, r0
        mov     r0, -(sp)               ; temporary save ay reg# to stack
        com     r0                      ; convert to BK style
        mov     r0, @#177715            ; send AY reg# to AY :-)
        call    fetch                   ; get AY data (normal) to R0
        cmp     @sp, #7
        beq     mixer
        cmp     @sp, #10                ; write to volume A register?
        beq     va
        cmp     @sp, #11                ; write to volume B register?
        beq     vb
        cmp     @sp, #12                ; write to volume C register?
        bne     std
        bitb    #20, r0                 ; envelope on volume C?? (10 000)
        beq     vcstd                   ; no - normal volume
        movb    #7, volC                ; interpolated envelope volume on C
        br      std
vcstd:  movb    r0, volC                ; save actual volume to VOL_C var
        br      std
vb:     bitb    #20, r0
        beq     vbstd
        movb    #7, volb                ; interpolated envelope volume on B
        br      std
vbstd:  movb    r0, volB                ; save actual volume to VOL_B var
        br      std
va:     bitb    #20, r0
        beq     vastd
        movb    #7, volA                ; interpolated envelope volume on A
        br      std
vastd:  movb    r0, volA                ; save actual volume to VOL_A var
        br      std
mixer:  com     r0                      ; invert for testing with / bitb
        bitb    #11, r0                 ; channel A is totally OFF?
        beq     aoff
cmix:   bitb    #22, r0
        beq     boff
cmix1:  bitb    #44, r0                 ; channel C is totally OFF??
        beq     coff                    ; yep
        br      std1                    ; (r0 inverted already)
aoff:   clrb    vola
        br      cmix                    ; continue testing
boff:   clrb    volb
        br      cmix1
coff:   clrb    volc                    ; clear volume C
        br      std1                    ; r0 inverted already
std:    com     r0                      ; convert ay data to bk style
std1:   tstb    (sp)+                   ; restore stack
        movb    r0, 177714
        br      more
eoi:    mov     (SP)+, r1
        mov     (SP)+, r0
v14e:   add     177711, 177713
        rtt

; --- <<< move file addr, name and do EMT 36 >>> ---
;
doload: mov     #320, r2
        mov     #16, r3
dl1:    mov     (r1)+, (r2)+
        sob     r3, dl1
        mov     #320, r1
        emt     36
        rts     pc

; --- <<< data >>> ---
;
cur:    .word   4000                    ; current buffer address
cur716: .word   16200                   ; current bk11m pages setup
rw1:    .word   7
preg:   .word   102000
volA:   .byte   0                       ; AY-3-8910 channel A volume (0-15)
volB:   .byte   0                       ; --------"-------  B
volC:   .byte   0                       ; --------"-------  C
type:   .byte   1                       ; buffer # (1,2,3,4,5,6)

dots:   .word   40660                   ; screen addr
        .word   1                       ; data mask (11=red dot)
        .word   63724                   ; screen addr
        .word   2                       ; data mask (10=green dot)
        .word   75706                   ; screen addr
        .word   1                       ; data mask (01=blue dot)
        .word   50442                   ; screen addr
        .word   3                       ; data mask (11=red dot)
        .word   54336                   ; screen addr
        .word   2                       ; data mask (10=green dot)
        .word   67210                   ; screen addr
        .word   1                       ; data mask (01=blue dot)
        .word   40346                   ; screen addr
        .word   3                       ; data mask (11=red dot)
        .word   56554                   ; screen addr
        .word   2                       ; data mask (10=green dot)
        .word   73102                   ; screen addr
        .word   3                       ; data mask (01=blue dot)
        .word   77666                   ; screen addr
        .word   2                       ; data mask
        .word   67334                   ; screen addr
        .word   1                       ; data mask
        .word   75776                   ; screen addr
        .word   2                       ; data mask
        .word   52464                   ; screen addr
        .word   1                       ; data mask
        .word   57720                   ; screen addr
        .word   2                       ; data mask
        .word   41002                   ; screen addr
        .word   3                       ; data mask
        .word   61514                   ; screen addr
        .word   3                       ; data mask
        .word   50700                   ; screen addr
        .word   2                       ; data mask
        .word   70562                   ; screen addr
        .word   1                       ; data mask

file1:  .word    3                      ; load cmd
	.word    4000                   ; buffer #1 adr
	.word    35000                  ; len in bytes
        .ascii  'NOROSOFT1.DAT   '

file2:  .word   3
	.word   40000			; adr
	.word   40000
        .ascii  'NOROSOFT2.DAT   '

file3:  .word   3
	.word   120000
	.word   20000
        .ascii  'NOROSOFT3.DAT   '

file4:  .word   3
	.word   40000
	.word   40000
        .ascii  'NOROSOFT4.DAT   '

file5:  .word   3
	.word   40000
	.word   40000
        .ascii  'NOROSOFT5.DAT   '

file6:  .word   3
	.word   40000
	.word   40000
        .ascii  'NOROSOFT6.DAT   '

file7:  .word   3
	.word   40000
        .word   30000
        .ascii  'NOROSOFT7.DAT   '

file8:  .word   3                       ; intro tune
	.word   40000
        .word   40000
        .ascii  'NOROSOFT8.DAT   '

	.end
