
; ===========================================================================
;
;   This is a main module for *.PSG files BK player (c) alex savelev - 2003
; Compiled for: Sampler.PT2 (converted from *.PT2 format to PSG by Ay_Emul)
; ===========================================================================

	.psect  1000                    ; compile at 1000

; --- <<< loader >>> ---
;
loader: mov     #776, sp
        mtps    #340
        reset
        mov     #disab, 4               ; disable stop
        mov     #40000, 177662          ; stop timer, show scr page 5
        mov     #75400, 177716          ; 6:3
        call    clr4                    ; clear page 6
        mov     #3000, r5
        mov     #54300,r2
        mov     #7000, r0
welc:   movb    (r5)+, (r2)+            ; copy welcome screen to page 6
        sob     r0, welc
        mov     #16200, 177716          ; page 5 at 40000,page 4 at 100000
        mov     #140000,177662          ; show scr page 6, timer OFF
        mov     #1330, 177664           ; normal scroll
        mov     #file6, r1
        call    doload                  ; load block6 to 40000
        mov     #15400, 177716          ; 5:3
        call    copy
        mov     #16200, 177716          ; 5:4
        mov     #file5, r1
        call    doload                  ; load block5 to 40000
        mov     #15000, 177716          ; 5:2
        call    copy                    ; copy 16kb datablock to ram page2
        mov     #16200, 177716          ; 5:4
        mov     #file4, r1
        call    doload                  ; load block4 to 40000
        mov     #14000, 177716          ; 5:1
        call    copy
        mov     #16200, 177716          ; normal 5:4 memory setup
	mov     #file1, r1
        call    doload                  ; load block1 (3000)
        call    clr4                    ; prepare page5 before picture load
        mov     #file7, r1              ; load pic (block7) at 40000,page5
        call    doload
        mov     #cool, 4
        jmp     40000                   ; unpack picture (packed w/ bkpack)
cool:   bitb    (sp)+, (sp)+            ; restore stack
        mov     #disab, 4               ; disable stop again
        mov     #file3, r1
        call    doload                  ; load block3 (120000)
        mov     #42000, 177662          ; show scr page5 (timer stopped),pal4
        mov     #17400, 177716          ; 5:6
        mov     #100000, r2
        mov     #20000, r4
cln1:   clr     (r2)+                   ; clear screen page 6
        sob     r4, cln1
        call    copy                    ; copy picture from 5 to 6
        mov     #142000,177662          ; show scr page 6, timer OFF, pal=4
        mov     #16200, r0
        mov     r0, 177716              ; set bk11m memory
        mov     r0, cur716              ; 5:4
	mov     #file2, r1
        call    doload                  ; load block2 (40000)
        call    shut                    ; fully initialize AY soundchip
        mov     #3000, cur              ; *********** BUFFER #1 *************
again:  movb    #1, type                ; starting buffer# := 1 !!
	mov     #hand, 100              ; set up 50 hz timer handler
	mov     #340, 102
	mtps    #0                      ; allow interrupts
        mov     #102000, 177662         ; turn ON 50hz timer,scr page=6,pal 4
        mov     #done, 4                ; user can cancel music playback !
        mov     #75400, 177716          ; 6:3 (map screen 6 at 40000)

; --- <<< infinite loop:draw AY-3-8910 channel A, B and C volume bars >>> ---
;
redraw: mov     #50312, r5              ; volume A - bar: SCREEN address
        movb    vola, r4                ; get actual channel A volume
        mov     #52525, r1
        call    chan                    ; draw bar for ch.A
        mov     #50335, r5              ; volume B - bar: SCREEN address
        movb    volb, r4
        mov     #177777, r1
        call    chan                    ; draw bar for ch.B
        mov     #50360, r5              ; volume C - bar: SCREEN address
        movb    volc, r4
        mov     #52525, r1
        call    chan                    ; draw bar for ch.C
        br      redraw

; --- <<< redraw single channel:r5=scr address of bottom line, r4=vol >>> ---
;
chan:   mov     #40, r3                 ; max vol = 16*2
        bic     #177760, r4             ; convert volume value to 0..15 range
	aslb	r4			; x2
cloop:  clr     r2                      ; empty fill
        tstb    r4                      ; zero already??
        beq     okfill
        mov     r1, r2                  ; filler
        decb    r4
okfill: movb    r2, @r5                 ; put data to screen
        movb    r2, 1(r5)
        movb    r2, 2(r5)
        movb    r2, 3(r5)
        movb    r2, 4(r5)               ; wide bars (3 words)
        movb    r2, 5(r5)
        sub     #100, r5
        sob     r3, cloop
        rts     pc

; --- <<< stop key handler, for use during loader phase >>> ---
;
disab:  sub     @pc, @sp                ; fully disable STOP key
        rti

; ---- <<< clear area 40000-100000 >>> ----
;
clr4:   mov     #40000, r3              ; clear screen page 5
        mov     #20000, r4
cln0:   clr     (r3)+
        sob     r4, cln0
        ret

; ---- <<< copy RAM page >>> ----
;
copy:   mov     #40000, r0
        mov     #100000, r1
        mov     #20000, r2
0:      mov     (r0)+, (r1)+
        sob     r2, 0
        ret

; ---- <<< shut down AY-3-8910 >>> ---
;
shut:   mov     #377, r0                ; ay reg #
        movb    #377, r1                ; ay data (zero)
        mov     #177714, r2             ; port
        mov     #20, r3                 ; counter (16 regs)
fill:   mov     r0, @r2                 ; send ay reg# (WORD)
        movb    r1, @r2                 ; send ay data (inverted zero), BYTE
        dec     r0                      ; next ay reg
        sob     r3, fill
        ret

; --- <<< retrieve musicdata, update pointer >>> ---
;
fetch:  mov     cur, r1                 ; get current address to R1
        mov     cur716, 177716          ; we must gain access to musicdata !!
        movb    (r1)+, r0               ; fetch data from (R1)+ to R0
        mov     #75400, 177716          ; 6:3 (map screen 6 at 40000)
        mov     r1, cur                 ; update address
        cmp     r1, #100000             ; overflow of buffer 1 & 2??
        beq     new
        cmp     r1, #121544             ; <-- end of melody point !!!
        bne     norm
        cmpb    type, #6
        beq     total
norm:   cmp     r1, #140000             ; overflow of buffer #3?
        beq     next
        ret
next:   cmpb    type, #3
        beq     med
        cmpb    type, #4
        beq     high
        mov     #15400, r1              ; 5:3
        movb    #6, type
gen:    mov     r1, cur716              ; save important value at memory
        mov     #100000, cur            ; 3, 4, 5
        ret
high:   mov     #15000, r1              ; 5:2
        movb    #5, type
        br      gen
med:    mov     #14000, r1              ; 5:1
        movb    #4, type                ; buffer #4
        br      gen
new:	movb    #3, type                ; we do not need to change 11m setup
        mov     #120000, cur            ; *********** BUFFER #2 *************
        ret
total:  mov     #16200, cur716          ; 5:4 (normal setup)
        mov     #15710, cur             ; <-- melody loop address!
        jmp     again                   ; restart playback

; --- <<< stop key handler, for use during playback >>> ---
;
done:   mtps    #340                    ; disable interrupts
        mov     #142000,177662          ; show scr page 6, timer OFF, pal=4
        call    shut                    ; shut down AY-3-8910 music chip
        mov     #17400, 177716          ; 5:6
        mov     #40000, r0
        mov     r0, r1
clntot: clr     (r0)+                   ; clear both page 5 and page 6
        sob     r1, clntot
        mov     #16200, 177716          ; 5:4
        reset
        mov     #40000, 177662          ; stop timer, show scr page 5, pal=0
        jmp     @#100000                ; restart AO-DOS (or other system :)

; --- <<< 50 hz player >>> ---
;
hand:   mov     r0, -(SP)               ; r0 used
        mov     r1, -(SP)               ; r1 used
more:   call    fetch                   ; retrieve next music byte to R0
        cmpb    #377, r0                ; end of INTR (0FFh) ??
        beq     eoi                     ; done
        bic     #177760, r0
        mov     r0, -(sp)               ; temporary save ay reg# to stack
        com     r0                      ; convert to BK style
        mov     r0, @#177714            ; send AY reg# to AY :-)
        call    fetch                   ; get AY data (normal) to R0
        cmp     @sp, #7
        beq     mixer
        cmp     @sp, #10                ; write to volume A register?
        beq     va
        cmp     @sp, #11                ; write to volume B register?
        beq     vb
        cmp     @sp, #12                ; write to volume C register?
        bne     std
        bitb    #20, r0                 ; envelope on volume C?? (10 000)
        beq     vcstd                   ; no - normal volume
        movb    #7, volC                ; interpolated envelope volume on C
        br      std
vcstd:  movb    r0, volC                ; save actual volume to VOL_C var
        br      std
vb:     bitb    #20, r0
        beq     vbstd
        movb    #7, volb                ; interpolated envelope volume on B
        br      std
vbstd:  movb    r0, volB                ; save actual volume to VOL_B var
        br      std
va:     bitb    #20, r0
        beq     vastd
        movb    #7, volA                ; interpolated envelope volume on A
        br      std
vastd:  movb    r0, volA                ; save actual volume to VOL_A var
        br      std
mixer:  com     r0                      ; invert for testing with / bitb
        bitb    #11, r0                 ; channel A is totally OFF?
        beq     aoff
cmix:   bitb    #22, r0
        beq     boff
cmix1:  bitb    #44, r0                 ; channel C is totally OFF??
        beq     coff                    ; yep
        br      std1                    ; (r0 inverted already)
aoff:   clrb    vola
        br      cmix                    ; continue testing
boff:   clrb    volb
        br      cmix1
coff:   clrb    volc                    ; clear volume C
        br      std1                    ; r0 inverted already
std:    com     r0                      ; convert ay data to bk style
std1:   tstb    (sp)+                   ; restore stack
        movb    r0, @#177714
        br      more
eoi:    mov     (SP)+, r1
        mov     (SP)+, r0
        rtt

; --- <<< move file addr, name and do EMT 36 >>> ---
;
doload: mov     #320, r2
        mov     #16, r3
dl1:    mov     (r1)+, (r2)+
        sob     r3, dl1
        mov     #320, r1
        emt     36
        rts     pc

; --- <<< data >>> ---
;
cur:    .word   3000                    ; current buffer address
cur716: .word   16200                   ; current bk11m pages setup
volA:   .byte   0                       ; AY-3-8910 channel A volume (0-15)
volB:   .byte   0                       ; --------"-------  B
volC:   .byte   0                       ; --------"-------  C
type:   .byte   1                       ; buffer # (1,2,3,4,5,6)

file1:  .word    3                      ; load cmd
	.word    3000                   ; buffer #1 adr
	.word    35000                  ; len in bytes
        .ascii  'sampler1.DAT    '
	.word   0

file2:  .word   3
	.word   40000			; adr
	.word   40000
        .ascii  'sampler2.DAT    '
	.word   0

file3:  .word   3
	.word   120000
	.word   20000
        .ascii  'sampler3.DAT    '
	.word   0

file4:  .word   3
	.word   40000
	.word   40000
        .ascii  'sampler4.DAT    '
	.word   0

file5:  .word   3
	.word   40000
	.word   40000
        .ascii  'sampler5.DAT    '
	.word   0

file6:  .word   3
	.word   40000
	.word   40000
        .ascii  'sampler6.DAT    '
	.word   0

file7:  .word   3
	.word   40000
        .word   34000
        .ascii  'sampler7.DAT    '
	.word   0

	.end
