/*
 *	ctype.h - character type definitions include file
 */
#ifdef	DOCUMENTATION

	This module defines a set of character test and manipulation
	macros  that allow classification
	and modification of Ascii characters.

	  isupper(c)	/* Upper case alphabetic	*/
	  islower(c)	/* Lower case alphabetic	*/
	  isalpha(c)	/* Alphabetic in any case	*/
	  isdigit(c)	/* Decimal digit		*/
	  isalnum(c)	/* Alphabetic or digit		*/
	  isxdigit(c)	/* Hexadecimal digit		*/
	  isspace(c)	/* Space or tab			*/
	  ispunct(c)	/* Punctuation			*/
	  isgraph(c)	/* Visible character		*/
	  isprint(c)	/* Printable character		*/
	  iscntrl(c)	/* Control character		*/
	  isascii(c)	/* 7-bit Ascii character	*/
	  _toupper(c)	/* Lower case convert to Upper	*/
	  _tolower(c)	/* Upper case convert to Lower	*/
	  toascii(c)	/* Remove eighth (parity) bit	*/

	Note that _toupper() and _tolower() must not be used with
	arguments that have side effects, such as

		_toupper(*ptr++);

	Use the functions toupper() and tolower() instead.
	
#endif

/*
 * 0.0 10-Mar-82 JB/MM	Extracted from vax library
 */

#define _U	0001	/*			Uppercase alpha		*/
#define _L	0002	/*			Lowercase alpha		*/
#define _UL	0003	/* _U | _L		Alpha in any case	*/
#define _D	0004	/*			Digit			*/
#define _ULD	0007	/* _U | _L | _D		Alphanumeric		*/
#define _S	0010	/*			Whitespace		*/
#define _P	0020	/*			Punctuation		*/
#define _PULD	0027	/* _P | _U | _L | _D	Textual character	*/
#define _C	0040	/*			Control character	*/
#define _X	0100	/*			Hexadecimal Alpha (A-F)	*/
#define _B	0200	/*			Space ' ' only		*/

extern	char	_ctype_ [];

#define isupper(c)	(_ctype_[(c)&0177]&_U)
#define islower(c)	(_ctype_[(c)&0177]&_L)
#define isalpha(c)	(_ctype_[(c)&0177]&_UL)
#define isdigit(c)	(_ctype_[(c)&0177]&_D)
#define isalnum(c)	(_ctype_[(c)&0177]&_ULD)
#define isxdigit(c)	(_ctype_[(c)&0177]&_X)
#define isspace(c)	(_ctype_[(c)&0177]&_S)
#define ispunct(c)	(_ctype_[(c)&0177]&_P)
#define isgraph(c)	(_ctype_[(c)&0177]&_PULD)
#define isprint(c)	(_ctype_[(c)&0177]&(_PULD|_B))
#define iscntrl(c)	(_ctype_[(c)&0177]&_C)
#define isascii(c)	((unsigned)(c)<=0177)
#define _toupper(c)	((c)>='a'&&(c)<='z'?(c)&0137:(c))
#define _tolower(c)	((c)>='A'&&(c)<='Z'?(c)|040:(c))
#define toascii(c)	((c)&0177)
                                                                                                                                                                                                                                                          