// Test program for DirectNT.sys
// Reading physical addresses 

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include "directnt.h"	   
#include <stdarg.h>
#include <string.h>

const char *DirectNTDrvName = "\\\\.\\Dev_DirectNT";
  
HANDLE Drv; 

static void error(char *fmt, ...)
{
  va_list argptr;

  va_start(argptr, fmt);
  vprintf(fmt, argptr);
  
  exit(1);
} /* error() */



BOOL DrvExec(HANDLE Drv,ULONG OpCode,ULONG Param1,ULONG Param2,ULONG Param3, void *Result,ULONG ResultSize)
{
  TDirectNTInfo I = {OpCode,Param1,Param2,Param3};
  ULONG         ResultLen;
  if (DeviceIoControl(Drv,DWORD(IOCTL_DIRECTNT_CONTROL),&I,sizeof(I),Result,ResultSize,&ResultLen,NULL))
  return TRUE;
  printf("Error in DirectNT.sys, Code = %d\n",GetLastError());
  return FALSE;
}

// #pragma argsused bei BC++ 

int __cdecl main(int argc,char *argv[])
{
  ULONG pstart, pend;
  ULONG value;

  Drv = CreateFile(DirectNTDrvName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
  if (Drv == INVALID_HANDLE_VALUE)
      error ("Error: Can't open DirectNT.sys!\n");

  if ((argc == 1) || (argc > 3)) 
      error ("Input memory address from .. to in hex\n");
    
  if (1 != sscanf(argv[1], "%x", &pstart))
        error ("from-address is not a correct hex value !\n");

  if (argc==3) 
       {
       if (1 != sscanf(argv[2], "%x", &pend))
           error("to-address is not a correct hex value!\n");
	    }
     else pend=pstart;
   
   for (ULONG p=pstart;p<= pend; p +=0x4) 
   {

   if (DrvExec(Drv,OP_ReadPhysMemDword,p,0,0, &value, sizeof (value)))
    printf ("%0X: %08X \n",p,value);  
    else error ("Error Reading Memory!\n");
   }
  
  if (!CloseHandle(Drv))
    printf("Error: Can't close DirectNT.sys!\n");
 
 return 0;
}
