/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences;

import bk2010.preferences.AYModes;
import bk2010.preferences.CovoxModes;
import bk2010.preferences.MachineBase;
import bk2010.preferences.PathStrings;
import java.io.File;

public class MachineConfiguration {
    public Choice machine = new Choice("Machine type", MachineBase.modes);
    public Choice AY = new Choice("AY-3-8910", AYModes.modes);
    public Choice Covox = new Choice("Covox", CovoxModes.modes);
    public OnOff filterSound = new OnOff("Filter", true);
    public OnOff noSound = new OnOff("No sound");
    public OnOff fakeTape = new OnOff("Tape<->.bin", true);
    public Disk diskA = new Disk("a.img");
    public Disk diskB = new Disk("b.img");
    public Tape readTape = new Tape("in.wav", false);
    public Tape writeTape = new Tape("out.wav", true);
    public boolean doLaunch;

    public MachineConfiguration() {
        this.Covox.select(0);
    }

    public class Choice {
        public final String subject;
        public final String[] choices;
        protected int selected;

        public Choice(String name, String[] choices) {
            this.subject = name;
            this.choices = choices;
            this.selected = choices.length - 1;
        }

        public String[] strings() {
            return this.choices;
        }

        public void select(int n) {
            if (n >= 0 && n < this.choices.length) {
                this.selected = n;
            }
        }

        public void select(String str) {
            str = str.trim();
            int i = 0;
            while (i < this.choices.length) {
                String choice = this.choices[i].trim();
                if (choice.equalsIgnoreCase(str)) {
                    this.selected = i;
                    break;
                }
                ++i;
            }
        }

        public int getSelected() {
            return this.selected;
        }

        public String getSelectedName() {
            return this.choices[this.selected];
        }
    }

    public class Disk {
        public File imageFile;
        public OnOff readOnly;
        public OnOff doMount;

        public Disk(String defaultFN) {
            this.readOnly = new OnOff("Read only");
            this.doMount = new OnOff("Mount");
            this.imageFile = new File(String.valueOf(PathStrings.diskImagesPath) + defaultFN);
            this.doMount.setState(true);
        }

        public Disk(File defaultFile) {
            this.readOnly = new OnOff("Read only");
            this.doMount = new OnOff("Mount");
            this.imageFile = defaultFile;
            this.doMount.setState(true);
        }
    }

    public class OnOff {
        public final String name;
        protected boolean state;

        public OnOff(String name) {
            this.name = name;
        }

        public OnOff(String name, boolean state) {
            this.name = name;
            this.state = state;
        }

        public void setState(boolean state) {
            this.state = state;
        }

        public boolean getState() {
            return this.state;
        }
    }

    public class Tape {
        public final boolean isOutput;
        public OnOff useTape;
        public OnOff motorControl;
        public File tapeFile;

        public Tape(String defaultFN, boolean toWrite) {
            this.useTape = new OnOff("Use tape", false);
            this.motorControl = new OnOff("Enable motor control", true);
            this.isOutput = toWrite;
            this.tapeFile = new File(String.valueOf(PathStrings.tapeImagesPath) + defaultFN);
        }

        public Tape(File defaultFile, boolean toWrite) {
            this.useTape = new OnOff("Use tape", false);
            this.motorControl = new OnOff("Enable motor control", true);
            this.isOutput = toWrite;
            this.tapeFile = defaultFile;
        }
    }
}

