/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.Shutdownable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ShutdownMonitor {
    private static final Set<Shutdownable> toShutdown = Collections.synchronizedSet(new HashSet());
    private static volatile boolean shuttingDown;

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownMonitorThread());
    }

    private ShutdownMonitor() {
    }

    public static void add(Shutdownable obj) {
        if (shuttingDown) {
            obj.shutdown();
        } else {
            toShutdown.add(obj);
        }
    }

    public static boolean remove(Shutdownable obj) {
        if (shuttingDown) {
            return false;
        }
        return toShutdown.remove(obj);
    }

    private static final class ShutdownMonitorThread
    extends Thread {
        private ShutdownMonitorThread() {
        }

        @Override
        public void run() {
            System.out.println("Emulator shutdown");
            shuttingDown = true;
            for (Shutdownable obj : toShutdown) {
                System.out.println(" .. " + obj.toString());
                obj.shutdown();
            }
            toShutdown.clear();
        }
    }
}

