/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.AudioAndTapePanel;
import bk2010.gui.DiskMountPanel;
import bk2010.gui.LauncherAdvancedDialog;
import bk2010.gui.helpers.RadioButtonPanel;
import bk2010.preferences.MachineConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class LauncherHWConfigurationDialog
extends JDialog {
    private MachineConfiguration selectedConfiguration;

    public LauncherHWConfigurationDialog(MachineConfiguration mc) {
        super((Frame)null, "BK2010 Launcher", true);
        this.selectedConfiguration = mc;
        AbstractAction launchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = true;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = false;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        };
        AbstractAction moreAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherAdvancedDialog dlg = new LauncherAdvancedDialog(LauncherHWConfigurationDialog.this.selectedConfiguration);
                dlg.setVisible(true);
                dlg.dispose();
            }
        };
        this.add((Component)new AudioAndTapePanel(this.selectedConfiguration), "North");
        Box leftPanel = Box.createVerticalBox();
        leftPanel.add(new RadioButtonPanel(this.selectedConfiguration.machine));
        leftPanel.add(Box.createVerticalGlue());
        JButton jbMore = new JButton("More ...");
        jbMore.addActionListener(moreAction);
        leftPanel.add(jbMore);
        this.add((Component)leftPanel, "West");
        Box okExitpanel = Box.createHorizontalBox();
        okExitpanel.add(Box.createHorizontalGlue());
        JButton jbStart = new JButton("Start emulator");
        jbStart.addActionListener(launchAction);
        okExitpanel.add(jbStart);
        JButton jbExit = new JButton("Quit");
        jbExit.addActionListener(quitAction);
        okExitpanel.add(jbExit);
        okExitpanel.add(Box.createHorizontalGlue());
        InputMap imap = okExitpanel.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "Launch");
        imap.put(KeyStroke.getKeyStroke(27, 0), "Quit");
        ActionMap amap = okExitpanel.getActionMap();
        amap.put("Launch", launchAction);
        amap.put("Quit", quitAction);
        this.add((Component)okExitpanel, "South");
        Box rPanel = Box.createVerticalBox();
        rPanel.add(new DiskMountPanel("Drive A:", this.selectedConfiguration.diskA));
        rPanel.add(new DiskMountPanel("Drive B:", this.selectedConfiguration.diskB));
        rPanel.add(Box.createVerticalGlue());
        this.add((Component)rPanel, "Center");
        this.pack();
        jbStart.requestFocusInWindow();
        Dimension winsize = this.getSize();
        Dimension scrsize = this.getToolkit().getScreenSize();
        this.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
    }

    public LauncherHWConfigurationDialog() {
        this(new MachineConfiguration());
    }

    public static MachineConfiguration doIt() {
        MachineConfiguration mc = new MachineConfiguration();
        mc.readFromFile();
        LauncherHWConfigurationDialog dlg = new LauncherHWConfigurationDialog(mc);
        dlg.setVisible(true);
        dlg.dispose();
        dlg.selectedConfiguration.saveToFile();
        return dlg.selectedConfiguration;
    }

    public static void main(String[] args) {
        LauncherHWConfigurationDialog.doIt();
        System.exit(0);
    }
}

