/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger;

import bk2010.gui.debugger.MemoryLocation;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.Disasm;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class MemoryModel
implements ListModel {
    private QBusProxy memory;
    private QBusReadDTO dto = new QBusReadDTO();
    private int[] memFlags = new int[32768];
    private int pc;

    public MemoryModel(QBusProxy memory) {
        this.memory = memory;
    }

    public void setPC(int addr) {
        this.pc = addr & 0xFFFE;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    public Object getElementAt(int index) {
        int len;
        int pcFlag;
        int n = pcFlag = index << 1 == this.pc ? 131072 : 0;
        if ((this.memFlags[index] & 7) == 0 && (len = Disasm.length(this.memory, (short)(index * 2))) > 0) {
            int pos = index;
            this.memFlags[pos] = this.memFlags[pos] & 0xFFFFFFF8 | len--;
            pos = pos + 1 & Short.MAX_VALUE;
            while (len-- > 0) {
                this.memFlags[pos] = this.memFlags[pos] & 0xFFFFFFF8 | 4;
                pos = pos + 1 & Short.MAX_VALUE;
            }
            while ((this.memFlags[pos] & 7) != 0) {
                int n2 = pos;
                this.memFlags[n2] = this.memFlags[n2] & 0xFFFFFFF8;
                pos = pos + 1 & Short.MAX_VALUE;
            }
        }
        if (!this.memory.readWord((short)(index * 2), this.dto)) {
            return new MemoryLocation(this.memory, index * 2, 65535, 0x10000 | pcFlag);
        }
        return new MemoryLocation(this.memory, index * 2, this.dto.value, this.memFlags[index] | pcFlag);
    }

    @Override
    public int getSize() {
        return 32768;
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

