/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.helpers;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class TapeFileFilter
extends FileFilter {
    String root;

    public TapeFileFilter(File rootDirectory) {
        try {
            this.root = rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            this.root = rootDirectory.getAbsolutePath();
        }
    }

    @Override
    public boolean accept(File f) {
        String path;
        if (!f.canRead()) {
            return false;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        if (path.startsWith(this.root)) {
            if (f.isDirectory()) {
                return true;
            }
            if ((path = path.toLowerCase()).endsWith(".wav")) {
                return true;
            }
        }
        return f.isDirectory() && this.root.startsWith(path);
    }

    @Override
    public String getDescription() {
        return "BK2010 Tape File";
    }
}

