/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.types;

import bk2010.preferences.PathStrings;
import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.storage.Setting;
import bk2010.preferences.types.OnOff;
import java.io.File;

public class Disk
implements Cloneable {
    public File imageFile;
    public OnOff readOnly = new OnOff("Read only");
    public OnOff doMount = new OnOff("Mount");

    public Disk(String defaultFN) {
        this.imageFile = new File(String.valueOf(PathStrings.diskImagesPath) + defaultFN);
        this.doMount.setState(true);
    }

    public Disk(File defaultFile) {
        this.imageFile = defaultFile;
        this.doMount.setState(true);
    }

    public void saveTo(ConfigFile cf, String prefix) {
        String imageName = String.valueOf(prefix) + "Image";
        Setting s = cf.getSetting(imageName);
        s = s == null ? new Setting(imageName, this.imageFile.getPath(), "") : new Setting(s.name, this.imageFile.getPath(), s.comments);
        cf.setSetting(s);
        this.readOnly.saveTo(cf, prefix);
        this.doMount.saveTo(cf, prefix);
    }

    public void readFrom(ConfigFile cf, String prefix) {
        this.readOnly.readFrom(cf, prefix);
        this.doMount.readFrom(cf, prefix);
        String imageName = String.valueOf(prefix) + "Image";
        Setting s = cf.getSetting(imageName);
        if (s == null || s.value.isEmpty()) {
            return;
        }
        this.imageFile = new File(s.value);
    }

    public Disk clone() {
        Disk tmp = new Disk(this.imageFile);
        tmp.doMount = this.doMount.clone();
        tmp.readOnly = this.readOnly.clone();
        return tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.doMount == null ? 0 : this.doMount.hashCode());
        result = 31 * result + (this.imageFile == null ? 0 : this.imageFile.hashCode());
        result = 31 * result + (this.readOnly == null ? 0 : this.readOnly.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disk other = (Disk)obj;
        if (this.doMount == null ? other.doMount != null : !this.doMount.equals(other.doMount)) {
            return false;
        }
        if (this.imageFile == null ? other.imageFile != null : !this.imageFile.equals(other.imageFile)) {
            return false;
        }
        return !(this.readOnly == null ? other.readOnly != null : !this.readOnly.equals(other.readOnly));
    }
}

