
#pragma used+
sfrb DIDR=1;
sfrb UBRRH=2;
sfrb UCSRC=3;
sfrb PCMSK1=4; 
sfrb PCMSK2=5; 
sfrb ACSR=8;
sfrb UBRRL=9;
sfrb UCSRB=0xa;
sfrb UCSRA=0xb;
sfrb UDR=0xc;
sfrb USICR=0xd;
sfrb USISR=0xe;
sfrb USIDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb GPIOR0=0x13;
sfrb GPIOR1=0x14;
sfrb GPIOR2=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb PINA=0x19;
sfrb DDRA=0x1a;
sfrb PORTA=0x1b;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEAR=0x1e;
sfrb PCMSK0=0x20;
sfrb WDTCR=0x21;
sfrb TCCR1C=0x22;
sfrb GTCCR=0x23;
sfrb ICR1L=0x24;
sfrb ICR1H=0x25;
sfrw ICR1=0x24;   
sfrb CLKPR=0x26;
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;   
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;   
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb TCCR0A=0x30;
sfrb OSCCAL=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0B=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb OCR0A=0x36;
sfrb SPMCSR=0x37;
sfrb TIFR=0x38;
sfrb TIMSK=0x39;
sfrb GIFR=0x3a; 
sfrb GIMSK=0x3b;
sfrb OCR0B=0x3c;
sfrb SPL=0x3d;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x50
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x40
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

bit begin_p; 
bit begin_k; 

bit end_p; 
bit end_k; 

bit lower_p; 
bit lower_k; 

bit zav_k; 

unsigned long max_p; 
unsigned long max_k; 

unsigned int timer_p;  
unsigned int timer_k;  

unsigned int timer_akt_p;  
unsigned int timer_akt_k;  

unsigned int step_p; 
unsigned int step_k; 
unsigned int step_pe; 
unsigned int step_ke; 

unsigned long tim_ocr_p;  
unsigned long tim_ocr_k;  

unsigned char start_cycle; 

eeprom unsigned int TP; 
eeprom unsigned int TK; 

eeprom unsigned int TBBP; 
eeprom unsigned int TBBK; 
eeprom unsigned int TBEP; 
eeprom unsigned int TBEK; 

eeprom unsigned int LEV_P; 
eeprom unsigned int LEV_K; 

eeprom unsigned long  day_p;  
eeprom unsigned long  day_k;  
eeprom unsigned long  night_p; 
eeprom unsigned long  night_k; 

void init_eerpom(void)  
{

day_p=1023  *128   *100  /100;  
day_k=1023  *128   *100  /100;   
night_p=1023  *128   *30   /100; 
night_k=1023  *128   *10   /100; 

TP=90 *128   ;       
TK=90 *128   ;       
TBBP=3 *128   ;   
TBBK=3 *128   ;   
TBEP=50 *128   ;   
TBEK=50 *128   ;   
LEV_P=50 *128   ; 
LEV_K=100 *128   ; 

}

void tim_write_p(void)  
{

OCR1A=tim_ocr_p>>7;  
}

void tim_write_k(void)  
{

OCR1B=tim_ocr_k>>7;  
}

void recalc_p(void)  
{
step_p=max_p/TBBP; 
step_pe=max_p/TBEP; 
}

void recalc_k(void)  
{
step_k=max_k/TBBK; 
step_ke=max_k/TBEK; 
}

interrupt [7] void timer0_ovf_isr(void)
{

TCNT0=0x0B;  

PORTD.6 =1;   

if ((PIND.2 ==1 || PINA.1 ==1)  && timer_p==0) 
{ 
begin_p=1;  end_p=0; 

if (PIND.4 ==0 && PIND.2 ==1 ) 
{max_p=day_p;    }  
else 
{max_p=night_p;  }

if (PINA.1 ==1 )
{max_p=day_p;  } 
recalc_p();

if (begin_k==0 && timer_k==0) 
{begin_k=1 ; end_k=0;  timer_k=TK/2; zav_k=1;
if (PIND.4 ==0) 
{ max_k=day_k/2;  }  
else 
{ max_k=night_k/2;  }
recalc_k();  
}          
} 

if ( (PIND.3 ==1 && timer_k==0) || (PIND.3 ==1 && zav_k==1)) 
{ 
begin_k=1 ; end_k=0; 
zav_k=0;
if (PIND.4 ==0) 
{ max_k=day_k;    }
else
{ max_k=night_k;  }

recalc_k();                
}      

if (PINA.1 ==1 || PIND.2 ==1  ) 
{  
timer_p=TP;  
timer_akt_p++; 
if (PIND.4 ==1 && timer_akt_p>LEV_P) 
{ max_p=day_p; recalc_p(); } 
}    
if (PIND.3 ==1) 
{
timer_k=TK; 
timer_akt_k++; 
if (PIND.4 ==1 && timer_akt_k>LEV_K) 
{max_k=day_k;   recalc_k(); } 
}

if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p<max_p )  
{ begin_p=1;}  
if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p>max_p )  
{ lower_p=1;}  

if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k<max_k )  
{ begin_k=1;}  
if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k>max_k )  
{ lower_k=1;}                

if (timer_p>0 && begin_p==1 && tim_ocr_p<max_p ) 
{ tim_ocr_p+=step_p; tim_write_p();  }
if (timer_p>0 && begin_p==1 && tim_ocr_p>=max_p ) 
{  begin_p=0; 
tim_ocr_p=max_p; 
tim_write_p();  } 

if (timer_p>0 && begin_p==0 && lower_p==0 )       
{ timer_p--;  }

if (timer_p==0 && tim_ocr_p>0 && end_p==0 ) 
{end_p=1; 
timer_akt_p=0; }
if ((tim_ocr_p==0 || tim_ocr_p-step_pe>max_p)&& end_p==1) 
{end_p=0; tim_ocr_p=0; tim_write_p(); timer_akt_p=0;}                  
if (tim_ocr_p>0 && end_p==1)  
{tim_ocr_p-=step_pe; tim_write_p();  }

if (lower_p==1)   
{tim_ocr_p=tim_ocr_p-step_pe; tim_write_p();  }
if (lower_p==1 && tim_ocr_p>max_p )  
{lower_p=0;}       

if (timer_k>0 && begin_k==1 && tim_ocr_k<max_k ) 
{ tim_ocr_k+=step_k;  tim_write_k();  }
if (timer_k>0 && begin_k==1 && tim_ocr_k>=max_k ) 
{ begin_k=0; tim_ocr_k=max_k; tim_write_k();  }            

if (timer_k>0 && begin_k==0 && lower_k==0)       
{  timer_k--;   }             

if (timer_k==0 && tim_ocr_k>0 && end_k==0)
{end_k=1;
timer_akt_k=0; } 
if ((tim_ocr_k==0 || tim_ocr_k-step_ke>max_k ) && end_k==1) 
{end_k=0; tim_ocr_k=0; tim_write_k(); timer_akt_k=0;}    
if (tim_ocr_k>0 && end_k==1)
{ tim_ocr_k-=step_ke;  tim_write_k();  }                 

if (lower_k==1)   
{tim_ocr_k=tim_ocr_k-step_ke;  tim_write_k();  }
if (lower_k==1 && tim_ocr_k>max_k )  
{lower_k=0;}

PORTD.6 =0;   
}

void main(void)
{

#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#pragma optsize+

PORTA=0x01;
DDRA=0x01;

PORTB=0x00;
DDRB=0x18;

PORTD=0x00;
DDRD=0x41;

TCCR0A=0x00;
TCCR0B=0x04;
TCNT0=0x0B;
OCR0A=0x00;
OCR0B=0x00;

TCCR1A=0xA3;
TCCR1B=0x01;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

MCUCR=0x00;
GIMSK=0x00;

TIMSK=0x02;

USICR=0x00;

UCSRB=0x00;

ACSR=0x80;
DIDR=0x00;

begin_p=0; begin_k=0; end_p=0; end_k=0; timer_p=0; timer_k=0; tim_ocr_p=0; tim_ocr_k=0; timer_akt_p=0; timer_akt_k=0; zav_k=0;

init_eerpom();

for (start_cycle = 0; start_cycle < 15; start_cycle ++ ) 
{
PORTD.6 =1;   
delay_ms(125); 
PORTD.6 =0;
delay_ms(125);     
}    

#asm("sei")

while (1)
{  

};

}

