
;CodeVisionAVR C Compiler V2.05.3 Standard
;(C) Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATtiny2313
;Program type             : Application
;Clock frequency          : 8.000000 MHz
;Memory model             : Tiny
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 32 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : No
;8 bit enums              : Yes
;Global 'const' stored in FLASH     : No
;Enhanced function parameter passing: Yes
;Enhanced core instructions         : On
;Smart register allocation          : On
;Automatic register allocation      : On

	#pragma AVRPART ADMIN PART_NAME ATtiny2313
	#pragma AVRPART MEMORY PROG_FLASH 2048
	#pragma AVRPART MEMORY EEPROM 128
	#pragma AVRPART MEMORY INT_SRAM SIZE 223
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F
	.EQU GPIOR0=0x13
	.EQU GPIOR1=0x14
	.EQU GPIOR2=0x15

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x00DF
	.EQU __DSTACK_SIZE=0x0020
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _timer_p=R2
	.DEF _timer_k=R4
	.DEF _timer_akt_p=R6
	.DEF _timer_akt_k=R8
	.DEF _step_p=R10
	.DEF _step_k=R12

;GPIOR0-GPIOR2 INITIALIZATION VALUES
	.EQU __GPIOR0_INIT=0x00
	.EQU __GPIOR1_INIT=0x00
	.EQU __GPIOR2_INIT=0x00

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer0_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,__CLEAR_SRAM_SIZE
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_SRAM

;GPIOR0-GPIOR2 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30
	;__GPIOR1_INIT = __GPIOR0_INIT
	OUT  GPIOR1,R30
	;__GPIOR2_INIT = __GPIOR0_INIT
	OUT  GPIOR2,R30

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x80

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.3 Standard
;Automatic Program Generator
;Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :  
;Version : 2.1    2313
;Date    : 07.01.2013
;Author  : MAXIOL
;Company : MAXIOL
;Comments:   
;
;Chip type               : ATtiny2313A
;AVR Core Clock frequency: 8.000000 MHz
;Memory model            : Tiny
;External RAM size       : 0
;Data Stack size         : 32
;*****************************************************/
;
;#include <tiny2313a.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x50
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x40
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;
;//      8MHz - 100
;
;// Declare your global variables here
;bit begin_p; //   
;bit begin_k; //   
;
;bit end_p; //   
;bit end_k; //   
;
;bit lower_p; //    
;bit lower_k; //    
;
;bit zav_k; //   
;
;
;unsigned long max_p; //      
;unsigned long max_k; //       
;
;unsigned int timer_p;  //   
;unsigned int timer_k;  //   
;
;unsigned int timer_akt_p;  //    
;unsigned int timer_akt_k;  //    
;
;unsigned int step_p; //    
;unsigned int step_k; //    
;unsigned int step_pe; //    
;unsigned int step_ke; //    
;
;unsigned long tim_ocr_p;  //          *100
;unsigned long tim_ocr_k;  //           *100
;
;unsigned char start_cycle; //     
;
;
;//eeprom unsigned int flag_eerpom_good; //   eeprom = 12345 -  ok
;eeprom unsigned int TP; //        . 1=10
;eeprom unsigned int TK; //        . 1=10
;
;eeprom unsigned int TBBP; //        . 1=10  1=100  / 
;eeprom unsigned int TBBK; //        . 1=10             / 
;eeprom unsigned int TBEP; //    . 1=10                          / 
;eeprom unsigned int TBEK; //    . 1=10                          / 
;
;eeprom unsigned int LEV_P; //         . 1=10 / 
;eeprom unsigned int LEV_K; //         . 1=10 / 
;
;// 
;eeprom unsigned long  day_p;  //   
;eeprom unsigned long  day_k;  //   
;eeprom unsigned long  night_p; //   
;eeprom unsigned long  night_k; //   
;//eeprom unsigned char kmid;    //        
;
;//   %
;#define  L_day_p   100  //   
;#define  L_day_k   100  //   
;#define  L_night_p 28   //   
;#define  L_night_k 7   //   
;// 
;#define  L_TP      90 //        
;#define  L_TK      90 //        
;#define  L_TBBP     3 //          / 
;#define  L_TBBK     3 //           / 
;#define  L_TBEP    50 //                   / 
;#define  L_TBEK    50 //                   / 
;#define  L_LEV_P   50 //          / 
;#define  L_LEV_K  100 //          / 
;
;
;//    
;#define  OCR_CLOCK  64   //     
;//#define  MAX_LIGHT  1023  //   -
;#define  MAX_LIGHT  8191  //   -
;//   
;#define  DAY  PIND.4 // PIND.4 /  ==0 
;#define  KOR  PIND.3 // PIND.3     ==1   (   )
;#define  PRI  PIND.2 // PIND.2    ==1   (   )
;#define  DOR  PINA.1 // PINA.1       ==1   (   )
;//  
;#define  LED  PORTD.6 //   
;#define  LED2  PORTD.0 //   
;// 
;#define  OCR_PRI  OCR1A
;#define  OCR_KOR  OCR1B
;
;
;void init_eerpom(void)  // -    eeprom   
; 0000 0071 {

	.CSEG
_init_eerpom:
; 0000 0072 //if (flag_eerpom_good!=12345)
; 0000 0073 //  {
; 0000 0074   // 
; 0000 0075   day_p=MAX_LIGHT*OCR_CLOCK*L_day_p/100;  //   
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0x1
; 0000 0076   day_k=MAX_LIGHT*OCR_CLOCK*L_day_k/100;   //   
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x1
; 0000 0077   night_p=MAX_LIGHT*OCR_CLOCK*L_night_p/100; //   
	LDI  R26,LOW(_night_p)
	LDI  R27,HIGH(_night_p)
	__GETD1N 0x23D5E
	RCALL __EEPROMWRD
; 0000 0078   night_k=MAX_LIGHT*OCR_CLOCK*L_night_k/100; //   
	LDI  R26,LOW(_night_k)
	LDI  R27,HIGH(_night_k)
	__GETD1N 0x8F57
	RCALL __EEPROMWRD
; 0000 0079 //  kmid=2;    //        
; 0000 007A 
; 0000 007B   // 
; 0000 007C   TP=L_TP*OCR_CLOCK;       //        .
	LDI  R26,LOW(_TP)
	LDI  R27,HIGH(_TP)
	LDI  R30,LOW(5760)
	LDI  R31,HIGH(5760)
	RCALL __EEPROMWRW
; 0000 007D   TK=L_TK*OCR_CLOCK;       //        .
	LDI  R26,LOW(_TK)
	LDI  R27,HIGH(_TK)
	RCALL __EEPROMWRW
; 0000 007E   TBBP=L_TBBP*OCR_CLOCK;   //        .  / 
	LDI  R26,LOW(_TBBP)
	LDI  R27,HIGH(_TBBP)
	LDI  R30,LOW(192)
	LDI  R31,HIGH(192)
	RCALL __EEPROMWRW
; 0000 007F   TBBK=L_TBBK*OCR_CLOCK;   //        .  / 
	LDI  R26,LOW(_TBBK)
	LDI  R27,HIGH(_TBBK)
	RCALL __EEPROMWRW
; 0000 0080   TBEP=L_TBEP*OCR_CLOCK;   //    .                / 
	LDI  R26,LOW(_TBEP)
	LDI  R27,HIGH(_TBEP)
	RCALL SUBOPT_0x3
; 0000 0081   TBEK=L_TBEK*OCR_CLOCK;   //    .                / 
	LDI  R26,LOW(_TBEK)
	LDI  R27,HIGH(_TBEK)
	RCALL SUBOPT_0x3
; 0000 0082   LEV_P=L_LEV_P*OCR_CLOCK; //         . / 
	LDI  R26,LOW(_LEV_P)
	LDI  R27,HIGH(_LEV_P)
	RCALL SUBOPT_0x3
; 0000 0083   LEV_K=L_LEV_K*OCR_CLOCK; //         . / 
	LDI  R26,LOW(_LEV_K)
	LDI  R27,HIGH(_LEV_K)
	LDI  R30,LOW(6400)
	LDI  R31,HIGH(6400)
	RCALL __EEPROMWRW
; 0000 0084 //  }
; 0000 0085 }
	RET
;
;
;// 
;void tim_write_p(void)  //      tim_ocr_p/OCR_CLOCK
; 0000 008A {
_tim_write_p:
; 0000 008B //OCR_PRI=tim_ocr_p/OCR_CLOCK;
; 0000 008C //OCR_PRI=tim_ocr_p>>7;  // :128
; 0000 008D OCR_PRI=tim_ocr_p>>6;  // :64
	RCALL SUBOPT_0x4
	LDI  R30,LOW(6)
	RCALL __LSRD12
	OUT  0x2A+1,R31
	OUT  0x2A,R30
; 0000 008E }
	RET
;
;//
;void tim_write_k(void)  //      tim_ocr_k/OCR_CLOCK
; 0000 0092 {
_tim_write_k:
; 0000 0093 //OCR_KOR=tim_ocr_k/OCR_CLOCK;
; 0000 0094 //OCR_KOR=tim_ocr_k>>7;  // :128
; 0000 0095 OCR_KOR=tim_ocr_k>>6;  // :64
	RCALL SUBOPT_0x5
	LDI  R30,LOW(6)
	RCALL __LSRD12
	OUT  0x28+1,R31
	OUT  0x28,R30
; 0000 0096 }
	RET
;
;void recalc_p(void)  // -      - 
; 0000 0099 {
_recalc_p:
; 0000 009A  step_p=max_p/TBBP; //   -  
	LDI  R26,LOW(_TBBP)
	LDI  R27,HIGH(_TBBP)
	RCALL SUBOPT_0x6
	MOVW R10,R30
; 0000 009B  step_pe=max_p/TBEP; //  -  
	LDI  R26,LOW(_TBEP)
	LDI  R27,HIGH(_TBEP)
	RCALL SUBOPT_0x6
	STS  _step_pe,R30
	STS  _step_pe+1,R31
; 0000 009C }
	RET
;
;void recalc_k(void)  // -      -  
; 0000 009F {
_recalc_k:
; 0000 00A0  step_k=max_k/TBBK; //   -  
	LDI  R26,LOW(_TBBK)
	LDI  R27,HIGH(_TBBK)
	RCALL SUBOPT_0x7
	MOVW R12,R30
; 0000 00A1  step_ke=max_k/TBEK; //   -  
	LDI  R26,LOW(_TBEK)
	LDI  R27,HIGH(_TBEK)
	RCALL SUBOPT_0x7
	STS  _step_ke,R30
	STS  _step_ke+1,R31
; 0000 00A2 }
	RET
;
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 00A6 {
_timer0_ovf_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00A7 // Reinitialize Timer 0 value
; 0000 00A8 //TCNT0=0xB1;  // ~100Hz
; 0000 00A9 //TCNT0=0x0B;  //  ~128Hz
; 0000 00AA TCNT0=0x85; //  64 
	LDI  R30,LOW(133)
	OUT  0x32,R30
; 0000 00AB 
; 0000 00AC 
; 0000 00AD // Place your code here
; 0000 00AE LED=1;   //   
	SBI  0x12,6
; 0000 00AF 
; 0000 00B0       // 
; 0000 00B1       //     -      !
; 0000 00B2       if ((PRI==1 || DOR==1)  && timer_p==0) //  -        
	SBIC 0x10,2
	RJMP _0x6
	SBIS 0x19,1
	RJMP _0x8
_0x6:
	RCALL SUBOPT_0x8
	BREQ _0x9
_0x8:
	RJMP _0x5
_0x9:
; 0000 00B3         {
; 0000 00B4         begin_p=1;  end_p=0; //        
	SBI  0x13,0
	CBI  0x13,2
; 0000 00B5 
; 0000 00B6         if (DAY==0 && PRI==1 ) // /
	LDI  R26,0
	SBIC 0x10,4
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BRNE _0xF
	SBIC 0x10,2
	RJMP _0x10
_0xF:
	RJMP _0xE
_0x10:
; 0000 00B7           {max_p=day_p;    }
	RCALL SUBOPT_0x0
	RJMP _0xA2
; 0000 00B8           else
_0xE:
; 0000 00B9           {max_p=night_p;  }
	LDI  R26,LOW(_night_p)
	LDI  R27,HIGH(_night_p)
_0xA2:
	RCALL __EEPROMRDD
	RCALL SUBOPT_0x9
; 0000 00BA 
; 0000 00BB         if (DOR==1 )
	SBIS 0x19,1
	RJMP _0x12
; 0000 00BC           {max_p=day_p;  } //   -   
	RCALL SUBOPT_0x0
	RCALL __EEPROMRDD
	RCALL SUBOPT_0x9
; 0000 00BD         recalc_p();
_0x12:
	RCALL _recalc_p
; 0000 00BE 
; 0000 00BF           //  
; 0000 00C0         if (begin_k==0 && timer_k==0) //  50%        
	RCALL SUBOPT_0xA
	BRNE _0x14
	RCALL SUBOPT_0xB
	BREQ _0x15
_0x14:
	RJMP _0x13
_0x15:
; 0000 00C1           {begin_k=1 ; end_k=0;  timer_k=TK/2; zav_k=1;
	SBI  0x13,1
	CBI  0x13,3
	LDI  R26,LOW(_TK)
	LDI  R27,HIGH(_TK)
	RCALL __EEPROMRDW
	LSR  R31
	ROR  R30
	MOVW R4,R30
	SBI  0x13,6
; 0000 00C2            if (DAY==0) // /
	SBIC 0x10,4
	RJMP _0x1C
; 0000 00C3             { max_k=day_k/2;  }
	RCALL SUBOPT_0x2
	RJMP _0xA3
; 0000 00C4             else
_0x1C:
; 0000 00C5             { max_k=night_k/2;  }
	LDI  R26,LOW(_night_k)
	LDI  R27,HIGH(_night_k)
_0xA3:
	RCALL __EEPROMRDD
	RCALL __LSRD1
	RCALL SUBOPT_0xC
; 0000 00C6           recalc_k();
	RCALL _recalc_k
; 0000 00C7           }
; 0000 00C8         }
_0x13:
; 0000 00C9 
; 0000 00CA       if ( (KOR==1 && timer_k==0) || (KOR==1 && zav_k==1)) // 
_0x5:
	SBIS 0x10,3
	RJMP _0x1F
	RCALL SUBOPT_0xB
	BREQ _0x21
_0x1F:
	SBIS 0x10,3
	RJMP _0x22
	SBIC 0x13,6
	RJMP _0x21
_0x22:
	RJMP _0x1E
_0x21:
; 0000 00CB         {
; 0000 00CC         begin_k=1 ; end_k=0; //        
	SBI  0x13,1
	CBI  0x13,3
; 0000 00CD         zav_k=0;
	CBI  0x13,6
; 0000 00CE         if (DAY==0) // /
	SBIC 0x10,4
	RJMP _0x2B
; 0000 00CF           { max_k=day_k;    }
	RCALL SUBOPT_0x2
	RJMP _0xA4
; 0000 00D0           else
_0x2B:
; 0000 00D1           { max_k=night_k;  }
	LDI  R26,LOW(_night_k)
	LDI  R27,HIGH(_night_k)
_0xA4:
	RCALL __EEPROMRDD
	RCALL SUBOPT_0xC
; 0000 00D2           //       
; 0000 00D3         recalc_k();
	RCALL _recalc_k
; 0000 00D4         }
; 0000 00D5 
; 0000 00D6 
; 0000 00D7       //    
; 0000 00D8       if (DOR==1 || PRI==1  ) //        
_0x1E:
	SBIC 0x19,1
	RJMP _0x2E
	SBIS 0x10,2
	RJMP _0x2D
_0x2E:
; 0000 00D9         {
; 0000 00DA         timer_p=TP;  //    
	LDI  R26,LOW(_TP)
	LDI  R27,HIGH(_TP)
	RCALL __EEPROMRDW
	MOVW R2,R30
; 0000 00DB         timer_akt_p++; //    
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
; 0000 00DC         if (DAY==1 && timer_akt_p>LEV_P) //      
	SBIS 0x10,4
	RJMP _0x31
	LDI  R26,LOW(_LEV_P)
	LDI  R27,HIGH(_LEV_P)
	RCALL __EEPROMRDW
	CP   R30,R6
	CPC  R31,R7
	BRLO _0x32
_0x31:
	RJMP _0x30
_0x32:
; 0000 00DD           { max_p=day_p; recalc_p(); } //   
	RCALL SUBOPT_0x0
	RCALL __EEPROMRDD
	RCALL SUBOPT_0x9
	RCALL _recalc_p
; 0000 00DE         }
_0x30:
; 0000 00DF       if (KOR==1) // 
_0x2D:
	SBIS 0x10,3
	RJMP _0x33
; 0000 00E0         {
; 0000 00E1         timer_k=TK; //    
	LDI  R26,LOW(_TK)
	LDI  R27,HIGH(_TK)
	RCALL __EEPROMRDW
	MOVW R4,R30
; 0000 00E2         timer_akt_k++; //    
	MOVW R30,R8
	ADIW R30,1
	MOVW R8,R30
	SBIW R30,1
; 0000 00E3         if (DAY==1 && timer_akt_k>LEV_K) //      
	SBIS 0x10,4
	RJMP _0x35
	LDI  R26,LOW(_LEV_K)
	LDI  R27,HIGH(_LEV_K)
	RCALL __EEPROMRDW
	CP   R30,R8
	CPC  R31,R9
	BRLO _0x36
_0x35:
	RJMP _0x34
_0x36:
; 0000 00E4           {max_k=day_k;   recalc_k(); } //   
	RCALL SUBOPT_0x2
	RCALL __EEPROMRDD
	RCALL SUBOPT_0xC
	RCALL _recalc_k
; 0000 00E5         }
_0x34:
; 0000 00E6 
; 0000 00E7 
; 0000 00E8       //   /    
; 0000 00E9       //  2  -              
; 0000 00EA       //       -
; 0000 00EB       if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p<max_p )  //     
_0x33:
	RCALL SUBOPT_0xD
	BRNE _0x38
	RCALL SUBOPT_0xE
	BRNE _0x38
	RCALL SUBOPT_0x8
	BRSH _0x38
	RCALL SUBOPT_0xF
	RCALL __CPD21
	BRLO _0x39
_0x38:
	RJMP _0x37
_0x39:
; 0000 00EC        { begin_p=1;}
	SBI  0x13,0
; 0000 00ED       if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p>max_p )  //     
_0x37:
	RCALL SUBOPT_0xD
	BRNE _0x3D
	RCALL SUBOPT_0xE
	BRNE _0x3D
	RCALL SUBOPT_0x8
	BRSH _0x3D
	RCALL SUBOPT_0xF
	RCALL __CPD12
	BRLO _0x3E
_0x3D:
	RJMP _0x3C
_0x3E:
; 0000 00EE        { lower_p=1;}
	SBI  0x13,4
; 0000 00EF 
; 0000 00F0       if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k<max_k )  //     
_0x3C:
	RCALL SUBOPT_0xA
	BRNE _0x42
	RCALL SUBOPT_0x10
	BRNE _0x42
	RCALL SUBOPT_0xB
	BRSH _0x42
	RCALL SUBOPT_0x11
	RCALL __CPD21
	BRLO _0x43
_0x42:
	RJMP _0x41
_0x43:
; 0000 00F1        { begin_k=1;}
	SBI  0x13,1
; 0000 00F2       if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k>max_k )  //     
_0x41:
	RCALL SUBOPT_0xA
	BRNE _0x47
	RCALL SUBOPT_0x10
	BRNE _0x47
	RCALL SUBOPT_0xB
	BRSH _0x47
	RCALL SUBOPT_0x11
	RCALL __CPD12
	BRLO _0x48
_0x47:
	RJMP _0x46
_0x48:
; 0000 00F3        { lower_k=1;}
	SBI  0x13,5
; 0000 00F4       //  
; 0000 00F5 
; 0000 00F6 
; 0000 00F7       //  
; 0000 00F8 
; 0000 00F9       // 
; 0000 00FA       //   
; 0000 00FB       if (timer_p>0 && begin_p==1 && tim_ocr_p<max_p ) //    -    max_p
_0x46:
	RCALL SUBOPT_0x8
	BRSH _0x4C
	SBIS 0x13,0
	RJMP _0x4C
	RCALL SUBOPT_0xF
	RCALL __CPD21
	BRLO _0x4D
_0x4C:
	RJMP _0x4B
_0x4D:
; 0000 00FC         { tim_ocr_p+=step_p; tim_write_p();  }
	MOVW R30,R10
	RCALL SUBOPT_0x12
	RCALL __ADDD12
	RCALL SUBOPT_0x13
; 0000 00FD       if (timer_p>0 && begin_p==1 && tim_ocr_p>=max_p ) //    
_0x4B:
	RCALL SUBOPT_0x8
	BRSH _0x4F
	SBIS 0x13,0
	RJMP _0x4F
	RCALL SUBOPT_0xF
	RCALL __CPD21
	BRSH _0x50
_0x4F:
	RJMP _0x4E
_0x50:
; 0000 00FE         {  begin_p=0; //   
	CBI  0x13,0
; 0000 00FF            tim_ocr_p=max_p;
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x13
; 0000 0100            tim_write_p();  } //   
; 0000 0101       //  
; 0000 0102       if (timer_p>0 && begin_p==0 && lower_p==0 )
_0x4E:
	RCALL SUBOPT_0x8
	BRSH _0x54
	RCALL SUBOPT_0xD
	BRNE _0x54
	LDI  R26,0
	SBIC 0x13,4
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x55
_0x54:
	RJMP _0x53
_0x55:
; 0000 0103         { timer_p--;  }
	MOVW R30,R2
	SBIW R30,1
	MOVW R2,R30
; 0000 0104       //  
; 0000 0105       if (timer_p==0 && tim_ocr_p>0 && end_p==0 ) //  ,  
_0x53:
	RCALL SUBOPT_0x8
	BRNE _0x57
	RCALL SUBOPT_0x4
	RCALL __CPD02
	BRSH _0x57
	RCALL SUBOPT_0xE
	BREQ _0x58
_0x57:
	RJMP _0x56
_0x58:
; 0000 0106         {end_p=1; //   
	SBI  0x13,2
; 0000 0107          timer_akt_p=0; }//   
	CLR  R6
	CLR  R7
; 0000 0108       if ((tim_ocr_p==0 || tim_ocr_p-step_pe>max_p)&& end_p==1) //  
_0x56:
	RCALL SUBOPT_0x4
	RCALL __CPD02
	BREQ _0x5C
	RCALL SUBOPT_0x15
	RCALL __SUBD21
	RCALL SUBOPT_0x14
	RCALL __CPD12
	BRSH _0x5E
_0x5C:
	SBIC 0x13,2
	RJMP _0x5F
_0x5E:
	RJMP _0x5B
_0x5F:
; 0000 0109         {end_p=0; tim_ocr_p=0; tim_write_p(); timer_akt_p=0;}
	CBI  0x13,2
	RCALL SUBOPT_0x16
	RCALL _tim_write_p
	CLR  R6
	CLR  R7
; 0000 010A       if (tim_ocr_p>0 && end_p==1)  //   
_0x5B:
	RCALL SUBOPT_0x4
	RCALL __CPD02
	BRSH _0x63
	SBIC 0x13,2
	RJMP _0x64
_0x63:
	RJMP _0x62
_0x64:
; 0000 010B         {tim_ocr_p-=step_pe; tim_write_p();  }
	RCALL SUBOPT_0x15
	RCALL SUBOPT_0x17
; 0000 010C       //   
; 0000 010D       if (lower_p==1)
_0x62:
	SBIS 0x13,4
	RJMP _0x65
; 0000 010E         {tim_ocr_p=tim_ocr_p-step_pe; tim_write_p();  }
	RCALL SUBOPT_0x15
	RCALL SUBOPT_0x17
; 0000 010F       if (lower_p==1 && tim_ocr_p>max_p )  //  
_0x65:
	SBIS 0x13,4
	RJMP _0x67
	RCALL SUBOPT_0xF
	RCALL __CPD12
	BRLO _0x68
_0x67:
	RJMP _0x66
_0x68:
; 0000 0110         {lower_p=0;}
	CBI  0x13,4
; 0000 0111 
; 0000 0112 
; 0000 0113       // 
; 0000 0114       //   
; 0000 0115       if (timer_k>0 && begin_k==1 && tim_ocr_k<max_k ) //   
_0x66:
	RCALL SUBOPT_0xB
	BRSH _0x6C
	SBIS 0x13,1
	RJMP _0x6C
	RCALL SUBOPT_0x11
	RCALL __CPD21
	BRLO _0x6D
_0x6C:
	RJMP _0x6B
_0x6D:
; 0000 0116         { tim_ocr_k+=step_k;  tim_write_k();  }
	MOVW R30,R12
	RCALL SUBOPT_0x18
	RCALL __ADDD12
	RCALL SUBOPT_0x19
; 0000 0117       if (timer_k>0 && begin_k==1 && tim_ocr_k>=max_k ) //    
_0x6B:
	RCALL SUBOPT_0xB
	BRSH _0x6F
	SBIS 0x13,1
	RJMP _0x6F
	RCALL SUBOPT_0x11
	RCALL __CPD21
	BRSH _0x70
_0x6F:
	RJMP _0x6E
_0x70:
; 0000 0118         { begin_k=0; tim_ocr_k=max_k; tim_write_k();  }
	CBI  0x13,1
	RCALL SUBOPT_0x1A
	RCALL SUBOPT_0x19
; 0000 0119       //  
; 0000 011A       if (timer_k>0 && begin_k==0 && lower_k==0)
_0x6E:
	RCALL SUBOPT_0xB
	BRSH _0x74
	RCALL SUBOPT_0xA
	BRNE _0x74
	LDI  R26,0
	SBIC 0x13,5
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x75
_0x74:
	RJMP _0x73
_0x75:
; 0000 011B         {  timer_k--;   }
	MOVW R30,R4
	SBIW R30,1
	MOVW R4,R30
; 0000 011C       //  
; 0000 011D       if (timer_k==0 && tim_ocr_k>0 && end_k==0)
_0x73:
	RCALL SUBOPT_0xB
	BRNE _0x77
	RCALL SUBOPT_0x5
	RCALL __CPD02
	BRSH _0x77
	RCALL SUBOPT_0x10
	BREQ _0x78
_0x77:
	RJMP _0x76
_0x78:
; 0000 011E         {end_k=1;
	SBI  0x13,3
; 0000 011F          timer_akt_k=0; } //   0
	CLR  R8
	CLR  R9
; 0000 0120       if ((tim_ocr_k==0 || tim_ocr_k-step_ke>max_k ) && end_k==1) //  
_0x76:
	RCALL SUBOPT_0x5
	RCALL __CPD02
	BREQ _0x7C
	RCALL SUBOPT_0x1B
	RCALL __SUBD21
	RCALL SUBOPT_0x1A
	RCALL __CPD12
	BRSH _0x7E
_0x7C:
	SBIC 0x13,3
	RJMP _0x7F
_0x7E:
	RJMP _0x7B
_0x7F:
; 0000 0121         {end_k=0; tim_ocr_k=0; tim_write_k(); timer_akt_k=0;}
	CBI  0x13,3
	RCALL SUBOPT_0x1C
	RCALL _tim_write_k
	CLR  R8
	CLR  R9
; 0000 0122       if (tim_ocr_k>0 && end_k==1)
_0x7B:
	RCALL SUBOPT_0x5
	RCALL __CPD02
	BRSH _0x83
	SBIC 0x13,3
	RJMP _0x84
_0x83:
	RJMP _0x82
_0x84:
; 0000 0123         { tim_ocr_k-=step_ke;  tim_write_k();  }
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1D
; 0000 0124       //   
; 0000 0125       if (lower_k==1)
_0x82:
	SBIS 0x13,5
	RJMP _0x85
; 0000 0126         {tim_ocr_k=tim_ocr_k-step_ke;  tim_write_k();  }
	RCALL SUBOPT_0x1B
	RCALL SUBOPT_0x1D
; 0000 0127       if (lower_k==1 && tim_ocr_k>max_k )  //  
_0x85:
	SBIS 0x13,5
	RJMP _0x87
	RCALL SUBOPT_0x11
	RCALL __CPD12
	BRLO _0x88
_0x87:
	RJMP _0x86
_0x88:
; 0000 0128         {lower_k=0;}
	CBI  0x13,5
; 0000 0129 
; 0000 012A LED=0;   //   
_0x86:
	CBI  0x12,6
; 0000 012B }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;
;
;void main(void)
; 0000 0130 {
_main:
; 0000 0131 
; 0000 0132 
; 0000 0133 // Crystal Oscillator division factor: 1
; 0000 0134 #pragma optsize-
; 0000 0135 CLKPR=0x80;
	LDI  R30,LOW(128)
	OUT  0x26,R30
; 0000 0136 CLKPR=0x00;
	LDI  R30,LOW(0)
	OUT  0x26,R30
; 0000 0137 #ifdef _OPTIMIZE_SIZE_
; 0000 0138 #pragma optsize+
; 0000 0139 #endif
; 0000 013A 
; 0000 013B 
; 0000 013C // Input/Output Ports initialization
; 0000 013D // Port A initialization
; 0000 013E // Func2=In Func1=In Func0=Out
; 0000 013F // State2=T State1=T State0=1
; 0000 0140 PORTA=0x01;
	LDI  R30,LOW(1)
	OUT  0x1B,R30
; 0000 0141 DDRA=0x01;
	OUT  0x1A,R30
; 0000 0142 
; 0000 0143 // Port B initialization
; 0000 0144 // Func7=In Func6=In Func5=In Func4=Out Func3=Out Func2=In Func1=In Func0=In
; 0000 0145 // State7=T State6=T State5=T State4=0 State3=0 State2=T State1=T State0=T
; 0000 0146 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0000 0147 DDRB=0x18;
	LDI  R30,LOW(24)
	OUT  0x17,R30
; 0000 0148 
; 0000 0149 // Port D initialization
; 0000 014A // Func6=Out Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 014B // State6=0 State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 014C PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0x12,R30
; 0000 014D DDRD=0x41;
	LDI  R30,LOW(65)
	OUT  0x11,R30
; 0000 014E 
; 0000 014F /*
; 0000 0150 // ~100hz
; 0000 0151 // Timer/Counter 0 initialization
; 0000 0152 // Clock source: System Clock
; 0000 0153 // Clock value: 7.813 kHz
; 0000 0154 // Mode: Normal top=0xFF
; 0000 0155 // OC0A output: Disconnected
; 0000 0156 // OC0B output: Disconnected
; 0000 0157 TCCR0A=0x00;
; 0000 0158 TCCR0B=0x05;
; 0000 0159 TCNT0=0xB1;
; 0000 015A OCR0A=0x00;
; 0000 015B OCR0B=0x00;
; 0000 015C */
; 0000 015D 
; 0000 015E /*
; 0000 015F // ~128Hz
; 0000 0160 // Timer/Counter 0 initialization
; 0000 0161 // Clock source: System Clock
; 0000 0162 // Clock value: 31.250 kHz
; 0000 0163 // Mode: Normal top=0xFF
; 0000 0164 // OC0A output: Disconnected
; 0000 0165 // OC0B output: Disconnected
; 0000 0166 TCCR0A=0x00;
; 0000 0167 TCCR0B=0x04;
; 0000 0168 TCNT0=0x0B;
; 0000 0169 OCR0A=0x00;
; 0000 016A OCR0B=0x00;
; 0000 016B */
; 0000 016C 
; 0000 016D // ~64Hz
; 0000 016E // Timer/Counter 0 initialization
; 0000 016F // Clock source: System Clock
; 0000 0170 // Clock value: 7.813 kHz
; 0000 0171 // Mode: Normal top=0xFF
; 0000 0172 // OC0A output: Disconnected
; 0000 0173 // OC0B output: Disconnected
; 0000 0174 TCCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 0175 TCCR0B=0x05;
	LDI  R30,LOW(5)
	OUT  0x33,R30
; 0000 0176 TCNT0=0x85;
	LDI  R30,LOW(133)
	OUT  0x32,R30
; 0000 0177 OCR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0x36,R30
; 0000 0178 OCR0B=0x00;
	OUT  0x3C,R30
; 0000 0179 
; 0000 017A /*
; 0000 017B // Timer/Counter 1 initialization
; 0000 017C // Clock source: System Clock
; 0000 017D // Clock value: 8000.000 kHz
; 0000 017E // Mode: Ph. correct PWM top=0x03FF
; 0000 017F // OC1A output: Non-Inv.
; 0000 0180 // OC1B output: Non-Inv.
; 0000 0181 // Noise Canceler: Off
; 0000 0182 // Input Capture on Falling Edge
; 0000 0183 // Timer1 Overflow Interrupt: Off
; 0000 0184 // Input Capture Interrupt: Off
; 0000 0185 // Compare A Match Interrupt: Off
; 0000 0186 // Compare B Match Interrupt: Off
; 0000 0187 TCCR1A=0xA3;
; 0000 0188 TCCR1B=0x01;
; 0000 0189 TCNT1H=0x00;
; 0000 018A TCNT1L=0x00;
; 0000 018B ICR1H=0x00;
; 0000 018C ICR1L=0x00;
; 0000 018D OCR1AH=0x00;
; 0000 018E OCR1AL=0x00;
; 0000 018F OCR1BH=0x00;
; 0000 0190 OCR1BL=0x00;
; 0000 0191 */
; 0000 0192 
; 0000 0193 
; 0000 0194 // Timer/Counter 1 initialization
; 0000 0195 // Clock source: System Clock
; 0000 0196 // Clock value: 8000.000 kHz
; 0000 0197 // Mode: Ph. correct PWM top=ICR1
; 0000 0198 // OC1A output: Non-Inv.
; 0000 0199 // OC1B output: Non-Inv.
; 0000 019A // Noise Canceler: Off
; 0000 019B // Input Capture on Falling Edge
; 0000 019C // Timer1 Overflow Interrupt: Off
; 0000 019D // Input Capture Interrupt: Off
; 0000 019E // Compare A Match Interrupt: Off
; 0000 019F // Compare B Match Interrupt: Off
; 0000 01A0 TCCR1A=0xA2;
	LDI  R30,LOW(162)
	OUT  0x2F,R30
; 0000 01A1 TCCR1B=0x11;
	LDI  R30,LOW(17)
	OUT  0x2E,R30
; 0000 01A2 TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0000 01A3 TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 01A4 ICR1H=0x1F;
	LDI  R30,LOW(31)
	OUT  0x25,R30
; 0000 01A5 ICR1L=0xFF;
	LDI  R30,LOW(255)
	OUT  0x24,R30
; 0000 01A6 OCR1AH=0x00;
	LDI  R30,LOW(0)
	OUT  0x2B,R30
; 0000 01A7 OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 01A8 OCR1BH=0x00;
	OUT  0x29,R30
; 0000 01A9 OCR1BL=0x00;
	OUT  0x28,R30
; 0000 01AA 
; 0000 01AB 
; 0000 01AC // External Interrupt(s) initialization
; 0000 01AD // INT0: Off
; 0000 01AE // INT1: Off
; 0000 01AF // Interrupt on any change on pins PCINT0-7: Off
; 0000 01B0 // Interrupt on any change on pins PCINT8-10: Off
; 0000 01B1 // Interrupt on any change on pins PCINT11-17: Off
; 0000 01B2 MCUCR=0x00;
	OUT  0x35,R30
; 0000 01B3 GIMSK=0x00;
	OUT  0x3B,R30
; 0000 01B4 
; 0000 01B5 // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 01B6 TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
; 0000 01B7 
; 0000 01B8 // Universal Serial Interface initialization
; 0000 01B9 // Mode: Disabled
; 0000 01BA // Clock source: Register & Counter=no clk.
; 0000 01BB // USI Counter Overflow Interrupt: Off
; 0000 01BC USICR=0x00;
	LDI  R30,LOW(0)
	OUT  0xD,R30
; 0000 01BD 
; 0000 01BE // USART initialization
; 0000 01BF // USART disabled
; 0000 01C0 UCSRB=0x00;
	OUT  0xA,R30
; 0000 01C1 
; 0000 01C2 // Analog Comparator initialization
; 0000 01C3 // Analog Comparator: Off
; 0000 01C4 // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 01C5 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 01C6 DIDR=0x00;
	LDI  R30,LOW(0)
	OUT  0x1,R30
; 0000 01C7 
; 0000 01C8 
; 0000 01C9 //  
; 0000 01CA begin_p=0; begin_k=0; end_p=0; end_k=0; timer_p=0; timer_k=0; tim_ocr_p=0; tim_ocr_k=0; timer_akt_p=0; timer_akt_k=0; zav_k=0;
	CBI  0x13,0
	CBI  0x13,1
	CBI  0x13,2
	CBI  0x13,3
	CLR  R2
	CLR  R3
	CLR  R4
	CLR  R5
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x1C
	CLR  R6
	CLR  R7
	CLR  R8
	CLR  R9
	CBI  0x13,6
; 0000 01CB 
; 0000 01CC init_eerpom();
	RCALL _init_eerpom
; 0000 01CD 
; 0000 01CE //   -    
; 0000 01CF for (start_cycle = 0; start_cycle < 15; start_cycle ++ )
	LDI  R30,LOW(0)
	STS  _start_cycle,R30
_0x98:
	LDS  R26,_start_cycle
	CPI  R26,LOW(0xF)
	BRSH _0x99
; 0000 01D0    {
; 0000 01D1    LED=1;   //   
	SBI  0x12,6
; 0000 01D2    delay_ms(125);
	RCALL SUBOPT_0x1E
; 0000 01D3    LED=0;
	CBI  0x12,6
; 0000 01D4    delay_ms(125);
	RCALL SUBOPT_0x1E
; 0000 01D5    }
	LDS  R30,_start_cycle
	SUBI R30,-LOW(1)
	STS  _start_cycle,R30
	RJMP _0x98
_0x99:
; 0000 01D6 
; 0000 01D7 
; 0000 01D8 
; 0000 01D9 
; 0000 01DA // Global enable interrupts
; 0000 01DB #asm("sei")
	sei
; 0000 01DC 
; 0000 01DD while (1)
_0x9E:
; 0000 01DE       {
; 0000 01DF 
; 0000 01E0       };
	RJMP _0x9E
; 0000 01E1 
; 0000 01E2 }
_0xA1:
	RJMP _0xA1
;

	.DSEG
_max_p:
	.BYTE 0x4
_max_k:
	.BYTE 0x4
_step_pe:
	.BYTE 0x2
_step_ke:
	.BYTE 0x2
_tim_ocr_p:
	.BYTE 0x4
_tim_ocr_k:
	.BYTE 0x4
_start_cycle:
	.BYTE 0x1

	.ESEG
_TP:
	.BYTE 0x2
_TK:
	.BYTE 0x2
_TBBP:
	.BYTE 0x2
_TBBK:
	.BYTE 0x2
_TBEP:
	.BYTE 0x2
_TBEK:
	.BYTE 0x2
_LEV_P:
	.BYTE 0x2
_LEV_K:
	.BYTE 0x2
_day_p:
	.BYTE 0x4
_day_k:
	.BYTE 0x4
_night_p:
	.BYTE 0x4
_night_k:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x0:
	LDI  R26,LOW(_day_p)
	LDI  R27,HIGH(_day_p)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1:
	__GETD1N 0x7FFC0
	RCALL __EEPROMWRD
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2:
	LDI  R26,LOW(_day_k)
	LDI  R27,HIGH(_day_k)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDI  R30,LOW(3200)
	LDI  R31,HIGH(3200)
	RCALL __EEPROMWRW
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:82 WORDS
SUBOPT_0x4:
	LDS  R26,_tim_ocr_p
	LDS  R27,_tim_ocr_p+1
	LDS  R24,_tim_ocr_p+2
	LDS  R25,_tim_ocr_p+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:82 WORDS
SUBOPT_0x5:
	LDS  R26,_tim_ocr_k
	LDS  R27,_tim_ocr_k+1
	LDS  R24,_tim_ocr_k+2
	LDS  R25,_tim_ocr_k+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x6:
	RCALL __EEPROMRDW
	LDS  R26,_max_p
	LDS  R27,_max_p+1
	LDS  R24,_max_p+2
	LDS  R25,_max_p+3
	CLR  R22
	CLR  R23
	RCALL __DIVD21U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x7:
	RCALL __EEPROMRDW
	LDS  R26,_max_k
	LDS  R27,_max_k+1
	LDS  R24,_max_k+2
	LDS  R25,_max_k+3
	CLR  R22
	CLR  R23
	RCALL __DIVD21U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x8:
	CLR  R0
	CP   R0,R2
	CPC  R0,R3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x9:
	STS  _max_p,R30
	STS  _max_p+1,R31
	STS  _max_p+2,R22
	STS  _max_p+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xA:
	LDI  R26,0
	SBIC 0x13,1
	LDI  R26,1
	CPI  R26,LOW(0x0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0xB:
	CLR  R0
	CP   R0,R4
	CPC  R0,R5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0xC:
	STS  _max_k,R30
	STS  _max_k+1,R31
	STS  _max_k+2,R22
	STS  _max_k+3,R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xD:
	LDI  R26,0
	SBIC 0x13,0
	LDI  R26,1
	CPI  R26,LOW(0x0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xE:
	LDI  R26,0
	SBIC 0x13,2
	LDI  R26,1
	CPI  R26,LOW(0x0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:30 WORDS
SUBOPT_0xF:
	LDS  R30,_max_p
	LDS  R31,_max_p+1
	LDS  R22,_max_p+2
	LDS  R23,_max_p+3
	RJMP SUBOPT_0x4

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x10:
	LDI  R26,0
	SBIC 0x13,3
	LDI  R26,1
	CPI  R26,LOW(0x0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:30 WORDS
SUBOPT_0x11:
	LDS  R30,_max_k
	LDS  R31,_max_k+1
	LDS  R22,_max_k+2
	LDS  R23,_max_k+3
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x12:
	RCALL SUBOPT_0x4
	CLR  R22
	CLR  R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x13:
	STS  _tim_ocr_p,R30
	STS  _tim_ocr_p+1,R31
	STS  _tim_ocr_p+2,R22
	STS  _tim_ocr_p+3,R23
	RJMP _tim_write_p

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x14:
	LDS  R30,_max_p
	LDS  R31,_max_p+1
	LDS  R22,_max_p+2
	LDS  R23,_max_p+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x15:
	LDS  R30,_step_pe
	LDS  R31,_step_pe+1
	RJMP SUBOPT_0x12

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x16:
	LDI  R30,LOW(0)
	STS  _tim_ocr_p,R30
	STS  _tim_ocr_p+1,R30
	STS  _tim_ocr_p+2,R30
	STS  _tim_ocr_p+3,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x17:
	RCALL __SUBD21
	STS  _tim_ocr_p,R26
	STS  _tim_ocr_p+1,R27
	STS  _tim_ocr_p+2,R24
	STS  _tim_ocr_p+3,R25
	RJMP _tim_write_p

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x18:
	RCALL SUBOPT_0x5
	CLR  R22
	CLR  R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x19:
	STS  _tim_ocr_k,R30
	STS  _tim_ocr_k+1,R31
	STS  _tim_ocr_k+2,R22
	STS  _tim_ocr_k+3,R23
	RJMP _tim_write_k

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1A:
	LDS  R30,_max_k
	LDS  R31,_max_k+1
	LDS  R22,_max_k+2
	LDS  R23,_max_k+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1B:
	LDS  R30,_step_ke
	LDS  R31,_step_ke+1
	RJMP SUBOPT_0x18

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1C:
	LDI  R30,LOW(0)
	STS  _tim_ocr_k,R30
	STS  _tim_ocr_k+1,R30
	STS  _tim_ocr_k+2,R30
	STS  _tim_ocr_k+3,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x1D:
	RCALL __SUBD21
	STS  _tim_ocr_k,R26
	STS  _tim_ocr_k+1,R27
	STS  _tim_ocr_k+2,R24
	STS  _tim_ocr_k+3,R25
	RJMP _tim_write_k

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1E:
	LDI  R26,LOW(125)
	LDI  R27,0
	RJMP _delay_ms


	.CSEG
_delay_ms:
	adiw r26,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r26,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	ADC  R23,R25
	RET

__SUBD21:
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R25,R23
	RET

__LSRD12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	MOVW R22,R24
	BREQ __LSRD12R
__LSRD12L:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRD12L
__LSRD12R:
	RET

__LSRD1:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	RET

__DIVD21U:
	PUSH R19
	PUSH R20
	PUSH R21
	CLR  R0
	CLR  R1
	CLR  R20
	CLR  R21
	LDI  R19,32
__DIVD21U1:
	LSL  R26
	ROL  R27
	ROL  R24
	ROL  R25
	ROL  R0
	ROL  R1
	ROL  R20
	ROL  R21
	SUB  R0,R30
	SBC  R1,R31
	SBC  R20,R22
	SBC  R21,R23
	BRCC __DIVD21U2
	ADD  R0,R30
	ADC  R1,R31
	ADC  R20,R22
	ADC  R21,R23
	RJMP __DIVD21U3
__DIVD21U2:
	SBR  R26,1
__DIVD21U3:
	DEC  R19
	BRNE __DIVD21U1
	MOVW R30,R26
	MOVW R22,R24
	MOVW R26,R0
	MOVW R24,R20
	POP  R21
	POP  R20
	POP  R19
	RET

__EEPROMRDD:
	ADIW R26,2
	RCALL __EEPROMRDW
	MOVW R22,R30
	SBIW R26,2

__EEPROMRDW:
	ADIW R26,1
	RCALL __EEPROMRDB
	MOV  R31,R30
	SBIW R26,1

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRD:
	RCALL __EEPROMWRW
	ADIW R26,2
	MOVW R0,R30
	MOVW R30,R22
	RCALL __EEPROMWRW
	MOVW R30,R0
	SBIW R26,2
	RET

__EEPROMWRW:
	RCALL __EEPROMWRB
	ADIW R26,1
	PUSH R30
	MOV  R30,R31
	RCALL __EEPROMWRB
	POP  R30
	SBIW R26,1
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__CPD02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	CPC  R0,R24
	CPC  R0,R25
	RET

__CPD12:
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	CPC  R23,R25
	RET

__CPD21:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R25,R23
	RET

;END OF CODE MARKER
__END_OF_CODE:
