/*****************************************************
This program was produced by the
CodeWizardAVR V2.05.3 Standard
Automatic Program Generator
Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project :  
Version : 2.1    2313
Date    : 07.01.2013
Author  : MAXIOL
Company : MAXIOL
Comments:   

Chip type               : ATtiny2313A
AVR Core Clock frequency: 8.000000 MHz
Memory model            : Tiny
External RAM size       : 0
Data Stack size         : 32
*****************************************************/

#include <tiny2313a.h>
#include <delay.h>

//      8MHz - 100

// Declare your global variables here
bit begin_p; //   
bit begin_k; //   

bit end_p; //   
bit end_k; //   

bit lower_p; //    
bit lower_k; //    

bit zav_k; //   


unsigned long max_p; //       
unsigned long max_k; //        

unsigned int timer_p;  //   
unsigned int timer_k;  //   

unsigned int timer_akt_p;  //    
unsigned int timer_akt_k;  //    

unsigned int step_p; //    
unsigned int step_k; //     
unsigned int step_pe; //    
unsigned int step_ke; //    

unsigned long tim_ocr_p;  //          *100
unsigned long tim_ocr_k;  //           *100

unsigned char start_cycle; //     


//eeprom unsigned int flag_eerpom_good; //   eeprom = 12345 -  ok
eeprom unsigned int TP; //        . 1=10   
eeprom unsigned int TK; //        . 1=10 

eeprom unsigned int TBBP; //        . 1=10  1=100  / 
eeprom unsigned int TBBK; //        . 1=10             / 
eeprom unsigned int TBEP; //    . 1=10                          / 
eeprom unsigned int TBEK; //    . 1=10                          / 

eeprom unsigned int LEV_P; //         . 1=10 /  
eeprom unsigned int LEV_K; //         . 1=10 / 

// 
eeprom unsigned long  day_p;  //   
eeprom unsigned long  day_k;  //   
eeprom unsigned long  night_p; //   
eeprom unsigned long  night_k; //   
//eeprom unsigned char kmid;    //        

//   %
#define  L_day_p   100  //   
#define  L_day_k   100  //   
#define  L_night_p 28   //   
#define  L_night_k 7   //   
// 
#define  L_TP      90 //           
#define  L_TK      90 //        
#define  L_TBBP     3 //          / 
#define  L_TBBK     3 //           / 
#define  L_TBEP    50 //                   / 
#define  L_TBEK    50 //                   / 
#define  L_LEV_P   50 //          /  
#define  L_LEV_K  100 //          / 


//     
#define  OCR_CLOCK  64   //     
//#define  MAX_LIGHT  1023  //   -
#define  MAX_LIGHT  8191  //   -
//   
#define  DAY  PIND.4 // PIND.4 /  ==0 
#define  KOR  PIND.3 // PIND.3     ==1   (   )
#define  PRI  PIND.2 // PIND.2    ==1   (   )
#define  DOR  PINA.1 // PINA.1       ==1   (   )
//  
#define  LED  PORTD.6 //   
#define  LED2  PORTD.0 //   
// 
#define  OCR_PRI  OCR1A
#define  OCR_KOR  OCR1B


void init_eerpom(void)  // -    eeprom   
{
//if (flag_eerpom_good!=12345)
//  {
  // 
  day_p=MAX_LIGHT*OCR_CLOCK*L_day_p/100;  //   
  day_k=MAX_LIGHT*OCR_CLOCK*L_day_k/100;   //   
  night_p=MAX_LIGHT*OCR_CLOCK*L_night_p/100; //   
  night_k=MAX_LIGHT*OCR_CLOCK*L_night_k/100; //   
//  kmid=2;    //        
  
  //   
  TP=L_TP*OCR_CLOCK;       //        .    
  TK=L_TK*OCR_CLOCK;       //        . 
  TBBP=L_TBBP*OCR_CLOCK;   //        .  / 
  TBBK=L_TBBK*OCR_CLOCK;   //        .  / 
  TBEP=L_TBEP*OCR_CLOCK;   //    .                / 
  TBEK=L_TBEK*OCR_CLOCK;   //    .                / 
  LEV_P=L_LEV_P*OCR_CLOCK; //         . /  
  LEV_K=L_LEV_K*OCR_CLOCK; //         . /   
//  }
}


// 
void tim_write_p(void)  //      tim_ocr_p/OCR_CLOCK
{
//OCR_PRI=tim_ocr_p/OCR_CLOCK;
//OCR_PRI=tim_ocr_p>>7;  // :128
OCR_PRI=tim_ocr_p>>6;  // :64
}

//
void tim_write_k(void)  //      tim_ocr_k/OCR_CLOCK
{
//OCR_KOR=tim_ocr_k/OCR_CLOCK;
//OCR_KOR=tim_ocr_k>>7;  // :128
OCR_KOR=tim_ocr_k>>6;  // :64
}

void recalc_p(void)  // -      - 
{
 step_p=max_p/TBBP; //   -  
 step_pe=max_p/TBEP; //  -  
}

void recalc_k(void)  // -      -  
{
 step_k=max_k/TBBK; //   -   
 step_ke=max_k/TBEK; //   -  
}

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
// Reinitialize Timer 0 value
//TCNT0=0xB1;  // ~100Hz
//TCNT0=0x0B;  //  ~128Hz
TCNT0=0x85; //  64 


// Place your code here
LED=1;   //   
   
      // 
      //     -      !
      if ((PRI==1 || DOR==1)  && timer_p==0) //  -         
        { 
        begin_p=1;  end_p=0; //        
            
        if (DAY==0 && PRI==1 ) // /
          {max_p=day_p;    }  
          else 
          {max_p=night_p;  }
          
        if (DOR==1 )
          {max_p=day_p;  } //   -              
        recalc_p();
        
          //  
        if (begin_k==0 && timer_k==0) //  50%        
          {begin_k=1 ; end_k=0;  timer_k=TK/2; zav_k=1;
           if (DAY==0) // /
            { max_k=day_k/2;  }  
            else 
            { max_k=night_k/2;  }
          recalc_k();  
          }          
        } 
      
      if ( (KOR==1 && timer_k==0) || (KOR==1 && zav_k==1)) //  
        { 
        begin_k=1 ; end_k=0; //        
        zav_k=0;
        if (DAY==0) // /
          { max_k=day_k;    }
          else
          { max_k=night_k;  }
          //       
        recalc_k();                
        }      
      
        
      //                         
      if (DOR==1 || PRI==1  ) //         
        {  
        timer_p=TP;  //    
        timer_akt_p++; //     
        if (DAY==1 && timer_akt_p>LEV_P) //       
          { max_p=day_p; recalc_p(); } //                      
        }    
      if (KOR==1) // 
        {
        timer_k=TK; //    
        timer_akt_k++; //    
        if (DAY==1 && timer_akt_k>LEV_K) //       
          {max_k=day_k;   recalc_k(); } //     
        }
               
       
      //   /    
      //  2  -                
      //       -
      if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p<max_p )  //      
       { begin_p=1;}  
      if (begin_p==0 && end_p==0 && timer_p>0 && tim_ocr_p>max_p )  //      
       { lower_p=1;}  
          
      if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k<max_k )  //      
       { begin_k=1;}  
      if (begin_k==0 && end_k==0 && timer_k>0 && tim_ocr_k>max_k )  //      
       { lower_k=1;}                
      //  
                     
      
      //  
      
      // 
      //   
      if (timer_p>0 && begin_p==1 && tim_ocr_p<max_p ) //    -    max_p  
        { tim_ocr_p+=step_p; tim_write_p();  }
      if (timer_p>0 && begin_p==1 && tim_ocr_p>=max_p ) //    
        {  begin_p=0; //   
           tim_ocr_p=max_p; 
           tim_write_p();  } //                       
      //  
      if (timer_p>0 && begin_p==0 && lower_p==0 )       
        { timer_p--;  }
      //  
      if (timer_p==0 && tim_ocr_p>0 && end_p==0 ) //  ,  
        {end_p=1; //   
         timer_akt_p=0; }//    
      if ((tim_ocr_p==0 || tim_ocr_p-step_pe>max_p)&& end_p==1) //  
        {end_p=0; tim_ocr_p=0; tim_write_p(); timer_akt_p=0;}                  
      if (tim_ocr_p>0 && end_p==1)  //   
        {tim_ocr_p-=step_pe; tim_write_p();  }
      //     
      if (lower_p==1)   
        {tim_ocr_p=tim_ocr_p-step_pe; tim_write_p();  }
      if (lower_p==1 && tim_ocr_p>max_p )  //  
        {lower_p=0;}       
                             
                 
      // 
      //   
      if (timer_k>0 && begin_k==1 && tim_ocr_k<max_k ) //    
        { tim_ocr_k+=step_k;  tim_write_k();  }
      if (timer_k>0 && begin_k==1 && tim_ocr_k>=max_k ) //    
        { begin_k=0; tim_ocr_k=max_k; tim_write_k();  }            
      //         
      if (timer_k>0 && begin_k==0 && lower_k==0)       
        {  timer_k--;   }             
      //  
      if (timer_k==0 && tim_ocr_k>0 && end_k==0)
        {end_k=1;
         timer_akt_k=0; } //   0              
      if ((tim_ocr_k==0 || tim_ocr_k-step_ke>max_k ) && end_k==1) //  
        {end_k=0; tim_ocr_k=0; tim_write_k(); timer_akt_k=0;}    
      if (tim_ocr_k>0 && end_k==1)
        { tim_ocr_k-=step_ke;  tim_write_k();  }                 
      //     
      if (lower_k==1)   
        {tim_ocr_k=tim_ocr_k-step_ke;  tim_write_k();  }
      if (lower_k==1 && tim_ocr_k>max_k )  //  
        {lower_k=0;}
                                  
LED=0;   //           
}



void main(void)
{


// Crystal Oscillator division factor: 1
#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif


// Input/Output Ports initialization
// Port A initialization
// Func2=In Func1=In Func0=Out 
// State2=T State1=T State0=1 
PORTA=0x01;
DDRA=0x01;

// Port B initialization
// Func7=In Func6=In Func5=In Func4=Out Func3=Out Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=0 State3=0 State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x18;

// Port D initialization
// Func6=Out Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=0 State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0x00;
DDRD=0x41;

/* 
// ~100hz
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 7.813 kHz
// Mode: Normal top=0xFF
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x05;
TCNT0=0xB1;
OCR0A=0x00;
OCR0B=0x00;
*/

/*
// ~128Hz
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 31.250 kHz
// Mode: Normal top=0xFF
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x04;
TCNT0=0x0B;
OCR0A=0x00;
OCR0B=0x00;
*/

// ~64Hz
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 7.813 kHz
// Mode: Normal top=0xFF
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x05;
TCNT0=0x85;
OCR0A=0x00;
OCR0B=0x00;

/*
// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 8000.000 kHz
// Mode: Ph. correct PWM top=0x03FF
// OC1A output: Non-Inv.
// OC1B output: Non-Inv.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0xA3;
TCCR1B=0x01;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;
*/


// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 8000.000 kHz
// Mode: Ph. correct PWM top=ICR1
// OC1A output: Non-Inv.
// OC1B output: Non-Inv.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0xA2;
TCCR1B=0x11;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x1F;
ICR1L=0xFF;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;


// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// Interrupt on any change on pins PCINT0-7: Off
// Interrupt on any change on pins PCINT8-10: Off
// Interrupt on any change on pins PCINT11-17: Off
MCUCR=0x00;
GIMSK=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x02;

// Universal Serial Interface initialization
// Mode: Disabled
// Clock source: Register & Counter=no clk.
// USI Counter Overflow Interrupt: Off
USICR=0x00;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
DIDR=0x00;


//  
begin_p=0; begin_k=0; end_p=0; end_k=0; timer_p=0; timer_k=0; tim_ocr_p=0; tim_ocr_k=0; timer_akt_p=0; timer_akt_k=0; zav_k=0;

init_eerpom();

//   -    
for (start_cycle = 0; start_cycle < 15; start_cycle ++ ) 
   {
   LED=1;   //   
   delay_ms(125); 
   LED=0;
   delay_ms(125);     
   }    




// Global enable interrupts
#asm("sei")

while (1)
      {  
        
      };
             
}

