   <HTML>
   <HEAD>
   <TITLE>Negotiate Test</TITLE>
   </HEAD>
   <!--
   	This script is used to detect if the Negotiate method is using NTLM
   	(windows NT Challenge-Response) or Kerberos as the authentication
   	method.
   -->	
   <BODY>
   <%
   Dim AuthMethod
   Dim AuthType
   Dim AuthLength
   Dim AuthOther

   ' Get the authentication method being used
   AuthMethod = Request.ServerVariables("AUTH_TYPE")

   ' Get the length of the HTTP_Authorization header (to determine Kerberos or NTLM)
   AuthLength = Request.ServerVariables ("HTTP_Authorization")

   ' If some other authentication method (other than Negotiate) gets used, call it "Other"
   If LTrim(RTrim(AuthMethod)) <> "Negotiate" Then AuthOtherMethod

   ' If Negotiate gets used, go straight to the subroutine to handle it
   If LTrim(RTrim(AuthMethod)) = "Negotiate" Then AuthNegotiateMethod

   Sub AuthOtherMethod()
   	' Since anonymous authentication will be blank, let's be sure we realize it's enabled to
   	If LTrim(RTrim(AuthMethod)) = "" Then AuthMethod = "Anonymous"	
   	Response.Write "<table width=500>The user was logged in using the <B>" & AuthMethod & "</B> authentication method."
   	Response.Write "<P>&#xa0;&#xa0;&#xa0;&#xa0;If you were expecting a different method to be used,"
   	Response.Write " please check the settings for the resource you are accessing. Remember, selecting"
   	Response.Write " multiple authentication methods, or allowing anonymous access can result in a "
   	Response.Write " different method being used.</table>"
   End Sub

   Sub AuthNegotiateMethod()
   	' Typically, NTLM will yield a 150 - 300 byte header, while Kerberos is more like 5000 bytes
   	If LEN(AuthLength) > 1000 Then AuthType = "Kerberos"
   	If LEN(AuthLength) < 1000 Then AuthType = "NTLM"
   	Response.Write "<table width=500>The <B>Negotiate</B> method was used!<BR>"	

   	' Tell us the Authentication method used to authenticate the user (and show a warning about the script)
   	Response.Write "The user was logged on using <B>" & AuthType & "</B>."
   	Response.Write "<P><font color=#800000><B>Please do not refresh this page</B></font>.<BR>"
   	Response.Write "&#xa0;&#xa0;&#xa0;&#xa0;If you do use refresh, <B>Kerberos</B> will always show up as <B>NTLM</B>."
   	Response.Write " This is because the HTTP_Authorization header is being used to determine the authentication method used."
   	Response.Write " Since the second request is technically unauthenticated, the length is zero. Please open a new browser"
   	Response.Write " for any subsequent requests.</table>"
   End Sub
   %>
   </BODY>
   </HTML>