rem --------------------------------------------------------------------------
rem	                ClusDiag Application
rem
rem                    Microsoft Confidential
rem	Copyright (c) 2002 Microsoft Corporation. All Rights  Reserved.
rem
rem File name   : CopyLogs.cmd
rem Description : Defines the set of copy commands used to capture the logs.
rem ----------------------------------------------------------------------------

@echo OFF
if "%1" EQU "" (
  echo The first argument must be the type of operation to be performed. This can be one of TESTCAPTURE/FULLCAPTURE/MINCAPTURE
  goto :Usage
)
if "%2" EQU "" (
  echo The second argument must be the ClusDiag application path.
  goto :Usage
)
if "%3" EQU "" (
  echo The third argument must be the Destination Path where the logs will be copied.
  goto :Usage
)

SET AppPath=%2
SET LogPath=%3
SET NodeList=%4

if "%1" EQU "TESTCAPTURE" (
  goto :TestCapture
) else (
         if "%1" EQU "FULLCAPTURE" (
           goto :FullCapture
         ) else (
                  if "%1" EQU "MINCAPTURE" (
                    goto :MinCapture
                  )
                )
       )
goto :End


rem ----------------------------------------------------------------------------
rem Section name : TestCapture
rem Description  : This section is intended to be executed in case of SPFail
rem                Run Test to capture the logs.
rem ----------------------------------------------------------------------------
:TestCapture
SET /a Num=1
  echo %0 > %LogPath%\CopyLogs.cmd.log
    echo Starting the copy tasks... >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\InstallRemoteFiles.log %LogPath%\InstallRemoteFiles.log >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\InstallRemoteFiles.log %LogPath%\InstallRemoteFiles.log >> %LogPath%\CopyLogs.cmd.log

rem ----------------------------------------------------------------------------
rem move %AppPath%\*.cap %LogPath%\ 
rem Comment: We are using the "copy" and "del" commands instead of
rem          using the "move" command since "move" does not log the information.
rem ----------------------------------------------------------------------------

    echo copy %AppPath%\*.cap %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.cap %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

    echo del %AppPath%\*.cap >> %LogPath%\CopyLogs.cmd.log
    del %AppPath%\*.cap >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\*.txt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.txt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

:Start
FOR /F "delims=, tokens=%Num%*" %%A IN (%NodeList%) DO (
  if "%%A" EQU "" (
  goto :End
)
SET /a Num+=1
  echo copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\qserv.log %LogPath%\%%A_qserv.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\qserv.log  %LogPath%\%%A_qserv.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\spsrv.log %LogPath%\%%A_spsrv.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\spsrv.log  %LogPath%\%%A_spsrv.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\spsrv.bak.log %LogPath%\%%A_spsrv.bak.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\spsrv.bak.log  %LogPath%\%%A_spsrv.bak.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\LogFiles\Cluster\* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\LogFiles\Cluster\*  %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\cluster\*.evm* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\cluster\*.evm* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\config.ini %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\config.ini %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*hive %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*hive %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*log %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*log %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*xml %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*xml %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

goto :Start
)

if %Num% EQU 1 (
  echo The fourth Argument must be the list of machines from which logs needs to be copied.
  goto :Usage
)
echo The copy task has finished. >> %LogPath%\CopyLogs.cmd.log
goto :End


rem ----------------------------------------------------------------------------
rem Section name : FullCapture
rem Description  : This section is intended to be executed in case of "Full
rem                Capture" to capture the logs.
rem ----------------------------------------------------------------------------
:FullCapture
SET /a Num=1
    echo %0 >> %LogPath%\CopyLogs.cmd.log
    echo Starting the copy tasks... >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\InstallRemoteFiles.log %LogPath%\InstallRemoteFiles.log >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\InstallRemoteFiles.log %LogPath%\InstallRemoteFiles.log >> %LogPath%\CopyLogs.cmd.log

rem ----------------------------------------------------------------------------
rem move %AppPath%\*.cap %LogPath%\ 
rem Comment: We are using the "copy" and "del" commands instead of
rem          using the "move" command since "move" does not log the information.
rem ----------------------------------------------------------------------------

    echo copy %AppPath%\*.cap %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.cap %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

    echo del %AppPath%\*.cap >> %LogPath%\CopyLogs.cmd.log
    del %AppPath%\*.cap >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\*.txt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.txt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

    echo copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
    copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

:Begin
FOR /F "delims=, tokens=%Num%*" %%A IN (%NodeList%) DO (
  if "%%A" EQU "" (
  goto :End
)
SET /a Num+=1
  echo copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\qserv.log %LogPath%\%%A_qserv.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\qserv.log  %LogPath%\%%A_qserv.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\spsrv.log %LogPath%\%%A_spsrv.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\spsrv.log  %LogPath%\%%A_spsrv.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\spsrv.bak.log %LogPath%\%%A_spsrv.bak.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\spsrv.bak.log  %LogPath%\%%A_spsrv.bak.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\system32\LogFiles\Cluster\* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\system32\LogFiles\Cluster\*  %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\cluster\*.evm* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\cluster\*.evm* %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\config.ini %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\config.ini %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*hive %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*hive %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*log %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*log %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\wttbin\*xml %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\wttbin\*xml %LogPath%\%%A\ >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\%%A_*.evt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\%%A_*.evt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

goto :Begin
)
if %Num% EQU 1 (
  echo The fourth Argument must be the list of machines from which logs needs to be copied.
  goto :Usage
)
goto :End


rem ----------------------------------------------------------------------------
rem Section name : MinCapture
rem Description  : This section is intended to be executed in case of Minimum
rem                Capture to capture the logs.
rem ----------------------------------------------------------------------------
:MinCapture
SET /a Num=1
  echo %0 >> %LogPath%\CopyLogs.cmd.log
  echo Starting the copy tasks... >> %LogPath%\CopyLogs.cmd.log

  echo copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
  copy %AppPath%\*.log %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

:BeginMin
FOR /F "delims=, tokens=%Num%*" %%A IN (%NodeList%) DO (
  if "%%A" EQU "" (
  goto :End
)
SET /a Num+=1
  echo copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\cluster\cluster.log %LogPath%\%%A\%%A_cluster.log >> %LogPath%\CopyLogs.cmd.log

  echo copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\debug\netlogon.log %LogPath%\%%A_netlogon.log >> %LogPath%\CopyLogs.cmd.log
 
  echo copy \\%%A\admin$\%%A_*.evt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log
  copy \\%%A\admin$\%%A_*.evt %LogPath%\ >> %LogPath%\CopyLogs.cmd.log

goto :BeginMin
)
if %Num% EQU 1 (
  echo The fourth Argument must be the list of machines from which logs needs to be copied.
  goto :Usage
)
goto :End


rem ----------------------------------------------------------------------------
rem Section name : Usage
rem Description  : This section specifies command usage.
rem ----------------------------------------------------------------------------
:Usage
echo 
echo NOTE: This batch file is not intended for the manual use and it is
echo       provided for the internal use of ClusDiag application ONLY.
echo 
echo Usage: %0 OperType[TESTCAPTURE/FULLCAPTURE/MINCAPTURE] AppPath DestPath "Node1,Node2"
echo Example:
echo   %0 TESTCAPTURE c:\Clusdiag\bin C:\Clusdiag\Logs "NodeN1,NodeN2"
echo 
:End
