rem =  ********************************************************************
rem =     This batch file is used to create a mib file for the memory and cpu PerfLib counters.
rem = 
rem =     In order to use this bat file you need to have the following installed
rem =      1. TCP/IP and snmp services
rem =      2. ResKit
rem = 
rem =     After you run this batch file, you will need to copy the mib file to your SNMP console station.
rem = 
rem =    If this bat file fails, enter the commands one line at a time at the command promt
rem =  ********************************************************************

rem =  ========================
rem =   The following command can be modified if you wish to 
rem =   add/remove PerfLib counters to the MIB file. 
rem =    See the help file for sytax
rem =  ========================
echo "creating perfmib"
perf2mib perfmib.mib perfmib.ini memory 1 memory processor 2 CPU "Network Segment" 3 net PhysicalDisk 4 disk

rem =  ========================
rem =   This line should only be changed if you understand what the mibcc flags mean.  For most users
rem =   the following is fine.
rem =  ========================
echo "compliling perfmib"
mibcc -o%NTResKit%\mib.bin -n -t -w2 %NTResKit%\LMMIB2MIB %NTResKit%\mib_ll.mib perfmib.mib

rem =  ========================
rem =   need to stop the current snmp service
rem =  ========================
echo "stoping snmp service"
net stop snmp

rem =  ========================
rem =  Saving the old MIB file.
rem =  Also moving in the new files needed that were created above
rem =  ========================
echo "saving old mib to mib.old"
move %systemroot%\system32\mib.bin %systemroot%\system32\mib.old
echo "copying perfmib files from NTResKit to system32"
copy %NTResKit%\perfmib.dll %systemroot%\system32\perfmib.dll
copy %NTResKit%\perfmib.ini %systemroot%\system32\perfmib.ini
copy %NTResKit%\mib.bin %systemroot%\system32\mib.bin

rem =  ========================
rem =    Need to add some new keys to the registry.  
rem =   If the "perfmib.reg" file is missing you can create a new one.
rem =  see the help files for the content.
rem =  ========================
echo "registering"
regini perfmib.reg

rem =  ========================
rem =   need to restart snmp service
rem =  ========================
echo "restarting snmp"
net start snmp

rem =  ========================
rem =  you need to add the MIB to your management station.
rem = see the management station documents on how to perform this.
rem =  ========================

echo "Don't forget to add PERFMIB.MIB to your management station!"

