/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992-1993 Microsoft Corporation

Module Name:

      perftp.h  

Abstract:

   This file provides the function prototypes for the routines
   to open, collect and close Total Processor Performance Data. It also
   provides the perftp.c module with some structure and
   constant definitions.

Author:

   HonWah Chan 07/24/93

Revision History:


--*/
#ifndef  _PERFTP_H_
#define  _PERFTP_H_

//
// Prototypes for the TP routines
//


TCHAR MapFileName[] = TEXT("Total Processor Map File");
TCHAR TPMutexName[] = TEXT("Total Processor Data Mutex");

// the following globals are for file mapping sharing among all
// threads and the TotlProc.DLL
typedef struct PROCESSORSTRUCT
{
   LONGLONG                CurrentCalValue;
   LONGLONG                TimeStartReading;
} TOTAL_PROCESSORS_DATA;

typedef struct TOTLPROC_SYSTEM_DATA
{
   int                     NumberOfProcessors;
   LONGLONG                BestSystemTime;
   TOTAL_PROCESSORS_DATA   TotalProcessorsData[1];
} TOTLPROC_SYSTEM_DATA, *LPTOTLPROC_SYSTEM_DATA;


#pragma pack ()

DWORD                   FirstCountIndex;
HANDLE                  hFileMapping;
HANDLE                  hSystemDataMutex;
LPTOTLPROC_SYSTEM_DATA  lpSystemData;

//
//  References to constants which initialize the Object type definitions
//

extern TP_DATA_DEFINITION TPDataDefinition;


//
// TP data structures
//

//
//  Function prototype
//
PM_OPEN_PROC    OpenTPPerformanceData;
PM_COLLECT_PROC CollectTPPerformanceData;
PM_CLOSE_PROC   CloseTPPerformanceData;



#endif //_PERFTP_H_
