/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware;

import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusSlave;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.bus.registers.Keyboard;
import bk2010.hardware.bus.registers.SystemRegs;
import bk2010.io.Joystick;
import bk2010.sound.SoundRenderer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BaseBK0010
extends QBusProxy {
    protected short[] ram;
    protected short[] monitor;
    protected short[] rom120;
    protected short[] rom140;
    protected short[] rom160;
    protected int rom160length = 8064;
    protected short iowritereg = 0;
    protected short ioreadreg = 0;
    protected short scrollReg = 0;
    protected static final int VM_1BIT = 0;
    protected static final int VM_GRAY = 1;
    protected static final int VM_RGB = 2;
    protected static final int VM_LAST = 2;
    protected int videoMode = 1;
    protected List<QBusSlave> plugins = new ArrayList<QBusSlave>();
    public final Keyboard keyboard = new Keyboard();
    public final Joystick joystick = new Joystick();
    public final CPUTimer timer = new CPUTimer();
    public final SystemRegs sregs = new SystemRegs();
    private SoundRenderer srend = null;
    private static final byte[] monoColorMap;
    private static final byte[] bgrColorMap;

    static {
        byte[] byArray = new byte[4];
        byArray[1] = 73;
        byArray[2] = -110;
        byArray[3] = -1;
        monoColorMap = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 3;
        byArray2[2] = 28;
        byArray2[3] = -32;
        bgrColorMap = byArray2;
    }

    public BaseBK0010() throws IOException {
        this.ram = new short[16384];
        this.monitor = new short[4096];
        this.rom120 = new short[4096];
        this.rom140 = new short[4096];
        this.rom160 = new short[this.rom160length / 2];
        int i = 0;
        while (i < 16384) {
            this.ram[i] = (short)(((i >> 7 ^ i) & 1) == 1 ? -1 : 0);
            ++i;
        }
        FileInputStream ms = new FileInputStream("roms/monit10.rom");
        int i2 = 0;
        while (i2 < 4096) {
            this.monitor[i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream("roms/basic10.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.rom120[i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4096) {
            this.rom140[i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rom160length / 2) {
            this.rom160[i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        this.plugins.add(this.keyboard);
        this.plugins.add(this.timer);
        this.plugins.add(this.sregs);
    }

    public void attach(QBusSlave plugin) {
        this.plugins.add(plugin);
    }

    @Override
    public short readWord(short addr) throws QBusError {
        int ia = addr & 0xFFFF;
        if (ia >= 0 && ia < 32768) {
            return this.ram[ia / 2];
        }
        if (ia >= 32768 && ia < 40960) {
            return this.monitor[(ia - 32768) / 2];
        }
        if (ia >= 40960 && ia < 49152) {
            return this.rom120[(ia - 40960) / 2];
        }
        if (ia >= 49152 && ia < 57344) {
            return this.rom140[(ia - 49152) / 2];
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            return plugin.readWord(addr);
        }
        if (ia >= 57344 && ia < 57344 + this.rom160length) {
            return this.rom160[(ia - 57344) / 2];
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            return (short)(this.ioreadreg | this.joystick.getIO());
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            return this.keyboard.getKeyDown() ? (short)-32624 : -32560;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return this.scrollReg;
        }
        return super.readWord(addr);
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        if (ia >= 0 && ia < 32768) {
            this.ram[ia / 2] = (ia & 1) == 0 ? (short)(this.ram[ia / 2] & 0xFF00 | data & 0xFF) : (short)(this.ram[ia / 2] & 0xFF | data & 0xFF00);
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeByteAsWord(addr, data);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = (ia & 1) == 0 ? (short)(this.iowritereg & 0xFF00 | data & 0xFF) : (short)(this.iowritereg & 0xFF | data & 0xFF00);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return;
        }
        super.writeByteAsWord(addr, data);
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        if (ia >= 0 && ia < 32768) {
            this.ram[ia / 2] = data;
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeWord(addr, data);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = data;
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            this.scrollReg = (short)(data & 0x2FF);
            return;
        }
        super.writeWord(addr, data);
    }

    public static void main(String[] args) throws IOException, QBusError {
        BaseBK0010 mem = new BaseBK0010();
        short i = 0;
        while (i < 16) {
            System.out.printf("%08o: %08o - %04o %08o\n", i, ((QBusProxy)mem).readWord(i), mem.readByte(i), mem.readByteAsWord(i));
            i = (short)(i + 1);
        }
        i = Short.MIN_VALUE;
        while (i < -32752) {
            System.out.printf("%08o: %08o - %04o %08o\n", i, ((QBusProxy)mem).readWord(i), mem.readByte(i), mem.readByteAsWord(i));
            i = (short)(i + 1);
        }
    }

    @Override
    public short getBaseAddress() {
        return 0;
    }

    @Override
    public int getNumWords() {
        return 0;
    }

    @Override
    public boolean gotInterrupt() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte interruptVector() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return plugin.interruptVector();
        }
        return -1;
    }

    @Override
    public void reset() {
        for (QBusSlave plugin : this.plugins) {
            plugin.reset();
        }
    }

    public void setSoundRenderer(SoundRenderer sr) {
        this.srend = sr;
    }

    public void cycleVideomodes() {
        this.videoMode = this.videoMode >= 2 ? 0 : this.videoMode + 1;
    }

    public void copyFramebuffer(byte[] buf) {
        int src = 8192 + (this.scrollReg + 40 & 0xFF) * 32;
        int dst = 0;
        int limit = (this.scrollReg & 0x200) == 0 ? 64 : 256;
        int y = 0;
        while (y < 256) {
            int x;
            if (y < limit) {
                x = 0;
                while (x < 32) {
                    short s = this.ram[src++];
                    switch (this.videoMode) {
                        case 0: {
                            int bit = 0;
                            while (bit < 16) {
                                buf[dst++] = (byte)(s << 31 - bit >> 31);
                                ++bit;
                            }
                            break;
                        }
                        case 1: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = monoColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                        case 2: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = bgrColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                    }
                    ++x;
                }
                src = src & 0x1FFF | 0x2000;
            } else {
                x = 0;
                while (x < 512) {
                    buf[dst++] = 0;
                    ++x;
                }
            }
            ++y;
        }
    }
}

