/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.Timed;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusSlave;

public final class CPUTimer
implements QBusSlave {
    private static final int TMR_STOP = 1;
    private static final int TMR_WRAPAROUND = 2;
    private static final int TMR_EXPIRECHECK = 4;
    private static final int TMR_SINGLEPASS = 8;
    private static final int TMR_RUN = 16;
    private static final int TMR_DIV16 = 32;
    private static final int TMR_DIV4 = 64;
    private static final int TMR_EXPIRED = 128;
    private short start = (short)4608;
    private short count = (short)-1;
    private short config = (short)-256;
    private long cycles = 0L;
    private long period = 128L;
    private Timed timeSource;

    @Override
    public short getBaseAddress() {
        return -58;
    }

    @Override
    public int getNumWords() {
        return 3;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public short readWord(short addr) throws QBusError {
        this.updateTimer();
        switch (addr) {
            case -58: {
                return this.start;
            }
            case -56: {
                return this.count;
            }
            case -54: {
                return this.config;
            }
        }
        throw new QBusError(addr, 1);
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        this.updateTimer();
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        this.updateTimer();
        switch (addr) {
            case -58: {
                this.start = data;
                return;
            }
            case -56: {
                return;
            }
            case -54: {
                this.setConfig(data);
                return;
            }
        }
        throw new QBusError(addr, 2);
    }

    @Override
    public void reset() {
        this.start = (short)4608;
        this.count = (short)-1;
        this.config = (short)-256;
    }

    private void setConfig(short data) {
        int tmp = 128;
        if ((data & 0x40) != 0) {
            tmp *= 4;
        }
        if ((data & 0x20) != 0) {
            tmp *= 16;
        }
        this.period = tmp;
        this.count = this.start;
        this.config = (short)(data | 0xFF00);
    }

    private void updateTimer() {
        long now = this.timeSource.getCycles();
        if (now - this.cycles < this.period) {
            return;
        }
        long periods = (now - this.cycles) / this.period;
        this.cycles += periods * this.period;
        if ((this.config & 1) != 0) {
            this.count = this.start;
            return;
        }
        if ((this.config & 0x10) == 0) {
            return;
        }
        if (periods >= (long)(this.count & 0xFFFF)) {
            if ((this.config & 4) != 0) {
                this.config = (short)(this.config | 0x80);
            }
            if ((this.config & 2) == 0) {
                if ((this.config & 8) != 0) {
                    this.config = (short)(this.config & 0xFFFFFFEF);
                    this.count = this.start;
                    return;
                }
                this.count = this.start == 0 ? (short)((long)this.count - periods) : (short)((long)this.start - (periods - (long)this.count) % (long)(this.start & 0xFFFF));
                return;
            }
        }
        this.count = (short)((long)this.count - periods);
    }

    public void setTimeSource(Timed source) {
        this.timeSource = source;
    }
}

