/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.io.JoystickMapper;
import java.awt.event.KeyEvent;

public final class KeyMapper {
    public static final int EVT_STOP = 1;
    public static final int EVT_VIDEOMODE = 2;
    public static final int EVT_RESET = 4;
    public static final int EVT_TRACETOGGLE = 8;
    private int nextEvent = 0;
    private int nextKey = -1;
    private int lastKey = -1;
    private boolean pressedKey = false;
    private JoystickMapper joyMapper = null;

    public KeyMapper(JoystickMapper joyMapper) {
        this.joyMapper = joyMapper;
    }

    public int translateKey(KeyEvent evt) {
        int key = evt.getKeyCode();
        boolean isAlpha = false;
        boolean isSymbol = false;
        if (key >= 65 && key <= 90) {
            isAlpha = true;
        } else if (key >= 48 && key <= 57) {
            isSymbol = true;
        } else {
            switch (key) {
                case 525: {
                    key = 64;
                    isAlpha = true;
                    break;
                }
                case 91: {
                    key = 91;
                    isAlpha = true;
                    break;
                }
                case 93: {
                    key = 93;
                    isAlpha = true;
                    break;
                }
                case 192: {
                    key = 94;
                    isAlpha = true;
                    break;
                }
                case 92: {
                    key = 92;
                    isAlpha = true;
                    break;
                }
                case 222: {
                    key = 95;
                    isAlpha = true;
                    break;
                }
                case 47: {
                    key = 47;
                    isSymbol = true;
                    break;
                }
                case 44: {
                    key = 44;
                    isSymbol = true;
                    break;
                }
                case 46: {
                    key = 46;
                    isSymbol = true;
                    break;
                }
                case 45: {
                    key = 45;
                    isSymbol = true;
                    break;
                }
                case 61: {
                    key = 59;
                    isSymbol = true;
                    break;
                }
                case 59: {
                    key = 58;
                    isSymbol = true;
                    break;
                }
                case 9: {
                    key = 9;
                    break;
                }
                case 10: {
                    key = 10;
                    break;
                }
                case 8: {
                    key = 24;
                    break;
                }
                case 32: {
                    key = 32;
                    break;
                }
                case 38: {
                    key = 26;
                    break;
                }
                case 40: {
                    key = 27;
                    break;
                }
                case 37: {
                    key = 8;
                    break;
                }
                case 39: {
                    key = 25;
                    break;
                }
                case 524: {
                    if (evt.getKeyLocation() == 2) {
                        key = 14;
                        break;
                    }
                    if (evt.getKeyLocation() != 3) break;
                    key = 15;
                    break;
                }
                case 112: {
                    return 129;
                }
                case 113: {
                    return 3;
                }
                case 114: {
                    return 153;
                }
                case 115: {
                    return 22;
                }
                case 116: {
                    return 23;
                }
                case 117: {
                    return 130;
                }
                case 118: {
                    return 132;
                }
                case 119: {
                    return 144;
                }
                case 120: {
                    return 12;
                }
                case 121: {
                    return 19;
                }
                case 27: {
                    this.nextEvent |= 1;
                    return -1;
                }
                case 145: {
                    this.nextEvent |= 2;
                    return -1;
                }
                case 122: {
                    if (evt.isControlDown()) {
                        this.nextEvent |= 4;
                    }
                    return -1;
                }
                case 123: {
                    if (evt.isAltDown()) {
                        this.nextEvent |= 8;
                    }
                    return -1;
                }
                default: {
                    return -1;
                }
            }
        }
        if (isAlpha) {
            if (evt.isControlDown()) {
                key &= 0x1F;
            } else if (evt.isShiftDown()) {
                key ^= 0x20;
            }
        } else if (isSymbol && evt.isShiftDown()) {
            key ^= 0x10;
        }
        if (evt.isAltDown()) {
            key |= 0x80;
        }
        return key;
    }

    public void keyHit(KeyEvent evt) {
        int key = this.translateKey(evt);
        if (key >= 0) {
            this.nextKey = key;
            this.lastKey = evt.getKeyCode();
            this.pressedKey = true;
        }
        if (this.joyMapper != null) {
            this.joyMapper.translateKey(evt, true);
        }
        evt.consume();
    }

    public void keyRelease(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key >= 0 && key == this.lastKey) {
            this.nextKey = -1;
            this.lastKey = -1;
            this.pressedKey = false;
        }
        if (this.joyMapper != null) {
            this.joyMapper.translateKey(evt, false);
        }
        evt.consume();
    }

    public int pollKey() {
        if (!this.pressedKey) {
            return -1;
        }
        this.pressedKey = false;
        return this.nextKey;
    }

    public boolean pollKeyHold() {
        return this.nextKey != -1;
    }

    public int pollEvents() {
        int tmp = this.nextEvent;
        this.nextEvent = 0;
        return tmp;
    }
}

