/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.io.KeyMapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class bk0010DisplayPanel
extends JPanel {
    BufferedImage display;
    private KeyMapper keyMapper;
    private static IndexColorModel rgb332model;

    public bk0010DisplayPanel(final KeyMapper keyMapper) {
        this.keyMapper = keyMapper;
        Dimension sz = new Dimension(1024, 768);
        this.setMaximumSize(sz);
        this.setMinimumSize(sz);
        this.setPreferredSize(sz);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                keyMapper.keyHit(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                keyMapper.keyRelease(e);
            }
        });
    }

    public static IndexColorModel getRGB332Model() {
        if (rgb332model == null) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            int i = 0;
            while (i < 256) {
                int tmp = i & 0xE0;
                tmp |= tmp >> 3;
                tmp |= tmp >> 6;
                r[i] = (byte)tmp;
                tmp = i << 3 & 0xE0;
                tmp |= tmp >> 3;
                tmp |= tmp >> 6;
                g[i] = (byte)tmp;
                tmp = i << 6 & 0xC0;
                tmp |= tmp >> 2;
                tmp |= tmp >> 4;
                b[i] = (byte)tmp;
                ++i;
            }
            rgb332model = new IndexColorModel(8, 256, r, g, b);
        }
        return rgb332model;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.display == null) {
            super.paintComponent(g);
            g2.setColor(Color.RED);
            Line2D.Double line2d = new Line2D.Double(0.0, 0.0, 1023.0, 767.0);
            g2.draw(line2d);
            line2d = new Line2D.Double(1023.0, 0.0, 0.0, 767.0);
            g2.draw(line2d);
            return;
        }
        g2.drawImage(this.display, 0, 0, 1024, 768, null);
        this.getToolkit().sync();
    }

    public void setDisplay(BufferedImage disp) {
        this.display = disp;
    }

    public static class TestFrame
    extends JFrame {
        public TestFrame(bk0010DisplayPanel panel) {
            this.add(panel);
            this.pack();
            this.setResizable(false);
        }
    }
}

