/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware;

import bk2010.hardware.BKMemorySelector;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusSlave;
import bk2010.hardware.bus.registers.CPUTimer;
import bk2010.hardware.bus.registers.Keyboard;
import bk2010.hardware.bus.registers.SystemRegs;
import bk2010.io.Joystick;
import bk2010.sound.SoundRenderer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BaseBK0010
extends QBusProxy
implements BKMemorySelector {
    protected static final int OF_RAMB10_120 = 16384;
    protected static final int OF_RAMB10_140 = 20480;
    protected static final int OF_ROMB10_100 = 65536;
    protected static final int OF_ROMBASIC10_120 = 69632;
    protected static final int OF_ROMBASIC10_140 = 73728;
    protected static final int OF_ROMBASIC10_160 = 77824;
    protected static final int OF_ROMFDD = 81920;
    protected static final int OF_MEMSIZE = 86016;
    protected static final int LEN_ROMBASIC10_160 = 8064;
    protected static final int LEN_ROMFDD_160 = 4096;
    protected short[] memory = new short[86016];
    protected final int MMAP_IOPAGE = 7;
    protected final int MMAP_PAGES = 8;
    protected int[] mmap = new int[8];
    protected boolean[] mmap_readable = new boolean[8];
    protected boolean[] mmap_writeable = new boolean[8];
    protected int rom160length = 8064;
    protected short iowritereg = 0;
    protected short ioreadreg = 0;
    protected short scrollReg = 0;
    protected static final int VM_1BIT = 0;
    protected static final int VM_GRAY = 1;
    protected static final int VM_RGB = 2;
    protected static final int VM_LAST = 2;
    protected int videoMode = 1;
    protected List<QBusSlave> plugins = new ArrayList<QBusSlave>();
    public final Keyboard keyboard = new Keyboard();
    public final Joystick joystick = new Joystick();
    public final CPUTimer timer = new CPUTimer();
    public final SystemRegs sregs = new SystemRegs();
    private SoundRenderer srend = null;
    private static final byte[] monoColorMap;
    private static final byte[] bgrColorMap;

    static {
        byte[] byArray = new byte[4];
        byArray[1] = 73;
        byArray[2] = -110;
        byArray[3] = -1;
        monoColorMap = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 3;
        byArray2[2] = 28;
        byArray2[3] = -32;
        bgrColorMap = byArray2;
    }

    public BaseBK0010() throws IOException {
        this.mmap_writeable[0] = true;
        this.mmap_writeable[1] = true;
        this.mmap_writeable[2] = true;
        this.mmap_writeable[3] = true;
        Arrays.fill(this.mmap_readable, true);
        this.mmap[0] = 0;
        this.mmap[1] = 4096;
        this.mmap[2] = 8192;
        this.mmap[3] = 12288;
        this.mmap[4] = 65536;
        this.mmap[5] = 69632;
        this.mmap[6] = 73728;
        this.mmap[7] = 77824;
        int i = 0;
        while (i < 16384) {
            this.memory[i] = (short)(((i >> 7 ^ i) & 1) == 1 ? -1 : 0);
            ++i;
        }
        FileInputStream ms = new FileInputStream("roms/monit10.rom");
        int i2 = 0;
        while (i2 < 4096) {
            this.memory[65536 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream("roms/basic10.rom");
        i2 = 0;
        while (i2 < 4096) {
            this.memory[69632 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4096) {
            this.memory[73728 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4032) {
            this.memory[77824 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        ms = new FileInputStream("roms/fdd.rom");
        i2 = 0;
        while (i2 < 2048) {
            this.memory[81920 + i2] = (short)(ms.read() & 0xFF | (ms.read() & 0xFF) << 8);
            ++i2;
        }
        this.plugins.add(this.keyboard);
        this.plugins.add(this.timer);
        this.plugins.add(this.sregs);
    }

    @Override
    public void setBaseModel() {
        this.mmap_readable[5] = false;
        this.mmap_readable[6] = false;
        this.mmap_readable[7] = false;
        this.mmap_writeable[5] = false;
        this.mmap_writeable[6] = false;
        this.mmap_writeable[7] = false;
    }

    @Override
    public void setFDD10Model() {
        this.mmap[5] = 16384;
        this.mmap[6] = 20480;
        this.mmap[7] = 81920;
        this.mmap_readable[5] = true;
        this.mmap_readable[6] = true;
        this.mmap_readable[7] = true;
        this.mmap_writeable[5] = true;
        this.mmap_writeable[6] = true;
        this.mmap_writeable[7] = false;
        this.rom160length = 4096;
    }

    @Override
    public void setBASIC10Model() {
        this.mmap[5] = 69632;
        this.mmap[6] = 73728;
        this.mmap[7] = 77824;
        this.mmap_readable[5] = true;
        this.mmap_readable[6] = true;
        this.mmap_readable[7] = true;
        this.mmap_writeable[5] = false;
        this.mmap_writeable[6] = false;
        this.mmap_writeable[7] = false;
        this.rom160length = 8064;
    }

    public void attach(QBusSlave plugin) {
        this.plugins.add(plugin);
    }

    @Override
    public short readWord(short addr) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_readable[page]) {
                return this.memory[mapped];
            }
            return super.readWord(addr);
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            return plugin.readWord(addr);
        }
        if (this.mmap_readable[7] && ia < 57344 + this.rom160length) {
            return this.memory[mapped];
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            return (short)(this.ioreadreg | this.joystick.getIO());
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            return this.keyboard.getKeyDown() ? (short)-32624 : -32560;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return this.scrollReg;
        }
        return super.readWord(addr);
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_writeable[page]) {
                this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
                return;
            }
            super.writeWord(addr, data);
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeByteAsWord(addr, data);
            return;
        }
        if (this.mmap_writeable[7] && ia < 57344 + this.rom160length) {
            this.memory[mapped] = (ia & 1) == 0 ? (short)(this.memory[mapped] & 0xFF00 | data & 0xFF) : (short)(this.memory[mapped] & 0xFF | data & 0xFF00);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = (ia & 1) == 0 ? (short)(this.iowritereg & 0xFF00 | data & 0xFF) : (short)(this.iowritereg & 0xFF | data & 0xFF00);
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            return;
        }
        super.writeByteAsWord(addr, data);
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        int ia = addr & 0xFFFF;
        int page = ia >> 13;
        int mapped = this.mmap[page] + ((ia & 0x1FFF) >> 1);
        if (page < 7) {
            if (this.mmap_writeable[page]) {
                this.memory[mapped] = data;
                return;
            }
            super.writeWord(addr, data);
            return;
        }
        for (QBusSlave plugin : this.plugins) {
            int base = plugin.getBaseAddress() & 0xFFFF;
            if (base > ia || (ia - base) / 2 >= plugin.getNumWords()) continue;
            plugin.writeWord(addr, data);
            return;
        }
        if (this.mmap_writeable[7] && ia < 57344 + this.rom160length) {
            this.memory[mapped] = data;
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65484) {
            this.iowritereg = data;
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65486) {
            if (this.srend != null) {
                this.srend.updateBit(data & 0x40);
            }
            return;
        }
        if ((ia & 0xFFFFFFFE) == 65460) {
            this.scrollReg = (short)(data & 0x2FF);
            return;
        }
        super.writeWord(addr, data);
    }

    @Override
    public short getBaseAddress() {
        return 0;
    }

    @Override
    public int getNumWords() {
        return 0;
    }

    @Override
    public boolean gotInterrupt() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte interruptVector() {
        for (QBusSlave plugin : this.plugins) {
            if (!plugin.gotInterrupt()) continue;
            return plugin.interruptVector();
        }
        return -1;
    }

    @Override
    public void reset() {
        for (QBusSlave plugin : this.plugins) {
            plugin.reset();
        }
    }

    public void setSoundRenderer(SoundRenderer sr) {
        this.srend = sr;
    }

    public void cycleVideomodes() {
        this.videoMode = this.videoMode >= 2 ? 0 : this.videoMode + 1;
    }

    public void copyFramebuffer(byte[] buf) {
        int src = 8192 + (this.scrollReg + 40 & 0xFF) * 32;
        int dst = 0;
        int limit = (this.scrollReg & 0x200) == 0 ? 64 : 256;
        int y = 0;
        while (y < 256) {
            int x;
            if (y < limit) {
                x = 0;
                while (x < 32) {
                    short s = this.memory[src++];
                    switch (this.videoMode) {
                        case 0: {
                            int bit = 0;
                            while (bit < 16) {
                                buf[dst++] = (byte)(s << 31 - bit >> 31);
                                ++bit;
                            }
                            break;
                        }
                        case 1: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = monoColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                        case 2: {
                            byte b;
                            int bit = 0;
                            while (bit < 16) {
                                b = bgrColorMap[s >> bit & 3];
                                buf[dst++] = b;
                                buf[dst++] = b;
                                bit += 2;
                            }
                            break;
                        }
                    }
                    ++x;
                }
                src = src & 0x1FFF | 0x2000;
            } else {
                x = 0;
                while (x < 512) {
                    buf[dst++] = 0;
                    ++x;
                }
            }
            ++y;
        }
    }
}

