/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.BKMemorySelector;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusSlave;
import bk2010.io.FloppyDisk;

public class FDDController
implements QBusSlave {
    protected static int CON_SEL0 = 0;
    protected static int CON_SEL1 = 1;
    protected static int CON_SEL2 = 2;
    protected static int CON_SEL3 = 3;
    protected static int CON_PWR = 4;
    protected static int CON_HEAD = 5;
    protected static int CON_DIR = 6;
    protected static int CON_SEEK = 7;
    protected static int CON_RESYNC = 8;
    protected static int CON_WRMARKER = 9;
    FloppyDisk[] drives = new FloppyDisk[2];
    FloppyDisk drive;
    short controlReg;
    boolean seekingMarker = true;
    boolean diskEnabled = false;
    TimeSource timeSource;
    long lastCycles;
    boolean isReadable = true;
    BKMemorySelector memSelector;

    @Override
    public short getBaseAddress() {
        return -424;
    }

    @Override
    public int getNumWords() {
        return 2;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public short readWord(short addr) throws QBusError {
        this.catchUp();
        if (!this.isReadable) {
            throw new QBusError(addr, 1);
        }
        if ((addr = (short)(addr & 0xFFFFFFFE)) == -424) {
            if (this.diskEnabled) {
                int tmp = this.drive.getStatus(this.controlReg >> CON_HEAD & 1);
                if (this.seekingMarker) {
                    if (!this.drive.isMarker(this.controlReg >> CON_HEAD & 1)) {
                        tmp &= 0xFFFFFF7F;
                    } else {
                        this.seekingMarker = false;
                    }
                }
                return (short)tmp;
            }
            return 0;
        }
        if (addr == -422) {
            if (this.diskEnabled) {
                return (short)this.drive.getData(this.controlReg >> CON_HEAD & 1);
            }
            return 0;
        }
        throw new QBusError(addr, 1);
    }

    @Override
    public void reset() {
        this.controlReg = 0;
        this.seekingMarker = true;
        this.diskEnabled = false;
    }

    @Override
    public void writeByteAsWord(short addr, short data) throws QBusError {
        if (addr == -424) {
            this.writeWord((short)-424, (short)(this.controlReg & 0xFF00 | data & 0xFF));
        } else if (addr == -423) {
            this.writeWord((short)-424, (short)(this.controlReg & 0xFF | data & 0xFF00));
        } else {
            this.writeWord(addr, data);
        }
    }

    @Override
    public void writeWord(short addr, short data) throws QBusError {
        this.catchUp();
        addr = (short)(addr & 0xFFFFFFFE);
        if (addr == -424) {
            int tmp = this.controlReg ^ data;
            if ((tmp & 0x13) != 0) {
                this.diskEnabled = (data & 0x13) == 17;
                switch (data & 0x13) {
                    case 17: {
                        this.drive = this.drives[0];
                        break;
                    }
                    case 18: {
                        this.drive = this.drives[1];
                    }
                }
                boolean bl = this.diskEnabled = this.drive != null;
            }
            if (this.memSelector != null && (tmp & 0xC) != 0) {
                switch (data & 0xC) {
                    case 12: {
                        this.memSelector.setBASIC10Model();
                        this.isReadable = false;
                        break;
                    }
                    case 8: {
                        this.memSelector.setBaseModel();
                        this.isReadable = true;
                        break;
                    }
                    default: {
                        this.memSelector.setFDD10Model();
                        this.isReadable = true;
                    }
                }
            }
            if (this.diskEnabled && (tmp & 0x80) != 0 && (data & 0x80) != 0) {
                if ((data & 0x40) != 0) {
                    this.drive.stepPlus();
                } else {
                    this.drive.stepMinus();
                }
            }
            if ((data & 0x100) != 0) {
                this.seekingMarker = true;
            }
            this.controlReg = data;
        } else if (addr != -422) {
            throw new QBusError(addr, 2);
        }
    }

    public void catchUp() {
        long cyclesPassed = this.timeSource.getCycles() - this.lastCycles;
        if (cyclesPassed > 0L) {
            if (this.drives[0] != null) {
                this.drives[0].cycles(cyclesPassed);
            }
            if (this.drives[1] != null) {
                this.drives[1].cycles(cyclesPassed);
            }
        }
        this.lastCycles += cyclesPassed;
    }

    public FDDController(FloppyDisk driveA, FloppyDisk driveB, TimeSource timeSource) {
        this.drives[0] = driveA;
        this.drives[1] = driveB;
        this.timeSource = timeSource;
        this.lastCycles = timeSource.getCycles();
    }

    public void setMemorySelector(BKMemorySelector memSel) {
        this.memSelector = memSel;
    }
}

